/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import java.util.concurrent.ScheduledFuture;

public class DropProtection
implements Runnable {
    private volatile boolean _isProtected = false;
    private L2PcInstance _owner = null;
    private ScheduledFuture<?> _task = null;
    private static final long PROTECTED_MILLIS_TIME = 15000L;

    @Override
    public synchronized void run() {
        this._isProtected = false;
        this._owner = null;
        this._task = null;
    }

    public boolean isProtected() {
        return this._isProtected;
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    public synchronized boolean tryPickUp(L2PcInstance actor) {
        if (!this._isProtected) {
            return true;
        }
        if (this._owner == actor) {
            return true;
        }
        return this._owner.getParty() != null && this._owner.getParty() == actor.getParty();
    }

    public boolean tryPickUp(L2PetInstance pet) {
        return this.tryPickUp(pet.getOwner());
    }

    public synchronized void unprotect() {
        if (this._task != null) {
            this._task.cancel(false);
        }
        this._isProtected = false;
        this._owner = null;
        this._task = null;
    }

    public synchronized void protect(L2PcInstance player) {
        this.unprotect();
        this._isProtected = true;
        this._owner = player;
        if (this._owner == null) {
            throw new NullPointerException("Trying to protect dropped item to null owner");
        }
        this._task = ThreadPoolManager.getInstance().scheduleGeneral(this, 15000L);
    }
}

