/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.util.Rnd;
import javolution.util.FastList;

public class L2CastleMagicianInstance
extends L2NpcInstance
implements L2SquadTrainer {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;

    public L2CastleMagicianInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2CastleMagicianInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/castlemagician/magician-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/castlemagician/magician-busy.htm";
            } else if (condition == 2) {
                filename = val == 0 ? "data/html/castlemagician/magician.htm" : "data/html/castlemagician/magician-" + val + ".htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
            return;
        }
        if (command.startsWith("ExchangeKE")) {
            int item;
            String filename = null;
            int i0 = Rnd.get(100);
            if (i0 < 5) {
                int i1 = Rnd.get(25);
                item = i0 < 5 ? 9931 : (i1 <= 50 ? 9932 : (i1 <= 75 ? 10416 : 10417));
            } else {
                int i1;
                item = i0 <= 15 ? ((i1 = Rnd.get(100)) <= 20 ? 9917 : (i1 <= 40 ? 9918 : (i1 <= 60 ? 9928 : (i1 <= 80 ? 9929 : 9920)))) : (i0 <= 30 ? ((i1 = Rnd.get(100)) <= 12 ? 9916 : (i1 <= 25 ? 9916 : (i1 <= 37 ? 9924 : (i1 <= 50 ? 9925 : (i1 <= 62 ? 9926 : (i1 <= 75 ? 9927 : (i1 <= 87 ? 10518 : 10424))))))) : ((i1 = Rnd.get(46)) == 0 ? 9914 : (i1 == 1 ? 9915 : (i1 == 2 ? 9920 : (i1 == 3 ? 9920 : (i1 == 4 ? 9921 : (i1 == 5 ? 9922 : (i1 == 6 ? 9933 : (i1 == 7 ? 9934 : (i1 == 8 ? 9935 : (i1 == 9 ? 9936 : (i1 == 10 ? 9937 : (i1 == 11 ? 9938 : (i1 == 12 ? 9939 : (i1 == 13 ? 9940 : (i1 == 14 ? 9941 : (i1 == 15 ? 9942 : (i1 == 16 ? 9943 : (i1 == 17 ? 9944 : (i1 == 18 ? 9945 : (i1 == 19 ? 9946 : (i1 == 20 ? 9947 : (i1 == 21 ? 9948 : (i1 == 22 ? 9949 : (i1 == 23 ? 9950 : (i1 == 25 ? 9952 : (i1 == 26 ? 9953 : (i1 == 27 ? 9954 : (i1 == 28 ? 9955 : (i1 == 29 ? 9956 : (i1 == 30 ? 9957 : (i1 == 31 ? 9958 : (i1 == 32 ? 9959 : (i1 == 33 ? 9960 : (i1 == 34 ? 9961 : (i1 == 35 ? 9962 : (i1 == 36 ? 9963 : (i1 == 37 ? 9964 : (i1 == 24 ? 9965 : (i1 == 38 ? 10418 : (i1 == 39 ? 10420 : (i1 == 40 ? 10519 : (i1 == 41 ? 10422 : (i1 == 42 ? 10423 : (i1 == 43 ? 10419 : 10421)))))))))))))))))))))))))))))))))))))))))))));
            }
            if (player.destroyItemByItemId("ExchangeKE", 9912, 10L, this, false)) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                msg.addItemName(9912);
                msg.addNumber(10);
                player.sendPacket(msg);
                player.addItem("ExchangeKE", item, 1L, player, true);
                filename = "data/html/castlemagician/magician-KE-Exchange.htm";
            } else {
                filename = "data/html/castlemagician/magician-no-KE.htm";
            }
            this.showChatWindow(player, filename);
        } else if (command.equals("gotoleader")) {
            if (player.getClan() != null) {
                L2PcInstance clanLeader = player.getClan().getLeader().getPlayerInstance();
                if (clanLeader == null) {
                    return;
                }
                if (clanLeader.getFirstEffect(L2EffectType.CLAN_GATE) != null) {
                    if (!L2CastleMagicianInstance.validateGateCondition(clanLeader, player)) {
                        return;
                    }
                    player.teleToLocation(clanLeader.getX(), clanLeader.getY(), clanLeader.getZ(), false);
                    return;
                }
                this.showChatWindow(player, "data/html/castlemagician/magician-nogate.htm");
            }
        } else if (command.equals("subskills")) {
            if (player.isClanLeader()) {
                FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableSubPledgeSkills(player.getClan());
                AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.SubPledge);
                int count = 0;
                for (L2SkillLearn s : skills) {
                    if (SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel()) == null) continue;
                    asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), s.getLevelUpSp(), 0);
                    ++count;
                }
                if (count == 0) {
                    player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
                } else {
                    player.sendPacket(asl);
                }
            } else {
                this.showChatWindow(player, "data/html/castlemagician/magician-nosquad.htm");
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    protected int validateCondition(L2PcInstance player) {
        if (player.isGM()) {
            return 2;
        }
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getZone().isActive()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId()) {
                return 2;
            }
        }
        return 0;
    }

    private static final boolean validateGateCondition(L2PcInstance clanLeader, L2PcInstance player) {
        if (clanLeader.isAlikeDead()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInStoreMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isRooted() || clanLeader.isInCombat()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInOlympiadMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isFestivalParticipant()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.inObserverMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInsideZone((byte)12)) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.getInstanceId() > 0 && (!Config.ALLOW_SUMMON_TO_INSTANCE || InstanceManager.getInstance().getInstance(player.getInstanceId()).isSummonAllowed())) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (player.isIn7sDungeon()) {
            int targetCabal = SevenSigns.getInstance().getPlayerCabal(clanLeader.getObjectId());
            if (SevenSigns.getInstance().isSealValidationPeriod()) {
                if (targetCabal != SevenSigns.getInstance().getCabalHighestScore()) {
                    player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
                    return false;
                }
            } else if (targetCabal == 0) {
                player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
                return false;
            }
        }
        if (!TvTEvent.onEscapeUse(player.getObjectId())) {
            player.sendMessage("You on TvT Event, teleporting disabled.");
            return false;
        }
        if (!TvTEvent.onEscapeUse(clanLeader.getObjectId())) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        return true;
    }

    @Override
    public void showSubUnitSkillList(L2PcInstance player) {
        this.onBypassFeedback(player, "subskills");
    }
}

