/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2BabyPetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PetStat;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetInventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2PetInstance
extends L2Summon {
    protected static final Logger _logPet = Logger.getLogger(L2PetInstance.class.getName());
    private int _curFed;
    private PetInventory _inventory;
    private final int _controlObjectId;
    private boolean _respawned;
    private boolean _mountable;
    private Future<?> _feedTask;
    private L2PetData _data;
    private L2PetLevelData _leveldata;
    private long _expBeforeDeath = 0L;
    private int _curWeightPenalty = 0;
    private static final int PET_DECAY_DELAY = 86400000;

    public final L2PetLevelData getPetLevelData() {
        if (this._leveldata == null) {
            this._leveldata = PetDataTable.getInstance().getPetLevelData(this.getTemplate().npcId, this.getStat().getLevel());
        }
        return this._leveldata;
    }

    public final L2PetData getPetData() {
        if (this._data == null) {
            this._data = PetDataTable.getInstance().getPetData(this.getTemplate().npcId);
        }
        return this._data;
    }

    public final void setPetData(L2PetLevelData value) {
        this._leveldata = value;
    }

    public static synchronized L2PetInstance spawnPet(L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        if (L2World.getInstance().getPet(owner.getObjectId()) != null) {
            return null;
        }
        L2PetInstance pet = L2PetInstance.restore(control, template, owner);
        if (pet != null) {
            pet.setTitle(owner.getName());
            L2World.getInstance().addPet(owner.getObjectId(), pet);
        }
        return pet;
    }

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        this(objectId, template, owner, control, (byte)(template.idTemplate == 12564 ? owner.getLevel() : (int)template.level));
    }

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control, byte level) {
        super(objectId, template, owner);
        this.setInstanceType(L2Object.InstanceType.L2PetInstance);
        this._controlObjectId = control.getObjectId();
        this.getStat().setLevel((byte)Math.max(level, PetDataTable.getInstance().getPetMinLevel(template.npcId)));
        this._inventory = new PetInventory(this);
        this._inventory.restore();
        int npcId = template.npcId;
        this._mountable = PetDataTable.isMountable(npcId);
        this.getPetData();
        this.getPetLevelData();
    }

    @Override
    public PetStat getStat() {
        return (PetStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PetStat(this));
    }

    @Override
    public double getLevelMod() {
        return (89.0 + (double)this.getLevel()) / 100.0;
    }

    public boolean isRespawned() {
        return this._respawned;
    }

    @Override
    public int getSummonType() {
        return 2;
    }

    @Override
    public int getControlObjectId() {
        return this._controlObjectId;
    }

    public L2ItemInstance getControlItem() {
        return this.getOwner().getInventory().getItemByObjectId(this._controlObjectId);
    }

    public int getCurrentFed() {
        return this._curFed;
    }

    public void setCurrentFed(int num) {
        this._curFed = num > this.getMaxFed() ? this.getMaxFed() : num;
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        for (L2ItemInstance item : this.getInventory().getItems()) {
            if (item.getLocation() != L2ItemInstance.ItemLocation.PET_EQUIP || item.getItem().getBodyPart() != 128) continue;
            return item;
        }
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return null;
        }
        return (L2Weapon)weapon.getItem();
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public PetInventory getInventory() {
        return this._inventory;
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.destroyItem(process, objectId, count, this.getOwner(), (Object)reference);
        if (item == null) {
            if (sendMessage) {
                this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            }
            return false;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        petIU.addItem(item);
        this.getOwner().sendPacket(petIU);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item.getItemId());
                sm.addItemNumber(count);
                this.getOwner().sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item.getItemId());
                this.getOwner().sendPacket(sm);
            }
        }
        return true;
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.destroyItemByItemId(process, itemId, count, this.getOwner(), reference);
        if (item == null) {
            if (sendMessage) {
                this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS));
            }
            return false;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        petIU.addItem(item);
        this.getOwner().sendPacket(petIU);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item.getItemId());
                sm.addItemNumber(count);
                this.getOwner().sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item.getItemId());
                this.getOwner().sendPacket(sm);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPickupItem(L2Object object) {
        boolean follow = this.getFollowStatus();
        if (this.isDead()) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        StopMove sm = new StopMove(this.getObjectId(), this.getX(), this.getY(), this.getZ(), this.getHeading());
        if (Config.DEBUG) {
            _logPet.fine("Pet pickup pos: " + object.getX() + " " + object.getY() + " " + object.getZ());
        }
        this.broadcastPacket(sm);
        if (!(object instanceof L2ItemInstance)) {
            _logPet.warning(this + " trying to pickup wrong target." + object);
            this.getOwner().sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2ItemInstance target = (L2ItemInstance)object;
        if (CursedWeaponsManager.getInstance().isCursed(target.getItemId())) {
            SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
            smsg.addItemName(target.getItemId());
            this.getOwner().sendPacket(smsg);
            return;
        }
        L2ItemInstance smsg = target;
        synchronized (smsg) {
            if (!target.isVisible()) {
                this.getOwner().sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!this._inventory.validateCapacity(target)) {
                this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS));
                return;
            }
            if (!this._inventory.validateWeight(target, target.getCount())) {
                this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.UNABLE_TO_PLACE_ITEM_YOUR_PET_IS_TOO_ENCUMBERED));
                return;
            }
            if (target.getOwnerId() != 0 && target.getOwnerId() != this.getOwner().getObjectId() && !this.getOwner().isInLooterParty(target.getOwnerId())) {
                this.getOwner().sendPacket(ActionFailed.STATIC_PACKET);
                if (target.getItemId() == 57) {
                    SystemMessage smsg2 = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1_ADENA);
                    smsg2.addItemNumber(target.getCount());
                    this.getOwner().sendPacket(smsg2);
                } else if (target.getCount() > 1L) {
                    SystemMessage smsg3 = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S2_S1_S);
                    smsg3.addItemName(target.getItemId());
                    smsg3.addItemNumber(target.getCount());
                    this.getOwner().sendPacket(smsg3);
                } else {
                    SystemMessage smsg4 = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                    smsg4.addItemName(target.getItemId());
                    this.getOwner().sendPacket(smsg4);
                }
                return;
            }
            if (target.getItemLootShedule() != null && (target.getOwnerId() == this.getOwner().getObjectId() || this.getOwner().isInLooterParty(target.getOwnerId()))) {
                target.resetOwnerTimer();
            }
            target.pickupMe(this);
            if (Config.SAVE_DROPPED_ITEM) {
                ItemsOnGroundManager.getInstance().removeObject(target);
            }
        }
        if (target.getItemType() == L2EtcItemType.HERB) {
            IItemHandler handler = ItemHandler.getInstance().getItemHandler(target.getEtcItem());
            if (handler == null) {
                _log.fine("No item handler registered for item ID " + target.getItemId() + ".");
            } else {
                handler.useItem(this, target, false);
            }
            ItemTable.getInstance().destroyItem("Consume", target, this.getOwner(), null);
            this.broadcastStatusUpdate();
        } else {
            SystemMessage sm2;
            if (target.getItemId() == 57) {
                sm2 = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1_ADENA);
                sm2.addItemNumber(target.getCount());
                this.getOwner().sendPacket(sm2);
            } else if (target.getEnchantLevel() > 0) {
                sm2 = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1_S2);
                sm2.addNumber(target.getEnchantLevel());
                sm2.addString(target.getName());
                this.getOwner().sendPacket(sm2);
            } else if (target.getCount() > 1L) {
                sm2 = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S2_S1_S);
                sm2.addItemNumber(target.getCount());
                sm2.addString(target.getName());
                this.getOwner().sendPacket(sm2);
            } else {
                sm2 = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1);
                sm2.addString(target.getName());
                this.getOwner().sendPacket(sm2);
            }
            this.getInventory().addItem("Pickup", target, this.getOwner(), this);
            PetItemList iu = new PetItemList(this);
            this.getOwner().sendPacket(iu);
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (follow) {
            this.followOwner();
        }
    }

    @Override
    public void deleteMe(L2PcInstance owner) {
        this.getInventory().transferItemsToOwner();
        super.deleteMe(owner);
        this.destroyControlItem(owner, false);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer, true)) {
            return false;
        }
        this.stopFeed();
        this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.MAKE_SURE_YOU_RESSURECT_YOUR_PET_WITHIN_24_HOURS));
        DecayTaskManager.getInstance().addDecayTask(this, 86400000);
        L2PcInstance owner = this.getOwner();
        if (!(owner == null || owner.isInDuel() || this.isInsideZone((byte)0) && !this.isInsideZone((byte)2))) {
            this.deathPenalty();
        }
        return true;
    }

    @Override
    public void doRevive() {
        this.getOwner().removeReviving();
        super.doRevive();
        DecayTaskManager.getInstance().cancelDecayTask(this);
        this.startFeed();
        if (!this.isHungry()) {
            this.setRunning();
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
    }

    @Override
    public void doRevive(double revivePower) {
        this.restoreExp(revivePower);
        this.doRevive();
    }

    public L2ItemInstance transferItem(String process, int objectId, long count, Inventory target, L2PcInstance actor, L2Object reference) {
        L2ItemInstance oldItem = this.getInventory().getItemByObjectId(objectId);
        L2ItemInstance playerOldItem = target.getItemByItemId(oldItem.getItemId());
        L2ItemInstance newItem = this.getInventory().transferItem(process, objectId, count, target, actor, reference);
        if (newItem == null) {
            return null;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        if (oldItem.getCount() > 0L && oldItem != newItem) {
            petIU.addModifiedItem(oldItem);
        } else {
            petIU.addRemovedItem(oldItem);
        }
        this.getOwner().sendPacket(petIU);
        if (!newItem.isStackable()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addNewItem(newItem);
            this.getOwner().sendPacket(iu);
        } else if (playerOldItem != null && newItem.isStackable()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(newItem);
            this.getOwner().sendPacket(iu);
        }
        return newItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyControlItem(L2PcInstance owner, boolean evolve) {
        L2World.getInstance().removePet(owner.getObjectId());
        try {
            L2ItemInstance removedItem;
            if (evolve) {
                removedItem = owner.getInventory().destroyItem("Evolve", this.getControlObjectId(), 1L, this.getOwner(), (Object)this);
            } else {
                removedItem = owner.getInventory().destroyItem("PetDestroy", this.getControlObjectId(), 1L, this.getOwner(), (Object)this);
                if (removedItem != null) {
                    owner.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED).addItemName(removedItem));
                }
            }
            if (removedItem == null) {
                _log.warning("Couldn't destroy pet control item for " + owner + " pet: " + this + " evolve: " + evolve);
            } else {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addRemovedItem(removedItem);
                owner.sendPacket(iu);
                StatusUpdate su = new StatusUpdate(owner);
                su.addAttribute(14, owner.getCurrentLoad());
                owner.sendPacket(su);
                owner.broadcastUserInfo();
                L2World.getInstance().removeObject(removedItem);
            }
        }
        catch (Exception e) {
            _logPet.log(Level.WARNING, "Error while destroying control item: " + e.getMessage(), e);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
            statement.setInt(1, this.getControlObjectId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _logPet.log(Level.SEVERE, "Failed to delete Pet [ObjectId: " + this.getObjectId() + "]", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void dropAllItems() {
        try {
            for (L2ItemInstance item : this.getInventory().getItems()) {
                this.dropItemHere(item);
            }
        }
        catch (Exception e) {
            _logPet.log(Level.WARNING, "Pet Drop Error: " + e.getMessage(), e);
        }
    }

    public void dropItemHere(L2ItemInstance dropit, boolean protect) {
        dropit = this.getInventory().dropItem("Drop", dropit.getObjectId(), dropit.getCount(), this.getOwner(), this);
        if (dropit != null) {
            if (protect) {
                dropit.getDropProtection().protect(this.getOwner());
            }
            _logPet.finer("Item id to drop: " + dropit.getItemId() + " amount: " + dropit.getCount());
            dropit.dropMe(this, this.getX(), this.getY(), this.getZ() + 100);
        }
    }

    public void dropItemHere(L2ItemInstance dropit) {
        this.dropItemHere(dropit, false);
    }

    @Override
    public boolean isMountable() {
        return this._mountable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static L2PetInstance restore(L2ItemInstance control, L2NpcTemplate template, L2PcInstance owner) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT item_obj_id, name, level, curHp, curMp, exp, sp, fed FROM pets WHERE item_obj_id=?");
            statement.setInt(1, control.getObjectId());
            ResultSet rset = statement.executeQuery();
            if (!rset.next()) {
                L2PetInstance pet = template.type.compareToIgnoreCase("L2BabyPet") == 0 ? new L2BabyPetInstance(IdFactory.getInstance().getNextId(), template, owner, control) : new L2PetInstance(IdFactory.getInstance().getNextId(), template, owner, control);
                rset.close();
                statement.close();
                L2PetInstance l2PetInstance = pet;
                return l2PetInstance;
            }
            L2PetInstance pet = template.type.compareToIgnoreCase("L2BabyPet") == 0 ? new L2BabyPetInstance(IdFactory.getInstance().getNextId(), template, owner, control, rset.getByte("level")) : new L2PetInstance(IdFactory.getInstance().getNextId(), template, owner, control, rset.getByte("level"));
            pet._respawned = true;
            pet.setName(rset.getString("name"));
            long exp = rset.getLong("exp");
            L2PetLevelData info = PetDataTable.getInstance().getPetLevelData(pet.getNpcId(), pet.getLevel());
            if (info != null && exp < info.getPetMaxExp()) {
                exp = info.getPetMaxExp();
            }
            pet.getStat().setExp(exp);
            pet.getStat().setSp(rset.getInt("sp"));
            pet.getStatus().setCurrentHp(rset.getDouble("curHp"));
            pet.getStatus().setCurrentMp(rset.getDouble("curMp"));
            pet.getStatus().setCurrentCp(pet.getMaxCp());
            if (rset.getDouble("curHp") < 0.5) {
                pet.setIsDead(true);
                pet.stopHpMpRegeneration();
            }
            pet.setCurrentFed(rset.getInt("fed"));
            rset.close();
            statement.close();
            L2PetInstance l2PetInstance = pet;
            return l2PetInstance;
        }
        catch (Exception e) {
            _logPet.log(Level.WARNING, "Could not restore pet data for owner: " + owner + " - " + e.getMessage(), e);
            L2PetInstance l2PetInstance = null;
            return l2PetInstance;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() {
        if (this.getControlObjectId() == 0) {
            return;
        }
        String req = !this.isRespawned() ? "INSERT INTO pets (name,level,curHp,curMp,exp,sp,fed,item_obj_id) VALUES (?,?,?,?,?,?,?,?)" : "UPDATE pets SET name=?,level=?,curHp=?,curMp=?,exp=?,sp=?,fed=? WHERE item_obj_id = ?";
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(req);
            statement.setString(1, this.getName());
            statement.setInt(2, this.getStat().getLevel());
            statement.setDouble(3, this.getStatus().getCurrentHp());
            statement.setDouble(4, this.getStatus().getCurrentMp());
            statement.setLong(5, this.getStat().getExp());
            statement.setInt(6, this.getStat().getSp());
            statement.setInt(7, this.getCurrentFed());
            statement.setInt(8, this.getControlObjectId());
            statement.executeUpdate();
            statement.close();
            this._respawned = true;
        }
        catch (Exception e) {
            _logPet.log(Level.SEVERE, "Failed to store Pet [ObjectId: " + this.getObjectId() + "] data", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        L2ItemInstance itemInst = this.getControlItem();
        if (itemInst != null && itemInst.getEnchantLevel() != this.getStat().getLevel()) {
            itemInst.setEnchantLevel(this.getStat().getLevel());
            itemInst.updateDatabase();
        }
    }

    public synchronized void stopFeed() {
        if (this._feedTask != null) {
            this._feedTask.cancel(false);
            this._feedTask = null;
            if (Config.DEBUG) {
                _logPet.fine("Pet [#" + this.getObjectId() + "] feed task stop");
            }
        }
    }

    public synchronized void startFeed() {
        this.stopFeed();
        if (!this.isDead() && this.getOwner().getPet() == this) {
            this._feedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FeedTask(), 10000L, 10000L);
        }
    }

    @Override
    public synchronized void unSummon(L2PcInstance owner) {
        this.stopFeed();
        this.stopHpMpRegeneration();
        super.unSummon(owner);
        if (!this.isDead()) {
            if (this.getInventory() != null) {
                this.getInventory().deleteMe();
            }
            L2World.getInstance().removePet(owner.getObjectId());
        }
    }

    public void restoreExp(double restorePercent) {
        if (this._expBeforeDeath > 0L) {
            this.getStat().addExp(Math.round((double)(this._expBeforeDeath - this.getStat().getExp()) * restorePercent / 100.0));
            this._expBeforeDeath = 0L;
        }
    }

    private void deathPenalty() {
        byte lvl = this.getStat().getLevel();
        double percentLost = -0.07 * (double)lvl + 6.5;
        long lostExp = Math.round((double)(this.getStat().getExpForLevel(lvl + 1) - this.getStat().getExpForLevel(lvl)) * percentLost / 100.0);
        this._expBeforeDeath = this.getStat().getExp();
        this.getStat().addExp(-lostExp);
    }

    @Override
    public void addExpAndSp(long addToExp, int addToSp) {
        if (this.getNpcId() == 12564) {
            this.getStat().addExpAndSp(Math.round((float)addToExp * Config.SINEATER_XP_RATE), addToSp);
        } else {
            this.getStat().addExpAndSp(Math.round((float)addToExp * Config.PET_XP_RATE), addToSp);
        }
    }

    @Override
    public long getExpForThisLevel() {
        return this.getStat().getExpForLevel(this.getLevel());
    }

    @Override
    public long getExpForNextLevel() {
        return this.getStat().getExpForLevel(this.getLevel() + 1);
    }

    @Override
    public final int getLevel() {
        return this.getStat().getLevel();
    }

    public int getMaxFed() {
        return this.getStat().getMaxFeed();
    }

    @Override
    public int getCriticalHit(L2Character target, L2Skill skill) {
        return this.getStat().getCriticalHit(target, skill);
    }

    @Override
    public int getMAtk(L2Character target, L2Skill skill) {
        return this.getStat().getMAtk(target, skill);
    }

    @Override
    public int getMDef(L2Character target, L2Skill skill) {
        return this.getStat().getMDef(target, skill);
    }

    @Override
    public final int getSkillLevel(int skillId) {
        if (this.getKnownSkill(skillId) == null) {
            return -1;
        }
        int lvl = this.getLevel();
        return lvl > 70 ? 7 + (lvl - 70) / 5 : lvl / 10;
    }

    public void updateRefOwner(L2PcInstance owner) {
        int oldOwnerId = this.getOwner().getObjectId();
        this.setOwner(owner);
        L2World.getInstance().removePet(oldOwnerId);
        L2World.getInstance().addPet(oldOwnerId, this);
    }

    public int getCurrentLoad() {
        return this._inventory.getTotalWeight();
    }

    @Override
    public final int getMaxLoad() {
        return this.getPetData().getLoad();
    }

    public int getInventoryLimit() {
        return Config.INVENTORY_MAXIMUM_PET;
    }

    public void refreshOverloaded() {
        int maxLoad = this.getMaxLoad();
        if (maxLoad > 0) {
            int newWeightPenalty;
            int weightproc = this.getCurrentLoad() * 1000 / maxLoad;
            if (this._curWeightPenalty != (newWeightPenalty = (weightproc *= (int)this.calcStat(Stats.WEIGHT_LIMIT, 1.0, this, null)) < 500 || this.getOwner().getDietMode() ? 0 : (weightproc < 666 ? 1 : (weightproc < 800 ? 2 : (weightproc < 1000 ? 3 : 4))))) {
                this._curWeightPenalty = newWeightPenalty;
                if (newWeightPenalty > 0) {
                    this.addSkill(SkillTable.getInstance().getInfo(4270, newWeightPenalty));
                    this.setIsOverloaded(this.getCurrentLoad() >= maxLoad);
                } else {
                    super.removeSkill(this.getKnownSkill(4270));
                    this.setIsOverloaded(false);
                }
            }
        }
    }

    @Override
    public void updateAndBroadcastStatus(int val) {
        this.refreshOverloaded();
        super.updateAndBroadcastStatus(val);
    }

    @Override
    public final boolean isHungry() {
        return (float)this.getCurrentFed() < (float)this.getPetData().getHungry_limit() / 100.0f * (float)this.getPetLevelData().getPetMaxFeed();
    }

    @Override
    public final int getWeapon() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(5);
        if (weapon != null) {
            return weapon.getItemId();
        }
        return 0;
    }

    @Override
    public final int getArmor() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(6);
        if (weapon != null) {
            return weapon.getItemId();
        }
        return 0;
    }

    public final int getJewel() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(4);
        if (weapon != null) {
            return weapon.getItemId();
        }
        return 0;
    }

    @Override
    public short getSoulShotsPerHit() {
        return this.getPetLevelData().getPetSoulShot();
    }

    @Override
    public short getSpiritShotsPerHit() {
        return this.getPetLevelData().getPetSpiritShot();
    }

    @Override
    public void setName(String name) {
        L2ItemInstance controlItem = this.getControlItem();
        if (this.getControlItem().getCustomType2() == (name == null ? 1 : 0)) {
            controlItem.setCustomType2(name != null ? 1 : 0);
            controlItem.updateDatabase();
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(controlItem);
            this.getOwner().sendPacket(iu);
        }
        super.setName(name);
    }

    @Override
    protected void broadcastModifiedStats(FastList<Stats> stats) {
        if (this.getInstanceType() == L2Object.InstanceType.L2PetInstance) {
            super.broadcastModifiedStats(stats);
        }
    }

    public boolean canEatFoodId(int itemId) {
        return Util.contains(this._data.getFood(), itemId);
    }

    class FeedTask
    implements Runnable {
        FeedTask() {
        }

        @Override
        public void run() {
            try {
                SystemMessage sm;
                if (L2PetInstance.this.getOwner() == null || L2PetInstance.this.getOwner().getPet() == null || L2PetInstance.this.getOwner().getPet().getObjectId() != L2PetInstance.this.getObjectId()) {
                    L2PetInstance.this.stopFeed();
                    return;
                }
                if (L2PetInstance.this.getCurrentFed() > this.getFeedConsume()) {
                    L2PetInstance.this.setCurrentFed(L2PetInstance.this.getCurrentFed() - this.getFeedConsume());
                } else {
                    L2PetInstance.this.setCurrentFed(0);
                }
                L2PetInstance.this.broadcastStatusUpdate();
                int[] foodIds = L2PetInstance.this.getPetData().getFood();
                if (foodIds.length == 0) {
                    if (L2PetInstance.this.getCurrentFed() == 0) {
                        if (L2PetInstance.this.getTemplate().npcId == 16050 && L2PetInstance.this.getOwner() != null) {
                            L2PetInstance.this.getOwner().setPkKills(Math.max(0, L2PetInstance.this.getOwner().getPkKills() - Rnd.get(1, 6)));
                        }
                        L2PetInstance.this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_HELPER_PET_LEAVING));
                        L2PetInstance.this.deleteMe(L2PetInstance.this.getOwner());
                    } else if (L2PetInstance.this.isHungry()) {
                        L2PetInstance.this.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THERE_NOT_MUCH_TIME_REMAINING_UNTIL_HELPER_LEAVES));
                    }
                    return;
                }
                L2ItemInstance food = null;
                for (int id : foodIds) {
                    food = L2PetInstance.this.getInventory().getItemByItemId(id);
                    if (food != null) break;
                }
                if (L2PetInstance.this.isRunning() && L2PetInstance.this.isHungry()) {
                    L2PetInstance.this.setWalking();
                } else if (!L2PetInstance.this.isHungry() && !L2PetInstance.this.isRunning()) {
                    L2PetInstance.this.setRunning();
                }
                if (food != null && L2PetInstance.this.isHungry()) {
                    IItemHandler handler = ItemHandler.getInstance().getItemHandler(food.getEtcItem());
                    if (handler != null) {
                        SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY);
                        sm2.addItemName(food.getItemId());
                        L2PetInstance.this.getOwner().sendPacket(sm2);
                        handler.useItem(L2PetInstance.this, food, false);
                    }
                } else if (L2PetInstance.this.getCurrentFed() == 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOUR_PET_IS_VERY_HUNGRY);
                    L2PetInstance.this.getOwner().sendPacket(sm);
                    if (Rnd.get(100) < 30) {
                        L2PetInstance.this.stopFeed();
                        sm = SystemMessage.getSystemMessage(SystemMessageId.STARVING_GRUMPY_AND_FED_UP_YOUR_PET_HAS_LEFT);
                        L2PetInstance.this.getOwner().sendPacket(sm);
                        L2Character._log.info("Hungry pet [" + L2PetInstance.this.getTemplate().getName() + "][" + L2PetInstance.this.getLevel() + "] deleted for player: " + L2PetInstance.this.getOwner() + " Control Item Id :" + L2PetInstance.this.getControlObjectId());
                        L2PetInstance.this.deleteMe(L2PetInstance.this.getOwner());
                    }
                } else if ((double)L2PetInstance.this.getCurrentFed() < 0.1 * (double)L2PetInstance.this.getPetLevelData().getPetMaxFeed()) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.PET_CAN_RUN_AWAY_WHEN_HUNGER_BELOW_10_PERCENT);
                    L2PetInstance.this.getOwner().sendPacket(sm);
                    if (Rnd.get(100) < 3) {
                        L2PetInstance.this.stopFeed();
                        sm = SystemMessage.getSystemMessage(SystemMessageId.STARVING_GRUMPY_AND_FED_UP_YOUR_PET_HAS_LEFT);
                        L2PetInstance.this.getOwner().sendPacket(sm);
                        L2Character._log.info("Hungry pet [" + L2PetInstance.this.getTemplate().getName() + "][" + L2PetInstance.this.getLevel() + "] deleted for player: " + L2PetInstance.this.getOwner() + " Control Item Id :" + L2PetInstance.this.getControlObjectId());
                        L2PetInstance.this.deleteMe(L2PetInstance.this.getOwner());
                    }
                }
            }
            catch (Exception e) {
                _logPet.log(Level.SEVERE, "Pet [ObjectId: " + L2PetInstance.this.getObjectId() + "] a feed task error has occurred", e);
            }
        }

        private int getFeedConsume() {
            if (L2PetInstance.this.isAttackingNow()) {
                return L2PetInstance.this.getPetLevelData().getPetFeedBattle();
            }
            return L2PetInstance.this.getPetLevelData().getPetFeedNormal();
        }
    }
}

