/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.AbstractEnchantPacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutEnchantSupportItemResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class RequestExTryToPutEnchantSupportItem
extends AbstractEnchantPacket {
    private int _supportObjectId;
    private int _enchantObjectId;

    @Override
    public String getType() {
        return "[C] D0:50 RequestExTryToPutEnchantSupportItem".intern();
    }

    @Override
    protected void readImpl() {
        this._supportObjectId = this.readD();
        this._enchantObjectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar != null && activeChar.isEnchanting()) {
            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._enchantObjectId);
            L2ItemInstance support = activeChar.getInventory().getItemByObjectId(this._supportObjectId);
            if (item == null || support == null) {
                return;
            }
            AbstractEnchantPacket.EnchantItem supportTemplate = RequestExTryToPutEnchantSupportItem.getSupportItem(support);
            if (supportTemplate == null || !supportTemplate.isValid(item)) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION));
                activeChar.setActiveEnchantSupportItem(null);
                activeChar.sendPacket(new ExPutEnchantSupportItemResult(0));
                return;
            }
            activeChar.setActiveEnchantSupportItem(support);
            activeChar.sendPacket(new ExPutEnchantSupportItemResult(this._supportObjectId));
        }
    }
}

