/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestJoinSiege
extends L2GameClientPacket {
    private static final String _C__A4_RequestJoinSiege = "[C] a4 RequestJoinSiege";
    private int _castleId;
    private int _isAttacker;
    private int _isJoining;

    @Override
    protected void readImpl() {
        this._castleId = this.readD();
        this._isAttacker = this.readD();
        this._isJoining = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if ((activeChar.getClanPrivileges() & 0x40000) != 262144) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        Castle castle = CastleManager.getInstance().getCastleById(this._castleId);
        if (castle == null) {
            return;
        }
        if (this._isJoining == 1) {
            if (System.currentTimeMillis() < clan.getDissolvingExpiryTime()) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_PARTICIPATE_IN_SIEGE_WHILE_DISSOLUTION_IN_PROGRESS));
                return;
            }
            if (this._isAttacker == 1) {
                castle.getSiege().registerAttacker(activeChar);
            } else {
                castle.getSiege().registerDefender(activeChar);
            }
        } else {
            castle.getSiege().removeSiegeClan(activeChar);
        }
        castle.getSiege().listRegisterClan(activeChar);
    }

    @Override
    public String getType() {
        return _C__A4_RequestJoinSiege;
    }
}

