/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import javolution.util.FastList;

public class ListPartyWating
extends L2GameServerPacket {
    private L2PcInstance _cha;
    private int _loc;
    private int _lim;
    private FastList<PartyMatchRoom> _rooms;

    public ListPartyWating(L2PcInstance player, int auto, int location, int limit) {
        this._cha = player;
        this._loc = location;
        this._lim = limit;
        this._rooms = new FastList();
    }

    @Override
    protected final void writeImpl() {
        for (PartyMatchRoom room : PartyMatchRoomList.getInstance().getRooms()) {
            if (room.getMembers() < 1 || room.getOwner() == null || !room.getOwner().isOnline() || room.getOwner().getPartyRoom() != room.getId()) {
                PartyMatchRoomList.getInstance().deleteRoom(room.getId());
                continue;
            }
            if (this._loc > 0 && this._loc != room.getLocation() || this._lim == 0 && (this._cha.getLevel() < room.getMinLvl() || this._cha.getLevel() > room.getMaxLvl())) continue;
            this._rooms.add((Object)room);
        }
        int count = 0;
        int size = this._rooms.size();
        this.writeC(156);
        if (size > 0) {
            this.writeD(1);
        } else {
            this.writeD(0);
        }
        this.writeD(this._rooms.size());
        while (size > count) {
            this.writeD(((PartyMatchRoom)this._rooms.get(count)).getId());
            this.writeS(((PartyMatchRoom)this._rooms.get(count)).getTitle());
            this.writeD(((PartyMatchRoom)this._rooms.get(count)).getLocation());
            this.writeD(((PartyMatchRoom)this._rooms.get(count)).getMinLvl());
            this.writeD(((PartyMatchRoom)this._rooms.get(count)).getMaxLvl());
            this.writeD(((PartyMatchRoom)this._rooms.get(count)).getMembers());
            this.writeD(((PartyMatchRoom)this._rooms.get(count)).getMaxMembers());
            this.writeS(((PartyMatchRoom)this._rooms.get(count)).getOwner().getName());
            ++count;
        }
    }

    @Override
    public String getType() {
        return "[S] 9c ListPartyWating";
    }
}

