/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectCombatPointHeal
extends L2Effect {
    public EffectCombatPointHeal(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.COMBAT_POINT_HEAL;
    }

    @Override
    public boolean onActionTime() {
        return false;
    }

    @Override
    public boolean onStart() {
        L2Character target = this.getEffected();
        if (target.isInvul()) {
            return false;
        }
        double cp = this.calc();
        if (target.getCurrentCp() + cp > (double)target.getMaxCp()) {
            cp = (double)target.getMaxCp() - target.getCurrentCp();
        }
        target.setCurrentCp(cp + target.getCurrentCp());
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CP_WILL_BE_RESTORED);
        sm.addNumber((int)cp);
        target.sendPacket(sm);
        return false;
    }
}

