/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller.util.mysql;

import com.l2jserver.tools.dbinstaller.DBOutputInterface;
import com.l2jserver.util.file.filter.SQLFilter;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class ScriptExecutor {
    DBOutputInterface _frame;
    String _log;

    public ScriptExecutor(DBOutputInterface frame, String log) {
        this._frame = frame;
        this._log = log;
        new File(log).delete();
    }

    public void execSqlBatch(File dir) {
        this.execSqlBatch(dir, false);
    }

    public void execSqlBatch(File dir, boolean skipErrors) {
        Object[] file = dir.listFiles(new SQLFilter());
        Arrays.sort(file);
        this._frame.setProgressIndeterminate(false);
        this._frame.setProgressMaximum(file.length - 1);
        for (int i = 0; i < file.length; ++i) {
            this._frame.setProgressValue(i);
            this.execSqlFile((File)file[i], skipErrors);
        }
    }

    public void execSqlFile(File file) {
        this.execSqlFile(file, false);
    }

    private void execSqlFile(File file, boolean skipErrors) {
        this.execSqlFile(file, skipErrors, "Installing ");
    }

    private void execSqlFile(File file, boolean skipErrors, String header) {
        int lineNumber = 0;
        this.log(file.getPath() + ":");
        this._frame.appendToProgressArea(header + file.getName());
        Connection con = this._frame.getConnection();
        try (Statement stmt = con.createStatement();
             LineNumberReader scn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder(256);
            Pattern patternComment1 = Pattern.compile("(?<!-)--\\s.*");
            Pattern patternSourceStatement = Pattern.compile("^SOURCE[ \t]+(.+);$", 2);
            while ((line = scn.readLine()) != null) {
                if ((line = line + System.lineSeparator()).startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                String trimed = patternComment1.matcher(line).replaceFirst("").trim();
                if (sb.length() == 0) {
                    if (trimed.length() == 0) continue;
                    lineNumber = scn.getLineNumber();
                }
                sb.append(line);
                if (!trimed.endsWith(";")) continue;
                String sql = sb.toString();
                sb.setLength(0);
                Matcher m = patternSourceStatement.matcher(sql);
                if (m.find()) {
                    this.execSqlFile(new File(m.group(1)), skipErrors, "SOURCE ");
                    continue;
                }
                if (skipErrors) {
                    try {
                        stmt.execute(sql);
                    }
                    catch (SQLException e) {
                        this.log(e.getMessage());
                    }
                    continue;
                }
                stmt.execute(sql);
            }
            if (sb.length() > 0) {
                stmt.execute(sb.toString());
            }
        }
        catch (FileNotFoundException e) {
            this.log(e);
            JOptionPane.showMessageDialog(null, "File Not Found!: " + e.getMessage(), "Installer Error", 0);
        }
        catch (SQLException e) {
            this.log(e);
            assert (!skipErrors);
            try {
                Object[] options = new Object[]{"Continue", "Abort"};
                Matcher m = Pattern.compile(" at line (\\d+)").matcher(e.getMessage());
                if (m.find()) {
                    lineNumber = lineNumber + Integer.parseInt(m.group(1)) - 1;
                }
                m = null;
                int n = JOptionPane.showOptionDialog(null, "MySQL Error: " + e.getMessage() + "\r\n" + file.getPath() + (lineNumber > 0 ? " at line " + lineNumber : ""), "Script Error", 0, 2, null, options, options[0]);
                if (n == 1) {
                    System.exit(0);
                }
            }
            catch (HeadlessException h) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.log(e);
            Object[] options = new Object[]{"Abort"};
            JOptionPane.showOptionDialog(null, "Error: " + e.getMessage() + "\r\n" + file.getPath(), "Error", -1, 0, null, options, options[0]);
            System.exit(0);
        }
    }

    private PrintWriter openLog() {
        try {
            return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._log, true), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void log(String msg) {
        System.out.println(msg);
        PrintWriter log = this.openLog();
        log.println(msg);
        log.close();
    }

    private void log(Throwable error) {
        error.printStackTrace();
        PrintWriter log = this.openLog();
        error.printStackTrace(log);
        log.close();
    }
}

