/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util.crypt;

import com.l2jserver.util.crypt.BlowfishEngine;

public final class NewCrypt {
    private final BlowfishEngine _cipher = new BlowfishEngine();

    public NewCrypt(byte[] blowfishKey) {
        this._cipher.init(blowfishKey);
    }

    public NewCrypt(String key) {
        this(key.getBytes());
    }

    public static boolean verifyChecksum(byte[] raw) {
        return NewCrypt.verifyChecksum(raw, 0, raw.length);
    }

    public static boolean verifyChecksum(byte[] raw, int offset, int size) {
        long check;
        if ((size & 3) != 0 || size <= 4) {
            return false;
        }
        long chksum = 0L;
        int count = size - 4;
        int i = offset;
        while (i < count) {
            check = raw[i++] & 0xFF | (raw[i++] & 0xFF) << 8 | (raw[i++] & 0xFF) << 16 | (raw[i++] & 0xFF) << 24;
            chksum ^= check;
        }
        return (check = (long)(raw[i++] & 0xFF | (raw[i++] & 0xFF) << 8 | (raw[i++] & 0xFF) << 16 | (raw[i++] & 0xFF) << 24)) == chksum;
    }

    public static void appendChecksum(byte[] raw) {
        NewCrypt.appendChecksum(raw, 0, raw.length);
    }

    public static void appendChecksum(byte[] raw, int offset, int size) {
        long chksum = 0L;
        int count = size - 4;
        int i = offset;
        while (i < count) {
            long ecx = raw[i++] & 0xFF | (raw[i++] & 0xFF) << 8 | (raw[i++] & 0xFF) << 16 | (raw[i++] & 0xFF) << 24;
            chksum ^= ecx;
        }
        raw[i++] = (byte)chksum;
        raw[i++] = (byte)(chksum >>> 8);
        raw[i++] = (byte)(chksum >>> 16);
        raw[i++] = (byte)(chksum >>> 24);
    }

    public static void encXORPass(byte[] raw, int key) {
        NewCrypt.encXORPass(raw, 0, raw.length, key);
    }

    static void encXORPass(byte[] raw, int offset, int size, int key) {
        int stop = size - 8;
        int pos = 4 + offset;
        int ecx = key;
        while (pos < stop) {
            int edx = raw[pos] & 0xFF | (raw[pos + 1] & 0xFF) << 8 | (raw[pos + 2] & 0xFF) << 16 | (raw[pos + 3] & 0xFF) << 24;
            ecx += edx;
            raw[pos++] = (byte)(edx ^= ecx);
            raw[pos++] = (byte)(edx >>> 8);
            raw[pos++] = (byte)(edx >>> 16);
            raw[pos++] = (byte)(edx >>> 24);
        }
        raw[pos++] = (byte)ecx;
        raw[pos++] = (byte)(ecx >>> 8);
        raw[pos++] = (byte)(ecx >>> 16);
        raw[pos++] = (byte)(ecx >>> 24);
    }

    public void decrypt(byte[] raw) {
        int length = raw.length & 0xFFFFFFF8;
        for (int i = 0; i < length; i += 8) {
            this._cipher.decryptBlock(raw, i, raw, i);
        }
    }

    public void decrypt(byte[] raw, int offset, int size) {
        for (int i = offset; i < offset + size; i += 8) {
            this._cipher.decryptBlock(raw, i);
        }
    }

    public void crypt(byte[] raw) {
        int length = raw.length & 0xFFFFFFF8;
        for (int i = 0; i < length; i += 8) {
            this._cipher.encryptBlock(raw, i, raw, i);
        }
    }

    public void crypt(byte[] raw, int offset, int size) {
        for (int i = offset; i < offset + size; i += 8) {
            this._cipher.encryptBlock(raw, i);
        }
    }
}

