/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassLoader
extends ClassLoader {
    private static Logger _log = Logger.getLogger(JarClassLoader.class.getCanonicalName());
    private final HashSet<String> _jars = new HashSet();

    public void addJarFile(String filename) {
        this._jars.add(filename);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            byte[] b = this.loadClassData(name);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name);
        }
    }

    private byte[] loadClassData(String name) throws IOException {
        byte[] classData = null;
        String fileName = name.replace('.', '/') + ".class";
        for (String jarFile : this._jars) {
            File file = new File(jarFile);
            try {
                ZipFile zipFile = new ZipFile(file);
                Throwable throwable = null;
                try {
                    ZipEntry entry = zipFile.getEntry(fileName);
                    if (entry == null) continue;
                    classData = new byte[(int)entry.getSize()];
                    try (DataInputStream zipStream = new DataInputStream(zipFile.getInputStream(entry));){
                        zipStream.readFully(classData, 0, (int)entry.getSize());
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            catch (IOException e) {
                _log.log(Level.WARNING, jarFile + ": " + e.getMessage(), e);
            }
        }
        if (classData == null) {
            throw new IOException("class not found in " + this._jars);
        }
        return classData;
    }
}

