/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.util.Util;
import com.l2jserver.util.file.filter.NumericNameFilter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class BuyListData
extends DocumentParser {
    private final FastIntObjectMap<L2BuyList> _buyLists = new FastIntObjectMap();

    protected BuyListData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        long started = System.currentTimeMillis();
        this.setCurrentFileFilter(new NumericNameFilter());
        this._buyLists.clear();
        this.parseDatapackDirectory("data/buylists", false);
        if (Config.CUSTOM_BUYLIST_LOAD) {
            this.parseDatapackDirectory("data/buylists/custom", false);
        }
        this.setCurrentFileFilter(null);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._buyLists.size() + " BuyLists from XML. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        started = System.currentTimeMillis();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM `buylists`");){
            while (rs.next()) {
                int buyListId = rs.getInt("buylist_id");
                int itemId = rs.getInt("item_id");
                long count = rs.getLong("count");
                long nextRestockTime = rs.getLong("next_restock_time");
                L2BuyList buyList = this.getBuyList(buyListId);
                if (buyList == null) {
                    this._log.warning("BuyList found in database but not loaded from xml! BuyListId: " + buyListId);
                    continue;
                }
                Product product = buyList.getProductByItemId(itemId);
                if (product == null) {
                    this._log.warning("ItemId found in database but not loaded from xml! BuyListId: " + buyListId + " ItemId: " + itemId);
                    continue;
                }
                if (count >= product.getMaxCount()) continue;
                product.setCount(count);
                product.restartRestockTask(nextRestockTime);
            }
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "Failed to load buyList data from database.", e);
        }
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._buyLists.size() + " BuyLists from DB. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    @Override
    protected void parseDocument() {
        try {
            int buyListId = Integer.parseInt(this.getCurrentFile().getName().replace(".xml", ""));
            for (Node node = this.getCurrentDocument().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
                L2BuyList buyList = new L2BuyList(buyListId);
                for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                    if ("item".equalsIgnoreCase(list_node.getNodeName())) {
                        L2Item item;
                        int itemId = -1;
                        long price = -1L;
                        long restockDelay = -1L;
                        long count = -1L;
                        NamedNodeMap attrs = list_node.getAttributes();
                        Node attr = attrs.getNamedItem("id");
                        itemId = Integer.parseInt(attr.getNodeValue());
                        attr = attrs.getNamedItem("price");
                        if (attr != null) {
                            price = Long.parseLong(attr.getNodeValue());
                        }
                        if ((attr = attrs.getNamedItem("restock_delay")) != null) {
                            restockDelay = Long.parseLong(attr.getNodeValue());
                        }
                        if ((attr = attrs.getNamedItem("count")) != null) {
                            count = Long.parseLong(attr.getNodeValue());
                        }
                        if ((item = ItemTable.getInstance().getTemplate(itemId)) != null) {
                            buyList.addProduct(new Product(buyList.getListId(), item, price, restockDelay, count));
                            continue;
                        }
                        this._log.warning("Item not found. BuyList:" + buyList.getListId() + " ItemID:" + itemId + " File:" + this.getCurrentFile().getName());
                        continue;
                    }
                    if (!"npcs".equalsIgnoreCase(list_node.getNodeName())) continue;
                    for (Node npcs_node = list_node.getFirstChild(); npcs_node != null; npcs_node = npcs_node.getNextSibling()) {
                        if (!"npc".equalsIgnoreCase(npcs_node.getNodeName())) continue;
                        int npcId = Integer.parseInt(npcs_node.getTextContent());
                        buyList.addAllowedNpc(npcId);
                    }
                }
                this._buyLists.put(buyList.getListId(), (Object)buyList);
            }
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "Failed to load buyList data from xml File:" + this.getCurrentFile().getName(), e);
        }
    }

    public void checkAllPrice() {
        for (L2BuyList list : this._buyLists.values()) {
            for (Product tradeItem : list.getProducts()) {
                L2Item itemTemplate = ItemTable.getInstance().getTemplate(tradeItem.getItemId());
                long sellPrice = itemTemplate.getReferencePrice() / 2;
                long buyPrice = tradeItem.getPrice();
                if (0L >= buyPrice || buyPrice >= sellPrice) continue;
                StringBuilder npcName = new StringBuilder(256);
                int[] npcIds = list.getAllowedNpcs();
                if (npcIds != null) {
                    for (int npcId : npcIds) {
                        npcName.append(',').append(npcId).append('-').append(NpcTable.getInstance().getTemplate(npcId).getName());
                    }
                }
                if (npcName.length() > 0) {
                    npcName.deleteCharAt(0);
                }
                this._log.warning("merchant_buylists \u4fa1\u683c\u8a2d\u5b9a\u30df\u30b9 \u5e97:" + list.getListId() + " NPC:" + npcName + " Item:" + tradeItem.getItemId() + " " + itemTemplate.getName() + " \u5e97\u982d\u4fa1\u683c:" + com.l2jserver.gameserver.util.Util.formatAdena(buyPrice) + " \u58f2\u5374\u4fa1\u683c:" + com.l2jserver.gameserver.util.Util.formatAdena(sellPrice));
            }
        }
    }

    public L2BuyList getBuyList(int listId) {
        return (L2BuyList)this._buyLists.get(listId);
    }

    public static BuyListData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final BuyListData _instance = new BuyListData();

        private SingletonHolder() {
        }
    }
}

