/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.fishing.L2Fish;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FishData
extends DocumentParser {
    private static final Map<Integer, L2Fish> _fishNormal = new HashMap<Integer, L2Fish>();
    private static final Map<Integer, L2Fish> _fishEasy = new HashMap<Integer, L2Fish>();
    private static final Map<Integer, L2Fish> _fishHard = new HashMap<Integer, L2Fish>();

    protected FishData() {
        this.load();
    }

    @Override
    public void load() {
        _fishEasy.clear();
        _fishNormal.clear();
        _fishHard.clear();
        this.parseDatapackFile("data/stats/fishing/fishes.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + (_fishEasy.size() + _fishNormal.size() + _fishHard.size()) + " Fishes.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            block6: for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"fish".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                L2Fish fish = new L2Fish(set);
                switch (fish.getFishGrade()) {
                    case 0: {
                        _fishEasy.put(fish.getFishId(), fish);
                        continue block6;
                    }
                    case 1: {
                        _fishNormal.put(fish.getFishId(), fish);
                        continue block6;
                    }
                    case 2: {
                        _fishHard.put(fish.getFishId(), fish);
                    }
                }
            }
        }
    }

    public List<L2Fish> getFish(int level, int group, int grade) {
        ArrayList<L2Fish> result = new ArrayList<L2Fish>();
        Map<Integer, L2Fish> fish = null;
        switch (grade) {
            case 0: {
                fish = _fishEasy;
                break;
            }
            case 1: {
                fish = _fishNormal;
                break;
            }
            case 2: {
                fish = _fishHard;
                break;
            }
            default: {
                this._log.warning(this.getClass().getSimpleName() + ": Unmanaged fish grade!");
                return result;
            }
        }
        for (L2Fish f : fish.values()) {
            if (f.getFishLevel() != level || f.getFishGroup() != group) continue;
            result.add(f);
        }
        if (result.isEmpty()) {
            this._log.warning(this.getClass().getSimpleName() + ": Cannot find any fish for level: " + level + " group: " + group + " and grade: " + grade + "!");
        }
        return result;
    }

    public static FishData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FishData _instance = new FishData();

        private SingletonHolder() {
        }
    }
}

