/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.fishing.L2FishingRod;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class FishingRodsData
extends DocumentParser {
    private static final Map<Integer, L2FishingRod> _fishingRods = new HashMap<Integer, L2FishingRod>();

    protected FishingRodsData() {
        this.load();
    }

    @Override
    public void load() {
        _fishingRods.clear();
        this.parseDatapackFile("data/stats/fishing/fishingRods.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _fishingRods.size() + " Fishing Rods.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"fishingRod".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                L2FishingRod fishingRod = new L2FishingRod(set);
                _fishingRods.put(fishingRod.getFishingRodItemId(), fishingRod);
            }
        }
    }

    public L2FishingRod getFishingRod(int itemId) {
        return _fishingRods.get(itemId);
    }

    public static FishingRodsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FishingRodsData _instance = new FishingRodsData();

        private SingletonHolder() {
        }
    }
}

