/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HerbDropTable {
    private static final Logger _log = Logger.getLogger(HerbDropTable.class.getName());
    private final Map<Integer, List<L2DropCategory>> _herbGroups = new HashMap<Integer, List<L2DropCategory>>();

    protected HerbDropTable() {
        this.restoreData();
    }

    private void restoreData() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement statement = con.createStatement();
             ResultSet dropData = statement.executeQuery("SELECT groupId,itemId,min,max,category,chance FROM herb_droplist_groups ORDER BY groupId,chance DESC");){
            L2DropData dropDat = null;
            while (dropData.next()) {
                List<Object> category;
                int groupId = dropData.getInt("groupId");
                if (this._herbGroups.containsKey(groupId)) {
                    category = this._herbGroups.get(groupId);
                } else {
                    category = new ArrayList();
                    this._herbGroups.put(groupId, category);
                }
                dropDat = new L2DropData();
                dropDat.setItemId(dropData.getInt("itemId"));
                dropDat.setMinDrop(dropData.getInt("min"));
                dropDat.setMaxDrop(dropData.getInt("max"));
                dropDat.setChance(dropData.getInt("chance"));
                int categoryType = dropData.getInt("category");
                if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                    _log.warning(this.getClass().getSimpleName() + ": Data for undefined item template! GroupId: " + groupId + " itemId: " + dropDat.getItemId());
                    continue;
                }
                boolean catExists = false;
                for (L2DropCategory l2DropCategory : category) {
                    if (l2DropCategory.getCategoryType() != categoryType) continue;
                    l2DropCategory.addDropData(dropDat, false);
                    catExists = true;
                    break;
                }
                if (catExists) continue;
                L2DropCategory cat = new L2DropCategory(categoryType);
                cat.addDropData(dropDat, false);
                category.add(cat);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading Herb dropdata. ", e);
        }
    }

    public List<L2DropCategory> getHerbDroplist(int groupId) {
        return this._herbGroups.get(groupId);
    }

    public static HerbDropTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HerbDropTable _instance = new HerbDropTable();

        private SingletonHolder() {
        }
    }
}

