/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KarmaData
extends DocumentParser {
    private final Map<Integer, Double> _karmaTable = new HashMap<Integer, Double>();

    public KarmaData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._karmaTable.clear();
        this.parseDatapackFile("data/stats/chars/pcKarmaIncrease.xml");
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded " + this._karmaTable.size() + " karma modifiers.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"pcKarmaIncrease".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"increase".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                this._karmaTable.put(this.parseInteger(attrs, "lvl"), this.parseDouble(attrs, "val"));
            }
        }
    }

    public double getMultiplier(int level) {
        return this._karmaTable.get(level);
    }

    public static KarmaData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final KarmaData _instance = new KarmaData();

        private SingletonHolder() {
        }
    }
}

