/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcPersonalAIData;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.interfaces.IProcedure;
import com.l2jserver.util.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastSet;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SpawnTable
extends DocumentParser {
    private static final Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private static final String SELECT_SPAWNS = "SELECT count, npc_templateid, locx, locy, locz, heading, respawn_delay, respawn_random, loc_id, periodOfDay FROM spawnlist";
    private static final String SELECT_CUSTOM_SPAWNS = "SELECT count, npc_templateid, locx, locy, locz, heading, respawn_delay, respawn_random, loc_id, periodOfDay FROM custom_spawnlist";
    private static final FastIntObjectMap<FastSet<L2Spawn>> _spawnTable = new FastIntObjectMap().shared();
    private int _xmlSpawnCount = 0;

    protected SpawnTable() {
        this.load();
    }

    @Override
    public void load() {
        if (!Config.ALT_DEV_NO_SPAWNS) {
            long started = System.currentTimeMillis();
            this.fillSpawnTable(false);
            int spawnCount = _spawnTable.size();
            _log.info(this.getClass().getSimpleName() + ": Loaded " + spawnCount + " npc spawns. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            if (Config.CUSTOM_SPAWNLIST_TABLE) {
                started = System.currentTimeMillis();
                this.fillSpawnTable(true);
                _log.info(this.getClass().getSimpleName() + ": Loaded " + (_spawnTable.size() - spawnCount) + " custom npc spawns. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
            }
            started = System.currentTimeMillis();
            this.parseDatapackDirectory("data/spawnlist", false);
            _log.info(this.getClass().getSimpleName() + ": Loaded " + this._xmlSpawnCount + " npc spawns from XML. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        }
    }

    private boolean checkTemplate(int npcId) {
        L2NpcTemplate npcTemplate = NpcTable.getInstance().getTemplate(npcId);
        if (npcTemplate == null) {
            _log.warning(this.getClass().getSimpleName() + ": Data missing in NPC table for ID: " + npcId + ".");
            return false;
        }
        return !npcTemplate.isType("L2SiegeGuard") && !npcTemplate.isType("L2RaidBoss") && (Config.ALLOW_CLASS_MASTERS || !npcTemplate.isType("L2ClassMaster"));
    }

    @Override
    protected void parseDocument() {
        for (Node list = this.getCurrentDocument().getFirstChild(); list != null; list = list.getNextSibling()) {
            NamedNodeMap attrs;
            if (!list.getNodeName().equalsIgnoreCase("list") || !Boolean.parseBoolean((attrs = list.getAttributes()).getNamedItem("enabled").getNodeValue())) continue;
            for (Node param = list.getFirstChild(); param != null; param = param.getNextSibling()) {
                attrs = param.getAttributes();
                if (!param.getNodeName().equalsIgnoreCase("spawn")) continue;
                String territoryName = null;
                String spawnName = null;
                HashMap<String, Integer> map = null;
                if (attrs.getNamedItem("name") != null) {
                    spawnName = this.parseString(attrs, "name");
                }
                if (attrs.getNamedItem("zone") != null && ZoneManager.getInstance().getSpawnTerritory(attrs.getNamedItem("zone").getNodeValue()) != null) {
                    territoryName = this.parseString(attrs, "zone");
                }
                for (Node npctag = param.getFirstChild(); npctag != null; npctag = npctag.getNextSibling()) {
                    String period;
                    attrs = npctag.getAttributes();
                    if (npctag.getNodeName().equalsIgnoreCase("AIData")) {
                        attrs = npctag.getAttributes();
                        if (map == null) {
                            map = new HashMap<String, Integer>();
                        }
                        for (Node c = npctag.getFirstChild(); c != null; c = c.getNextSibling()) {
                            int val;
                            if (c.getNodeName().equals("#text")) continue;
                            switch (c.getNodeName()) {
                                case "disableRandomAnimation": 
                                case "disableRandomWalk": {
                                    val = Boolean.parseBoolean(c.getTextContent()) ? 1 : 0;
                                    break;
                                }
                                default: {
                                    val = Integer.parseInt(c.getTextContent());
                                }
                            }
                            map.put(c.getNodeName(), val);
                        }
                        continue;
                    }
                    if (!npctag.getNodeName().equalsIgnoreCase("npc")) continue;
                    int templateId = this.parseInteger(attrs, "id");
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    try {
                        x = this.parseInteger(attrs, "x");
                        y = this.parseInteger(attrs, "y");
                        z = this.parseInteger(attrs, "z");
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    if (x == 0 && y == 0 && territoryName == null) {
                        _log.warning("XML Spawnlist: Spawn could not be initialized, both coordinates and zone are unspecified for ID " + templateId);
                        continue;
                    }
                    StatsSet spawnInfo = new StatsSet();
                    spawnInfo.set("npcTemplateid", templateId);
                    spawnInfo.set("x", x);
                    spawnInfo.set("y", y);
                    spawnInfo.set("z", z);
                    spawnInfo.set("territoryName", territoryName);
                    spawnInfo.set("spawnName", spawnName);
                    if (attrs.getNamedItem("heading") != null) {
                        spawnInfo.set("heading", this.parseInteger(attrs, "heading"));
                    }
                    if (attrs.getNamedItem("count") != null) {
                        spawnInfo.set("count", this.parseInteger(attrs, "count"));
                    }
                    if (attrs.getNamedItem("respawnDelay") != null) {
                        spawnInfo.set("respawnDelay", this.parseInteger(attrs, "respawnDelay"));
                    }
                    if (attrs.getNamedItem("respawnRandom") != null) {
                        spawnInfo.set("respawnRandom", this.parseInteger(attrs, "respawnRandom"));
                    }
                    if (attrs.getNamedItem("periodOfDay") != null && ((period = attrs.getNamedItem("periodOfDay").getNodeValue()).equalsIgnoreCase("day") || period.equalsIgnoreCase("night"))) {
                        spawnInfo.set("periodOfDay", period.equalsIgnoreCase("day") ? 1 : 2);
                    }
                    this._xmlSpawnCount += this.addSpawn(spawnInfo, map);
                }
            }
        }
    }

    private int fillSpawnTable(boolean isCustom) {
        int npcSpawnCount = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery(isCustom ? SELECT_CUSTOM_SPAWNS : SELECT_SPAWNS);){
            while (rs.next()) {
                StatsSet spawnInfo = new StatsSet();
                int npcId = rs.getInt("npc_templateid");
                if (!this.checkTemplate(npcId)) continue;
                spawnInfo.set("npcTemplateid", npcId);
                spawnInfo.set("count", rs.getInt("count"));
                spawnInfo.set("x", rs.getInt("locx"));
                spawnInfo.set("y", rs.getInt("locy"));
                spawnInfo.set("z", rs.getInt("locz"));
                spawnInfo.set("heading", rs.getInt("heading"));
                spawnInfo.set("respawnDelay", rs.getInt("respawn_delay"));
                spawnInfo.set("respawnRandom", rs.getInt("respawn_random"));
                spawnInfo.set("locId", rs.getInt("loc_id"));
                spawnInfo.set("periodOfDay", rs.getInt("periodOfDay"));
                spawnInfo.set("isCustomSpawn", isCustom);
                npcSpawnCount += this.addSpawn(spawnInfo);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Spawn could not be initialized: " + e.getMessage(), e);
        }
        return npcSpawnCount;
    }

    private int addSpawn(StatsSet spawnInfo, Map<String, Integer> AIData) {
        int ret = 0;
        try {
            L2Spawn spawnDat = new L2Spawn(NpcTable.getInstance().getTemplate(spawnInfo.getInt("npcTemplateid")));
            spawnDat.setAmount(spawnInfo.getInt("count", 1));
            spawnDat.setX(spawnInfo.getInt("x", 0));
            spawnDat.setY(spawnInfo.getInt("y", 0));
            spawnDat.setZ(spawnInfo.getInt("z", 0));
            spawnDat.setHeading(spawnInfo.getInt("heading", -1));
            spawnDat.setRespawnDelay(spawnInfo.getInt("respawnDelay", 0), spawnInfo.getInt("respawnRandom", 0));
            spawnDat.setLocationId(spawnInfo.getInt("locId", 0));
            String territoryName = spawnInfo.getString("territoryName", "");
            String spawnName = spawnInfo.getString("spawnName", "");
            spawnDat.setCustom(spawnInfo.getBoolean("isCustomSpawn", false));
            if (!spawnName.isEmpty()) {
                spawnDat.setName(spawnName);
            }
            if (!territoryName.isEmpty()) {
                spawnDat.setSpawnTerritory(ZoneManager.getInstance().getSpawnTerritory(territoryName));
            }
            NpcPersonalAIData.getInstance().storeData(spawnDat, AIData);
            switch (spawnInfo.getInt("periodOfDay", 0)) {
                case 0: {
                    ret += spawnDat.init();
                    break;
                }
                case 1: {
                    DayNightSpawnManager.getInstance().addDayCreature(spawnDat);
                    ret = 1;
                    break;
                }
                case 2: {
                    DayNightSpawnManager.getInstance().addNightCreature(spawnDat);
                    ret = 1;
                }
            }
            this.addSpawn(spawnDat);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Spawn could not be initialized: " + e.getMessage(), e);
        }
        return ret;
    }

    private int addSpawn(StatsSet spawnInfo) {
        return this.addSpawn(spawnInfo, null);
    }

    public FastIntObjectMap<FastSet<L2Spawn>> getSpawnTable() {
        return _spawnTable;
    }

    public Set<L2Spawn> getSpawns(int npcId) {
        FastSet t = (FastSet)_spawnTable.get(npcId);
        return t != null ? t : Collections.emptySet();
    }

    public L2Spawn getFirstSpawn(int npcId) {
        FastSet t = (FastSet)_spawnTable.get(npcId);
        if (t != null) {
            for (L2Spawn spawn : t) {
                if (spawn == null) continue;
                return spawn;
            }
        }
        return null;
    }

    public void addNewSpawn(L2Spawn spawn, boolean storeInDb) {
        this.addSpawn(spawn);
        if (storeInDb) {
            String spawnTable = spawn.isCustom() && Config.CUSTOM_SPAWNLIST_TABLE ? "custom_spawnlist" : "spawnlist";
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement insert = con.prepareStatement("INSERT INTO " + spawnTable + "(count,npc_templateid,locx,locy,locz,heading,respawn_delay,respawn_random,loc_id) values(?,?,?,?,?,?,?,?,?)");){
                insert.setInt(1, spawn.getAmount());
                insert.setInt(2, spawn.getId());
                insert.setInt(3, spawn.getX());
                insert.setInt(4, spawn.getY());
                insert.setInt(5, spawn.getZ());
                insert.setInt(6, spawn.getHeading());
                insert.setInt(7, spawn.getRespawnDelay() / 1000);
                insert.setInt(8, spawn.getRespawnMaxDelay() - spawn.getRespawnMinDelay());
                insert.setInt(9, spawn.getLocationId());
                insert.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not store spawn in the DB:" + e.getMessage(), e);
            }
            String zoneName = MapRegionManager.getInstance().getClosestTownName(spawn.getX(), spawn.getY());
            SpawnTable.addSqlLog("-- " + Util.dateFormat() + " " + spawn.getTemplate().getTitle() + " " + spawn.getTemplate().getName() + " - " + zoneName + "\r\n" + "INSERT INTO " + spawnTable + " SET location='//spawn." + zoneName + "'" + ", count=" + spawn.getAmount() + ", npc_templateid=" + spawn.getId() + ", locx=" + spawn.getX() + ", locy=" + spawn.getY() + ", locz=" + spawn.getZ() + ", heading=" + spawn.getHeading() + ", respawn_delay=" + spawn.getRespawnDelay() / 1000 + ", loc_id=" + spawn.getLocation() + ";\r\n");
        }
    }

    public void deleteSpawn(L2Spawn spawn, boolean updateDb) {
        if (!this.removeSpawn(spawn)) {
            return;
        }
        if (updateDb) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement delete = con.prepareStatement("DELETE FROM " + (spawn.isCustom() ? "custom_spawnlist" : "spawnlist") + " WHERE locx=? AND locy=? AND locz=? AND npc_templateid=? AND heading=?");){
                delete.setInt(1, spawn.getX());
                delete.setInt(2, spawn.getY());
                delete.setInt(3, spawn.getZ());
                delete.setInt(4, spawn.getId());
                delete.setInt(5, spawn.getHeading());
                delete.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Spawn " + spawn + " could not be removed from DB: " + e.getMessage(), e);
            }
            String zoneName = MapRegionManager.getInstance().getClosestTownName(spawn.getX(), spawn.getY());
            SpawnTable.addSqlLog("-- " + Util.dateFormat() + " " + spawn.getTemplate().getTitle() + " " + spawn.getTemplate().getName() + " - " + zoneName + "\r\n" + "DELETE FROM " + (spawn.isCustom() ? "custom_spawnlist" : "spawnlist") + " WHERE locx=" + spawn.getX() + " AND locy=" + spawn.getY() + " AND locz=" + spawn.getZ() + " AND npc_templateid=" + spawn.getId() + " AND heading=" + spawn.getHeading() + ";\r\n");
        }
    }

    private void addSpawn(L2Spawn spawn) {
        FastSet test = (FastSet)_spawnTable.get(spawn.getId());
        if (test == null) {
            test = new FastSet().shared();
            _spawnTable.put(spawn.getId(), (Object)test);
        }
        test.add((Object)spawn);
    }

    private boolean removeSpawn(L2Spawn spawn) {
        FastSet set = (FastSet)_spawnTable.get(spawn.getId());
        if (set != null) {
            boolean removed = set.remove((Object)spawn);
            if (set.isEmpty()) {
                _spawnTable.remove(spawn.getId());
            }
            return removed;
        }
        return false;
    }

    public boolean forEachSpawn(IProcedure<L2Spawn, Boolean> procedure) {
        for (Set set : _spawnTable.values()) {
            for (L2Spawn spawn : set) {
                if (procedure.execute(spawn)) continue;
                return false;
            }
        }
        return true;
    }

    public void addNewSpawnOne(L2Npc npc) {
        Set t = (Set)_spawnTable.get(npc.getId());
        if (t != null) {
            t.clear();
        }
        this.addNewSpawn(npc.getSpawn(), false);
    }

    public void deleteSpawnOne(L2Npc npc) {
        _spawnTable.remove(npc.getSpawn().getId());
    }

    public L2Spawn getSpawnOne(int npcId) {
        Set t = (Set)_spawnTable.get(npcId);
        if (t != null && t.size() > 0) {
            return (L2Spawn)t.iterator().next();
        }
        return null;
    }

    private static void addSqlLog(String sql) {
        System.out.print(sql);
        try {
            BufferedWriter save = Util.utf8BufferedWriter("log/_spawnlist.sql", true);
            save.write(sql);
            save.flush();
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SpawnTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SpawnTable _instance = new SpawnTable();

        private SingletonHolder() {
        }
    }
}

