/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.ActionKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class UIData
extends DocumentParser {
    private static final Logger _log = Logger.getLogger(UIData.class.getName());
    private final Map<Integer, List<ActionKey>> _storedKeys = new HashMap<Integer, List<ActionKey>>();
    private final Map<Integer, List<Integer>> _storedCategories = new HashMap<Integer, List<Integer>>();

    protected UIData() {
        this.load();
    }

    @Override
    public void load() {
        this._storedKeys.clear();
        this._storedCategories.clear();
        this.parseDatapackFile("data/ui/ui_en.xml");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._storedKeys.size() + " keys " + this._storedCategories.size() + " categories.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"category".equalsIgnoreCase(d.getNodeName())) continue;
                this.parseCategory(d);
            }
        }
    }

    private void parseCategory(Node n) {
        int cat = this.parseInteger(n.getAttributes(), "id");
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            if ("commands".equalsIgnoreCase(d.getNodeName())) {
                this.parseCommands(cat, d);
                continue;
            }
            if (!"keys".equalsIgnoreCase(d.getNodeName())) continue;
            this.parseKeys(cat, d);
        }
    }

    private void parseCommands(int cat, Node d) {
        for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!"cmd".equalsIgnoreCase(c.getNodeName())) continue;
            UIData.addCategory(this._storedCategories, cat, Integer.parseInt(c.getTextContent()));
        }
    }

    private void parseKeys(int cat, Node d) {
        for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!"key".equalsIgnoreCase(c.getNodeName())) continue;
            ActionKey akey = new ActionKey(cat);
            block15: for (int i = 0; i < c.getAttributes().getLength(); ++i) {
                Node att = c.getAttributes().item(i);
                int val = Integer.parseInt(att.getNodeValue());
                switch (att.getNodeName()) {
                    case "cmd": {
                        akey.setCommandId(val);
                        continue block15;
                    }
                    case "key": {
                        akey.setKeyId(val);
                        continue block15;
                    }
                    case "toggleKey1": {
                        akey.setToogleKey1(val);
                        continue block15;
                    }
                    case "toggleKey2": {
                        akey.setToogleKey2(val);
                        continue block15;
                    }
                    case "showType": {
                        akey.setShowStatus(val);
                    }
                }
            }
            UIData.addKey(this._storedKeys, cat, akey);
        }
    }

    public static void addCategory(Map<Integer, List<Integer>> map, int cat, int cmd) {
        if (!map.containsKey(cat)) {
            map.put(cat, new ArrayList());
        }
        map.get(cat).add(cmd);
    }

    public static void addKey(Map<Integer, List<ActionKey>> map, int cat, ActionKey akey) {
        if (!map.containsKey(cat)) {
            map.put(cat, new ArrayList());
        }
        map.get(cat).add(akey);
    }

    public Map<Integer, List<Integer>> getCategories() {
        return this._storedCategories;
    }

    public Map<Integer, List<ActionKey>> getKeys() {
        return this._storedKeys;
    }

    public static UIData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final UIData _instance = new UIData();

        private SingletonHolder() {
        }
    }
}

