/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.ManorData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.itemcontainer.ClanWarehouse;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class CastleManorManager {
    protected static final Logger _log = Logger.getLogger(CastleManorManager.class.getName());
    public static final int PERIOD_CURRENT = 0;
    public static final int PERIOD_NEXT = 1;
    private static final String CASTLE_MANOR_LOAD_PROCURE = "SELECT * FROM castle_manor_procure WHERE castle_id=?";
    private static final String CASTLE_MANOR_LOAD_PRODUCTION = "SELECT * FROM castle_manor_production WHERE castle_id=?";
    private static final int NEXT_PERIOD_APPROVE = Config.ALT_MANOR_APPROVE_TIME;
    private static final int NEXT_PERIOD_APPROVE_MIN = Config.ALT_MANOR_APPROVE_MIN;
    private static final int MANOR_REFRESH = Config.ALT_MANOR_REFRESH_TIME;
    private static final int MANOR_REFRESH_MIN = Config.ALT_MANOR_REFRESH_MIN;
    protected static final long MAINTENANCE_PERIOD = Config.ALT_MANOR_MAINTENANCE_PERIOD;
    private Calendar _manorRefresh;
    private Calendar _periodApprove;
    private boolean _underMaintenance;
    private boolean _disabled;
    protected ScheduledFuture<?> _scheduledManorRefresh;
    protected ScheduledFuture<?> _scheduledMaintenanceEnd;
    protected ScheduledFuture<?> _scheduledNextPeriodapprove;

    protected CastleManorManager() {
        this.load();
        this.init();
        this._underMaintenance = false;
        boolean bl = this._disabled = !Config.ALLOW_MANOR;
        boolean isApproved = this._periodApprove.getTimeInMillis() > this._manorRefresh.getTimeInMillis() ? this._manorRefresh.getTimeInMillis() > System.currentTimeMillis() : this._periodApprove.getTimeInMillis() < System.currentTimeMillis() && this._manorRefresh.getTimeInMillis() > System.currentTimeMillis();
        for (Castle c : CastleManager.getInstance().getCastles()) {
            c.setNextPeriodApproved(isApproved);
        }
    }

    private void load() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statementProduction = con.prepareStatement(CASTLE_MANOR_LOAD_PRODUCTION);
             PreparedStatement statementProcure = con.prepareStatement(CASTLE_MANOR_LOAD_PROCURE);){
            for (Castle castle : CastleManager.getInstance().getCastles()) {
                FastList production = new FastList();
                FastList productionNext = new FastList();
                FastList procure = new FastList();
                FastList procureNext = new FastList();
                statementProduction.setInt(1, castle.getResidenceId());
                try (ResultSet rs = statementProduction.executeQuery();){
                    statementProduction.clearParameters();
                    while (rs.next()) {
                        int seedId = rs.getInt("seed_id");
                        int canProduce = rs.getInt("can_produce");
                        int startProduce = rs.getInt("start_produce");
                        int price = rs.getInt("seed_price");
                        int period = rs.getInt("period");
                        if (period == 0) {
                            production.add((Object)new SeedProduction(seedId, canProduce, price, startProduce));
                            continue;
                        }
                        productionNext.add((Object)new SeedProduction(seedId, canProduce, price, startProduce));
                    }
                }
                castle.setSeedProduction((List<SeedProduction>)production, 0);
                castle.setSeedProduction((List<SeedProduction>)productionNext, 1);
                statementProcure.setInt(1, castle.getResidenceId());
                rs = statementProcure.executeQuery();
                var14_21 = null;
                try {
                    statementProcure.clearParameters();
                    while (rs.next()) {
                        int cropId = rs.getInt("crop_id");
                        int canBuy = rs.getInt("can_buy");
                        int startBuy = rs.getInt("start_buy");
                        int rewardType = rs.getInt("reward_type");
                        int price = rs.getInt("price");
                        int period = rs.getInt("period");
                        if (period == 0) {
                            procure.add((Object)new CropProcure(cropId, canBuy, rewardType, startBuy, price));
                            continue;
                        }
                        procureNext.add((Object)new CropProcure(cropId, canBuy, rewardType, startBuy, price));
                    }
                }
                catch (Throwable throwable) {
                    var14_21 = throwable;
                    throw throwable;
                }
                finally {
                    if (rs != null) {
                        if (var14_21 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                var14_21.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                castle.setCropProcure((List<CropProcure>)procure, 0);
                castle.setCropProcure((List<CropProcure>)procureNext, 1);
                if (procure.isEmpty() && procureNext.isEmpty() && production.isEmpty() && productionNext.isEmpty()) continue;
                _log.info(this.getClass().getSimpleName() + ": " + castle.getName() + ": Data loaded");
            }
        }
        catch (Exception e) {
            _log.info("Error restoring manor data: " + e.getMessage());
        }
    }

    private void init() {
        this._manorRefresh = Calendar.getInstance();
        this._manorRefresh.set(11, MANOR_REFRESH);
        this._manorRefresh.set(12, MANOR_REFRESH_MIN);
        this._periodApprove = Calendar.getInstance();
        this._periodApprove.set(11, NEXT_PERIOD_APPROVE);
        this._periodApprove.set(12, NEXT_PERIOD_APPROVE_MIN);
        this.updateManorRefresh();
        this.updatePeriodApprove();
    }

    public void updateManorRefresh() {
        _log.info("Manor System: Manor refresh updated");
        this._scheduledManorRefresh = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (!CastleManorManager.this.isDisabled()) {
                    CastleManorManager.this.setUnderMaintenance(true);
                    _log.info("Manor System: Under maintenance mode started");
                    CastleManorManager.this._scheduledMaintenanceEnd = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                        @Override
                        public void run() {
                            _log.info("Manor System: Next period started");
                            CastleManorManager.this.setNextPeriod();
                            try {
                                CastleManorManager.this.save();
                            }
                            catch (Exception e) {
                                _log.log(Level.WARNING, "Manor System: Failed to save manor data: " + e.getMessage(), e);
                            }
                            CastleManorManager.this.setUnderMaintenance(false);
                        }
                    }, MAINTENANCE_PERIOD);
                }
                CastleManorManager.this.updateManorRefresh();
            }
        }, this.getMillisToManorRefresh());
    }

    public void updatePeriodApprove() {
        _log.info("Manor System: Manor period approve updated");
        this._scheduledNextPeriodapprove = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (!CastleManorManager.this.isDisabled()) {
                    CastleManorManager.this.approveNextPeriod();
                    _log.info("Manor System: Next period approved");
                }
                CastleManorManager.this.updatePeriodApprove();
            }
        }, this.getMillisToNextPeriodApprove());
    }

    public long getMillisToManorRefresh() {
        if (this._manorRefresh.getTimeInMillis() - System.currentTimeMillis() < 120000L) {
            this.setNewManorRefresh();
        }
        _log.info("Manor System: New Schedule for manor refresh @ " + Util.dateFormat(this._manorRefresh));
        return this._manorRefresh.getTimeInMillis() - System.currentTimeMillis();
    }

    public void setNewManorRefresh() {
        this._manorRefresh = Calendar.getInstance();
        this._manorRefresh.set(11, MANOR_REFRESH);
        this._manorRefresh.set(12, MANOR_REFRESH_MIN);
        this._manorRefresh.set(13, 0);
        this._manorRefresh.add(11, 24);
    }

    public long getMillisToNextPeriodApprove() {
        if (this._periodApprove.getTimeInMillis() - System.currentTimeMillis() < 120000L) {
            this.setNewPeriodApprove();
        }
        _log.info("Manor System: New Schedule for period approve @ " + Util.dateFormat(this._periodApprove));
        return this._periodApprove.getTimeInMillis() - System.currentTimeMillis();
    }

    public void setNewPeriodApprove() {
        this._periodApprove = Calendar.getInstance();
        this._periodApprove.set(11, NEXT_PERIOD_APPROVE);
        this._periodApprove.set(12, NEXT_PERIOD_APPROVE_MIN);
        this._periodApprove.set(13, 0);
        this._periodApprove.add(11, 24);
    }

    public void setNextPeriod() {
        for (Castle c : CastleManager.getInstance().getCastles()) {
            L2Clan clan;
            if (c.getOwnerId() <= 0 || (clan = ClanTable.getInstance().getClan(c.getOwnerId())) == null) continue;
            ItemContainer cwh = clan.getWarehouse();
            if (!(cwh instanceof ClanWarehouse)) {
                _log.info("Can't get clan warehouse for clan " + ClanTable.getInstance().getClan(c.getOwnerId()));
                continue;
            }
            for (CropProcure crop : c.getCropProcure(0)) {
                if (crop.getStartAmount() == 0L) continue;
                if (crop.getStartAmount() - crop.getAmount() > 0L) {
                    long count = crop.getStartAmount() - crop.getAmount();
                    if ((count = count * 90L / 100L) < 1L && Rnd.nextInt(99) < 90) {
                        count = 1L;
                    }
                    if (count > 0L) {
                        cwh.addItem("Manor", ManorData.getInstance().getMatureCrop(crop.getId()), count, null, null);
                    }
                }
                if (crop.getAmount() <= 0L) continue;
                c.addToTreasuryNoTax(crop.getAmount() * crop.getPrice());
            }
            c.setSeedProduction(c.getSeedProduction(1), 0);
            c.setCropProcure(c.getCropProcure(1), 0);
            if (c.getTreasury() < c.getManorCost(0)) {
                c.setSeedProduction(this.getNewSeedsList(c.getResidenceId()), 1);
                c.setCropProcure(this.getNewCropsList(c.getResidenceId()), 1);
            } else {
                FastList production = new FastList();
                for (SeedProduction s : c.getSeedProduction(0)) {
                    s.setCanProduce(s.getStartProduce());
                    production.add((Object)s);
                }
                c.setSeedProduction((List<SeedProduction>)production, 1);
                FastList procure = new FastList();
                for (CropProcure cr : c.getCropProcure(0)) {
                    cr.setAmount(cr.getStartAmount());
                    procure.add((Object)cr);
                }
                c.setCropProcure((List<CropProcure>)procure, 1);
            }
            if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
                c.saveCropData();
                c.saveSeedData();
            }
            L2PcInstance clanLeader = null;
            clanLeader = L2World.getInstance().getPlayer(clan.getLeader().getName());
            if (clanLeader != null) {
                clanLeader.sendPacket(SystemMessageId.THE_MANOR_INFORMATION_HAS_BEEN_UPDATED);
            }
            c.setNextPeriodApproved(false);
        }
    }

    public void approveNextPeriod() {
        for (Castle c : CastleManager.getInstance().getCastles()) {
            boolean notFunc = false;
            if (c.getOwnerId() <= 0) {
                c.setCropProcure((List<CropProcure>)new FastList(), 1);
                c.setSeedProduction((List<SeedProduction>)new FastList(), 1);
            } else if (c.getTreasury() < c.getManorCost(1)) {
                notFunc = true;
                _log.info("Manor for castle " + c.getName() + " disabled, not enough adena in treasury: " + c.getTreasury() + ", " + c.getManorCost(1) + " required.");
                c.setSeedProduction(this.getNewSeedsList(c.getResidenceId()), 1);
                c.setCropProcure(this.getNewCropsList(c.getResidenceId()), 1);
            } else {
                ItemContainer cwh = ClanTable.getInstance().getClan(c.getOwnerId()).getWarehouse();
                if (!(cwh instanceof ClanWarehouse)) {
                    _log.info("Can't get clan warehouse for clan " + ClanTable.getInstance().getClan(c.getOwnerId()));
                    continue;
                }
                int slots = 0;
                for (CropProcure crop : c.getCropProcure(1)) {
                    if (crop.getStartAmount() <= 0L || cwh.getItemByItemId(ManorData.getInstance().getMatureCrop(crop.getId())) != null) continue;
                    ++slots;
                }
                if (!cwh.validateCapacity(slots)) {
                    notFunc = true;
                    _log.info("Manor for castle " + c.getName() + " disabled, not enough free slots in clan warehouse: " + (Config.WAREHOUSE_SLOTS_CLAN - cwh.getSize()) + ", but " + slots + " required.");
                    c.setSeedProduction(this.getNewSeedsList(c.getResidenceId()), 1);
                    c.setCropProcure(this.getNewCropsList(c.getResidenceId()), 1);
                }
            }
            c.setNextPeriodApproved(true);
            c.addToTreasuryNoTax(-c.getManorCost(1));
            if (!notFunc) continue;
            L2Clan clan = ClanTable.getInstance().getClan(c.getOwnerId());
            L2PcInstance clanLeader = null;
            if (clan != null) {
                clanLeader = L2World.getInstance().getPlayer(clan.getLeaderId());
            }
            if (clanLeader == null) continue;
            clanLeader.sendPacket(SystemMessageId.THE_AMOUNT_IS_NOT_SUFFICIENT_AND_SO_THE_MANOR_IS_NOT_IN_OPERATION);
        }
    }

    private List<SeedProduction> getNewSeedsList(int castleId) {
        ArrayList<SeedProduction> seeds = new ArrayList<SeedProduction>();
        List<Integer> seedsIds = ManorData.getInstance().getSeedsForCastle(castleId);
        for (int sd : seedsIds) {
            seeds.add(new SeedProduction(sd));
        }
        return seeds;
    }

    private List<CropProcure> getNewCropsList(int castleId) {
        ArrayList<CropProcure> crops = new ArrayList<CropProcure>();
        List<Integer> cropsIds = ManorData.getInstance().getCropsForCastle(castleId);
        for (int cr : cropsIds) {
            crops.add(new CropProcure(cr));
        }
        return crops;
    }

    public boolean isUnderMaintenance() {
        return this._underMaintenance;
    }

    public void setUnderMaintenance(boolean mode) {
        this._underMaintenance = mode;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean mode) {
        this._disabled = mode;
    }

    public SeedProduction getNewSeedProduction(int id, long amount, long price, long sales) {
        return new SeedProduction(id, amount, price, sales);
    }

    public CropProcure getNewCropProcure(int id, long amount, int type, long price, long buy) {
        return new CropProcure(id, amount, type, buy, price);
    }

    public void save() {
        for (Castle c : CastleManager.getInstance().getCastles()) {
            c.saveSeedData();
            c.saveCropData();
        }
    }

    public static final CastleManorManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CastleManorManager _instance = new CastleManorManager();

        private SingletonHolder() {
        }
    }
}

