/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.tasks.MessageDeletionTask;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostArrived;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class MailManager {
    private static final Logger _log = Logger.getLogger(MailManager.class.getName());
    private final FastMap<Integer, Message> _messages = new FastMap().shared();

    protected MailManager() {
        this.load();
    }

    private void load() {
        int count = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement ps = con.createStatement();
             ResultSet rs = ps.executeQuery("SELECT * FROM messages ORDER BY expiration");){
            while (rs.next()) {
                Message msg = new Message(rs);
                int msgId = msg.getId();
                this._messages.put((Object)msgId, (Object)msg);
                ++count;
                long expiration = msg.getExpiration();
                if (expiration < System.currentTimeMillis()) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msgId), 10000L);
                    continue;
                }
                ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msgId), expiration - System.currentTimeMillis());
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error loading from database:" + e.getMessage(), e);
        }
        _log.info(this.getClass().getSimpleName() + ": Successfully loaded " + count + " messages.");
    }

    public final Message getMessage(int msgId) {
        return (Message)this._messages.get((Object)msgId);
    }

    public final Collection<Message> getMessages() {
        return this._messages.values();
    }

    public final boolean hasUnreadPost(L2PcInstance player) {
        int objectId = player.getObjectId();
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getReceiverId() != objectId || !msg.isUnread()) continue;
            return true;
        }
        return false;
    }

    public final int getInboxSize(int objectId) {
        int size = 0;
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getReceiverId() != objectId || msg.isDeletedByReceiver()) continue;
            ++size;
        }
        return size;
    }

    public final int getOutboxSize(int objectId) {
        int size = 0;
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getSenderId() != objectId || msg.isDeletedBySender()) continue;
            ++size;
        }
        return size;
    }

    public final List<Message> getInbox(int objectId) {
        FastList inbox = new FastList();
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getReceiverId() != objectId || msg.isDeletedByReceiver()) continue;
            inbox.add(msg);
        }
        return inbox;
    }

    public final List<Message> getOutbox(int objectId) {
        FastList outbox = new FastList();
        for (Message msg : this.getMessages()) {
            if (msg == null || msg.getSenderId() != objectId || msg.isDeletedBySender()) continue;
            outbox.add(msg);
        }
        return outbox;
    }

    public void sendMessage(Message msg) {
        this._messages.put((Object)msg.getId(), (Object)msg);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = Message.getStatement(msg, con);){
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error saving message:" + e.getMessage(), e);
        }
        L2PcInstance receiver = L2World.getInstance().getPlayer(msg.getReceiverId());
        if (receiver != null) {
            receiver.sendPacket(ExNoticePostArrived.valueOf(true));
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new MessageDeletionTask(msg.getId()), msg.getExpiration() - System.currentTimeMillis());
    }

    public final void markAsReadInDb(int msgId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET isUnread = 'false' WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error marking as read message:" + e.getMessage(), e);
        }
    }

    public final void markAsDeletedBySenderInDb(int msgId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET isDeletedBySender = 'true' WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error marking as deleted by sender message:" + e.getMessage(), e);
        }
    }

    public final void markAsDeletedByReceiverInDb(int msgId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET isDeletedByReceiver = 'true' WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error marking as deleted by receiver message:" + e.getMessage(), e);
        }
    }

    public final void removeAttachmentsInDb(int msgId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE messages SET hasAttachments = 'false' WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error removing attachments in message:" + e.getMessage(), e);
        }
    }

    public final void deleteMessageInDb(int msgId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM messages WHERE messageId = ?");){
            ps.setInt(1, msgId);
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error deleting message:" + e.getMessage(), e);
        }
        this._messages.remove((Object)msgId);
        IdFactory.getInstance().releaseId(msgId);
    }

    public static MailManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final MailManager _instance = new MailManager();

        private SingletonHolder() {
        }
    }
}

