/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TowerSpawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.util.PropertiesParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class SiegeManager {
    private static final Logger _log = Logger.getLogger(SiegeManager.class.getName());
    private final Map<Integer, List<TowerSpawn>> _controlTowers = new HashMap<Integer, List<TowerSpawn>>();
    private final Map<Integer, List<TowerSpawn>> _flameTowers = new HashMap<Integer, List<TowerSpawn>>();
    private int _attackerMaxClans = 500;
    private int _attackerRespawnDelay = 0;
    private int _defenderMaxClans = 500;
    private int _flagMaxCount = 1;
    private int _siegeClanMinLevel = 5;
    private int _siegeLength = 120;
    private int _bloodAllianceReward = 0;

    protected SiegeManager() {
        this.load();
    }

    public final void addSiegeSkills(L2PcInstance character) {
        for (L2Skill sk : SkillTable.getInstance().getSiegeSkills(character.isNoble(), character.getClan().getCastleId() > 0)) {
            character.addSkill(sk, false);
        }
    }

    public final boolean checkIfOkToSummon(L2Character activeChar, boolean isCheckOnly) {
        if (!(activeChar instanceof L2PcInstance)) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        Castle castle = CastleManager.getInstance().getCastle(player);
        if (castle == null || castle.getResidenceId() <= 0) {
            text = "You must be on castle ground to summon this";
        } else if (!castle.getSiege().getIsInProgress()) {
            text = "You can only summon this during a siege.";
        } else if (player.getClanId() != 0 && castle.getSiege().getAttackerClan(player.getClanId()) == null) {
            text = "You can only summon this as a registered attacker.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }

    public final boolean checkIsRegistered(L2Clan clan, int castleid) {
        if (clan == null) {
            return false;
        }
        if (clan.getCastleId() > 0) {
            return true;
        }
        boolean register = false;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT clan_id FROM siege_clans where clan_id=? and castle_id=?");){
            statement.setInt(1, clan.getId());
            statement.setInt(2, castleid);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    register = true;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception: checkIsRegistered(): " + e.getMessage(), e);
        }
        return register;
    }

    public final void removeSiegeSkills(L2PcInstance character) {
        for (L2Skill sk : SkillTable.getInstance().getSiegeSkills(character.isNoble(), character.getClan().getCastleId() > 0)) {
            character.removeSkill(sk);
        }
    }

    private final void load() {
        PropertiesParser siegeSettings = new PropertiesParser("./config/Siege.properties");
        this._attackerMaxClans = siegeSettings.getInt("AttackerMaxClans", 500);
        this._attackerRespawnDelay = siegeSettings.getInt("AttackerRespawn", 0);
        this._defenderMaxClans = siegeSettings.getInt("DefenderMaxClans", 500);
        this._flagMaxCount = siegeSettings.getInt("MaxFlags", 1);
        this._siegeClanMinLevel = siegeSettings.getInt("SiegeClanMinLevel", 5);
        this._siegeLength = siegeSettings.getInt("SiegeLength", 120);
        this._bloodAllianceReward = siegeSettings.getInt("BloodAllianceReward", 0);
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            String settingsKeyName;
            String settingsKeyName2;
            ArrayList<TowerSpawn> controlTowers = new ArrayList<TowerSpawn>();
            for (int i = 1; i < 255 && siegeSettings.containskey(settingsKeyName2 = castle.getName() + "ControlTower" + i); ++i) {
                StringTokenizer st = new StringTokenizer(siegeSettings.getString(settingsKeyName2, ""), ",");
                try {
                    int x = Integer.parseInt(st.nextToken());
                    int y = Integer.parseInt(st.nextToken());
                    int z = Integer.parseInt(st.nextToken());
                    int npcId = Integer.parseInt(st.nextToken());
                    controlTowers.add(new TowerSpawn(npcId, new Location(x, y, z)));
                    continue;
                }
                catch (Exception e) {
                    _log.warning(this.getClass().getSimpleName() + ": Error while loading control tower(s) for " + castle.getName() + " castle.");
                }
            }
            ArrayList<TowerSpawn> flameTowers = new ArrayList<TowerSpawn>();
            for (int i = 1; i < 255 && siegeSettings.containskey(settingsKeyName = castle.getName() + "FlameTower" + i); ++i) {
                StringTokenizer st = new StringTokenizer(siegeSettings.getString(settingsKeyName, ""), ",");
                try {
                    int x = Integer.parseInt(st.nextToken());
                    int y = Integer.parseInt(st.nextToken());
                    int z = Integer.parseInt(st.nextToken());
                    int npcId = Integer.parseInt(st.nextToken());
                    ArrayList<Integer> zoneList = new ArrayList<Integer>();
                    while (st.hasMoreTokens()) {
                        zoneList.add(Integer.parseInt(st.nextToken()));
                    }
                    flameTowers.add(new TowerSpawn(npcId, new Location(x, y, z), zoneList));
                    continue;
                }
                catch (Exception e) {
                    _log.warning(this.getClass().getSimpleName() + ": Error while loading flame tower(s) for " + castle.getName() + " castle.");
                }
            }
            this._controlTowers.put(castle.getResidenceId(), controlTowers);
            this._flameTowers.put(castle.getResidenceId(), flameTowers);
            MercTicketManager.MERCS_MAX_PER_CASTLE[castle.getResidenceId() - 1] = siegeSettings.getInt(castle.getName() + "MaxMercenaries", MercTicketManager.MERCS_MAX_PER_CASTLE[castle.getResidenceId() - 1]);
            if (castle.getOwnerId() == 0) continue;
            this.loadTrapUpgrade(castle.getResidenceId());
        }
    }

    public final List<TowerSpawn> getControlTowers(int castleId) {
        return this._controlTowers.get(castleId);
    }

    public final List<TowerSpawn> getFlameTowers(int castleId) {
        return this._flameTowers.get(castleId);
    }

    public final int getAttackerMaxClans() {
        return this._attackerMaxClans;
    }

    public final int getAttackerRespawnDelay() {
        return this._attackerRespawnDelay;
    }

    public final int getDefenderMaxClans() {
        return this._defenderMaxClans;
    }

    public final int getFlagMaxCount() {
        return this._flagMaxCount;
    }

    public final Siege getSiege(ILocational loc) {
        return this.getSiege(loc.getX(), loc.getY(), loc.getZ());
    }

    public final Siege getSiege(L2Object activeObject) {
        return this.getSiege(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final Siege getSiege(int x, int y, int z) {
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            if (!castle.getSiege().checkIfInZone(x, y, z)) continue;
            return castle.getSiege();
        }
        return null;
    }

    public final int getSiegeClanMinLevel() {
        return this._siegeClanMinLevel;
    }

    public final int getSiegeLength() {
        return this._siegeLength;
    }

    public final int getBloodAllianceReward() {
        return this._bloodAllianceReward;
    }

    public final List<Siege> getSieges() {
        FastList sieges = new FastList();
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            sieges.add((Object)castle.getSiege());
        }
        return sieges;
    }

    private final void loadTrapUpgrade(int castleId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM castle_trapupgrade WHERE castleId=?");){
            ps.setInt(1, castleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._flameTowers.get(castleId).get(rs.getInt("towerIndex")).setUpgradeLevel(rs.getInt("level"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadTrapUpgrade(): " + e.getMessage(), e);
        }
    }

    public static final SiegeManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SiegeManager _instance = new SiegeManager();

        private SingletonHolder() {
        }
    }
}

