/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.BlockCheckerEngine;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;

public final class ArenaParticipantsHolder {
    private final int _arena;
    private final ArrayList<L2PcInstance> _redPlayers;
    private final ArrayList<L2PcInstance> _bluePlayers;
    private final BlockCheckerEngine _engine;

    public ArenaParticipantsHolder(int arena) {
        this._arena = arena;
        this._redPlayers = new ArrayList(6);
        this._bluePlayers = new ArrayList(6);
        this._engine = new BlockCheckerEngine(this, this._arena);
    }

    public List<L2PcInstance> getRedPlayers() {
        return this._redPlayers;
    }

    public List<L2PcInstance> getBluePlayers() {
        return this._bluePlayers;
    }

    public List<L2PcInstance> getAllPlayers() {
        ArrayList<L2PcInstance> all = new ArrayList<L2PcInstance>(12);
        all.addAll(this._redPlayers);
        all.addAll(this._bluePlayers);
        return all;
    }

    public void addPlayer(L2PcInstance player, int team) {
        if (team == 0) {
            this._redPlayers.add(player);
        } else {
            this._bluePlayers.add(player);
        }
    }

    public void removePlayer(L2PcInstance player, int team) {
        if (team == 0) {
            this._redPlayers.remove(player);
        } else {
            this._bluePlayers.remove(player);
        }
    }

    public int getPlayerTeam(L2PcInstance player) {
        if (this._redPlayers.contains(player)) {
            return 0;
        }
        if (this._bluePlayers.contains(player)) {
            return 1;
        }
        return -1;
    }

    public int getRedTeamSize() {
        return this._redPlayers.size();
    }

    public int getBlueTeamSize() {
        return this._bluePlayers.size();
    }

    public void broadCastPacketToTeam(L2GameServerPacket packet) {
        for (L2PcInstance p : this._redPlayers) {
            p.sendPacket(packet);
        }
        for (L2PcInstance p : this._bluePlayers) {
            p.sendPacket(packet);
        }
    }

    public void clearPlayers() {
        this._redPlayers.clear();
        this._bluePlayers.clear();
    }

    public BlockCheckerEngine getEvent() {
        return this._engine;
    }

    public void updateEvent() {
        this._engine.updatePlayersOnStart(this);
    }

    public void checkAndShuffle() {
        block3: {
            int blueSize;
            int redSize;
            block2: {
                redSize = this._redPlayers.size();
                if (redSize <= (blueSize = this._bluePlayers.size()) + 1) break block2;
                this.broadCastPacketToTeam(SystemMessage.getSystemMessage(SystemMessageId.TEAM_ADJUSTED_BECAUSE_WRONG_POPULATION_RATIO));
                int needed = redSize - (blueSize + 1);
                for (int i = 0; i < needed + 1; ++i) {
                    L2PcInstance plr = this._redPlayers.get(i);
                    if (plr == null) continue;
                    HandysBlockCheckerManager.getInstance().changePlayerToTeam(plr, this._arena, 1);
                }
                break block3;
            }
            if (blueSize <= redSize + 1) break block3;
            this.broadCastPacketToTeam(SystemMessage.getSystemMessage(SystemMessageId.TEAM_ADJUSTED_BECAUSE_WRONG_POPULATION_RATIO));
            int needed = blueSize - (redSize + 1);
            for (int i = 0; i < needed + 1; ++i) {
                L2PcInstance plr = this._bluePlayers.get(i);
                if (plr == null) continue;
                HandysBlockCheckerManager.getInstance().changePlayerToTeam(plr, this._arena, 0);
            }
        }
    }
}

