/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.PcRace;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.SocialClass;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.util.ArrayList;
import java.util.List;

public final class L2SkillLearn {
    private final String _skillName;
    private final int _skillId;
    private final int _skillLvl;
    private final int _getLevel;
    private final boolean _autoGet;
    private final int _levelUpSp;
    private final List<ItemHolder> _requiredItems = new ArrayList<ItemHolder>();
    private final List<PcRace> _races = new ArrayList<PcRace>();
    private final List<SkillHolder> _preReqSkills = new ArrayList<SkillHolder>();
    private SocialClass _socialClass;
    private final boolean _residenceSkill;
    private final List<Integer> _residenceIds = new ArrayList<Integer>();
    private final List<SubClassData> _subClassLvlNumber = new ArrayList<SubClassData>();
    private final boolean _learnedByNpc;
    private final boolean _learnedByFS;

    public L2SkillLearn(StatsSet set) {
        this._skillName = set.getString("skillName");
        this._skillId = set.getInt("skillId");
        this._skillLvl = set.getInt("skillLvl");
        this._getLevel = set.getInt("getLevel");
        this._autoGet = set.getBoolean("autoGet", false);
        this._levelUpSp = set.getInt("levelUpSp", 0);
        this._residenceSkill = set.getBoolean("residenceSkill", false);
        this._learnedByNpc = set.getBoolean("learnedByNpc", false);
        this._learnedByFS = set.getBoolean("learnedByFS", false);
    }

    public String getName() {
        return this._skillName;
    }

    public int getSkillId() {
        return this._skillId;
    }

    public int getSkillLevel() {
        return this._skillLvl;
    }

    public int getGetLevel() {
        return this._getLevel;
    }

    public int getLevelUpSp() {
        return this._levelUpSp;
    }

    public boolean isAutoGet() {
        return this._autoGet;
    }

    public List<ItemHolder> getRequiredItems() {
        return this._requiredItems;
    }

    public void addRequiredItem(ItemHolder item) {
        this._requiredItems.add(item);
    }

    public List<PcRace> getRaces() {
        return this._races;
    }

    public void addRace(PcRace race) {
        this._races.add(race);
    }

    public List<SkillHolder> getPreReqSkills() {
        return this._preReqSkills;
    }

    public void addPreReqSkill(SkillHolder skill) {
        this._preReqSkills.add(skill);
    }

    public SocialClass getSocialClass() {
        return this._socialClass;
    }

    public void setSocialClass(SocialClass socialClass) {
        if (this._socialClass == null) {
            this._socialClass = socialClass;
        }
    }

    public boolean isResidencialSkill() {
        return this._residenceSkill;
    }

    public List<Integer> getResidenceIds() {
        return this._residenceIds;
    }

    public void addResidenceId(Integer id) {
        this._residenceIds.add(id);
    }

    public List<SubClassData> getSubClassConditions() {
        return this._subClassLvlNumber;
    }

    public void addSubclassConditions(int slot, int lvl) {
        this._subClassLvlNumber.add(new SubClassData(slot, lvl));
    }

    public boolean isLearnedByNpc() {
        return this._learnedByNpc;
    }

    public boolean isLearnedByFS() {
        return this._learnedByFS;
    }

    public int getCalculatedLevelUpSp(ClassId playerClass, ClassId learningClass) {
        if (playerClass == null || learningClass == null) {
            return this._levelUpSp;
        }
        int levelUpSp = this._levelUpSp;
        if (Config.ALT_GAME_SKILL_LEARN && playerClass != learningClass) {
            levelUpSp = playerClass.isMage() != learningClass.isMage() ? (levelUpSp *= 3) : (levelUpSp *= 2);
        }
        return levelUpSp;
    }

    public class SubClassData {
        private final int slot;
        private final int lvl;

        public SubClassData(int pSlot, int pLvl) {
            this.slot = pSlot;
            this.lvl = pLvl;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getLvl() {
            return this.lvl;
        }
    }
}

