/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcPersonalAIData;
import com.l2jserver.gameserver.datatables.TerritoryTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.SpawnListener;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.model.zone.type.NpcSpawnTerritory;
import com.l2jserver.util.Rnd;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2Spawn
implements IPositionable,
IIdentifiable,
INamable {
    protected static final Logger _log = Logger.getLogger(L2Spawn.class.getName());
    private String _name;
    private L2NpcTemplate _template;
    private int _maximumCount;
    private int _currentCount;
    protected int _scheduledCount;
    private int _locationId;
    private Location _location = new Location(0, 0, 0);
    private NpcSpawnTerritory _spawnTerritory = null;
    private int _respawnMinDelay;
    private int _respawnMaxDelay;
    private int _instanceId = 0;
    private Constructor<?> _constructor;
    private boolean _doRespawn;
    private boolean _customSpawn;
    private static List<SpawnListener> _spawnListeners = new FastList();
    private final FastList<L2Npc> _spawnedNpcs = new FastList();
    private Map<Integer, Location> _lastSpawnPoints;
    private boolean _isNoRndWalk = false;

    public L2Spawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
        this._template = mobTemplate;
        if (this._template == null) {
            return;
        }
        Class[] parameters = new Class[]{Integer.TYPE, Class.forName("com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate")};
        this._constructor = Class.forName("com.l2jserver.gameserver.model.actor.instance." + this._template.getType() + "Instance").getConstructor(parameters);
    }

    public int getAmount() {
        return this._maximumCount;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getLocationId() {
        return this._locationId;
    }

    @Override
    public Location getLocation() {
        return this._location;
    }

    public Location getLocation(L2Object obj) {
        Location p;
        return this._lastSpawnPoints != null && obj != null && (p = this._lastSpawnPoints.get(obj.getObjectId())) != null ? p : this._location;
    }

    @Override
    public int getX() {
        return this._location.getX();
    }

    public int getX(L2Object obj) {
        return this.getLocation(obj).getX();
    }

    @Override
    public void setX(int x) {
        this._location.setX(x);
    }

    @Override
    public int getY() {
        return this._location.getY();
    }

    public int getY(L2Object obj) {
        return this.getLocation(obj).getY();
    }

    @Override
    public void setY(int y) {
        this._location.setY(y);
    }

    @Override
    public int getZ() {
        return this._location.getZ();
    }

    public int getZ(L2Object obj) {
        return this.getLocation(obj).getZ();
    }

    @Override
    public void setZ(int z) {
        this._location.setZ(z);
    }

    @Override
    public void setXYZ(int x, int y, int z) {
        this._location.setXYZ(x, y, z);
    }

    @Override
    public void setXYZ(ILocational loc) {
        this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public int getHeading() {
        return this._location.getHeading();
    }

    @Override
    public void setHeading(int heading) {
        this._location.setHeading(heading);
    }

    @Override
    public void setLocation(Location loc) {
        this._location = loc;
    }

    @Override
    public int getId() {
        return this._template.getId();
    }

    public int getNpcid() {
        return this.getId();
    }

    public int getRespawnMinDelay() {
        return this._respawnMinDelay;
    }

    public int getRespawnMaxDelay() {
        return this._respawnMaxDelay;
    }

    public void setAmount(int amount) {
        if (amount <= 0) {
            _log.log(Level.WARNING, "NPC " + this._template.getId() + this._template.getName() + " setAmount(" + amount + ")");
            Thread.dumpStack();
        }
        this._maximumCount = amount;
    }

    public void setLocationId(int id) {
        this._locationId = id;
    }

    public void setRespawnMinDelay(int date) {
        this._respawnMinDelay = date;
    }

    public void setRespawnMaxDelay(int date) {
        this._respawnMaxDelay = date;
    }

    public void setCustom(boolean custom) {
        this._customSpawn = custom;
    }

    public boolean isCustom() {
        return this._customSpawn;
    }

    public void decreaseCount(L2Npc oldNpc) {
        if (this._currentCount <= 0) {
            return;
        }
        --this._currentCount;
        this._spawnedNpcs.remove((Object)oldNpc);
        if (this._lastSpawnPoints != null) {
            this._lastSpawnPoints.remove(oldNpc.getObjectId());
        }
        if (this._doRespawn && this._scheduledCount + this._currentCount < this._maximumCount) {
            ++this._scheduledCount;
            ThreadPoolManager.getInstance().scheduleGeneral(new SpawnTask(oldNpc), this.hasRespawnRandom() ? (long)Rnd.get(this._respawnMinDelay, this._respawnMaxDelay) : (long)this._respawnMinDelay);
        }
    }

    public int init() {
        while (this._currentCount < this._maximumCount) {
            this.doSpawn();
        }
        this._doRespawn = this._respawnMinDelay != 0;
        return this._currentCount;
    }

    public L2Npc spawnOne(boolean val) {
        return this.doSpawn(val);
    }

    public boolean isRespawnEnabled() {
        return this._doRespawn;
    }

    public void stopRespawn() {
        this._doRespawn = false;
    }

    public void startRespawn() {
        this._doRespawn = true;
    }

    public L2Npc doSpawn() {
        return this.doSpawn(false);
    }

    public L2Npc doSpawn(boolean isSummonSpawn) {
        L2Npc mob = null;
        try {
            if (this._template.isType("L2Pet") || this._template.isType("L2Decoy") || this._template.isType("L2Trap") || this._template.isType("L2EffectPoint")) {
                ++this._currentCount;
                return mob;
            }
            Object[] parameters = new Object[]{IdFactory.getInstance().getNextId(), this._template};
            Object tmp = this._constructor.newInstance(parameters);
            ((L2Object)tmp).setInstanceId(this._instanceId);
            if (isSummonSpawn && tmp instanceof L2Character) {
                ((L2Character)tmp).setShowSummonAnimation(isSummonSpawn);
            }
            if (!(tmp instanceof L2Npc)) {
                return mob;
            }
            mob = (L2Npc)tmp;
            if (this._name != null) {
                NpcPersonalAIData.getInstance().initializeNpcParameters(mob, this, this._name);
            }
            return this.initializeNpcInstance(mob);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPC " + this._template.getId() + " " + this._template.getName() + " '" + this._template.getType() + "' class not found", e);
            this._maximumCount = 0;
            return mob;
        }
    }

    private L2Npc initializeNpcInstance(L2Npc mob) {
        int newlocz;
        int newlocy;
        int newlocx;
        if (this.isTerritoryBased()) {
            int[] p = this._spawnTerritory.getRandomPoint();
            newlocx = p[0];
            newlocy = p[1];
            newlocz = p[2];
        } else if (this.getX() == 0 && this.getY() == 0) {
            if (this.getLocationId() == 0) {
                return mob;
            }
            int[] p = TerritoryTable.getInstance().getRandomPoint(this.getLocationId());
            newlocx = p[0];
            newlocy = p[1];
            newlocz = p[3];
        } else {
            newlocx = this.getX();
            newlocy = this.getY();
            newlocz = this.getZ();
        }
        if (!mob.isFlying()) {
            newlocz = GeoData.getInstance().getSpawnHeight(newlocx, newlocy, newlocz, newlocz);
        }
        mob.stopAllEffects();
        mob.setIsDead(false);
        mob.setDecayed(false);
        mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
        if (mob.hasVariables()) {
            mob.getVariables().getSet().clear();
        }
        mob.setIsNoRndWalk(this.isNoRndWalk());
        if (this.getHeading() == -1) {
            mob.setHeading(Rnd.nextInt(61794));
        } else {
            mob.setHeading(this.getHeading());
        }
        if (mob instanceof L2Attackable) {
            ((L2Attackable)mob).setChampion(false);
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && mob.isMonster() && !this.getTemplate().isQuestMonster() && !mob.isRaid() && !mob.isRaidMinion() && Config.L2JMOD_CHAMPION_FREQUENCY > 0 && mob.getLevel() >= Config.L2JMOD_CHAMP_MIN_LVL && mob.getLevel() <= Config.L2JMOD_CHAMP_MAX_LVL && (Config.L2JMOD_CHAMPION_ENABLE_IN_INSTANCES || this.getInstanceId() == 0) && Rnd.get(100) < Config.L2JMOD_CHAMPION_FREQUENCY) {
            ((L2Attackable)mob).setChampion(true);
        }
        mob.setSpawn(this);
        mob.spawnMe(newlocx, newlocy, newlocz);
        L2Spawn.notifyNpcSpawned(mob);
        this._spawnedNpcs.add((Object)mob);
        if (this._lastSpawnPoints != null) {
            this._lastSpawnPoints.put(mob.getObjectId(), new Location(newlocx, newlocy, newlocz));
        }
        if (Config.DEBUG) {
            _log.finest("Spawned Mob Id: " + this._template.getId() + " , at: X: " + mob.getX() + " Y: " + mob.getY() + " Z: " + mob.getZ());
        }
        ++this._currentCount;
        return mob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSpawnListener(SpawnListener listener) {
        List<SpawnListener> list = _spawnListeners;
        synchronized (list) {
            _spawnListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSpawnListener(SpawnListener listener) {
        List<SpawnListener> list = _spawnListeners;
        synchronized (list) {
            _spawnListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyNpcSpawned(L2Npc npc) {
        List<SpawnListener> list = _spawnListeners;
        synchronized (list) {
            for (SpawnListener listener : _spawnListeners) {
                listener.npcSpawned(npc);
            }
        }
    }

    public void setRespawnDelay(int delay, int randomInterval) {
        if (delay != 0) {
            if (delay < 0) {
                _log.warning("respawn delay is negative for spawn:" + this);
            }
            int minDelay = delay - randomInterval;
            int maxDelay = delay + randomInterval;
            this._respawnMinDelay = Math.max(10, minDelay) * 1000;
            this._respawnMaxDelay = Math.max(10, maxDelay) * 1000;
        } else {
            this._respawnMinDelay = 0;
            this._respawnMaxDelay = 0;
        }
    }

    public void setRespawnDelay(int delay) {
        this.setRespawnDelay(delay, 0);
    }

    public int getRespawnDelay() {
        return (this._respawnMinDelay + this._respawnMaxDelay) / 2;
    }

    public boolean hasRespawnRandom() {
        return this._respawnMinDelay != this._respawnMaxDelay;
    }

    public void setSpawnTerritory(NpcSpawnTerritory territory) {
        this._spawnTerritory = territory;
        this._lastSpawnPoints = new ConcurrentHashMap<Integer, Location>();
    }

    public NpcSpawnTerritory getSpawnTerritory() {
        return this._spawnTerritory;
    }

    public boolean isTerritoryBased() {
        return this._spawnTerritory != null && this._location.getX() == 0 && this._location.getY() == 0;
    }

    public L2Npc getLastSpawn() {
        if (!this._spawnedNpcs.isEmpty()) {
            return (L2Npc)this._spawnedNpcs.getLast();
        }
        return null;
    }

    public final FastList<L2Npc> getSpawnedNpcs() {
        return this._spawnedNpcs;
    }

    public void respawnNpc(L2Npc oldNpc) {
        if (this._doRespawn) {
            oldNpc.refreshID();
            this.initializeNpcInstance(oldNpc);
        }
    }

    public L2NpcTemplate getTemplate() {
        return this._template;
    }

    @Override
    public int getInstanceId() {
        return this._instanceId;
    }

    @Override
    public void setInstanceId(int instanceId) {
        this._instanceId = instanceId;
    }

    public String toString() {
        return "L2Spawn [_template=" + this.getId() + ", _locX=" + this.getX() + ", _locY=" + this.getY() + ", _locZ=" + this.getZ() + ", _heading=" + this.getHeading() + "]";
    }

    public final boolean isNoRndWalk() {
        return this._isNoRndWalk;
    }

    public final void setIsNoRndWalk(boolean value) {
        this._isNoRndWalk = value;
    }

    class SpawnTask
    implements Runnable {
        private final L2Npc _oldNpc;

        public SpawnTask(L2Npc pOldNpc) {
            this._oldNpc = pOldNpc;
        }

        @Override
        public void run() {
            try {
                L2Spawn.this.respawnNpc(this._oldNpc);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
            --L2Spawn.this._scheduledCount;
        }
    }
}

