/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroCmd;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IRestorable;
import com.l2jserver.gameserver.network.serverpackets.SendMacroList;
import com.l2jserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class MacroList
implements IRestorable {
    private static final Logger _log = Logger.getLogger(MacroList.class.getName());
    private final L2PcInstance _owner;
    private int _revision;
    private final FastIntObjectMap<Macro> _macroses = new FastIntObjectMap().shared();

    public MacroList(L2PcInstance owner) {
        this._owner = owner;
        this._revision = 1;
    }

    public int getRevision() {
        return this._revision;
    }

    public int size() {
        return this._macroses.size();
    }

    public void registerMacro(Macro macro) {
        int macroId = macro.getId();
        if (macroId == 0) {
            macroId = this._macroses.size() == 0 ? 1000 : ((Macro)this._macroses.tail().getPrevious().getValue()).getId();
            do {
                macro.setId(++macroId);
            } while (this._macroses.putIfAbsent(macroId, (Object)macro) != null);
        } else {
            this._macroses.put(macroId, (Object)macro);
        }
        this.registerMacroInDb(macro);
        this.sendUpdate();
    }

    public void deleteMacro(int id) {
        L2ShortCut[] allShortCuts;
        Macro removed = (Macro)this._macroses.remove(id);
        if (removed != null) {
            this.deleteMacroFromDb(removed);
        }
        for (L2ShortCut sc : allShortCuts = this._owner.getAllShortCuts()) {
            if (sc.getId() != id || sc.getType() != 4) continue;
            this._owner.deleteShortCut(sc.getSlot(), sc.getPage());
        }
        this.sendUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdate() {
        ++this._revision;
        Collection allMacros = this._macroses.values();
        FastIntObjectMap<Macro> fastIntObjectMap = this._macroses;
        synchronized (fastIntObjectMap) {
            if (allMacros.isEmpty()) {
                this._owner.sendPacket(new SendMacroList(this._revision, 0, null));
            } else {
                for (Macro m : allMacros) {
                    this._owner.sendPacket(new SendMacroList(this._revision, allMacros.size(), m));
                }
            }
        }
    }

    private void registerMacroInDb(Macro macro) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO character_macroses (charId,id,icon,name,descr,acronym,commands) values(?,?,?,?,?,?,?)");){
            ps.setInt(1, this._owner.getObjectId());
            ps.setInt(2, macro.getId());
            ps.setInt(3, macro.getIcon());
            ps.setString(4, macro.getName());
            ps.setString(5, macro.getDescr());
            ps.setString(6, macro.getAcronym());
            StringBuilder sb = new StringBuilder(300);
            for (MacroCmd cmd : macro.getCommands()) {
                StringUtil.append(sb, String.valueOf(cmd.getType()), ",", String.valueOf(cmd.getD1()), ",", String.valueOf(cmd.getD2()));
                if (cmd.getCmd() != null && cmd.getCmd().length() > 0) {
                    StringUtil.append(sb, ",", cmd.getCmd());
                }
                sb.append(';');
            }
            if (sb.length() > 255) {
                sb.setLength(255);
            }
            ps.setString(7, sb.toString());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store macro:", e);
        }
    }

    private void deleteMacroFromDb(Macro macro) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM character_macroses WHERE charId=? AND id=?");){
            ps.setInt(1, this._owner.getObjectId());
            ps.setInt(2, macro.getId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete macro:", e);
        }
    }

    @Override
    public boolean restoreMe() {
        this._macroses.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT charId, id, icon, name, descr, acronym, commands FROM character_macroses WHERE charId=?");){
            ps.setInt(1, this._owner.getObjectId());
            try (ResultSet rset = ps.executeQuery();){
                while (rset.next()) {
                    int id = rset.getInt("id");
                    int icon = rset.getInt("icon");
                    String name = rset.getString("name");
                    String descr = rset.getString("descr");
                    String acronym = rset.getString("acronym");
                    ArrayList<MacroCmd> commands = new ArrayList<MacroCmd>();
                    StringTokenizer st1 = new StringTokenizer(rset.getString("commands"), ";");
                    while (st1.hasMoreTokens()) {
                        StringTokenizer st = new StringTokenizer(st1.nextToken(), ",");
                        if (st.countTokens() < 3) continue;
                        int type = Integer.parseInt(st.nextToken());
                        int d1 = Integer.parseInt(st.nextToken());
                        int d2 = Integer.parseInt(st.nextToken());
                        String cmd = "";
                        if (st.hasMoreTokens()) {
                            cmd = st.nextToken();
                        }
                        commands.add(new MacroCmd(commands.size(), type, d1, d2, cmd));
                    }
                    this._macroses.put(id, (Object)new Macro(id, icon, name, descr, acronym, commands));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not store shortcuts:", e);
            return false;
        }
        return true;
    }
}

