/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.UIData;
import com.l2jserver.gameserver.model.ActionKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UIKeysSettings {
    private static final Logger _log = Logger.getLogger(UIKeysSettings.class.getName());
    private final int _playerObjId;
    private Map<Integer, List<ActionKey>> _storedKeys;
    private Map<Integer, List<Integer>> _storedCategories;
    private boolean _saved = true;

    public UIKeysSettings(int playerObjId) {
        this._playerObjId = playerObjId;
        this.loadFromDB();
    }

    public void storeAll(Map<Integer, List<Integer>> catMap, Map<Integer, List<ActionKey>> keyMap) {
        this._saved = false;
        this._storedCategories = catMap;
        this._storedKeys = keyMap;
    }

    public void storeCategories(Map<Integer, List<Integer>> catMap) {
        this._saved = false;
        this._storedCategories = catMap;
    }

    public Map<Integer, List<Integer>> getCategories() {
        return this._storedCategories;
    }

    public void storeKeys(Map<Integer, List<ActionKey>> keyMap) {
        this._saved = false;
        this._storedKeys = keyMap;
    }

    public Map<Integer, List<ActionKey>> getKeys() {
        return this._storedKeys;
    }

    public void loadFromDB() {
        this.getCatsFromDB();
        this.getKeysFromDB();
    }

    public void saveInDB() {
        Connection con;
        Iterator<ActionKey> i$;
        if (this._saved) {
            return;
        }
        String query = "REPLACE INTO character_ui_categories (`charId`, `catId`, `order`, `cmdId`) VALUES ";
        for (int n : this._storedCategories.keySet()) {
            int order = 0;
            i$ = this._storedCategories.get(n).iterator();
            while (i$.hasNext()) {
                int key = i$.next();
                query = query + "(" + this._playerObjId + ", " + n + ", " + order++ + ", " + key + "),";
            }
        }
        query = query.substring(0, query.length() - 1) + "; ";
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            Throwable throwable = null;
            try {
                PreparedStatement statement = con.prepareStatement(query);
                i$ = null;
                try {
                    statement.execute();
                }
                catch (Throwable x2) {
                    i$ = x2;
                    throw x2;
                }
                finally {
                    if (statement != null) {
                        if (i$ != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)((Object)i$)).addSuppressed(x2);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                Throwable throwable2 = x2;
                throw x2;
            }
            finally {
                if (con != null) {
                    if (throwable != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveInDB(): " + e.getMessage(), e);
        }
        query = "REPLACE INTO character_ui_actions (`charId`, `cat`, `order`, `cmd`, `key`, `tgKey1`, `tgKey2`, `show`) VALUES";
        for (List<ActionKey> throwable : this._storedKeys.values()) {
            int order = 0;
            for (ActionKey key : throwable) {
                query = query + key.getSqlSaveString(this._playerObjId, order++) + ",";
            }
        }
        query = query.substring(0, query.length() - 1) + ";";
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            Throwable throwable = null;
            try (PreparedStatement statement = con.prepareStatement(query);){
                statement.execute();
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
            finally {
                if (con != null) {
                    if (throwable != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveInDB(): " + e.getMessage(), e);
        }
        this._saved = true;
    }

    public void getCatsFromDB() {
        if (this._storedCategories != null) {
            return;
        }
        this._storedCategories = new HashMap<Integer, List<Integer>>();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement stmt = con.prepareStatement("SELECT * FROM character_ui_categories WHERE `charId` = ? ORDER BY `catId`, `order`");){
            stmt.setInt(1, this._playerObjId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    UIData.addCategory(this._storedCategories, rs.getInt("catId"), rs.getInt("cmdId"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: getCatsFromDB(): " + e.getMessage(), e);
        }
        if (this._storedCategories.isEmpty()) {
            this._storedCategories = UIData.getInstance().getCategories();
        }
    }

    public void getKeysFromDB() {
        if (this._storedKeys != null) {
            return;
        }
        this._storedKeys = new HashMap<Integer, List<ActionKey>>();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement stmt = con.prepareStatement("SELECT * FROM character_ui_actions WHERE `charId` = ? ORDER BY `cat`, `order`");){
            stmt.setInt(1, this._playerObjId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    int cat = rs.getInt("cat");
                    int cmd = rs.getInt("cmd");
                    int key = rs.getInt("key");
                    int tgKey1 = rs.getInt("tgKey1");
                    int tgKey2 = rs.getInt("tgKey2");
                    int show = rs.getInt("show");
                    UIData.addKey(this._storedKeys, cat, new ActionKey(cat, cmd, key, tgKey1, tgKey2, show));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: getKeysFromDB(): " + e.getMessage(), e);
        }
        if (this._storedKeys.isEmpty()) {
            this._storedKeys = UIData.getInstance().getKeys();
        }
    }

    public boolean isSaved() {
        return this._saved;
    }
}

