/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.ChanceSkillList;
import com.l2jserver.gameserver.model.CharEffectList;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.TimeStamp;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.events.CharEvents;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.actor.knownlist.CharKnownList;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.model.actor.status.CharStatus;
import com.l2jserver.gameserver.model.actor.tasks.character.FlyToLocationTask;
import com.l2jserver.gameserver.model.actor.tasks.character.HitTask;
import com.l2jserver.gameserver.model.actor.tasks.character.MagicUseTask;
import com.l2jserver.gameserver.model.actor.tasks.character.NotifyAITask;
import com.l2jserver.gameserver.model.actor.tasks.character.QueuedMagicUseTask;
import com.l2jserver.gameserver.model.actor.tasks.character.UsePotionTask;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.actor.transform.Transform;
import com.l2jserver.gameserver.model.actor.transform.TransformTemplate;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.holders.SkillUseHolder;
import com.l2jserver.gameserver.model.interfaces.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.interfaces.IDeletable;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.options.OptionsSkillHolder;
import com.l2jserver.gameserver.model.options.OptionsSkillType;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import com.l2jserver.gameserver.model.skills.SkillChannelized;
import com.l2jserver.gameserver.model.skills.SkillChannelizer;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Calculator;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.Attack;
import com.l2jserver.gameserver.network.serverpackets.ChangeMoveType;
import com.l2jserver.gameserver.network.serverpackets.ChangeWaitType;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillCanceld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MoveToLocation;
import com.l2jserver.gameserver.network.serverpackets.Revive;
import com.l2jserver.gameserver.network.serverpackets.ServerObjectInfo;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TeleportToLocation;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.WeakFastSet;
import jp.sf.l2j.troja.FastIntObjectMap;

public abstract class L2Character
extends L2Object
implements ISkillsHolder,
IDeletable {
    public static final Logger _log = Logger.getLogger(L2Character.class.getName());
    private volatile Set<L2Character> _attackByList;
    private volatile boolean _isCastingNow = false;
    private volatile boolean _isCastingSimultaneouslyNow = false;
    private L2Skill _lastSkillCast;
    private L2Skill _lastSimultaneousSkillCast;
    private boolean _isFallsdown;
    private boolean _isDead = false;
    private boolean _isImmobilized = false;
    private boolean _isOverloaded = false;
    private boolean _isParalyzed = false;
    private boolean _isPendingRevive = false;
    private boolean _isRunning = false;
    private boolean _isNoRndWalk = false;
    protected boolean _showSummonAnimation = false;
    protected boolean _isTeleporting = false;
    private boolean _isInvul = false;
    private boolean _isMortal = true;
    private boolean _isFlying = false;
    private CharStat _stat;
    private CharStatus _status;
    private CharEvents _events;
    private L2CharTemplate _template;
    private String _title;
    public static final double MAX_HP_BAR_PX = 352.0;
    private double _hpUpdateIncCheck = 0.0;
    private double _hpUpdateDecCheck = 0.0;
    private double _hpUpdateInterval = 0.0;
    private Calculator[] _calculators;
    private final Map<Integer, L2Skill> _skills;
    private volatile FastIntObjectMap<TimeStamp> _reuseTimeStampsSkills = null;
    private volatile FastIntObjectMap<TimeStamp> _reuseTimeStampsItems = null;
    private volatile FastIntObjectMap<Long> _disabledSkills = null;
    private static final Long SKILL_DISABLED_FOREVER = Long.MAX_VALUE;
    private boolean _allSkillsDisabled;
    private volatile ChanceSkillList _chanceSkills;
    private final byte[] _zones = new byte[ZoneId.getZoneCount()];
    protected byte _zoneValidateCounter = (byte)4;
    private L2Character _debugger = null;
    private final ReentrantLock _teleportLock;
    private Team _team = Team.NONE;
    private boolean _lethalable = true;
    private volatile Map<Integer, OptionsSkillHolder> _triggerSkills;
    private final CharEffectList _effectList = new CharEffectList(this);
    private L2Character _summoner = null;
    private SkillChannelizer _channelizer = null;
    private SkillChannelized _channelized = null;
    private int _abnormalVisualEffects;
    private int _abnormalVisualEffectsSpecial;
    private int _abnormalVisualEffectsEvent;
    private static final AbstractEffect DUMMY_EFFECT;
    protected MoveData _move;
    private L2Object _target;
    private int _attackEndTime;
    private int _disableBowAttackEndTime;
    private int _disableCrossBowAttackEndTime;
    private int _castEndTime;
    private int _castInterruptTime;
    private static final Calculator[] NPC_STD_CALCULATOR;
    protected volatile L2CharacterAI _ai;
    protected Future<?> _skillCast;
    protected Future<?> _skillCast2;
    private boolean _AIdisabled = false;

    public final CharEffectList getEffectList() {
        return this._effectList;
    }

    public boolean isDebug() {
        return this._debugger != null;
    }

    public void setDebug(L2Character debugger) {
        this._debugger = debugger;
    }

    public void sendDebugPacket(L2GameServerPacket pkt) {
        if (this._debugger != null) {
            this._debugger.sendPacket(pkt);
        }
    }

    public void sendDebugMessage(String msg) {
        if (this._debugger != null) {
            this._debugger.sendMessage(msg);
        }
    }

    public Inventory getInventory() {
        return null;
    }

    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        return true;
    }

    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return true;
    }

    @Override
    public final boolean isInsideZone(ZoneId zone) {
        Instance instance = InstanceManager.getInstance().getInstance(this.getInstanceId());
        switch (zone) {
            case PVP: {
                if (instance != null && instance.isPvPInstance()) {
                    return true;
                }
                return this._zones[ZoneId.PVP.getId()] > 0 && this._zones[ZoneId.PEACE.getId()] == 0;
            }
            case PEACE: {
                if (instance == null || !instance.isPvPInstance()) break;
                return false;
            }
        }
        return this._zones[zone.getId()] > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInsideZone(ZoneId zone, boolean state) {
        byte[] byArray = this._zones;
        synchronized (this._zones) {
            if (state) {
                int n = zone.getId();
                this._zones[n] = (byte)(this._zones[n] + 1);
            } else {
                int n = zone.getId();
                this._zones[n] = (byte)(this._zones[n] - 1);
                if (this._zones[zone.getId()] < 0) {
                    this._zones[zone.getId()] = 0;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public boolean isTransformed() {
        return false;
    }

    public Transform getTransformation() {
        return null;
    }

    public void untransform() {
    }

    public boolean isGM() {
        return false;
    }

    public L2AccessLevel getAccessLevel() {
        return null;
    }

    public L2Character(int objectId, L2CharTemplate template) {
        super(objectId);
        if (template == null) {
            throw new NullPointerException("Template is null!");
        }
        this.setInstanceType(InstanceType.L2Character);
        this.initCharStat();
        this.initCharStatus();
        this.initCharEvents();
        this._template = template;
        if (this.isDoor()) {
            this._calculators = Formulas.getStdDoorCalculators();
            this._skills = Collections.emptyMap();
        } else if (this.isNpc()) {
            this._calculators = NPC_STD_CALCULATOR;
            this._skills = new FastMap().shared();
            for (L2Skill skill : template.getSkills().values()) {
                this.addSkill(skill);
            }
        } else {
            this._calculators = new Calculator[Stats.NUM_STATS];
            this._skills = new FastMap().shared();
            if (this.isSummon()) {
                for (L2Skill skill : template.getSkills().values()) {
                    this.addSkill(skill);
                }
            }
            Formulas.addFuncsToNewCharacter(this);
        }
        this.setIsInvul(true);
        this._teleportLock = new ReentrantLock();
    }

    protected void initCharStatusUpdateValues() {
        this._hpUpdateIncCheck = this.getMaxHp();
        this._hpUpdateInterval = this._hpUpdateIncCheck / 352.0;
        this._hpUpdateDecCheck = this._hpUpdateIncCheck - this._hpUpdateInterval;
    }

    public void onDecay() {
        L2WorldRegion reg = this.getWorldRegion();
        this.decayMe();
        if (reg != null) {
            reg.removeFromZones(this);
        }
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.revalidateZone(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTeleported() {
        if (!this._teleportLock.tryLock()) {
            return;
        }
        try {
            if (!this.isTeleporting()) {
                return;
            }
            this.spawnMe(this.getX(), this.getY(), this.getZ());
            this.setIsTeleporting(false);
            this.getEvents().onTeleported();
        }
        finally {
            this._teleportLock.unlock();
        }
        if (this._isPendingRevive) {
            this.doRevive();
        }
    }

    public void addAttackerToAttackByList(L2Character player) {
    }

    public void broadcastPacket(L2GameServerPacket mov) {
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            player.sendPacket(mov);
        }
    }

    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    protected boolean needHpUpdate() {
        double currentHp = this.getCurrentHp();
        double maxHp = this.getMaxHp();
        if (currentHp <= 1.0 || maxHp < 352.0) {
            return true;
        }
        if (currentHp < this._hpUpdateDecCheck || Math.abs(currentHp - this._hpUpdateDecCheck) <= 1.0E-6 || currentHp > this._hpUpdateIncCheck || Math.abs(currentHp - this._hpUpdateIncCheck) <= 1.0E-6) {
            if (Math.abs(currentHp - maxHp) <= 1.0E-6) {
                this._hpUpdateIncCheck = currentHp + 1.0;
                this._hpUpdateDecCheck = currentHp - this._hpUpdateInterval;
            } else {
                double doubleMulti = currentHp / this._hpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._hpUpdateDecCheck = this._hpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._hpUpdateIncCheck = this._hpUpdateDecCheck + this._hpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    public void broadcastStatusUpdate() {
        if (this.getStatus().getStatusListener().isEmpty() || !this.needHpUpdate()) {
            return;
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(9, (int)this.getCurrentHp());
        for (L2Character temp : this.getStatus().getStatusListener()) {
            if (temp == null) continue;
            temp.sendPacket(su);
        }
    }

    public void sendMessage(String text) {
    }

    public void teleToLocation(int x, int y, int z, int heading, int instanceId, int randomOffset) {
        this.setInstanceId(instanceId);
        if (this.isPlayer() && DimensionalRiftManager.getInstance().checkIfInRiftZone(this.getX(), this.getY(), this.getZ(), false)) {
            L2PcInstance player = this.getActingPlayer();
            player.sendMessage("You have been sent to the waiting room.");
            if (player.isInParty() && player.getParty().isInDimensionalRift()) {
                player.getParty().getDimensionalRift().usedTeleport(player);
            }
            int[] newCoords = DimensionalRiftManager.getInstance().getRoom((byte)0, (byte)0).getTeleportCoorinates();
            x = newCoords[0];
            y = newCoords[1];
            z = newCoords[2];
        }
        this.stopMove(null, false);
        this.abortAttack();
        this.abortCast();
        this.setIsTeleporting(true);
        this.setTarget(null);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        if (Config.OFFSET_ON_TELEPORT_ENABLED && randomOffset > 0) {
            x += Rnd.get(-randomOffset, randomOffset);
            y += Rnd.get(-randomOffset, randomOffset);
        }
        this.broadcastPacket(new TeleportToLocation(this, x, y, z += 5, heading));
        this.decayMe();
        this.setXYZ(x, y, z);
        if (heading != 0) {
            this.setHeading(heading);
        }
        if (!this.isPlayer() || this.getActingPlayer().getClient() != null && this.getActingPlayer().getClient().isDetached()) {
            this.onTeleported();
        }
        this.revalidateZone(true);
    }

    public void teleToLocation(int x, int y, int z, int heading, int instanceId, boolean randomOffset) {
        this.teleToLocation(x, y, z, heading, instanceId, randomOffset ? Config.MAX_OFFSET_ON_TELEPORT : 0);
    }

    public void teleToLocation(int x, int y, int z, int heading, int instanceId) {
        this.teleToLocation(x, y, z, heading, instanceId, 0);
    }

    public void teleToLocation(int x, int y, int z, int heading, boolean randomOffset) {
        this.teleToLocation(x, y, z, heading, -1, randomOffset ? Config.MAX_OFFSET_ON_TELEPORT : 0);
    }

    public void teleToLocation(int x, int y, int z, int heading) {
        this.teleToLocation(x, y, z, heading, -1, 0);
    }

    public void teleToLocation(int x, int y, int z, boolean randomOffset) {
        this.teleToLocation(x, y, z, 0, -1, randomOffset ? Config.MAX_OFFSET_ON_TELEPORT : 0);
    }

    public void teleToLocation(int x, int y, int z) {
        this.teleToLocation(x, y, z, 0, -1, 0);
    }

    public void teleToLocation(ILocational loc, int randomOffset) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), loc.getInstanceId(), randomOffset);
    }

    public void teleToLocation(ILocational loc, boolean randomOffset) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), loc.getInstanceId(), randomOffset ? Config.MAX_OFFSET_ON_TELEPORT : 0);
    }

    public void teleToLocation(ILocational loc) {
        this.teleToLocation(loc.getX(), loc.getY(), loc.getZ(), loc.getHeading(), loc.getInstanceId(), 0);
    }

    public void teleToLocation(TeleportWhereType teleportWhere) {
        this.teleToLocation((ILocational)MapRegionManager.getInstance().getTeleToLocation(this, teleportWhere), true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doAttack(L2Character target) {
        L2Weapon wpn;
        if (target == null || this.isAttackingDisabled() || !this.getEvents().onAttack(target)) {
            return;
        }
        if (!this.isAlikeDead()) {
            if (this.isNpc() && target.isAlikeDead() || !this.getKnownList().knowsObject(target)) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (this.isPlayer()) {
                if (target.isDead()) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                L2PcInstance actor = this.getActingPlayer();
                if (actor.isTransformed() && !actor.getTransformation().canAttack()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
            }
        }
        if (this.getActiveWeaponItem() != null && !(wpn = this.getActiveWeaponItem()).isAttackWeapon() && !this.isGM()) {
            if (wpn.getItemType() == L2WeaponType.FISHINGROD) {
                this.sendPacket(SystemMessageId.CANNOT_ATTACK_WITH_FISHING_POLE);
            } else {
                this.sendPacket(SystemMessageId.THAT_WEAPON_CANT_ATTACK);
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this.getActingPlayer() != null) {
            if (this.getActingPlayer().inObserverMode()) {
                this.sendPacket(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target.getActingPlayer() != null && this.getActingPlayer().getSiegeState() > 0 && this.isInsideZone(ZoneId.SIEGE) && target.getActingPlayer().getSiegeState() == this.getActingPlayer().getSiegeState() && target.getActingPlayer() != this && target.getActingPlayer().getSiegeSide() == this.getActingPlayer().getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY);
                } else {
                    this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target.isInsidePeaceZone(this.getActingPlayer())) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        } else if (this.isInsidePeaceZone(this, (L2Object)target)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        this.stopEffectsOnAction();
        L2Weapon weaponItem = this.getActiveWeaponItem();
        if (!GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
            this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (weaponItem != null && !this.isTransformed()) {
            int mpConsume;
            if (weaponItem.getItemType() == L2WeaponType.BOW && this.isPlayer()) {
                if (target.isInsidePeaceZone(this.getActingPlayer())) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (!this.checkAndEquipArrows()) {
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    this.sendPacket(SystemMessageId.NOT_ENOUGH_ARROWS);
                    return;
                }
                if (this._disableBowAttackEndTime > GameTimeController.getInstance().getGameTicks()) {
                    ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), 1000L);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                mpConsume = weaponItem.getMpConsume();
                if (weaponItem.getReducedMpConsume() > 0 && Rnd.get(100) < weaponItem.getReducedMpConsumeChance()) {
                    mpConsume = weaponItem.getReducedMpConsume();
                }
                mpConsume = (int)this.calcStat(Stats.BOW_MP_CONSUME_RATE, mpConsume, null, null);
                if (this.getCurrentMp() < (double)mpConsume) {
                    ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), 1000L);
                    this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (mpConsume > 0) {
                    this.getStatus().reduceMp(mpConsume);
                }
                this._disableBowAttackEndTime = 50 + GameTimeController.getInstance().getGameTicks();
            }
            if (weaponItem.getItemType() == L2WeaponType.CROSSBOW) {
                if (this.isPlayer()) {
                    if (target.isInsidePeaceZone(this.getActingPlayer())) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    if (!this.checkAndEquipBolts()) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        this.sendPacket(SystemMessageId.NOT_ENOUGH_BOLTS);
                        return;
                    }
                    if (this._disableCrossBowAttackEndTime > GameTimeController.getInstance().getGameTicks()) {
                        ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), 1000L);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    mpConsume = weaponItem.getMpConsume();
                    if (weaponItem.getReducedMpConsume() > 0 && Rnd.get(100) < weaponItem.getReducedMpConsumeChance()) {
                        mpConsume = weaponItem.getReducedMpConsume();
                    }
                    mpConsume = (int)this.calcStat(Stats.BOW_MP_CONSUME_RATE, mpConsume, null, null);
                    if (this.getCurrentMp() < (double)mpConsume) {
                        ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), 1000L);
                        this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return;
                    }
                    if (mpConsume > 0) {
                        this.getStatus().reduceMp(mpConsume);
                    }
                    this._disableCrossBowAttackEndTime = 50 + GameTimeController.getInstance().getGameTicks();
                } else if (this.isNpc() && this._disableCrossBowAttackEndTime > GameTimeController.getInstance().getGameTicks()) {
                    return;
                }
            }
        }
        target.getKnownList().addKnownObject(this);
        if (Config.ALT_GAME_TIREDNESS) {
            this.setCurrentCp(this.getCurrentCp() - 10.0);
        }
        this.rechargeShots(true, false);
        boolean wasSSCharged = this.isChargedShot(ShotType.SOULSHOTS);
        int timeAtk = this.calculateTimeBetweenAttacks(target, weaponItem);
        int timeToHit = timeAtk / 2;
        this._attackEndTime = GameTimeController.getInstance().getGameTicks() + timeAtk / 100 - 1;
        int ssGrade = weaponItem != null ? weaponItem.getItemGradeSPlus() : 0;
        Attack attack = new Attack(this, target, wasSSCharged, ssGrade);
        this.setHeading(Util.calculateHeadingFrom(this, target));
        int reuse = this.calculateReuseTime(target, weaponItem);
        boolean hitted = false;
        switch (this.getAttackType()) {
            case BOW: {
                hitted = this.doAttackHitByBow(attack, target, timeAtk, reuse);
                break;
            }
            case CROSSBOW: {
                hitted = this.doAttackHitByCrossBow(attack, target, timeAtk, reuse);
                break;
            }
            case POLE: {
                hitted = this.doAttackHitByPole(attack, target, timeToHit);
                break;
            }
            case FIST: {
                if (!this.isPlayer()) {
                    hitted = this.doAttackHitSimple(attack, target, timeToHit);
                    break;
                }
            }
            case DUAL: 
            case DUALFIST: 
            case DUALDAGGER: {
                hitted = this.doAttackHitByDual(attack, target, timeToHit);
                break;
            }
            default: {
                hitted = this.doAttackHitSimple(attack, target, timeToHit);
            }
        }
        L2PcInstance player = this.getActingPlayer();
        if (player != null) {
            AttackStanceTaskManager.getInstance().addAttackStanceTask(player);
            if (player.getSummon() != target) {
                player.updatePvPStatus(target);
            }
        }
        if (!hitted) {
            this.abortAttack();
        } else {
            this.setChargedShot(ShotType.SOULSHOTS, false);
            if (player != null) {
                if (player.isCursedWeaponEquipped()) {
                    if (!target.isInvul()) {
                        target.setCurrentCp(0.0);
                    }
                } else if (player.isHero() && target.isPlayer() && target.getActingPlayer().isCursedWeaponEquipped()) {
                    target.setCurrentCp(0.0);
                }
            }
        }
        if (attack.hasHits()) {
            this.broadcastPacket(attack);
        }
        ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_READY_TO_ACT), timeAtk + reuse);
    }

    private boolean doAttackHitByBow(Attack attack, L2Character target, int sAtk, int reuse) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        this.reduceArrowCount(false);
        this._move = null;
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), false, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, attack.hasSoulshot());
            damage1 = (int)((double)damage1 * (this.calculateDistance(target, true, false) / 4000.0 + 0.8));
        }
        if (this.isPlayer()) {
            this.sendPacket(new SetupGauge(1, sAtk + reuse));
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk);
        this._disableBowAttackEndTime = (sAtk + reuse) / 100 + GameTimeController.getInstance().getGameTicks();
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    private boolean doAttackHitByCrossBow(Attack attack, L2Character target, int sAtk, int reuse) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        this.reduceArrowCount(true);
        this._move = null;
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), false, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, attack.hasSoulshot());
        }
        if (this.isPlayer()) {
            this.sendPacket(SystemMessageId.CROSSBOW_PREPARING_TO_FIRE);
            SetupGauge sg = new SetupGauge(1, sAtk + reuse);
            this.sendPacket(sg);
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk);
        this._disableCrossBowAttackEndTime = (sAtk + reuse) / 100 + GameTimeController.getInstance().getGameTicks();
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    private boolean doAttackHitByDual(Attack attack, L2Character target, int sAtk) {
        int damage1 = 0;
        int damage2 = 0;
        byte shld1 = 0;
        byte shld2 = 0;
        boolean crit1 = false;
        boolean crit2 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        boolean miss2 = Formulas.calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), false, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, attack.hasSoulshot());
            damage1 /= 2;
        }
        if (!miss2) {
            shld2 = Formulas.calcShldUse(this, target);
            crit2 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), false, target);
            damage2 = (int)Formulas.calcPhysDam(this, target, null, shld2, crit2, attack.hasSoulshot());
            damage2 /= 2;
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk / 2);
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage2, crit2, miss2, attack.hasSoulshot(), shld2), sAtk);
        attack.addHit(target, damage1, miss1, crit1, shld1);
        attack.addHit(target, damage2, miss2, crit2, shld2);
        return !miss1 || !miss2;
    }

    private boolean doAttackHitByPole(Attack attack, L2Character target, int sAtk) {
        int maxRadius = this.getStat().getPhysicalAttackRange();
        int maxAngleDiff = this.getStat().getPhysicalAttackAngle();
        int attackRandomCountMax = (int)this.getStat().calcStat(Stats.ATTACK_COUNT_MAX, 1.0, null, null);
        int attackcount = 0;
        boolean hitted = this.doAttackHitSimple(attack, target, 100.0, sAtk);
        double attackpercent = 85.0;
        Collection objs = this.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            L2Character temp;
            if (obj == target || !(obj instanceof L2Character) || obj.isPet() && this.isPlayer() && ((L2PetInstance)obj).getOwner() == this.getActingPlayer() || !Util.checkIfInRange(maxRadius, this, obj, false) || Math.abs(obj.getZ() - this.getZ()) > 650 || !this.isFacing(obj, maxAngleDiff) || this.isAttackable() && obj.isPlayer() && this.getTarget().isAttackable() || this.isAttackable() && obj.isAttackable() && ((L2Attackable)this).getEnemyClan() == null && ((L2Attackable)this).getIsChaos() == 0 || this.isAttackable() && obj.isAttackable() && !((L2Attackable)this).getEnemyClan().equals(((L2Attackable)obj).getClan()) && ((L2Attackable)this).getIsChaos() == 0 || (temp = (L2Character)obj).isAlikeDead() || temp != this.getAI().getAttackTarget() && !temp.isAutoAttackable(this)) continue;
            hitted |= this.doAttackHitSimple(attack, temp, attackpercent, sAtk);
            attackpercent /= 1.15;
            if (++attackcount <= attackRandomCountMax) continue;
            break;
        }
        return hitted;
    }

    private boolean doAttackHitSimple(Attack attack, L2Character target, int sAtk) {
        return this.doAttackHitSimple(attack, target, 100.0, sAtk);
    }

    private boolean doAttackHitSimple(Attack attack, L2Character target, double attackpercent, int sAtk) {
        int damage1 = 0;
        byte shld1 = 0;
        boolean crit1 = false;
        boolean miss1 = Formulas.calcHitMiss(this, target);
        if (!miss1) {
            shld1 = Formulas.calcShldUse(this, target);
            crit1 = Formulas.calcCrit(this.getStat().getCriticalHit(target, null), false, target);
            damage1 = (int)Formulas.calcPhysDam(this, target, null, shld1, crit1, attack.hasSoulshot());
            if (attackpercent != 100.0) {
                damage1 = (int)((double)damage1 * attackpercent / 100.0);
            }
        }
        ThreadPoolManager.getInstance().scheduleAi(new HitTask(this, target, damage1, crit1, miss1, attack.hasSoulshot(), shld1), sAtk);
        attack.addHit(target, damage1, miss1, crit1, shld1);
        return !miss1;
    }

    public void doCast(L2Skill skill) {
        this.beginCast(skill, false);
    }

    public void doSimultaneousCast(L2Skill skill) {
        this.beginCast(skill, true);
    }

    public void doCast(L2Skill skill, L2Character target, L2Object[] targets) {
        if (!this.checkDoCastConditions(skill)) {
            this.setIsCastingNow(false);
            return;
        }
        if (skill.isSimultaneousCast()) {
            this.doSimultaneousCast(skill, target, targets);
            return;
        }
        this.stopEffectsOnAction();
        this.beginCast(skill, false, target, targets);
    }

    public void doSimultaneousCast(L2Skill skill, L2Character target, L2Object[] targets) {
        if (!this.checkDoCastConditions(skill)) {
            this.setIsCastingSimultaneouslyNow(false);
            return;
        }
        this.stopEffectsOnAction();
        this.beginCast(skill, true, target, targets);
    }

    private void beginCast(L2Skill skill, boolean simultaneously) {
        if (!this.checkDoCastConditions(skill)) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        if (skill.isSimultaneousCast() && !simultaneously) {
            simultaneously = true;
        }
        this.stopEffectsOnAction();
        this.rechargeShots(skill.useSoulShot(), skill.useSpiritShot());
        L2Character target = null;
        L2Object[] targets = skill.getTargetList(this);
        boolean doit = false;
        switch (skill.getTargetType()) {
            case AREA_SUMMON: {
                target = this.getSummon();
                break;
            }
            case AURA: 
            case AURA_CORPSE_MOB: 
            case FRONT_AURA: 
            case BEHIND_AURA: 
            case GROUND: {
                target = this;
                break;
            }
            case SELF: 
            case PET: 
            case SERVITOR: 
            case SUMMON: 
            case OWNER_PET: 
            case PARTY: 
            case CLAN: 
            case PARTY_CLAN: {
                doit = true;
            }
            default: {
                if (targets.length == 0) {
                    if (simultaneously) {
                        this.setIsCastingSimultaneouslyNow(false);
                    } else {
                        this.setIsCastingNow(false);
                    }
                    if (this.isPlayer()) {
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    }
                    return;
                }
                if (skill.isContinuous() && !skill.isDebuff()) {
                    doit = true;
                } else if (skill.getSkillType() == L2SkillType.DUMMY && skill.hasEffectType(L2EffectType.CPHEAL, L2EffectType.HEAL)) {
                    doit = true;
                }
                target = doit ? (L2Character)targets[0] : (L2Character)this.getTarget();
            }
        }
        this.beginCast(skill, simultaneously, target, targets);
    }

    private void beginCast(L2Skill skill, boolean simultaneously, L2Character target, L2Object[] targets) {
        int initmpcons;
        if (target == null || !this.getEvents().onMagic(skill, simultaneously, target, targets)) {
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            return;
        }
        if (skill.hasEffectType(L2EffectType.RESURRECTION) && (this.isResurrectionBlocked() || target.isResurrectionBlocked())) {
            this.sendPacket(SystemMessageId.REJECT_RESURRECTION);
            target.sendPacket(SystemMessageId.REJECT_RESURRECTION);
            if (simultaneously) {
                this.setIsCastingSimultaneouslyNow(false);
            } else {
                this.setIsCastingNow(false);
            }
            if (this.isPlayer()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
            }
            return;
        }
        int magicId = skill.getId();
        int skillTime = skill.getHitTime() + skill.getCoolTime();
        if (!skill.isChanneling()) {
            if (!skill.isStatic()) {
                skillTime = Formulas.calcAtkSpd(this, skill, skillTime);
            }
            if (skill.isMagic() && (this.isChargedShot(ShotType.SPIRITSHOTS) || this.isChargedShot(ShotType.BLESSED_SPIRITSHOTS))) {
                skillTime = (int)(0.6 * (double)skillTime);
            }
        }
        if (skill.isMagic() && skill.getHitTime() + skill.getCoolTime() > 550 && skillTime < 550) {
            skillTime = 550;
        } else if (!skill.isStatic() && skill.getHitTime() + skill.getCoolTime() >= 500 && skillTime < 500) {
            skillTime = 500;
        }
        if (this.isCastingSimultaneouslyNow() && simultaneously) {
            ThreadPoolManager.getInstance().scheduleAi(new UsePotionTask(this, skill), 100L);
            return;
        }
        if (simultaneously) {
            this.setIsCastingSimultaneouslyNow(true);
        } else {
            this.setIsCastingNow(true);
        }
        if (!simultaneously) {
            this._castEndTime = 10 + GameTimeController.getInstance().getGameTicks() + skillTime / 100;
            this._castInterruptTime = -2 + GameTimeController.getInstance().getGameTicks() + skillTime / 100;
            this.setLastSkillCast(skill);
        } else {
            this.setLastSimultaneousSkillCast(skill);
        }
        int reuseDelay = skill.isStaticReuse() || skill.isStatic() ? skill.getReuseDelay() : (skill.isMagic() ? (int)((double)skill.getReuseDelay() * this.calcStat(Stats.MAGIC_REUSE_RATE, 1.0, null, null)) : (int)((double)skill.getReuseDelay() * this.calcStat(Stats.P_REUSE, 1.0, null, null)));
        boolean skillMastery = Formulas.calcSkillMastery(this, skill);
        if (reuseDelay > 30000 && !skillMastery) {
            this.addTimeStamp(skill, reuseDelay);
        }
        if ((initmpcons = this.getStat().getMpInitialConsume(skill)) > 0) {
            this.getStatus().reduceMp(initmpcons);
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(11, (int)this.getCurrentMp());
            this.sendPacket(su);
        }
        if (reuseDelay > 10) {
            if (skillMastery) {
                reuseDelay = 100;
                if (this.getActingPlayer() != null) {
                    this.getActingPlayer().sendPacket(SystemMessageId.SKILL_READY_TO_USE_AGAIN);
                }
            }
            this.disableSkill(skill, reuseDelay);
        }
        if (target != this) {
            this.setHeading(Util.calculateHeadingFrom(this, target));
        }
        if (this.isPlayable()) {
            if (skill.getItemConsumeId() > 0 && !this.destroyItemByItemId("Consume", skill.getItemConsumeId(), skill.getItemConsume(), null, true)) {
                this.getActingPlayer().sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
                this.abortCast();
                return;
            }
            if (skill.getReferenceItemId() > 0 && ItemTable.getInstance().getTemplate(skill.getReferenceItemId()).getBodyPart() == 0x400000) {
                for (L2ItemInstance item : this.getInventory().getItemsByItemId(skill.getReferenceItemId())) {
                    if (!item.isEquipped()) continue;
                    item.decreaseMana(false, item.useSkillDisTime());
                    break;
                }
            }
        }
        this.broadcastPacket(new MagicSkillUse(this, target, skill.getDisplayId(), skill.getDisplayLevel(), skillTime, reuseDelay));
        if (this.isPlayer() && !skill.isAbnormalInstant()) {
            SystemMessage sm = null;
            switch (magicId) {
                case 1312: {
                    break;
                }
                case 2046: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.SUMMON_A_PET);
                    break;
                }
                default: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.USE_S1);
                    sm.addSkillName(skill);
                }
            }
            this.sendPacket(sm);
        }
        if (skill.getFlyType() != null) {
            ThreadPoolManager.getInstance().scheduleEffect(new FlyToLocationTask(this, target, skill), 50L);
        }
        MagicUseTask mut = new MagicUseTask(this, targets, skill, skillTime, simultaneously);
        if (skillTime > 0) {
            Future<?> future;
            if (this.isPlayer() && !simultaneously) {
                this.sendPacket(new SetupGauge(0, skillTime));
            }
            if (skill.isChanneling()) {
                this.getSkillChannelizer().startChanneling(skill);
            }
            if (simultaneously) {
                future = this._skillCast2;
                if (future != null) {
                    future.cancel(true);
                    this._skillCast2 = null;
                }
                this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, skillTime - 400);
            } else {
                future = this._skillCast;
                if (future != null) {
                    future.cancel(true);
                    this._skillCast = null;
                }
                this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, skillTime - 400);
            }
        } else {
            mut.setSkillTime(0);
            this.onMagicLaunchedTimer(mut);
        }
    }

    public boolean checkDoCastConditions(L2Skill skill) {
        L2ItemInstance requiredItems;
        L2Weapon wep;
        if (skill == null || this.isSkillDisabled(skill) || (skill.getFlyRadius() > 0 || skill.getFlyType() != null) && this.isMovementDisabled()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume(skill) + this.getStat().getMpInitialConsume(skill))) {
            this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getCurrentHp() <= (double)skill.getHpConsume()) {
            this.sendPacket(SystemMessageId.NOT_ENOUGH_HP);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (!skill.isStatic()) {
            if (skill.isMagic()) {
                if (this.isMuted()) {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            } else if (this.isPhysicalMuted()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.isChanneling()) {
            L2WorldRegion region = this.getWorldRegion();
            if (region == null) {
                return false;
            }
            boolean canCast = true;
            if (skill.getTargetType() == L2TargetType.GROUND && this.isPlayer()) {
                Location wp = this.getActingPlayer().getCurrentSkillWorldPosition();
                if (!region.checkEffectRangeInsidePeaceZone(skill, wp.getX(), wp.getY(), wp.getZ())) {
                    canCast = false;
                }
            } else if (!region.checkEffectRangeInsidePeaceZone(skill, this.getX(), this.getY(), this.getZ())) {
                canCast = false;
            }
            if (!canCast) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                sm.addSkillName(skill);
                this.sendPacket(sm);
                return false;
            }
        }
        if (this.getActiveWeaponItem() != null && (wep = this.getActiveWeaponItem()).useWeaponSkillsOnly() && !this.isGM() && wep.hasSkills()) {
            boolean found = false;
            for (SkillHolder sh : wep.getSkills()) {
                if (sh.getSkillId() != skill.getId()) continue;
                found = true;
            }
            if (!found) {
                if (this.getActingPlayer() != null) {
                    this.sendPacket(SystemMessageId.WEAPON_CAN_USE_ONLY_WEAPON_SKILL);
                }
                return false;
            }
        }
        if (skill.getItemConsumeId() > 0 && this.getInventory() != null && ((requiredItems = this.getInventory().getItemByItemId(skill.getItemConsumeId())) == null || requiredItems.getCount() < (long)skill.getItemConsume())) {
            this.sendPacket(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
            return false;
        }
        return true;
    }

    public final FastIntObjectMap<TimeStamp> getItemReuseTimeStamps() {
        return this._reuseTimeStampsItems;
    }

    public final void addTimeStampItem(L2ItemInstance item, long reuse) {
        this.addTimeStampItem(item, reuse, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTimeStampItem(L2ItemInstance item, long reuse, long systime) {
        if (this._reuseTimeStampsItems == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._reuseTimeStampsItems == null) {
                    this._reuseTimeStampsItems = new FastIntObjectMap().shared();
                }
            }
        }
        this._reuseTimeStampsItems.put(item.getObjectId(), (Object)new TimeStamp(item, reuse, systime));
    }

    public final synchronized long getItemRemainingReuseTime(int itemObjId) {
        TimeStamp reuseStamp;
        return this._reuseTimeStampsItems != null && (reuseStamp = (TimeStamp)this._reuseTimeStampsItems.get(itemObjId)) != null ? reuseStamp.getRemaining() : -1L;
    }

    public final long getReuseDelayOnGroup(int group) {
        if (group > 0 && this._reuseTimeStampsItems != null) {
            for (TimeStamp ts : this._reuseTimeStampsItems.values()) {
                if (ts.getSharedReuseGroup() != group || !ts.hasNotPassed()) continue;
                return ts.getRemaining();
            }
        }
        return -1L;
    }

    public final FastIntObjectMap<TimeStamp> getSkillReuseTimeStamps() {
        return this._reuseTimeStampsSkills;
    }

    public final void addTimeStamp(L2Skill skill, long reuse) {
        this.addTimeStamp(skill, reuse, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTimeStamp(L2Skill skill, long reuse, long systime) {
        if (this._reuseTimeStampsSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._reuseTimeStampsSkills == null) {
                    this._reuseTimeStampsSkills = new FastIntObjectMap().shared();
                }
            }
        }
        this._reuseTimeStampsSkills.put(skill.getReuseHashCode(), (Object)new TimeStamp(skill, reuse, systime));
    }

    public final synchronized void removeTimeStamp(L2Skill skill) {
        if (this._reuseTimeStampsSkills != null) {
            this._reuseTimeStampsSkills.remove(skill.getReuseHashCode());
        }
    }

    public final synchronized void resetTimeStamps() {
        if (this._reuseTimeStampsSkills != null) {
            this._reuseTimeStampsSkills.clear();
        }
    }

    public final synchronized long getSkillRemainingReuseTime(int hashCode) {
        TimeStamp reuseStamp;
        return this._reuseTimeStampsSkills != null && (reuseStamp = (TimeStamp)this._reuseTimeStampsSkills.get(hashCode)) != null ? reuseStamp.getRemaining() : -1L;
    }

    public final synchronized boolean hasSkillReuse(int hashCode) {
        TimeStamp reuseStamp;
        return this._reuseTimeStampsSkills != null && (reuseStamp = (TimeStamp)this._reuseTimeStampsSkills.get(hashCode)) != null ? reuseStamp.hasNotPassed() : false;
    }

    public final synchronized TimeStamp getSkillReuseTimeStamp(int hashCode) {
        return this._reuseTimeStampsSkills != null ? (TimeStamp)this._reuseTimeStampsSkills.get(hashCode) : null;
    }

    @Deprecated
    public FastIntObjectMap<Long> getDisabledSkills() {
        return this._disabledSkills;
    }

    public void enableSkill(L2Skill skill) {
        if (skill == null || this._disabledSkills == null) {
            return;
        }
        this._disabledSkills.remove(skill.getReuseHashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSkill(L2Skill skill, long delay) {
        if (skill == null) {
            return;
        }
        if (this._disabledSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._disabledSkills == null) {
                    this._disabledSkills = new FastIntObjectMap().shared();
                }
            }
        }
        this._disabledSkills.put(skill.getReuseHashCode(), (Object)(delay > 0L ? System.currentTimeMillis() + delay : SKILL_DISABLED_FOREVER));
    }

    public final void resetDisabledSkills() {
        if (this._disabledSkills != null) {
            this._disabledSkills.clear();
        }
    }

    public boolean isSkillDisabled(L2Skill skill) {
        return skill != null && this.isSkillDisabled(skill.getReuseHashCode());
    }

    public boolean isSkillDisabled(int hashCode) {
        if (this.isAllSkillsDisabled()) {
            return true;
        }
        if (this._disabledSkills == null) {
            return false;
        }
        Long stamp = (Long)this._disabledSkills.get(hashCode);
        if (stamp == null) {
            return false;
        }
        if (stamp < System.currentTimeMillis()) {
            this._disabledSkills.remove(hashCode);
            return false;
        }
        return true;
    }

    public void disableAllSkills() {
        this._allSkillsDisabled = true;
    }

    public void enableAllSkills() {
        this._allSkillsDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDie(L2Character killer) {
        L2Character l2Character = this;
        synchronized (l2Character) {
            if (this.isDead()) {
                return false;
            }
            this.setCurrentHp(0.0);
            this.setIsDead(true);
        }
        if (!this.getEvents().onDeath(killer)) {
            return false;
        }
        this.setTarget(null);
        this.stopMove(null);
        this.getStatus().stopHpMpRegeneration();
        if (this.isPlayable() && ((L2Playable)this).isPhoenixBlessed()) {
            if (((L2Playable)this).isCharmOfLuckAffected()) {
                this.stopEffects(L2EffectType.CHARM_OF_LUCK);
            }
            if (((L2Playable)this).isNoblesseBlessed()) {
                this.stopEffects(L2EffectType.NOBLESSE_BLESSING);
            }
        } else if (this.isPlayable() && ((L2Playable)this).isNoblesseBlessed()) {
            this.stopEffects(L2EffectType.NOBLESSE_BLESSING);
            if (((L2Playable)this).isCharmOfLuckAffected()) {
                this.stopEffects(L2EffectType.CHARM_OF_LUCK);
            }
        } else {
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        if (this.isPlayer() && this.getActingPlayer().getAgathionId() != 0) {
            this.getActingPlayer().setAgathionId(0);
        }
        this.calculateRewards(killer);
        this.broadcastStatusUpdate();
        if (this.hasAI()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_DEAD);
        }
        if (this.getWorldRegion() != null) {
            this.getWorldRegion().onDeath(this);
        }
        this.getAttackByList().clear();
        if (this.isSummon() && this.getSummon().isPhoenixBlessed() && this.getActingPlayer() != null) {
            this.getActingPlayer().reviveRequest(this.getActingPlayer(), null, true, 0);
        }
        if (this.isPlayer()) {
            if (((L2Playable)this).isPhoenixBlessed()) {
                this.getActingPlayer().reviveRequest(this.getActingPlayer(), null, false, 100);
            } else if (this.isAffected(EffectFlag.CHARM_OF_COURAGE) && this.getActingPlayer().isInSiege()) {
                this.getActingPlayer().reviveRequest(this.getActingPlayer(), null, false, 0);
            }
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        this.setDebug(null);
        if (this.hasAI()) {
            this.getAI().stopAITask();
        }
        return true;
    }

    protected void calculateRewards(L2Character killer) {
    }

    public void doRevive() {
        if (!this.isDead()) {
            return;
        }
        if (!this.isTeleporting()) {
            this.setIsPendingRevive(false);
            this.setIsDead(false);
            boolean restorefull = false;
            if (this.isPlayable() && ((L2Playable)this).isPhoenixBlessed()) {
                restorefull = true;
                this.stopEffects(L2EffectType.PHOENIX_BLESSING);
            }
            if (restorefull) {
                this._status.setCurrentCp(this.getCurrentCp());
                this._status.setCurrentHp(this.getMaxHp());
                this._status.setCurrentMp(this.getMaxMp());
            } else {
                if (Config.RESPAWN_RESTORE_CP > 0.0 && this.getCurrentCp() < (double)this.getMaxCp() * Config.RESPAWN_RESTORE_CP) {
                    this._status.setCurrentCp((double)this.getMaxCp() * Config.RESPAWN_RESTORE_CP);
                }
                if (Config.RESPAWN_RESTORE_HP > 0.0 && this.getCurrentHp() < (double)this.getMaxHp() * Config.RESPAWN_RESTORE_HP) {
                    this._status.setCurrentHp((double)this.getMaxHp() * Config.RESPAWN_RESTORE_HP);
                }
                if (Config.RESPAWN_RESTORE_MP > 0.0 && this.getCurrentMp() < (double)this.getMaxMp() * Config.RESPAWN_RESTORE_MP) {
                    this._status.setCurrentMp((double)this.getMaxMp() * Config.RESPAWN_RESTORE_MP);
                }
            }
            this.broadcastPacket(new Revive(this));
            if (this.getWorldRegion() != null) {
                this.getWorldRegion().onRevive(this);
            }
        } else {
            this.setIsPendingRevive(true);
        }
    }

    public void doRevive(double revivePower) {
        this.doRevive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._ai == null) {
                    this._ai = new L2CharacterAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    public void setAI(L2CharacterAI newAI) {
        L2CharacterAI oldAI = this._ai;
        this._ai = newAI;
        if (oldAI != null && oldAI != newAI && oldAI instanceof L2AttackableAI) {
            ((L2AttackableAI)oldAI).stopAITask();
        }
    }

    public boolean hasAI() {
        return this._ai != null;
    }

    public boolean isRaid() {
        return false;
    }

    public boolean isMinion() {
        return false;
    }

    public boolean isRaidMinion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<L2Character> getAttackByList() {
        if (this._attackByList == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._attackByList == null) {
                    this._attackByList = new WeakFastSet(true);
                }
            }
        }
        return this._attackByList;
    }

    public final L2Skill getLastSimultaneousSkillCast() {
        return this._lastSimultaneousSkillCast;
    }

    public void setLastSimultaneousSkillCast(L2Skill skill) {
        this._lastSimultaneousSkillCast = skill;
    }

    public final L2Skill getLastSkillCast() {
        return this._lastSkillCast;
    }

    public void setLastSkillCast(L2Skill skill) {
        this._lastSkillCast = skill;
    }

    public final boolean isNoRndWalk() {
        return this._isNoRndWalk;
    }

    public final void setIsNoRndWalk(boolean value) {
        this._isNoRndWalk = value;
    }

    public final boolean isAfraid() {
        return this.isAffected(EffectFlag.FEAR);
    }

    public final boolean isAllSkillsDisabled() {
        return this._allSkillsDisabled || this.isStunned() || this.isSleeping() || this.isParalyzed();
    }

    public boolean isAttackingDisabled() {
        return this.isFlying() || this.isStunned() || this.isSleeping() || this._attackEndTime > GameTimeController.getInstance().getGameTicks() || this.isAlikeDead() || this.isParalyzed() || this.isPhysicalAttackMuted() || this.isCoreAIDisabled() || this.isFallsdown();
    }

    public final Calculator[] getCalculators() {
        return this._calculators;
    }

    public final boolean isConfused() {
        return this.isAffected(EffectFlag.CONFUSED);
    }

    public boolean isAlikeDead() {
        return this._isDead;
    }

    public final boolean isDead() {
        return this._isDead;
    }

    public final void setIsDead(boolean value) {
        this._isDead = value;
    }

    public final boolean isFallsdown() {
        return this._isFallsdown;
    }

    public final void setIsFallsdown(boolean value) {
        this._isFallsdown = value;
    }

    public boolean isImmobilized() {
        return this._isImmobilized;
    }

    public void setIsImmobilized(boolean value) {
        this._isImmobilized = value;
    }

    public final boolean isMuted() {
        return this.isAffected(EffectFlag.MUTED);
    }

    public final boolean isPhysicalMuted() {
        return this.isAffected(EffectFlag.PSYCHICAL_MUTED);
    }

    public final boolean isPhysicalAttackMuted() {
        return this.isAffected(EffectFlag.PSYCHICAL_ATTACK_MUTED);
    }

    public boolean isMovementDisabled() {
        return this.isStunned() || this.isRooted() || this.isSleeping() || this.isOverloaded() || this.isParalyzed() || this.isImmobilized() || this.isAlikeDead() || this.isTeleporting() || this.isFallsdown();
    }

    public final boolean isOutOfControl() {
        return this.isConfused() || this.isAfraid();
    }

    public final boolean isOverloaded() {
        return this._isOverloaded;
    }

    public final void setIsOverloaded(boolean value) {
        this._isOverloaded = value;
    }

    public final boolean isParalyzed() {
        return this._isParalyzed || this.isAffected(EffectFlag.PARALYZED);
    }

    public final void setIsParalyzed(boolean value) {
        this._isParalyzed = value;
    }

    public final boolean isPendingRevive() {
        return this.isDead() && this._isPendingRevive;
    }

    public final void setIsPendingRevive(boolean value) {
        this._isPendingRevive = value;
    }

    public final boolean isDisarmed() {
        return this.isAffected(EffectFlag.DISARMED);
    }

    public L2Summon getSummon() {
        return null;
    }

    public final boolean hasSummon() {
        return this.getSummon() != null;
    }

    public final boolean hasPet() {
        return this.hasSummon() && this.getSummon().isPet();
    }

    public final boolean hasServitor() {
        return this.hasSummon() && this.getSummon().isServitor();
    }

    public final boolean isRooted() {
        return this.isAffected(EffectFlag.ROOTED);
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public final void setIsRunning(boolean value) {
        this._isRunning = value;
        int runSpeed = this.getRunSpeed();
        if (runSpeed != 0) {
            this.broadcastPacket(new ChangeMoveType(this));
        }
        if (this.isPlayer()) {
            this.getActingPlayer().broadcastUserInfo();
        } else if (this.isSummon()) {
            ((L2Summon)this).broadcastStatusUpdate();
        } else if (this.isNpc()) {
            Collection plrs = this.getKnownList().getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (player == null) continue;
                if (runSpeed == 0) {
                    player.sendPacket(new ServerObjectInfo((L2Npc)this, player));
                    continue;
                }
                player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)this, player));
            }
        }
    }

    public final void setRunning() {
        if (!this.isRunning()) {
            this.setIsRunning(true);
        }
    }

    public final boolean isSleeping() {
        return this.isAffected(EffectFlag.SLEEP);
    }

    public final boolean isStunned() {
        return this.isAffected(EffectFlag.STUNNED);
    }

    public final boolean isBetrayed() {
        return this.isAffected(EffectFlag.BETRAYED);
    }

    public final boolean isTeleporting() {
        return this._isTeleporting;
    }

    public void setIsTeleporting(boolean value) {
        this._isTeleporting = value;
    }

    public void setIsInvul(boolean b) {
        this._isInvul = b;
    }

    public boolean isInvul() {
        return this._isInvul || this._isTeleporting || this.isAffected(EffectFlag.INVUL);
    }

    public void setIsMortal(boolean b) {
        this._isMortal = b;
    }

    public boolean isMortal() {
        return this._isMortal;
    }

    public boolean isUndead() {
        return false;
    }

    public boolean isResurrectionBlocked() {
        return this.isAffected(EffectFlag.BLOCK_RESURRECTION);
    }

    public final boolean isFlying() {
        return this._isFlying;
    }

    public final void setIsFlying(boolean mode) {
        this._isFlying = mode;
    }

    @Override
    public CharKnownList getKnownList() {
        return (CharKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new CharKnownList(this));
    }

    public CharStat getStat() {
        return this._stat;
    }

    public void initCharStat() {
        this._stat = new CharStat(this);
    }

    public final void setStat(CharStat value) {
        this._stat = value;
    }

    public CharStatus getStatus() {
        return this._status;
    }

    public void initCharStatus() {
        this._status = new CharStatus(this);
    }

    public final void setStatus(CharStatus value) {
        this._status = value;
    }

    public void initCharEvents() {
        this._events = new CharEvents(this);
    }

    public void setCharEvents(CharEvents events) {
        this._events = events;
    }

    public CharEvents getEvents() {
        return this._events;
    }

    public L2CharTemplate getTemplate() {
        return this._template;
    }

    protected final void setTemplate(L2CharTemplate template) {
        this._template = template;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String value) {
        this._title = value == null ? "" : (value.length() > 21 ? value.substring(0, 20) : value);
    }

    public final void setWalking() {
        if (this.isRunning()) {
            this.setIsRunning(false);
        }
    }

    public int getAbnormalVisualEffects() {
        return this._abnormalVisualEffects;
    }

    public int getAbnormalVisualEffectSpecial() {
        return this._abnormalVisualEffectsSpecial;
    }

    public int getAbnormalVisualEffectEvent() {
        return this._abnormalVisualEffectsEvent;
    }

    public boolean hasAbnormalVisualEffect(AbnormalVisualEffect ave) {
        if (ave.isEvent()) {
            return (this.getAbnormalVisualEffectEvent() & ave.getMask()) == ave.getMask();
        }
        if (ave.isSpecial()) {
            return (this.getAbnormalVisualEffectSpecial() & ave.getMask()) == ave.getMask();
        }
        return (this.getAbnormalVisualEffects() & ave.getMask()) == ave.getMask();
    }

    public final void startAbnormalVisualEffect(boolean update, AbnormalVisualEffect ... aves) {
        for (AbnormalVisualEffect ave : aves) {
            if (ave.isEvent()) {
                this._abnormalVisualEffectsEvent |= ave.getMask();
                continue;
            }
            if (ave.isSpecial()) {
                this._abnormalVisualEffectsSpecial |= ave.getMask();
                continue;
            }
            this._abnormalVisualEffects |= ave.getMask();
        }
        if (update) {
            this.updateAbnormalEffect();
        }
    }

    public final void stopAbnormalVisualEffect(boolean update, AbnormalVisualEffect ... aves) {
        for (AbnormalVisualEffect ave : aves) {
            if (ave.isEvent()) {
                this._abnormalVisualEffectsEvent &= ~ave.getMask();
                continue;
            }
            if (ave.isSpecial()) {
                this._abnormalVisualEffectsSpecial &= ~ave.getMask();
                continue;
            }
            this._abnormalVisualEffects &= ~ave.getMask();
        }
        if (update) {
            this.updateAbnormalEffect();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void startFakeDeath() {
        block17: {
            boolean isFakeDeath;
            block16: {
                Iterator<L2Character> i$;
                int highestLevel;
                boolean isRaid;
                block15: {
                    block13: {
                        block14: {
                            if (!this.isPlayer()) {
                                return;
                            }
                            this.setIsFallsdown(true);
                            if (!Config.FAILD_FAKEDEATH) break block13;
                            isFakeDeath = true;
                            if (this.getAttackByList() == null || this.getAttackByList().size() == 0) break block14;
                            isRaid = false;
                            highestLevel = this.getLevel();
                            i$ = this.getAttackByList().iterator();
                            break block15;
                        }
                        if (Rnd.get(100) < 25) {
                            isFakeDeath = false;
                        }
                        break block16;
                    }
                    this.getActingPlayer().setIsFakeDeath(true);
                    break block17;
                }
                while (i$.hasNext()) {
                    L2Character atkChar = i$.next();
                    if (atkChar.isRaid()) {
                        isRaid = true;
                        break;
                    }
                    if (atkChar.getLevel() <= highestLevel) continue;
                    highestLevel = atkChar.getLevel();
                }
                if (isRaid) {
                    isFakeDeath = false;
                } else {
                    int _diff = highestLevel - this.getLevel();
                    switch (_diff) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (Rnd.get(100) >= 5) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 6: {
                            if (Rnd.get(100) >= 10) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 7: {
                            if (Rnd.get(100) >= 15) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 8: {
                            if (Rnd.get(100) >= 20) break;
                            isFakeDeath = false;
                            break;
                        }
                        case 9: {
                            if (Rnd.get(100) >= 25) break;
                            isFakeDeath = false;
                            break;
                        }
                        default: {
                            if (_diff <= 9 || Rnd.get(100) >= 50) break;
                            isFakeDeath = false;
                        }
                    }
                }
            }
            this.getActingPlayer().setIsFakeDeath(isFakeDeath);
        }
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_FAKE_DEATH);
        this.broadcastPacket(new ChangeWaitType(this, 2));
    }

    public final void startStunning() {
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_STUNNED);
        if (!this.isSummon()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.updateAbnormalEffect();
    }

    public final void startParalyze() {
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this.getAI().notifyEvent(CtrlEvent.EVT_PARALYZED);
    }

    public void stopAllEffects() {
        this._effectList.stopAllEffects();
    }

    public void stopAllEffectsExceptThoseThatLastThroughDeath() {
        this._effectList.stopAllEffectsExceptThoseThatLastThroughDeath();
    }

    public void stopSkillEffects(boolean removed, int skillId) {
        this._effectList.stopSkillEffects(removed, skillId);
    }

    public final void stopEffects(L2EffectType type) {
        this._effectList.stopEffects(type);
    }

    public final void stopEffectsOnAction() {
        this._effectList.stopEffectsOnAction();
    }

    public final void stopEffectsOnDamage(boolean awake) {
        this._effectList.stopEffectsOnDamage(awake);
    }

    public final void stopFakeDeath(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.FAKE_DEATH);
        }
        this.setIsFallsdown(false);
        if (this.isPlayer()) {
            this.getActingPlayer().setIsFakeDeath(false);
            this.getActingPlayer().setRecentFakeDeath(true);
        }
        this.broadcastPacket(new ChangeWaitType(this, 3));
        this.broadcastPacket(new Revive(this));
    }

    public final void stopStunning(boolean removeEffects) {
        if (removeEffects) {
            this.stopEffects(L2EffectType.STUN);
        }
        if (!this.isPlayer()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public final void stopTransformation(boolean removeEffects) {
        if (removeEffects) {
            this.getEffectList().stopSkillEffects(false, AbnormalType.TRANSFORM);
        }
        if (this.isPlayer() && this.getActingPlayer().getTransformation() != null) {
            this.getActingPlayer().untransform();
        }
        if (!this.isPlayer()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_THINK);
        }
        this.updateAbnormalEffect();
    }

    public abstract void updateAbnormalEffect();

    public final void updateEffectIcons() {
        this.updateEffectIcons(false);
    }

    public void updateEffectIcons(boolean partyOnly) {
    }

    public boolean isAffectedBySkill(int skillId) {
        return this._effectList.isAffectedBySkill(skillId);
    }

    public final List<AbstractEffect> getAllEffects() {
        return this._effectList.getAllEffects();
    }

    public final AbstractEffect getFirstEffect(int skillId) {
        return this.isAffectedBySkill(skillId) ? DUMMY_EFFECT : null;
    }

    public final AbstractEffect getFirstEffect(L2Skill skill) {
        return this.isAffectedBySkill(skill.getId()) ? DUMMY_EFFECT : null;
    }

    public final AbstractEffect getFirstEffect(L2EffectType tp) {
        BuffInfo info = this._effectList.getFirstEffect(tp);
        if (info != null) {
            for (AbstractEffect effect : info.getEffects()) {
                if (effect == null || effect.getEffectType() != tp) continue;
                return effect;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStatFunc(Func f) {
        if (f == null) {
            return;
        }
        Calculator[] calculatorArray = this._calculators;
        synchronized (this._calculators) {
            int stat;
            if (this._calculators == NPC_STD_CALCULATOR) {
                this._calculators = new Calculator[Stats.NUM_STATS];
                for (int i = 0; i < Stats.NUM_STATS; ++i) {
                    if (NPC_STD_CALCULATOR[i] == null) continue;
                    this._calculators[i] = new Calculator(NPC_STD_CALCULATOR[i]);
                }
            }
            if (this._calculators[stat = f.stat.ordinal()] == null) {
                this._calculators[stat] = new Calculator();
            }
            this._calculators[stat].addFunc(f);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final void addStatFuncs(List<Func> funcs) {
        if (funcs.size() == 0) {
            return;
        }
        ArrayList<Stats> modifiedStats = new ArrayList<Stats>(funcs.size());
        for (Func f : funcs) {
            modifiedStats.add(f.stat);
            this.addStatFunc(f);
        }
        this.broadcastModifiedStats(modifiedStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStatFunc(Func f) {
        if (f == null) {
            return;
        }
        int stat = f.stat.ordinal();
        Calculator[] calculatorArray = this._calculators;
        synchronized (this._calculators) {
            if (this._calculators[stat] == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this._calculators[stat].removeFunc(f);
            if (this._calculators[stat].size() == 0) {
                this._calculators[stat] = null;
            }
            if (this.isNpc()) {
                int i;
                for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
                }
                if (i >= Stats.NUM_STATS) {
                    this._calculators = NPC_STD_CALCULATOR;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final void removeStatFuncs(Func[] funcs) {
        if (funcs.length == 0) {
            return;
        }
        ArrayList<Stats> modifiedStats = new ArrayList<Stats>(funcs.length);
        for (Func f : funcs) {
            modifiedStats.add(f.stat);
            this.removeStatFunc(f);
        }
        this.broadcastModifiedStats(modifiedStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStatsOwner(Object owner) {
        List<Stats> modifiedStats = null;
        int i = 0;
        Calculator[] calculatorArray = this._calculators;
        synchronized (this._calculators) {
            for (Calculator calc : this._calculators) {
                if (calc != null) {
                    if (modifiedStats != null) {
                        modifiedStats.addAll(calc.removeOwner(owner));
                    } else {
                        modifiedStats = calc.removeOwner(owner);
                    }
                    if (calc.size() == 0) {
                        this._calculators[i] = null;
                    }
                }
                ++i;
            }
            if (this.isNpc()) {
                for (i = 0; i < Stats.NUM_STATS && Calculator.equalsCals(this._calculators[i], NPC_STD_CALCULATOR[i]); ++i) {
                }
                if (i >= Stats.NUM_STATS) {
                    this._calculators = NPC_STD_CALCULATOR;
                }
            }
            this.broadcastModifiedStats(modifiedStats);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void broadcastModifiedStats(List<Stats> stats) {
        if (stats == null || stats.isEmpty()) {
            return;
        }
        if (this.isSummon()) {
            L2Summon summon = (L2Summon)this;
            if (summon.getOwner() != null) {
                summon.updateAndBroadcastStatus(1);
            }
        } else {
            boolean broadcastFull = false;
            StatusUpdate su = new StatusUpdate(this);
            for (Stats stat : stats) {
                if (stat == Stats.POWER_ATTACK_SPEED) {
                    su.addAttribute(18, this.getPAtkSpd());
                    continue;
                }
                if (stat == Stats.MAGIC_ATTACK_SPEED) {
                    su.addAttribute(24, this.getMAtkSpd());
                    continue;
                }
                if (stat != Stats.MOVE_SPEED) continue;
                broadcastFull = true;
            }
            if (this.isPlayer()) {
                if (broadcastFull) {
                    this.getActingPlayer().updateAndBroadcastStatus(2);
                } else {
                    this.getActingPlayer().updateAndBroadcastStatus(1);
                    if (su.hasAttributes()) {
                        this.broadcastPacket(su);
                    }
                }
                if (this.getSummon() != null && this.isAffected(EffectFlag.SERVITOR_SHARE)) {
                    this.getSummon().broadcastStatusUpdate();
                }
            } else if (this.isNpc()) {
                if (broadcastFull) {
                    Collection plrs = this.getKnownList().getKnownPlayers().values();
                    for (L2PcInstance player : plrs) {
                        if (player == null) continue;
                        if (this.getRunSpeed() == 0) {
                            player.sendPacket(new ServerObjectInfo((L2Npc)this, player));
                            continue;
                        }
                        player.sendPacket(new AbstractNpcInfo.NpcInfo((L2Npc)this, player));
                    }
                } else if (su.hasAttributes()) {
                    this.broadcastPacket(su);
                }
            } else if (su.hasAttributes()) {
                this.broadcastPacket(su);
            }
        }
    }

    public final int getXdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._xDestination;
        }
        return this.getX();
    }

    public final int getYdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._yDestination;
        }
        return this.getY();
    }

    public final int getZdestination() {
        MoveData m = this._move;
        if (m != null) {
            return m._zDestination;
        }
        return this.getZ();
    }

    public boolean isInCombat() {
        return this.hasAI() && (this.getAI().getAttackTarget() != null || this.getAI().isAutoAttacking());
    }

    public final boolean isMoving() {
        return this._move != null;
    }

    public final boolean isOnGeodataPath() {
        MoveData m = this._move;
        if (m == null) {
            return false;
        }
        if (m.onGeodataPathIndex == -1) {
            return false;
        }
        return m.onGeodataPathIndex != m.geoPath.size() - 1;
    }

    public final boolean isCastingNow() {
        return this._isCastingNow;
    }

    public void setIsCastingNow(boolean value) {
        this._isCastingNow = value;
    }

    public final boolean isCastingSimultaneouslyNow() {
        return this._isCastingSimultaneouslyNow;
    }

    public void setIsCastingSimultaneouslyNow(boolean value) {
        this._isCastingSimultaneouslyNow = value;
    }

    public final boolean canAbortCast() {
        return this._castInterruptTime > GameTimeController.getInstance().getGameTicks();
    }

    public int getCastInterruptTime() {
        return this._castInterruptTime;
    }

    public boolean isAttackingNow() {
        return this._attackEndTime > GameTimeController.getInstance().getGameTicks();
    }

    public final void abortAttack() {
        if (this.isAttackingNow()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public final void abortCast() {
        if (this.isCastingNow() || this.isCastingSimultaneouslyNow()) {
            Future<?> future = this._skillCast;
            if (future != null) {
                future.cancel(true);
                this._skillCast = null;
            }
            if ((future = this._skillCast2) != null) {
                future.cancel(true);
                this._skillCast2 = null;
            }
            if (this.isChanneling()) {
                this.getSkillChannelizer().stopChanneling();
            }
            if (this._allSkillsDisabled) {
                this.enableAllSkills();
            }
            this.setIsCastingNow(false);
            this.setIsCastingSimultaneouslyNow(false);
            this._castInterruptTime = 0;
            if (this.isPlayer()) {
                this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
            }
            this.broadcastPacket(new MagicSkillCanceld(this.getObjectId()));
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public boolean updatePosition(int gameTicks) {
        double dz;
        boolean isFloating;
        double dy;
        double dx;
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        if (!this.isVisible()) {
            this._move = null;
            return true;
        }
        if (m._moveTimestamp == 0) {
            m._moveTimestamp = m._moveStartTime;
            m._xAccurate = this.getX();
            m._yAccurate = this.getY();
        }
        if (m._moveTimestamp == gameTicks) {
            return false;
        }
        int xPrev = this.getX();
        int yPrev = this.getY();
        int zPrev = this.getZ();
        if (Config.COORD_SYNCHRONIZE == 1) {
            dx = m._xDestination - xPrev;
            dy = m._yDestination - yPrev;
        } else {
            dx = (double)m._xDestination - m._xAccurate;
            dy = (double)m._yDestination - m._yAccurate;
        }
        boolean bl = isFloating = this.isFlying() || this.isInsideZone(ZoneId.WATER);
        if (Config.GEODATA > 0 && Config.COORD_SYNCHRONIZE == 2 && !isFloating && !m.disregardingGeodata && GameTimeController.getInstance().getGameTicks() % 10 == 0 && GeoData.getInstance().hasGeo(xPrev, yPrev)) {
            int geoHeight = GeoData.getInstance().getSpawnHeight(xPrev, yPrev, zPrev - 30, zPrev + 30);
            dz = m._zDestination - geoHeight;
            if (this.isPlayer() && Math.abs(this.getActingPlayer().getClientZ() - geoHeight) > 200 && Math.abs(this.getActingPlayer().getClientZ() - geoHeight) < 1500) {
                dz = m._zDestination - zPrev;
            } else if (this.isInCombat() && Math.abs(dz) > 200.0 && dx * dx + dy * dy < 40000.0) {
                dz = m._zDestination - zPrev;
            } else {
                zPrev = geoHeight;
            }
        } else {
            dz = m._zDestination - zPrev;
        }
        double delta = dx * dx + dy * dy;
        delta = delta < 10000.0 && dz * dz > 2500.0 && !isFloating ? Math.sqrt(delta) : Math.sqrt(delta + dz * dz);
        double distFraction = Double.MAX_VALUE;
        if (delta > 1.0) {
            double distPassed = this.getStat().getMoveSpeed() * (float)(gameTicks - m._moveTimestamp) / 10.0f;
            distFraction = distPassed / delta;
        }
        if (distFraction > 1.0) {
            super.setXYZ(m._xDestination, m._yDestination, m._zDestination);
        } else {
            m._xAccurate += dx * distFraction;
            m._yAccurate += dy * distFraction;
            super.setXYZ((int)m._xAccurate, (int)m._yAccurate, zPrev + (int)(dz * distFraction + 0.5));
        }
        this.revalidateZone(false);
        m._moveTimestamp = gameTicks;
        return distFraction > 1.0;
    }

    public void revalidateZone(boolean force) {
        if (this.getWorldRegion() == null) {
            return;
        }
        if (force) {
            this._zoneValidateCounter = (byte)4;
        } else {
            this._zoneValidateCounter = (byte)(this._zoneValidateCounter - 1);
            if (this._zoneValidateCounter < 0) {
                this._zoneValidateCounter = (byte)4;
            } else {
                return;
            }
        }
        this.getWorldRegion().revalidateZones(this);
    }

    public void stopMove(Location loc) {
        this.stopMove(loc, false);
    }

    public void stopMove(Location loc, boolean updateKnownObjects) {
        this._move = null;
        if (loc != null) {
            this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
            this.setHeading(loc.getHeading());
            this.revalidateZone(true);
        }
        this.broadcastPacket(new StopMove(this));
        if (Config.MOVE_BASED_KNOWNLIST && updateKnownObjects) {
            this.getKnownList().findObjects();
        }
    }

    public boolean isShowSummonAnimation() {
        return this._showSummonAnimation;
    }

    public void setShowSummonAnimation(boolean showSummonAnimation) {
        this._showSummonAnimation = showSummonAnimation;
    }

    public void setTarget(L2Object object) {
        if (object != null && !object.isVisible()) {
            object = null;
        }
        if (object != null && object != this._target) {
            this.getKnownList().addKnownObject(object);
            object.getKnownList().addKnownObject(this);
        }
        this._target = object;
    }

    public final int getTargetId() {
        if (this._target != null) {
            return this._target.getObjectId();
        }
        return 0;
    }

    public final L2Object getTarget() {
        return this._target;
    }

    protected void moveToLocation(int x, int y, int z, int offset) {
        double cos;
        double sin;
        boolean verticalMovementOnly;
        float speed = this.getStat().getMoveSpeed();
        if (speed <= 0.0f || this.isMovementDisabled()) {
            return;
        }
        int curX = super.getX();
        int curY = super.getY();
        int curZ = super.getZ();
        double dx = x - curX;
        double dy = y - curY;
        double dz = z - curZ;
        double distance = Math.sqrt(dx * dx + dy * dy);
        boolean bl = verticalMovementOnly = this.isFlying() && distance == 0.0 && dz != 0.0;
        if (verticalMovementOnly) {
            distance = Math.abs(dz);
        }
        if (Config.GEODATA > 0 && this.isInsideZone(ZoneId.WATER) && distance > 700.0) {
            double divider = 700.0 / distance;
            x = curX + (int)(divider * dx);
            y = curY + (int)(divider * dy);
            z = curZ + (int)(divider * dz);
            dx = x - curX;
            dy = y - curY;
            dz = z - curZ;
            distance = Math.sqrt(dx * dx + dy * dy);
        }
        if (offset > 0 || distance < 1.0) {
            if ((offset = (int)((double)offset - Math.abs(dz))) < 5) {
                offset = 5;
            }
            if (distance < 1.0 || distance - (double)offset <= 0.0) {
                this.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
                return;
            }
            sin = dy / distance;
            cos = dx / distance;
            x = curX + (int)((distance -= (double)(offset - 5)) * cos);
            y = curY + (int)(distance * sin);
        } else {
            sin = dy / distance;
            cos = dx / distance;
        }
        MoveData m = new MoveData();
        m.onGeodataPathIndex = -1;
        m.disregardingGeodata = false;
        if (!(Config.GEODATA <= 0 || this.isFlying() || this.isInsideZone(ZoneId.WATER) && !this.isInsideZone(ZoneId.SIEGE))) {
            boolean isInVehicle;
            boolean bl2 = isInVehicle = this.isPlayer() && this.getActingPlayer().getVehicle() != null;
            if (isInVehicle) {
                m.disregardingGeodata = true;
            }
            double originalDistance = distance;
            int originalX = x;
            int originalY = y;
            int originalZ = z;
            int gtx = originalX - L2World.MAP_MIN_X >> 4;
            int gty = originalY - L2World.MAP_MIN_Y >> 4;
            if (Config.GEODATA == 2 && (!this.isAttackable() || !((L2Attackable)this).isReturningToSpawnPoint()) || this.isPlayer() && (!isInVehicle || !(distance > 1500.0)) || this.isSummon() && this.getAI().getIntention() != CtrlIntention.AI_INTENTION_FOLLOW || this.isAfraid() || this instanceof L2RiftInvaderInstance) {
                if (this.isOnGeodataPath()) {
                    try {
                        if (gtx == this._move.geoPathGtx && gty == this._move.geoPathGty) {
                            return;
                        }
                        this._move.onGeodataPathIndex = -1;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                if (curX < L2World.MAP_MIN_X || curX > L2World.MAP_MAX_X || curY < L2World.MAP_MIN_Y || curY > L2World.MAP_MAX_Y) {
                    _log.warning("Character " + this.getName() + " outside world area, in coordinates x:" + curX + " y:" + curY);
                    this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    if (this.isPlayer()) {
                        this.getActingPlayer().logout();
                    } else {
                        if (this.isSummon()) {
                            return;
                        }
                        this.onDecay();
                    }
                    return;
                }
                Location destiny = GeoData.getInstance().moveCheck(curX, curY, curZ, x, y, z, this.getInstanceId());
                x = destiny.getX();
                y = destiny.getY();
                z = destiny.getZ();
                dx = x - curX;
                dy = y - curY;
                dz = z - curZ;
                double d = distance = verticalMovementOnly ? Math.abs(dz * dz) : Math.sqrt(dx * dx + dy * dy);
            }
            if (Config.GEODATA == 2 && originalDistance - distance > 30.0 && distance < 2000.0 && !this.isAfraid() && (this.isPlayable() && !isInVehicle || this.isMinion() || this.isInCombat())) {
                m.geoPath = PathFinding.getInstance().findPath(curX, curY, curZ, originalX, originalY, originalZ, this.getInstanceId(), this.isPlayable());
                if (m.geoPath == null || m.geoPath.size() < 2) {
                    if (this.isPlayer() || !this.isPlayable() && !this.isMinion() && Math.abs(z - curZ) > 140 || this.isSummon() && !((L2Summon)this).getFollowStatus()) {
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    m.disregardingGeodata = true;
                    x = originalX;
                    y = originalY;
                    z = originalZ;
                    distance = originalDistance;
                } else {
                    m.onGeodataPathIndex = 0;
                    m.geoPathGtx = gtx;
                    m.geoPathGty = gty;
                    m.geoPathAccurateTx = originalX;
                    m.geoPathAccurateTy = originalY;
                    x = m.geoPath.get(m.onGeodataPathIndex).getX();
                    y = m.geoPath.get(m.onGeodataPathIndex).getY();
                    z = m.geoPath.get(m.onGeodataPathIndex).getZ();
                    if (DoorTable.getInstance().checkIfDoorsBetween(curX, curY, curZ, x, y, z, this.getInstanceId())) {
                        m.geoPath = null;
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    for (int i = 0; i < m.geoPath.size() - 1; ++i) {
                        if (!DoorTable.getInstance().checkIfDoorsBetween(m.geoPath.get(i), m.geoPath.get(i + 1), this.getInstanceId())) continue;
                        m.geoPath = null;
                        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    dx = x - curX;
                    dy = y - curY;
                    dz = z - curZ;
                    distance = verticalMovementOnly ? Math.abs(dz * dz) : Math.sqrt(dx * dx + dy * dy);
                    sin = dy / distance;
                    cos = dx / distance;
                }
            }
            if (distance < 1.0 && (Config.GEODATA == 2 || this.isPlayable() || this instanceof L2RiftInvaderInstance || this.isAfraid())) {
                if (this.isSummon()) {
                    ((L2Summon)this).setFollowStatus(false);
                }
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                return;
            }
        }
        if ((this.isFlying() || this.isInsideZone(ZoneId.WATER)) && !verticalMovementOnly) {
            distance = Math.sqrt(distance * distance + dz * dz);
        }
        int ticksToMove = 1 + (int)(10.0 * distance / (double)speed);
        m._xDestination = x;
        m._yDestination = y;
        m._zDestination = z;
        m._heading = 0;
        if (!verticalMovementOnly) {
            this.setHeading(Util.calculateHeadingFrom(cos, sin));
        }
        m._moveStartTime = GameTimeController.getInstance().getGameTicks();
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        if (ticksToMove * 100 > 3000) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
    }

    public boolean moveToNextRoutePoint() {
        if (!this.isOnGeodataPath()) {
            this._move = null;
            return false;
        }
        float speed = this.getStat().getMoveSpeed();
        if (speed <= 0.0f || this.isMovementDisabled()) {
            this._move = null;
            return false;
        }
        MoveData md = this._move;
        if (md == null) {
            return false;
        }
        MoveData m = new MoveData();
        m.onGeodataPathIndex = md.onGeodataPathIndex + 1;
        m.geoPath = md.geoPath;
        m.geoPathGtx = md.geoPathGtx;
        m.geoPathGty = md.geoPathGty;
        m.geoPathAccurateTx = md.geoPathAccurateTx;
        m.geoPathAccurateTy = md.geoPathAccurateTy;
        if (md.onGeodataPathIndex == md.geoPath.size() - 2) {
            m._xDestination = md.geoPathAccurateTx;
            m._yDestination = md.geoPathAccurateTy;
            m._zDestination = md.geoPath.get(m.onGeodataPathIndex).getZ();
        } else {
            m._xDestination = md.geoPath.get(m.onGeodataPathIndex).getX();
            m._yDestination = md.geoPath.get(m.onGeodataPathIndex).getY();
            m._zDestination = md.geoPath.get(m.onGeodataPathIndex).getZ();
        }
        double dx = m._xDestination - super.getX();
        double dy = m._yDestination - super.getY();
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance != 0.0) {
            this.setHeading(Util.calculateHeadingFrom(this.getX(), this.getY(), m._xDestination, m._yDestination));
        }
        int ticksToMove = 1 + (int)(10.0 * distance / (double)speed);
        m._heading = 0;
        m._moveStartTime = GameTimeController.getInstance().getGameTicks();
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
        if (ticksToMove * 100 > 3000) {
            ThreadPoolManager.getInstance().scheduleAi(new NotifyAITask(this, CtrlEvent.EVT_ARRIVED_REVALIDATE), 2000L);
        }
        MoveToLocation msg = new MoveToLocation(this);
        this.broadcastPacket(msg);
        return true;
    }

    public boolean validateMovementHeading(int heading) {
        MoveData m = this._move;
        if (m == null) {
            return true;
        }
        boolean result = true;
        if (m._heading != heading) {
            result = m._heading == 0;
            m._heading = heading;
        }
        return result;
    }

    @Deprecated
    public final double getDistance(int x, int y) {
        return this.calculateDistance(x, y, 0, false, false);
    }

    @Deprecated
    public final double getDistance(int x, int y, int z) {
        return this.calculateDistance(x, y, z, true, false);
    }

    public final double getDistanceSq(L2Object object) {
        return this.calculateDistance(object.getX(), object.getY(), object.getZ(), true, true);
    }

    public final double getDistanceSq(int x, int y, int z) {
        return this.calculateDistance(x, y, z, true, true);
    }

    public final double getPlanDistanceSq(L2Object object) {
        return this.calculateDistance(object.getX(), object.getY(), object.getZ(), false, true);
    }

    public final double getPlanDistanceSq(int x, int y) {
        return this.calculateDistance(x, y, 0, false, true);
    }

    public final boolean isInsideRadius(ILocational loc, int radius, boolean checkZAxis, boolean strictCheck) {
        return this.isInsideRadius(loc.getX(), loc.getY(), loc.getZ(), radius, checkZAxis, strictCheck);
    }

    public final boolean isInsideRadius(int x, int y, int z, int radius, boolean checkZAxis, boolean strictCheck) {
        double distance = this.calculateDistance(x, y, z, checkZAxis, true);
        return strictCheck ? distance < (double)(radius * radius) : distance <= (double)(radius * radius);
    }

    protected boolean checkAndEquipArrows() {
        return true;
    }

    protected boolean checkAndEquipBolts() {
        return true;
    }

    public void addExpAndSp(long addToExp, int addToSp) {
    }

    public abstract L2ItemInstance getActiveWeaponInstance();

    public abstract L2Weapon getActiveWeaponItem();

    public abstract L2ItemInstance getSecondaryWeaponInstance();

    public abstract L2Item getSecondaryWeaponItem();

    public void onHitTimer(L2Character target, int damage, boolean crit, boolean miss, boolean soulshot, byte shld) {
        L2Weapon activeWeapon;
        if (target == null || this.isAlikeDead() || this.isNpc() && ((L2Npc)this).isEventMob()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (this.isNpc() && target.isAlikeDead() || target.isDead() || !this.getKnownList().knowsObject(target) && !this.isDoor()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (miss) {
            if (target.hasAI()) {
                target.getAI().notifyEvent(CtrlEvent.EVT_EVADED, this);
            }
            if (target.getChanceSkills() != null) {
                target.getChanceSkills().onEvadedHit(this);
            }
        }
        this.sendDamageMessage(target, damage, false, crit, miss);
        if (target.isRaid() && target.giveRaidCurse() && !Config.RAID_DISABLE_CURSE && this.getLevel() > target.getLevel() + 8) {
            L2Skill skill = SkillTable.FrequentSkill.RAID_CURSE2.getSkill();
            if (skill != null) {
                this.abortAttack();
                this.abortCast();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                skill.applyEffects(target, this);
            } else {
                _log.warning("Skill 4515 at level 1 is missing in DP.");
            }
            damage = 0;
        }
        if (target.isPlayer()) {
            L2PcInstance enemy = target.getActingPlayer();
            enemy.getAI().clientStartAutoAttack();
        }
        if (!miss && damage > 0) {
            L2PcInstance owner;
            double reflectPercent;
            L2Weapon weapon = this.getActiveWeaponItem();
            boolean isBow = weapon != null && (weapon.getItemType() == L2WeaponType.BOW || weapon.getItemType() == L2WeaponType.CROSSBOW);
            int reflectedDamage = 0;
            if (!(isBow || target.isInvul() || target.isRaid() && this.getActingPlayer() != null && this.getActingPlayer().getLevel() > target.getLevel() + 8 || !((reflectPercent = target.getStat().calcStat(Stats.REFLECT_DAMAGE_PERCENT, 0.0, null, null)) > 0.0) || (reflectedDamage = (int)(reflectPercent / 100.0 * (double)damage)) <= target.getMaxHp())) {
                reflectedDamage = target.getMaxHp();
            }
            target.reduceCurrentHp(damage, this, null);
            target.notifyDamageReceived(damage, this, null, crit, false);
            if (reflectedDamage > 0) {
                this.reduceCurrentHp(reflectedDamage, target, true, false, null);
                this.notifyDamageReceived(reflectedDamage, target, null, crit, false);
            }
            if (!isBow) {
                int maxCanAbsorb;
                int absorbDamage;
                double absorbPercent = this.getStat().calcStat(Stats.ABSORB_DAMAGE_PERCENT, 0.0, null, null);
                if (absorbPercent > 0.0) {
                    absorbDamage = (int)(absorbPercent / 100.0 * (double)damage);
                    maxCanAbsorb = (int)((double)this.getMaxRecoverableHp() - this.getCurrentHp());
                    if (absorbDamage > maxCanAbsorb) {
                        absorbDamage = maxCanAbsorb;
                    }
                    if (absorbDamage > 0) {
                        this.setCurrentHp(this.getCurrentHp() + (double)absorbDamage);
                    }
                }
                if ((absorbPercent = this.getStat().calcStat(Stats.ABSORB_MANA_DAMAGE_PERCENT, 0.0, null, null)) > 0.0) {
                    absorbDamage = (int)(absorbPercent / 100.0 * (double)damage);
                    maxCanAbsorb = (int)((double)this.getMaxRecoverableMp() - this.getCurrentMp());
                    if (absorbDamage > maxCanAbsorb) {
                        absorbDamage = maxCanAbsorb;
                    }
                    if (absorbDamage > 0) {
                        this.setCurrentMp(this.getCurrentMp() + (double)absorbDamage);
                    }
                }
            }
            if (target.hasAI()) {
                target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
            }
            this.getAI().clientStartAutoAttack();
            if (this.isSummon() && (owner = ((L2Summon)this).getOwner()) != null) {
                owner.getAI().clientStartAutoAttack();
            }
            if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                target.breakAttack();
                target.breakCast();
            }
            if (this._chanceSkills != null) {
                this._chanceSkills.onHit(target, damage, false, crit);
                if (reflectedDamage > 0) {
                    this._chanceSkills.onHit(target, reflectedDamage, true, false);
                }
            }
            if (this._triggerSkills != null) {
                for (OptionsSkillHolder holder : this._triggerSkills.values()) {
                    if ((crit || holder.getSkillType() != OptionsSkillType.ATTACK) && (holder.getSkillType() != OptionsSkillType.CRITICAL || !crit) || !((double)Rnd.get(100) < holder.getChance())) continue;
                    this.makeTriggerCast(holder.getSkill(), target);
                }
            }
            if (target.getChanceSkills() != null) {
                target.getChanceSkills().onHit(this, damage, true, crit);
            }
        }
        if ((activeWeapon = this.getActiveWeaponItem()) != null) {
            activeWeapon.getSkillEffects(this, target, crit);
        }
    }

    public void breakAttack() {
        if (this.isAttackingNow()) {
            this.abortAttack();
            if (this.isPlayer()) {
                this.sendPacket(SystemMessageId.ATTACK_FAILED);
            }
        }
    }

    public void breakCast() {
        if (this.isCastingNow() && this.canAbortCast() && this.getLastSkillCast() != null && (this.getLastSkillCast().isMagic() || this.getLastSkillCast().isStatic())) {
            this.abortCast();
            if (this.isPlayer()) {
                this.sendPacket(SystemMessageId.CASTING_INTERRUPTED);
            }
        }
    }

    protected void reduceArrowCount(boolean bolts) {
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        if (this.isInsidePeaceZone(player)) {
            player.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInOlympiadMode() && player.getTarget() != null && player.getTarget().isPlayable()) {
            L2PcInstance target = null;
            L2Object object = player.getTarget();
            if (object != null && object.isPlayable()) {
                target = object.getActingPlayer();
            }
            if (target == null || target.isInOlympiadMode() && (!player.isOlympiadStart() || player.getOlympiadGameId() != target.getOlympiadGameId())) {
                player.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if (player.getTarget() != null && !player.getTarget().canBeAttacked() && !player.getAccessLevel().allowPeaceAttack()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isConfused()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!GeoData.getInstance().canSeeTarget((L2Object)player, this)) {
            player.sendPacket(SystemMessageId.CANT_SEE_TARGET);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.getBlockCheckerArena() != -1) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
    }

    public boolean isInsidePeaceZone(L2PcInstance attacker) {
        return this.isInsidePeaceZone(attacker, (L2Object)this);
    }

    public boolean isInsidePeaceZone(L2PcInstance attacker, L2Object target) {
        return !attacker.getAccessLevel().allowPeaceAttack() && this.isInsidePeaceZone((L2Object)attacker, target);
    }

    public boolean isInsidePeaceZone(L2Object attacker, L2Object target) {
        if (target == null) {
            return false;
        }
        if (!target.isPlayable() || !attacker.isPlayable()) {
            return false;
        }
        if (InstanceManager.getInstance().getInstance(this.getInstanceId()).isPvPInstance()) {
            return false;
        }
        if (TerritoryWarManager.PLAYER_WITH_WARD_CAN_BE_KILLED_IN_PEACEZONE && TerritoryWarManager.getInstance().isTWInProgress() && target.isPlayer() && target.getActingPlayer().isCombatFlagEquipped()) {
            return false;
        }
        if (Config.ALT_GAME_KARMA_PLAYER_CAN_BE_KILLED_IN_PEACEZONE) {
            if (target.getActingPlayer() != null && target.getActingPlayer().getKarma() > 0) {
                return false;
            }
            if (attacker.getActingPlayer() != null && attacker.getActingPlayer().getKarma() > 0 && target.getActingPlayer() != null && target.getActingPlayer().getPvpFlag() > 0) {
                return false;
            }
            if (attacker instanceof L2Character && target instanceof L2Character) {
                return target.isInsideZone(ZoneId.PEACE) || attacker.isInsideZone(ZoneId.PEACE);
            }
            if (attacker instanceof L2Character) {
                return TownManager.getTown(target.getX(), target.getY(), target.getZ()) != null || attacker.isInsideZone(ZoneId.PEACE);
            }
        }
        if (attacker instanceof L2Character && target instanceof L2Character) {
            return target.isInsideZone(ZoneId.PEACE) || attacker.isInsideZone(ZoneId.PEACE);
        }
        if (attacker instanceof L2Character) {
            return TownManager.getTown(target.getX(), target.getY(), target.getZ()) != null || attacker.isInsideZone(ZoneId.PEACE);
        }
        return TownManager.getTown(target.getX(), target.getY(), target.getZ()) != null || TownManager.getTown(attacker.getX(), attacker.getY(), attacker.getZ()) != null;
    }

    public boolean isInActiveRegion() {
        L2WorldRegion region = this.getWorldRegion();
        return region != null && region.isActive();
    }

    public boolean isInParty() {
        return false;
    }

    public L2Party getParty() {
        return null;
    }

    public int calculateTimeBetweenAttacks(L2Character target, L2Weapon weapon) {
        if (weapon != null && !this.isTransformed()) {
            switch (weapon.getItemType()) {
                case BOW: {
                    return 517500 / this.getPAtkSpd();
                }
                case CROSSBOW: {
                    return 414000 / this.getPAtkSpd();
                }
            }
        }
        return Formulas.calcPAtkSpd(this, target, this.getPAtkSpd());
    }

    public int calculateReuseTime(L2Character target, L2Weapon weapon) {
        if (weapon == null || this.isTransformed()) {
            return 0;
        }
        int reuse = weapon.getReuseDelay();
        if (reuse == 0) {
            return 0;
        }
        reuse = (int)((double)reuse * this.getStat().getWeaponReuseModifier(target));
        double atkSpd = this.getStat().getPAtkSpd();
        switch (weapon.getItemType()) {
            case BOW: 
            case CROSSBOW: {
                return (int)((double)(reuse * 345) / atkSpd);
            }
        }
        return (int)((double)(reuse * 312) / atkSpd);
    }

    @Override
    public L2Skill addSkill(L2Skill newSkill) {
        L2Skill oldSkill = null;
        if (newSkill != null) {
            oldSkill = this._skills.put(newSkill.getId(), newSkill);
            if (oldSkill != null) {
                if (oldSkill.triggerAnotherSkill()) {
                    this.removeSkill(oldSkill.getTriggeredId(), true);
                }
                this.removeStatsOwner(oldSkill);
            }
            this.addStatFuncs(newSkill.getStatFuncs(null, this));
            if (oldSkill != null && this._chanceSkills != null) {
                this.removeChanceSkill(oldSkill.getId());
            }
            if (newSkill.isChance()) {
                this.addChanceTrigger(newSkill);
            }
            if (newSkill.isPassive()) {
                newSkill.applyEffects(this, null, this, false, true, false, 0);
            }
        }
        return oldSkill;
    }

    public L2Skill removeSkill(L2Skill skill, boolean cancelEffect) {
        return skill != null ? this.removeSkill(skill.getId(), cancelEffect) : null;
    }

    public L2Skill removeSkill(int skillId) {
        return this.removeSkill(skillId, true);
    }

    public L2Skill removeSkill(int skillId, boolean cancelEffect) {
        L2Skill oldSkill = this._skills.remove(skillId);
        if (oldSkill != null) {
            if (oldSkill.triggerAnotherSkill() && oldSkill.getTriggeredId() > 0) {
                this.removeSkill(oldSkill.getTriggeredId(), true);
            }
            if (this.getLastSkillCast() != null && this.isCastingNow() && oldSkill.getId() == this.getLastSkillCast().getId()) {
                this.abortCast();
            }
            if (this.getLastSimultaneousSkillCast() != null && this.isCastingSimultaneouslyNow() && oldSkill.getId() == this.getLastSimultaneousSkillCast().getId()) {
                this.abortCast();
            }
            if (cancelEffect || oldSkill.isToggle() || oldSkill.isPassive()) {
                this.removeStatsOwner(oldSkill);
                this.stopSkillEffects(true, oldSkill.getId());
            }
            if (this.isPlayer() && oldSkill instanceof L2SkillSummon && oldSkill.getId() == 710 && this.hasSummon() && this.getSummon().getId() == 14870) {
                this.getActingPlayer().getSummon().unSummon(this.getActingPlayer());
            }
            if (oldSkill.isChance() && this._chanceSkills != null) {
                this.removeChanceSkill(oldSkill.getId());
            }
        }
        return oldSkill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChanceSkill(int id) {
        if (this._chanceSkills == null) {
            return;
        }
        ChanceSkillList chanceSkillList = this._chanceSkills;
        synchronized (chanceSkillList) {
            for (IChanceSkillTrigger trigger : this._chanceSkills.keySet()) {
                if (!(trigger instanceof L2Skill) || ((L2Skill)trigger).getId() != id) continue;
                this._chanceSkills.remove(trigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChanceTrigger(IChanceSkillTrigger trigger) {
        if (this._chanceSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._chanceSkills == null) {
                    this._chanceSkills = new ChanceSkillList(this);
                }
            }
        }
        this._chanceSkills.put(trigger, trigger.getTriggeredChanceCondition());
    }

    public void removeChanceEffect(IChanceSkillTrigger effect) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.remove(effect);
    }

    public void onStartChanceEffect(byte element) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.onStart(element);
    }

    public void onActionTimeChanceEffect(byte element) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.onActionTime(element);
    }

    public void onExitChanceEffect(byte element) {
        if (this._chanceSkills == null) {
            return;
        }
        this._chanceSkills.onExit(element);
    }

    public final Collection<L2Skill> getAllSkills() {
        return this._skills.size() == 0 ? Collections.emptyList() : new ArrayList<L2Skill>(this._skills.values());
    }

    @Override
    public Map<Integer, L2Skill> getSkills() {
        return this._skills;
    }

    public ChanceSkillList getChanceSkills() {
        return this._chanceSkills;
    }

    @Override
    public int getSkillLevel(int skillId) {
        L2Skill skill = this.getKnownSkill(skillId);
        return skill == null ? -1 : skill.getLevel();
    }

    @Override
    public final L2Skill getKnownSkill(int skillId) {
        return this._skills.get(skillId);
    }

    public int getBuffCount() {
        return this._effectList.getBuffCount();
    }

    public int getDanceCount() {
        return this._effectList.getDanceCount();
    }

    public void onMagicLaunchedTimer(MagicUseTask mut) {
        L2Skill skill = mut.getSkill();
        L2Object[] targets = mut.getTargets();
        if (skill == null || targets == null) {
            this.abortCast();
            return;
        }
        if (targets.length == 0) {
            switch (skill.getTargetType()) {
                case AURA: 
                case AURA_CORPSE_MOB: 
                case FRONT_AURA: 
                case BEHIND_AURA: {
                    break;
                }
                default: {
                    this.abortCast();
                    return;
                }
            }
        }
        int escapeRange = 0;
        if (skill.getEffectRange() > escapeRange) {
            escapeRange = skill.getEffectRange();
        } else if (skill.getCastRange() < 0 && skill.getAffectRange() > 80) {
            escapeRange = skill.getAffectRange();
        }
        if (targets.length > 0 && escapeRange > 0) {
            int _skiprange = 0;
            int _skipgeo = 0;
            int _skippeace = 0;
            FastList targetList = new FastList(targets.length);
            for (L2Object target : targets) {
                if (!(target instanceof L2Character)) continue;
                if (!this.isInsideRadius(target.getX(), target.getY(), target.getZ(), escapeRange + this.getTemplate().getCollisionRadius(), true, false)) {
                    ++_skiprange;
                    continue;
                }
                if (escapeRange > 0 && Config.GEODATA > 0 && !GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
                    ++_skipgeo;
                    continue;
                }
                if (skill.isBad()) {
                    if (this.isPlayer()) {
                        if (((L2Character)target).isInsidePeaceZone(this.getActingPlayer())) {
                            ++_skippeace;
                            continue;
                        }
                    } else if (((L2Character)target).isInsidePeaceZone(this, target)) {
                        ++_skippeace;
                        continue;
                    }
                }
                targetList.add((L2Character)target);
            }
            if (targetList.isEmpty()) {
                if (this.isPlayer()) {
                    if (_skiprange > 0) {
                        this.sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
                    } else if (_skipgeo > 0) {
                        this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                    } else if (_skippeace > 0) {
                        this.sendPacket(SystemMessageId.A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE);
                    }
                }
                this.abortCast();
                return;
            }
            mut.setTargets(targetList.toArray(new L2Character[targetList.size()]));
        }
        if (mut.isSimultaneous() && !this.isCastingSimultaneouslyNow() || !mut.isSimultaneous() && !this.isCastingNow() || this.isAlikeDead() && !skill.isStatic()) {
            this.getAI().notifyEvent(CtrlEvent.EVT_CANCEL);
            return;
        }
        if (!skill.isChanneling()) {
            this.broadcastPacket(new MagicSkillLaunched(this, skill.getDisplayId(), skill.getDisplayLevel(), targets));
        }
        mut.setPhase(2);
        if (mut.getSkillTime() == 0) {
            this.onMagicHitTimer(mut);
        } else {
            this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, 400L);
        }
    }

    public void onMagicHitTimer(MagicUseTask mut) {
        L2Skill skill = mut.getSkill();
        L2Object[] targets = mut.getTargets();
        if (skill == null || targets == null) {
            this.abortCast();
            return;
        }
        try {
            L2ItemInstance weaponInst;
            for (L2Object tgt : targets) {
                if (tgt.isPlayable()) {
                    if (!this.isPlayer() || !tgt.isSummon()) continue;
                    ((L2Summon)tgt).updateAndBroadcastStatus(1);
                    continue;
                }
                if (!this.isPlayable() || !tgt.isAttackable()) continue;
                L2Character target = (L2Character)tgt;
                if (skill.getEffectPoint() > 0) {
                    ((L2Attackable)target).reduceHate(this, skill.getEffectPoint());
                    continue;
                }
                if (skill.getEffectPoint() >= 0) continue;
                ((L2Attackable)target).addDamageHate(this, 0, -skill.getEffectPoint());
            }
            StatusUpdate su = new StatusUpdate(this);
            boolean isSendStatus = false;
            double mpConsume = this.getStat().getMpConsume(skill);
            if (mpConsume > 0.0) {
                if (mpConsume > this.getCurrentMp()) {
                    this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
                    this.abortCast();
                    return;
                }
                this.getStatus().reduceMp(mpConsume);
                su.addAttribute(11, (int)this.getCurrentMp());
                isSendStatus = true;
            }
            if (skill.getHpConsume() > 0) {
                double consumeHp = skill.getHpConsume();
                if (consumeHp >= this.getCurrentHp()) {
                    this.sendPacket(SystemMessageId.NOT_ENOUGH_HP);
                    this.abortCast();
                    return;
                }
                this.getStatus().reduceHp(consumeHp, this, true);
                su.addAttribute(9, (int)this.getCurrentHp());
                isSendStatus = true;
            }
            if (isSendStatus) {
                this.sendPacket(su);
            }
            if (this.isPlayer()) {
                if (skill.getChargeConsume() > 0) {
                    this.getActingPlayer().decreaseCharges(skill.getChargeConsume());
                }
                if (skill.getMaxSoulConsumeCount() > 0 && !this.getActingPlayer().decreaseSouls(skill.getMaxSoulConsumeCount(), skill)) {
                    this.abortCast();
                    return;
                }
            }
            if (mut.getCount() > 0 && (weaponInst = this.getActiveWeaponInstance()) != null) {
                if (mut.getSkill().useSoulShot()) {
                    this.setChargedShot(ShotType.SOULSHOTS, true);
                } else if (mut.getSkill().useSpiritShot()) {
                    this.setChargedShot(ShotType.SPIRITSHOTS, true);
                }
            }
            this.callSkill(mut.getSkill(), mut.getTargets());
        }
        catch (NullPointerException e) {
            _log.log(Level.WARNING, "", e);
        }
        if (mut.getSkillTime() > 0) {
            mut.setCount(mut.getCount() + 1);
        }
        mut.setPhase(3);
        if (mut.getSkillTime() == 0) {
            this.onMagicFinalizer(mut);
        } else if (mut.isSimultaneous()) {
            this._skillCast2 = ThreadPoolManager.getInstance().scheduleEffect(mut, 0L);
        } else {
            this._skillCast = ThreadPoolManager.getInstance().scheduleEffect(mut, 0L);
        }
    }

    public void onMagicFinalizer(MagicUseTask mut) {
        L2Object target;
        if (mut.isSimultaneous()) {
            this._skillCast2 = null;
            this.setIsCastingSimultaneouslyNow(false);
            return;
        }
        this._skillCast = null;
        this._castInterruptTime = 0;
        this.setIsCastingNow(false);
        L2Skill skill = mut.getSkill();
        L2Object l2Object = target = mut.getTargets().length > 0 ? mut.getTargets()[0] : null;
        if (skill.nextActionIsAttack() && this.getTarget() instanceof L2Character && this.getTarget() != this && target != null && this.getTarget() == target && target.canBeAttacked() && (this.getAI() == null || this.getAI().getNextIntention() == null || this.getAI().getNextIntention().getCtrlIntention() != CtrlIntention.AI_INTENTION_MOVE_TO)) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
        if (skill.isBad()) {
            switch (skill.getSkillType()) {
                case UNLOCK: 
                case UNLOCK_SPECIAL: 
                case DELUXE_KEY_UNLOCK: {
                    break;
                }
                default: {
                    this.getAI().clientStartAutoAttack();
                }
            }
        }
        this.getAI().notifyEvent(CtrlEvent.EVT_FINISH_CASTING);
        this.notifyQuestEventSkillFinished(skill, target);
        if (this.isPlayer()) {
            L2PcInstance currPlayer = this.getActingPlayer();
            SkillUseHolder queuedSkill = currPlayer.getQueuedSkill();
            currPlayer.setCurrentSkill(null, false, false);
            if (queuedSkill != null) {
                currPlayer.setQueuedSkill(null, false, false);
                ThreadPoolManager.getInstance().executeTask(new QueuedMagicUseTask(currPlayer, queuedSkill.getSkill(), queuedSkill.isCtrlPressed(), queuedSkill.isShiftPressed()));
            }
        }
        if (this.isChanneling()) {
            this.getSkillChannelizer().stopChanneling();
        }
    }

    protected void notifyQuestEventSkillFinished(L2Skill skill, L2Object target) {
    }

    public void callSkill(L2Skill skill, L2Object[] targets) {
        try {
            L2Weapon activeWeapon = this.getActiveWeaponItem();
            if (skill.isToggle() && this.isAffectedBySkill(skill.getId())) {
                return;
            }
            for (L2Object trg : targets) {
                if (!(trg instanceof L2Character)) continue;
                L2Character target = (L2Character)trg;
                L2Character targetsAttackTarget = null;
                L2Character targetsCastTarget = null;
                if (target.hasAI()) {
                    targetsAttackTarget = target.getAI().getAttackTarget();
                    targetsCastTarget = target.getAI().getCastTarget();
                }
                if (!Config.RAID_DISABLE_CURSE && (target.isRaid() && target.giveRaidCurse() && this.getLevel() > target.getLevel() + 8 || !skill.isBad() && targetsAttackTarget != null && targetsAttackTarget.isRaid() && targetsAttackTarget.giveRaidCurse() && targetsAttackTarget.getAttackByList().contains(target) && this.getLevel() > targetsAttackTarget.getLevel() + 8 || !skill.isBad() && targetsCastTarget != null && targetsCastTarget.isRaid() && targetsCastTarget.giveRaidCurse() && targetsCastTarget.getAttackByList().contains(target) && this.getLevel() > targetsCastTarget.getLevel() + 8)) {
                    L2Skill tempSkill;
                    if (skill.isMagic()) {
                        tempSkill = SkillTable.FrequentSkill.RAID_CURSE.getSkill();
                        if (tempSkill != null) {
                            this.abortAttack();
                            this.abortCast();
                            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                            tempSkill.applyEffects(target, this);
                        } else if (_log.isLoggable(Level.WARNING)) {
                            _log.log(Level.WARNING, "Skill 4215 at level 1 is missing in DP.");
                        }
                    } else {
                        tempSkill = SkillTable.FrequentSkill.RAID_CURSE2.getSkill();
                        if (tempSkill != null) {
                            this.abortAttack();
                            this.abortCast();
                            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                            tempSkill.applyEffects(target, this);
                        } else if (_log.isLoggable(Level.WARNING)) {
                            _log.log(Level.WARNING, "Skill 4515 at level 1 is missing in DP.");
                        }
                    }
                    return;
                }
                if (skill.isOverhit() && target.isAttackable()) {
                    ((L2Attackable)target).overhitEnabled(true);
                }
                if (skill.isStatic()) continue;
                if (activeWeapon != null && !target.isDead() && activeWeapon.getSkillEffects(this, target, skill) && this.isPlayer()) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_BEEN_ACTIVATED);
                    sm.addSkillName(skill);
                    this.sendPacket(sm);
                }
                if (this._chanceSkills != null) {
                    this._chanceSkills.onSkillHit(target, skill, false);
                }
                if (target.getChanceSkills() != null) {
                    target.getChanceSkills().onSkillHit(this, skill, true);
                }
                if (this._triggerSkills == null) continue;
                for (OptionsSkillHolder holder : this._triggerSkills.values()) {
                    if ((!skill.isMagic() || holder.getSkillType() != OptionsSkillType.MAGIC) && (!skill.isPhysical() || holder.getSkillType() != OptionsSkillType.ATTACK) || !((double)Rnd.get(100) < holder.getChance())) continue;
                    this.makeTriggerCast(holder.getSkill(), target);
                }
            }
            ISkillHandler handler = SkillHandler.getInstance().getHandler(skill.getSkillType());
            if (handler != null) {
                handler.useSkill(this, skill, targets);
            } else {
                skill.useSkill(this, targets);
            }
            L2PcInstance player = this.getActingPlayer();
            if (player != null) {
                for (L2Object target : targets) {
                    if (!(target instanceof L2Character)) continue;
                    if (skill.getEffectPoint() <= 0) {
                        if (target.isPlayer() || target.isSummon() || target.isTrap()) {
                            if (!target.equals(this)) {
                                if (skill.getEffectPoint() != 0) {
                                    L2PcInstance owner;
                                    if (target.isPlayer()) {
                                        target.getActingPlayer().getAI().clientStartAutoAttack();
                                    } else if (target.isSummon() && ((L2Character)target).hasAI() && (owner = ((L2Summon)target).getOwner()) != null) {
                                        owner.getAI().clientStartAutoAttack();
                                    }
                                }
                                if (!(player.getSummon() == target || this.isTrap() || skill.getEffectPoint() == 0 && skill.getAffectRange() > 0)) {
                                    player.updatePvPStatus((L2Character)target);
                                }
                            }
                        } else if (target.isAttackable()) {
                            switch (skill.getId()) {
                                case 51: 
                                case 511: {
                                    break;
                                }
                                default: {
                                    ((L2Character)target).addAttackerToAttackByList(this);
                                }
                            }
                        }
                        if (!((L2Character)target).hasAI() || skill.hasEffectType(L2EffectType.HATE)) continue;
                        ((L2Character)target).getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
                        continue;
                    }
                    if (target.isPlayer()) {
                        if (target.equals(this) || target.equals(player) || target.getActingPlayer().getPvpFlag() <= 0 && target.getActingPlayer().getKarma() <= 0) continue;
                        player.updatePvPStatus();
                        continue;
                    }
                    if (!target.isAttackable()) continue;
                    player.updatePvPStatus();
                }
                Collection objs = player.getKnownList().getKnownObjects().values();
                for (L2Object spMob : objs) {
                    List<Quest> eventQuests;
                    L2Npc npcMob;
                    if (spMob == null || !spMob.isNpc() || !(npcMob = (L2Npc)spMob).isInsideRadius(player, 1000, true, true) || (eventQuests = npcMob.getTemplate().getEventQuests(QuestEventType.ON_SKILL_SEE)) == null) continue;
                    for (Quest quest : eventQuests) {
                        quest.notifySkillSee(npcMob, player, skill, targets, this.isSummon());
                    }
                }
            }
            if (skill.isBad() && !skill.hasEffectType(L2EffectType.HATE)) {
                for (L2Object target : targets) {
                    if (!(target instanceof L2Character) || !((L2Character)target).hasAI()) continue;
                    ((L2Character)target).getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": callSkill() failed.", e);
        }
    }

    public boolean isBehind(L2Object target) {
        double maxAngleDiff = 60.0;
        if (target == null) {
            return false;
        }
        if (target instanceof L2Character) {
            double angleTarget;
            L2Character target1 = (L2Character)target;
            double angleChar = Util.calculateAngleFrom(this, target1);
            double angleDiff = angleChar - (angleTarget = Util.convertHeadingToDegree(target1.getHeading()));
            if (angleDiff <= -360.0 + maxAngleDiff) {
                angleDiff += 360.0;
            }
            if (angleDiff >= 360.0 - maxAngleDiff) {
                angleDiff -= 360.0;
            }
            if (Math.abs(angleDiff) <= maxAngleDiff) {
                return true;
            }
        }
        return false;
    }

    public boolean isBehindTarget() {
        return this.isBehind(this.getTarget());
    }

    public boolean isInFrontOf(L2Character target) {
        double maxAngleDiff = 60.0;
        if (target == null) {
            return false;
        }
        double angleTarget = Util.calculateAngleFrom(target, this);
        double angleChar = Util.convertHeadingToDegree(target.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + maxAngleDiff) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - maxAngleDiff) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= maxAngleDiff;
    }

    public boolean isFacing(L2Object target, int maxAngle) {
        if (target == null) {
            return false;
        }
        double maxAngleDiff = (double)maxAngle / 2.0;
        double angleTarget = Util.calculateAngleFrom(this, target);
        double angleChar = Util.convertHeadingToDegree(this.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + maxAngleDiff) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - maxAngleDiff) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= maxAngleDiff;
    }

    public boolean isInFrontOfTarget() {
        L2Object target = this.getTarget();
        if (target instanceof L2Character) {
            return this.isInFrontOf((L2Character)target);
        }
        return false;
    }

    public double getLevelMod() {
        return (double)(this.getLevel() + 89) / 100.0;
    }

    public final void setSkillCast(Future<?> newSkillCast) {
        this._skillCast = newSkillCast;
    }

    public final void forceIsCasting(int newSkillCastEndTick) {
        this.setIsCastingNow(true);
        this._castInterruptTime = newSkillCastEndTick - 4;
    }

    public void updatePvPFlag(int value) {
    }

    public final double getRandomDamageMultiplier() {
        L2Weapon activeWeapon = this.getActiveWeaponItem();
        int random = activeWeapon != null ? activeWeapon.getRandomDamage() : 5 + (int)Math.sqrt(this.getLevel());
        return 1.0 + (double)Rnd.get(0 - random, random) / 100.0;
    }

    public int getAttackEndTime() {
        return this._attackEndTime;
    }

    public int getBowAttackEndTime() {
        return this._disableBowAttackEndTime;
    }

    public long getCastEndTimeLeftMilli() {
        int t;
        if (this.isCastingNow() && (t = this._castEndTime - GameTimeController.getInstance().getGameTicks()) > 0) {
            return (long)t * 100L;
        }
        return 0L;
    }

    public abstract int getLevel();

    public final double calcStat(Stats stat, double init, L2Character target, L2Skill skill) {
        return this.getStat().calcStat(stat, init, target, skill);
    }

    public int getAccuracy() {
        return this.getStat().getAccuracy();
    }

    public final float getAttackSpeedMultiplier() {
        return this.getStat().getAttackSpeedMultiplier();
    }

    public int getCON() {
        return this.getStat().getCON();
    }

    public int getDEX() {
        return this.getStat().getDEX();
    }

    public final double getCriticalDmg(L2Character target, double init) {
        return this.getStat().getCriticalDmg(target, init);
    }

    public int getCriticalHit(L2Character target, L2Skill skill) {
        return this.getStat().getCriticalHit(target, skill);
    }

    public int getEvasionRate(L2Character target) {
        return this.getStat().getEvasionRate(target);
    }

    public int getINT() {
        return this.getStat().getINT();
    }

    public final int getMagicalAttackRange(L2Skill skill) {
        return this.getStat().getMagicalAttackRange(skill);
    }

    public final int getMaxCp() {
        return this.getStat().getMaxCp();
    }

    public final int getMaxRecoverableCp() {
        return this.getStat().getMaxRecoverableCp();
    }

    public int getMAtk(L2Character target, L2Skill skill) {
        return this.getStat().getMAtk(target, skill);
    }

    public int getMAtkSpd() {
        return this.getStat().getMAtkSpd();
    }

    public int getMaxMp() {
        return this.getStat().getMaxMp();
    }

    public int getMaxRecoverableMp() {
        return this.getStat().getMaxRecoverableMp();
    }

    public int getMaxHp() {
        return this.getStat().getMaxHp();
    }

    public int getMaxRecoverableHp() {
        return this.getStat().getMaxRecoverableHp();
    }

    public final int getMCriticalHit(L2Character target, L2Skill skill) {
        return this.getStat().getMCriticalHit(target, skill);
    }

    public int getMDef(L2Character target, L2Skill skill) {
        return this.getStat().getMDef(target, skill);
    }

    public int getMEN() {
        return this.getStat().getMEN();
    }

    public double getMReuseRate(L2Skill skill) {
        return this.getStat().getMReuseRate(skill);
    }

    public float getMovementSpeedMultiplier() {
        return this.getStat().getMovementSpeedMultiplier();
    }

    public int getPAtk(L2Character target) {
        return this.getStat().getPAtk(target);
    }

    public int getPAtkSpd() {
        return this.getStat().getPAtkSpd();
    }

    public int getPDef(L2Character target) {
        return this.getStat().getPDef(target);
    }

    public final int getPhysicalAttackRange() {
        return this.getStat().getPhysicalAttackRange();
    }

    public int getRunSpeed() {
        return this.getStat().getRunSpeed();
    }

    public int getSwimRunSpeed() {
        return this.getStat().getSwimRunSpeed();
    }

    public final int getShldDef() {
        return this.getStat().getShldDef();
    }

    public int getSTR() {
        return this.getStat().getSTR();
    }

    public final int getWalkSpeed() {
        return this.getStat().getWalkSpeed();
    }

    public final int getSwimWalkSpeed() {
        return this.getStat().getSwimWalkSpeed();
    }

    public int getWIT() {
        return this.getStat().getWIT();
    }

    public void addStatusListener(L2Character object) {
        this.getStatus().addStatusListener(object);
    }

    public void reduceCurrentHp(double i, L2Character attacker, L2Skill skill) {
        this.reduceCurrentHp(i, attacker, true, false, skill);
    }

    public void reduceCurrentHpByDOT(double i, L2Character attacker, L2Skill skill) {
        this.reduceCurrentHp(i, attacker, !skill.isToggle(), true, skill);
    }

    public void reduceCurrentHp(double i, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion() && Config.L2JMOD_CHAMPION_HP != 0) {
            this.getStatus().reduceHp(i / (double)Config.L2JMOD_CHAMPION_HP, attacker, awake, isDOT, false);
        } else {
            this.getStatus().reduceHp(i, attacker, awake, isDOT, false);
        }
    }

    public void reduceCurrentMp(double i) {
        this.getStatus().reduceMp(i);
    }

    @Override
    public void removeStatusListener(L2Character object) {
        this.getStatus().removeStatusListener(object);
    }

    protected void stopHpMpRegeneration() {
        this.getStatus().stopHpMpRegeneration();
    }

    public final double getCurrentCp() {
        return this.getStatus().getCurrentCp();
    }

    public final void setCurrentCp(Double newCp) {
        this.setCurrentCp((double)newCp);
    }

    public final void setCurrentCp(double newCp) {
        this.getStatus().setCurrentCp(newCp);
    }

    public final double getCurrentHp() {
        return this.getStatus().getCurrentHp();
    }

    public final void setCurrentHp(double newHp) {
        this.getStatus().setCurrentHp(newHp);
    }

    public final void setCurrentHpMp(double newHp, double newMp) {
        this.getStatus().setCurrentHpMp(newHp, newMp);
    }

    public final double getCurrentMp() {
        return this.getStatus().getCurrentMp();
    }

    public final void setCurrentMp(Double newMp) {
        this.setCurrentMp((double)newMp);
    }

    public final void setCurrentMp(double newMp) {
        this.getStatus().setCurrentMp(newMp);
    }

    public int getMaxLoad() {
        if (this.isPlayer() || this.isPet()) {
            double baseLoad = Math.floor(BaseStats.CON.calcBonus(this) * 69000.0 * Config.ALT_WEIGHT_LIMIT);
            return (int)this.calcStat(Stats.WEIGHT_LIMIT, baseLoad, this, null);
        }
        return 0;
    }

    public int getBonusWeightPenalty() {
        if (this.isPlayer() || this.isPet()) {
            return (int)this.calcStat(Stats.WEIGHT_PENALTY, 1.0, this, null);
        }
        return 0;
    }

    public int getCurrentLoad() {
        if (this.isPlayer() || this.isPet()) {
            return this.getInventory().getTotalWeight();
        }
        return 0;
    }

    public boolean isChampion() {
        return false;
    }

    public int getMaxBuffCount() {
        int count = Config.BUFFS_MAX_AMOUNT;
        if (this.isAffectedBySkill(1405)) {
            BuffInfo info = this.getEffectList().getBuffInfoBySkillId(1405);
            for (AbstractEffect effect : info.getEffects()) {
                count += (int)effect.getValue();
            }
        }
        return count;
    }

    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
    }

    public byte getAttackElement() {
        return this.getStat().getAttackElement();
    }

    public int getAttackElementValue(byte attackAttribute) {
        return this.getStat().getAttackElementValue(attackAttribute);
    }

    public int getDefenseElementValue(byte defenseAttribute) {
        return this.getStat().getDefenseElementValue(defenseAttribute);
    }

    public final void startPhysicalAttackMuted() {
        this.abortAttack();
    }

    public void disableCoreAI(boolean val) {
        this._AIdisabled = val;
    }

    public boolean isCoreAIDisabled() {
        return this._AIdisabled;
    }

    public boolean giveRaidCurse() {
        return true;
    }

    public boolean isAffected(EffectFlag flag) {
        return this._effectList.isAffected(flag);
    }

    public void broadcastSocialAction(int id) {
        this.broadcastPacket(new SocialAction(this.getObjectId(), id));
    }

    public Team getTeam() {
        return this._team;
    }

    public void setTeam(Team team) {
        this._team = team;
    }

    public boolean canOverrideCond(PcCondOverride excs) {
        return false;
    }

    public void setLethalable(boolean val) {
        this._lethalable = val;
    }

    public boolean isLethalable() {
        return this._lethalable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, OptionsSkillHolder> getTriggerSkills() {
        if (this._triggerSkills == null) {
            L2Character l2Character = this;
            synchronized (l2Character) {
                if (this._triggerSkills == null) {
                    this._triggerSkills = new ConcurrentHashMap<Integer, OptionsSkillHolder>();
                }
            }
        }
        return this._triggerSkills;
    }

    public void addTriggerSkill(OptionsSkillHolder holder) {
        this.getTriggerSkills().put(holder.getSkillId(), holder);
    }

    public void removeTriggerSkill(OptionsSkillHolder holder) {
        this.getTriggerSkills().remove(holder.getSkillId());
    }

    public void makeTriggerCast(L2Skill skill, L2Character target, boolean ignoreTargetType) {
        try {
            if (skill.checkCondition(this, target, false)) {
                L2PcInstance player;
                L2Object[] l2ObjectArray;
                if (skill.triggersChanceSkill()) {
                    skill = SkillTable.getInstance().getInfo(skill.getTriggeredChanceId(), skill.getTriggeredChanceLevel());
                    if (skill == null || skill.getSkillType() == L2SkillType.NOTDONE) {
                        return;
                    }
                    if (!skill.checkCondition(this, target, false)) {
                        return;
                    }
                }
                if (this.isSkillDisabled(skill)) {
                    return;
                }
                if (skill.getReuseDelay() > 0) {
                    this.disableSkill(skill, skill.getReuseDelay());
                }
                if (!ignoreTargetType) {
                    l2ObjectArray = skill.getTargetList(this, false, target);
                } else {
                    L2Character[] l2CharacterArray = new L2Character[1];
                    l2ObjectArray = l2CharacterArray;
                    l2CharacterArray[0] = target;
                }
                L2Object[] targets = l2ObjectArray;
                if (targets.length == 0) {
                    return;
                }
                if (Config.ALT_VALIDATE_TRIGGER_SKILLS && this.isPlayable() && target != null && target.isPlayable() && !(player = this.getActingPlayer()).checkPvpSkill(target, skill, this.isSummon())) {
                    return;
                }
                this.broadcastPacket(new MagicSkillUse(this, target, skill.getDisplayId(), skill.getLevel(), 0, 0));
                this.broadcastPacket(new MagicSkillLaunched(this, skill.getDisplayId(), skill.getLevel(), targets));
                ISkillHandler handler = SkillHandler.getInstance().getHandler(skill.getSkillType());
                if (handler != null) {
                    handler.useSkill(this, skill, targets);
                } else {
                    skill.useSkill(this, targets);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public void makeTriggerCast(L2Skill skill, L2Character target) {
        this.makeTriggerCast(skill, target, false);
    }

    public boolean canRevive() {
        return true;
    }

    public void setCanRevive(boolean val) {
    }

    public boolean isSweepActive() {
        return false;
    }

    public boolean isOnEvent() {
        return false;
    }

    public int getClanId() {
        return 0;
    }

    public int getAllyId() {
        return 0;
    }

    public void notifyDamageReceived(double damage, L2Character attacker, L2Skill skill, boolean critical, boolean damageOverTime) {
        this.getEvents().onDamageReceived(damage, attacker, skill, critical, damageOverTime);
        attacker.getEvents().onDamageDealt(damage, this, skill, critical, damageOverTime);
    }

    public final L2WeaponType getAttackType() {
        TransformTemplate template;
        L2Weapon weapon = this.getActiveWeaponItem();
        if (weapon != null) {
            return weapon.getItemType();
        }
        if (this.isTransformed() && (template = this.getTransformation().getTemplate(this.getActingPlayer())) != null) {
            return template.getBaseAttackType();
        }
        return this.getTemplate().getBaseAttackType();
    }

    public boolean isInCategory(CategoryType type) {
        return false;
    }

    public L2Character getSummoner() {
        return this._summoner;
    }

    public void setSummoner(L2Character summoner) {
        this._summoner = summoner;
    }

    @Override
    public boolean isCharacter() {
        return true;
    }

    public final boolean isChanneling() {
        return this._channelizer != null && this._channelizer.isChanneling();
    }

    public final SkillChannelizer getSkillChannelizer() {
        if (this._channelizer == null) {
            this._channelizer = new SkillChannelizer(this);
        }
        return this._channelizer;
    }

    public final boolean isChannelized() {
        return this._channelized != null && !this._channelized.isChannelized();
    }

    public final SkillChannelized getSkillChannelized() {
        if (this._channelized == null) {
            this._channelized = new SkillChannelized();
        }
        return this._channelized;
    }

    static {
        StatsSet set = new StatsSet();
        set.set("name", "Dummy");
        DUMMY_EFFECT = new DummyEffect(null, null, set, null);
        NPC_STD_CALCULATOR = Formulas.getStdNPCCalculators();
    }

    public static class MoveData {
        public int _moveStartTime;
        public int _moveTimestamp;
        public int _xDestination;
        public int _yDestination;
        public int _zDestination;
        public double _xAccurate;
        public double _yAccurate;
        public double _zAccurate;
        public int _heading;
        public boolean disregardingGeodata;
        public int onGeodataPathIndex;
        public List<AbstractNodeLoc> geoPath;
        public int geoPathAccurateTx;
        public int geoPathAccurateTy;
        public int geoPathGtx;
        public int geoPathGty;
    }

    public class AIAccessor {
        public L2Character getActor() {
            return L2Character.this;
        }

        public void moveTo(int x, int y, int z, int offset) {
            L2Character.this.moveToLocation(x, y, z, offset);
        }

        public void moveTo(int x, int y, int z) {
            L2Character.this.moveToLocation(x, y, z, 0);
        }

        public void stopMove(Location loc) {
            L2Character.this.stopMove(loc);
        }

        public void doAttack(L2Character target) {
            L2Character.this.doAttack(target);
        }

        public void doCast(L2Skill skill) {
            L2Character.this.doCast(skill);
        }

        public NotifyAITask newNotifyTask(CtrlEvent evt) {
            return new NotifyAITask(this.getActor(), evt);
        }

        public void detachAI() {
            if (L2Character.this.isWalker()) {
                return;
            }
            L2Character.this.setAI(null);
        }
    }

    private static final class DummyEffect
    extends AbstractEffect {
        protected DummyEffect(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params) {
            super(attachCond, applyCond, set, params);
        }
    }
}

