/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public final class L2BabyPetInstance
extends L2PetInstance {
    private static final int BUFF_CONTROL = 5771;
    private static final int AWAKENING = 5753;
    protected List<SkillHolder> _buffs = null;
    protected SkillHolder _majorHeal = null;
    protected SkillHolder _minorHeal = null;
    protected SkillHolder _recharge = null;
    private Future<?> _castTask;
    protected boolean _bufferMode = true;

    public L2BabyPetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        super(objectId, template, owner, control);
        this.setInstanceType(InstanceType.L2BabyPetInstance);
    }

    public L2BabyPetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control, byte level) {
        super(objectId, template, owner, control, level);
        this.setInstanceType(InstanceType.L2BabyPetInstance);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        double healPower = 0.0;
        for (L2PetData.L2PetSkillLearn psl : PetDataTable.getInstance().getPetData(this.getId()).getAvailableSkills()) {
            L2Skill skill;
            int id = psl.getSkillId();
            int lvl = PetDataTable.getInstance().getPetData(this.getId()).getAvailableLevel(id, this.getLevel());
            if (lvl == 0 || (skill = SkillTable.getInstance().getInfo(id, lvl)) == null || skill.getId() == 5771 || skill.getId() == 5753) continue;
            if (skill.hasEffectType(L2EffectType.MANAHEAL_BY_LEVEL)) {
                this._recharge = new SkillHolder(skill);
                continue;
            }
            if (skill.hasEffectType(L2EffectType.HEAL)) {
                if (healPower == 0.0) {
                    this._minorHeal = this._majorHeal = new SkillHolder(skill);
                    healPower = skill.getPower();
                    continue;
                }
                if (skill.getPower() > healPower) {
                    this._majorHeal = new SkillHolder(skill);
                    continue;
                }
                this._minorHeal = new SkillHolder(skill);
                continue;
            }
            if (!skill.isContinuous() || skill.isDebuff()) continue;
            if (this._buffs == null) {
                this._buffs = new ArrayList<SkillHolder>();
            }
            this._buffs.add(new SkillHolder(skill));
        }
        this.startCastTask();
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.stopCastTask();
        this.abortCast();
        return true;
    }

    @Override
    public synchronized void unSummon(L2PcInstance owner) {
        this.stopCastTask();
        this.abortCast();
        super.unSummon(owner);
    }

    @Override
    public void doRevive() {
        super.doRevive();
        this.startCastTask();
    }

    @Override
    public void onDecay() {
        super.onDecay();
        if (this._buffs != null) {
            this._buffs.clear();
        }
    }

    private final void startCastTask() {
        if (this._majorHeal != null || this._buffs != null || this._recharge != null && this._castTask == null && !this.isDead()) {
            this._castTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new CastTask(this), 3000L, 2000L);
        }
    }

    @Override
    public void switchMode() {
        this._bufferMode = !this._bufferMode;
    }

    public boolean isInSupportMode() {
        return this._bufferMode;
    }

    private final void stopCastTask() {
        if (this._castTask != null) {
            this._castTask.cancel(false);
            this._castTask = null;
        }
    }

    protected void castSkill(L2Skill skill) {
        boolean previousFollowStatus = this.getFollowStatus();
        if (!previousFollowStatus && !this.isInsideRadius(this.getOwner(), skill.getCastRange(), true, true)) {
            return;
        }
        this.setTarget(this.getOwner());
        this.useMagic(skill, false, false);
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.PET_USES_S1);
        msg.addSkillName(skill);
        this.sendPacket(msg);
        if (previousFollowStatus != this.getFollowStatus()) {
            this.setFollowStatus(previousFollowStatus);
        }
    }

    private class CastTask
    implements Runnable {
        private final L2BabyPetInstance _baby;
        private final List<L2Skill> _currentBuffs = new ArrayList<L2Skill>();

        public CastTask(L2BabyPetInstance baby) {
            this._baby = baby;
        }

        @Override
        public void run() {
            L2PcInstance owner = this._baby.getOwner();
            if (owner == null || owner.isDead() || owner.isInvul()) {
                return;
            }
            if (this._baby.isCastingNow() || this._baby.isBetrayed() || this._baby.isMuted() || this._baby.isOutOfControl() || !L2BabyPetInstance.this._bufferMode || this._baby.getAI().getIntention() == CtrlIntention.AI_INTENTION_CAST) {
                return;
            }
            L2Skill skill = null;
            if (L2BabyPetInstance.this._majorHeal != null) {
                double hpPercent = owner.getCurrentHp() / (double)owner.getMaxHp();
                boolean isImprovedBaby = PetDataTable.isUpgradeBabyPetGroup(L2BabyPetInstance.this.getId());
                if (isImprovedBaby && hpPercent < 0.3 || !isImprovedBaby && hpPercent < 0.15) {
                    skill = L2BabyPetInstance.this._majorHeal.getSkill();
                    if (!this._baby.isSkillDisabled(skill) && Rnd.get(100) <= 75 && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                        L2BabyPetInstance.this.castSkill(skill);
                        return;
                    }
                } else if (L2BabyPetInstance.this._majorHeal.getSkill() != L2BabyPetInstance.this._minorHeal.getSkill() && (isImprovedBaby && hpPercent < 0.7 || !isImprovedBaby && hpPercent < 0.8) && !this._baby.isSkillDisabled(skill = L2BabyPetInstance.this._minorHeal.getSkill()) && Rnd.get(100) <= 25 && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                    L2BabyPetInstance.this.castSkill(skill);
                    return;
                }
            }
            if (!this._baby.isAffectedBySkill(5771)) {
                if (L2BabyPetInstance.this._buffs != null && !L2BabyPetInstance.this._buffs.isEmpty()) {
                    for (SkillHolder buff : L2BabyPetInstance.this._buffs) {
                        BuffInfo buffInfo;
                        skill = buff.getSkill();
                        if (this._baby.isSkillDisabled(skill) || this._baby.getCurrentMp() < (double)skill.getMpConsume() || (buffInfo = owner.getEffectList().getBuffInfoByAbnormalType(skill.getAbnormalType())) != null && skill.getAbnormalLvl() <= buffInfo.getSkill().getAbnormalLvl()) continue;
                        this._currentBuffs.add(skill);
                    }
                }
                if (!this._currentBuffs.isEmpty()) {
                    skill = this._currentBuffs.get(Rnd.get(this._currentBuffs.size()));
                    L2BabyPetInstance.this.castSkill(skill);
                    this._currentBuffs.clear();
                    return;
                }
            }
            if (L2BabyPetInstance.this._recharge != null && owner.isInCombat() && owner.getCurrentMp() / (double)owner.getMaxMp() < 0.6 && Rnd.get(100) <= 60 && !this._baby.isSkillDisabled(skill = L2BabyPetInstance.this._recharge.getSkill()) && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                L2BabyPetInstance.this.castSkill(skill);
            }
        }
    }
}

