/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;

public class L2FortEnvoyInstance
extends L2Npc {
    public L2FortEnvoyInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(InstanceType.L2FortEnvoyInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        Fort fortress = this.getFort();
        String filePath = !player.isClanLeader() || fortress.getResidenceId() != player.getClan().getFortId() ? "data/html/fortress/ambassador-not-leader.htm" : (fortress.getFortState() == 1 ? "data/html/fortress/ambassador-rejected.htm" : (fortress.getFortState() == 2 ? "data/html/fortress/ambassador-signed.htm" : (fortress.isBorderFortress() ? "data/html/fortress/ambassador-border.htm" : "data/html/fortress/ambassador.htm")));
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filePath);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%castleName%", fortress.getCastleByAmbassador(this.getId()).getLocNameHtm());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("select ")) {
            String filePath;
            String param = command.substring(7);
            Fort fortress = this.getFort();
            Castle castle = fortress.getCastleByAmbassador(this.getId());
            if (castle.getOwnerId() == 0) {
                filePath = "data/html/fortress/ambassador-not-owned.htm";
            } else {
                int choice = Util.isDigit(param) ? Integer.parseInt(param) : 0;
                fortress.setFortState(choice, castle.getResidenceId());
                filePath = choice == 1 ? "data/html/fortress/ambassador-independent.htm" : "data/html/fortress/ambassador-signed.htm";
            }
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), filePath);
            html.replace((CharSequence)"%castleName%", castle.getLocNameHtm());
            player.sendPacket(html);
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

