/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.util.StringTokenizer;

public class L2FortLogisticsInstance
extends L2MerchantInstance {
    private static final int[] SUPPLY_BOX_IDS = new int[]{35665, 35697, 35734, 35766, 35803, 35834, 35866, 35903, 35935, 35973, 36010, 36042, 36080, 36117, 36148, 36180, 36218, 36256, 36293, 36325, 36363};

    public L2FortLogisticsInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(InstanceType.L2FortLogisticsInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (actualCommand.equalsIgnoreCase("rewards")) {
            if (this.isMyLord(player)) {
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-rewards.htm");
                html.replace((CharSequence)"%bloodoath%", player.getClan().getBloodOathCount());
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-noprivs.htm");
            }
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
        } else if (actualCommand.equalsIgnoreCase("blood")) {
            if (this.isMyLord(player)) {
                int blood = player.getClan().getBloodOathCount();
                if (blood > 0) {
                    player.addItem("Quest", 9910, blood, this, true);
                    player.getClan().resetBloodOathCount();
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-blood.htm");
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-noblood.htm");
                }
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-noprivs.htm");
            }
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
        } else if (actualCommand.equalsIgnoreCase("supplylvl")) {
            if (this.getFort().getFortState() == 2) {
                if (player.isClanLeader()) {
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-supplylvl.htm");
                    html.replace((CharSequence)"%supplylvl%", this.getFort().getSupplyLvL());
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-noprivs.htm");
                }
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-1.htm");
            }
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
        } else if (actualCommand.equalsIgnoreCase("supply")) {
            if (this.isMyLord(player)) {
                if (this.getFort().getSiege().getIsInProgress()) {
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-siege.htm");
                } else {
                    int level = this.getFort().getSupplyLvL();
                    if (level > 0) {
                        L2NpcTemplate BoxTemplate = NpcTable.getInstance().getTemplate(SUPPLY_BOX_IDS[level - 1]);
                        L2MonsterInstance box = new L2MonsterInstance(IdFactory.getInstance().getNextId(), BoxTemplate);
                        box.setCurrentHp(box.getMaxHp());
                        box.setCurrentMp(box.getMaxMp());
                        box.setHeading(0);
                        box.spawnMe(this.getX() - 23, this.getY() + 41, this.getZ());
                        this.getFort().setSupplyLvL(0);
                        this.getFort().saveFortVariables();
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-supply.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-nosupply.htm");
                    }
                }
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/logistics-noprivs.htm");
            }
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        this.showMessageWindow(player, 0);
    }

    private void showMessageWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = val == 0 ? "data/html/fortress/logistics.htm" : "data/html/fortress/logistics-" + val + ".htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getId());
        if (this.getFort().getOwnerClan() != null) {
            html.replace((CharSequence)"%clanname%", this.getFort().getOwnerClan().getName());
        } else {
            html.replace((CharSequence)"%clanname%", "NPC");
        }
        player.sendPacket(html);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/fortress/logistics", 0, val);
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }
}

