/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.GuardKnownList;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.logging.Logger;

public class L2GuardInstance
extends L2Attackable {
    private static Logger _log = Logger.getLogger(L2GuardInstance.class.getName());

    public L2GuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2GuardInstance);
    }

    @Override
    public final GuardKnownList getKnownList() {
        return (GuardKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new GuardKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker instanceof L2MonsterInstance;
    }

    @Override
    public void setAI(L2CharacterAI newAI) {
        super.setAI(newAI);
        if (newAI == null && !this.isWalker()) {
            this.home();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2GuardInstance l2GuardInstance = this;
            synchronized (l2GuardInstance) {
                if (this._ai == null) {
                    this._ai = new L2GuardAI(new L2Character.AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    protected boolean home() {
        assert (!this.isWalker());
        if (this.isDead() || !this.isVisible()) {
            return false;
        }
        if (!this.isInsideRadius(this.getSpawn(), 150, false, false)) {
            this.clearAggroList();
            this.setRunning();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this.getSpawn().getLocation());
            return false;
        }
        return true;
    }

    @Override
    public void returnHome() {
        if (this.home()) {
            if (this.getX() == this.getSpawn().getX() && this.getY() == this.getSpawn().getY() && this.getHeading() != this.getSpawn().getHeading()) {
                this.setHeading(this.getSpawn().getHeading());
                this.broadcastPacket(new ValidateLocation(this));
            }
            if (this.hasAI() && this.getAI().getIntention() != CtrlIntention.AI_INTENTION_IDLE) {
                if (this.getKnownList().getKnownPlayers().isEmpty()) {
                    super.setAI(null);
                } else if (this.getAggroList().isEmpty() && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_ACTIVE && !this.autoAttackCondition()) {
                    super.setAI(null);
                }
            }
        }
    }

    private boolean autoAttackCondition() {
        for (L2Object target : this.getKnownList().getKnownObjects().values()) {
            if (!(target instanceof L2PcInstance ? ((L2PcInstance)target).getKarma() > 0 : target instanceof L2MonsterInstance && Config.GUARD_ATTACK_AGGRO_MOB && ((L2MonsterInstance)target).isAggressive())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        super.onSpawn();
        L2WorldRegion region = L2World.getInstance().getRegion(this.getX(), this.getY());
        if (region != null && !region.isActive()) {
            ((L2AttackableAI)this.getAI()).stopAITask();
        }
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/guard/", npcId, val);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this.getObjectId() != player.getTargetId()) {
            player.setTarget(this);
        } else if (interact) {
            if (this.containsTarget(player)) {
                if (Config.DEBUG) {
                    _log.fine(player.getObjectId() + ": Attacked guard " + this.getObjectId());
                }
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else if (!this.canInteract(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            } else {
                this.broadcastPacket(new SocialAction(this.getObjectId(), Rnd.nextInt(8)));
                player.setLastFolkNPC(this);
                List<Quest> qlsa = this.getTemplate().getEventQuests(QuestEventType.QUEST_START);
                List<Quest> qlst = this.getTemplate().getEventQuests(QuestEventType.ON_FIRST_TALK);
                if (qlsa != null && !qlsa.isEmpty()) {
                    player.setLastQuestNpcObject(this.getObjectId());
                }
                if (qlst != null && qlst.size() == 1) {
                    qlst.get(0).notifyFirstTalk(this, player);
                } else {
                    this.showChatWindow(player, 0);
                }
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private static class L2GuardAI
    extends L2AttackableAI {
        public L2GuardAI(L2Character.AIAccessor accessor) {
            super(accessor);
        }

        @Override
        protected void onIntentionIdle() {
            super.onIntentionIdle();
            if (!this.getActor().isWalker()) {
                this.getActor().home();
            }
        }

        @Override
        public L2GuardInstance getActor() {
            return (L2GuardInstance)super.getActor();
        }
    }
}

