/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcBufferTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class L2NpcBufferInstance
extends L2Npc {
    private static final Logger _log = Logger.getLogger(L2NpcBufferInstance.class.getName());
    private static final Map<Integer, Integer> pageVal = new HashMap<Integer, Integer>();

    public L2NpcBufferInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2NpcBufferInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        if (player == null) {
            return;
        }
        String htmContent = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), val > 0 ? "data/html/mods/NpcBuffer-" + val + ".htm" : "data/html/mods/NpcBuffer.htm");
        if (htmContent != null) {
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
            npcHtmlMessage.setHtml(htmContent);
            npcHtmlMessage.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(npcHtmlMessage);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player == null || player.getLastFolkNPC() == null || player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        L2Playable target = player;
        if (command.startsWith("Pet")) {
            if (!player.hasSummon()) {
                player.sendPacket(SystemMessageId.DONT_HAVE_PET);
                this.showChatWindow(player, 0);
                return;
            }
            target = player.getSummon();
        }
        int npcId = this.getId();
        if (command.startsWith("Chat")) {
            int val = Integer.parseInt(command.substring(5));
            pageVal.put(player.getObjectId(), val);
            this.showChatWindow(player, val);
        } else if (command.startsWith("Buff") || command.startsWith("PetBuff")) {
            String[] buffGroupArray;
            for (String buffGroupList : buffGroupArray = command.substring(command.indexOf("Buff") + 5).split(" ")) {
                L2Skill skill;
                if (buffGroupList == null) {
                    _log.warning("NPC Buffer Warning: npcId = " + npcId + " has no buffGroup set in the bypass for the buff selected.");
                    return;
                }
                int buffGroup = Integer.parseInt(buffGroupList);
                NpcBufferTable.NpcBufferData npcBuffGroupInfo = NpcBufferTable.getInstance().getSkillInfo(npcId, buffGroup);
                if (npcBuffGroupInfo == null) {
                    _log.warning("NPC Buffer Warning: npcId = " + npcId + " Location: " + this.getX() + ", " + this.getY() + ", " + this.getZ() + " Player: " + player.getName() + " has tried to use skill group (" + buffGroup + ") not assigned to the NPC Buffer!");
                    return;
                }
                if (npcBuffGroupInfo.getFee().getId() != 0) {
                    L2ItemInstance itemInstance = player.getInventory().getItemByItemId(npcBuffGroupInfo.getFee().getId());
                    if (itemInstance == null || !itemInstance.isStackable() && player.getInventory().getInventoryItemCount(npcBuffGroupInfo.getFee().getId(), -1) < npcBuffGroupInfo.getFee().getCount()) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
                        player.sendPacket(sm);
                        continue;
                    }
                    if (itemInstance.isStackable()) {
                        if (npcBuffGroupInfo.getFee().getId() == 57) {
                            if (!player.reduceAdena("Npc Buffer", npcBuffGroupInfo.getFee().getCount(), player.getTarget(), true)) {
                                continue;
                            }
                        } else if (!player.destroyItemByItemId("Npc Buffer", npcBuffGroupInfo.getFee().getId(), npcBuffGroupInfo.getFee().getCount(), player.getTarget(), true)) {
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL);
                            player.sendPacket(sm);
                            continue;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < npcBuffGroupInfo.getFee().getCount()) {
                            player.destroyItemByItemId("Npc Buffer", npcBuffGroupInfo.getFee().getId(), 1L, player.getTarget(), true);
                            ++i;
                        }
                    }
                }
                if ((skill = SkillTable.getInstance().getInfo(npcBuffGroupInfo.getSkill().getSkillId(), npcBuffGroupInfo.getSkill().getSkillLvl())) == null) continue;
                skill.applyEffects(player, target);
            }
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else if (command.startsWith("Heal") || command.startsWith("PetHeal")) {
            if (!target.isInCombat() && !AttackStanceTaskManager.getInstance().hasAttackStanceTask(target)) {
                String[] healArray;
                for (String healType : healArray = command.substring(command.indexOf("Heal") + 5).split(" ")) {
                    if (healType.equalsIgnoreCase("HP")) {
                        target.setCurrentHp(target.getMaxHp());
                        continue;
                    }
                    if (healType.equalsIgnoreCase("MP")) {
                        target.setCurrentMp(target.getMaxMp());
                        continue;
                    }
                    if (!healType.equalsIgnoreCase("CP")) continue;
                    target.setCurrentCp(target.getMaxCp());
                }
            }
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else if (command.startsWith("RemoveBuffs") || command.startsWith("PetRemoveBuffs")) {
            target.stopAllEffectsExceptThoseThatLastThroughDeath();
            this.showChatWindow(player, pageVal.get(player.getObjectId()));
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

