/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.CharSummonTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SummonEffectsTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PetStat;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetInventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2PetInstance
extends L2Summon {
    protected static final Logger _logPet = Logger.getLogger(L2PetInstance.class.getName());
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_pet_skills_save (petObjItemId,skill_id,skill_level,remaining_time,buff_index) VALUES (?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT petObjItemId,skill_id,skill_level,remaining_time,buff_index FROM character_pet_skills_save WHERE petObjItemId=? ORDER BY buff_index ASC";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_pet_skills_save WHERE petObjItemId=?";
    private int _curFed;
    private final PetInventory _inventory;
    private final int _controlObjectId;
    private boolean _respawned;
    private final boolean _mountable;
    private Future<?> _feedTask;
    private L2PetData _data;
    private L2PetLevelData _leveldata;
    private long _expBeforeDeath = 0L;
    private int _curWeightPenalty = 0;
    private static final int PET_DECAY_DELAY = 86400000;

    public final L2PetLevelData getPetLevelData() {
        if (this._leveldata == null) {
            this._leveldata = PetDataTable.getInstance().getPetLevelData(this.getTemplate().getId(), this.getStat().getLevel());
        }
        return this._leveldata;
    }

    public final L2PetData getPetData() {
        if (this._data == null) {
            this._data = PetDataTable.getInstance().getPetData(this.getTemplate().getId());
        }
        return this._data;
    }

    public final void setPetData(L2PetLevelData value) {
        this._leveldata = value;
    }

    public static synchronized L2PetInstance spawnPet(L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        if (L2World.getInstance().getPet(owner.getObjectId()) != null) {
            return null;
        }
        L2PetData data = PetDataTable.getInstance().getPetData(template.getId());
        L2PetInstance pet = L2PetInstance.restore(control, template, owner);
        if (pet != null) {
            pet.setTitle(owner.getName());
            if (data.isSynchLevel() && pet.getLevel() != owner.getLevel()) {
                pet.getStat().setLevel((byte)owner.getLevel());
                pet.getStat().setExp(pet.getStat().getExpForLevel(owner.getLevel()));
            }
            L2World.getInstance().addPet(owner.getObjectId(), pet);
        }
        return pet;
    }

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        this(objectId, template, owner, control, (byte)(template.getIdTemplate() == 12564 ? owner.getLevel() : (int)template.getLevel()));
    }

    public L2PetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control, byte level) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2PetInstance);
        this._controlObjectId = control.getObjectId();
        this.getStat().setLevel((byte)Math.max(level, PetDataTable.getInstance().getPetMinLevel(template.getId())));
        this._inventory = new PetInventory(this);
        this._inventory.restore();
        int npcId = template.getId();
        this._mountable = PetDataTable.isMountable(npcId);
        this.getPetData();
        this.getPetLevelData();
    }

    @Override
    public PetStat getStat() {
        return (PetStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PetStat(this));
    }

    public boolean isRespawned() {
        return this._respawned;
    }

    @Override
    public int getSummonType() {
        return 2;
    }

    @Override
    public int getControlObjectId() {
        return this._controlObjectId;
    }

    public L2ItemInstance getControlItem() {
        return this.getOwner().getInventory().getItemByObjectId(this._controlObjectId);
    }

    public int getCurrentFed() {
        return this._curFed;
    }

    public void setCurrentFed(int num) {
        this._curFed = num > this.getMaxFed() ? this.getMaxFed() : num;
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        for (L2ItemInstance item : this.getInventory().getItems()) {
            if (item.getItemLocation() != ItemLocation.PET_EQUIP || item.getItem().getBodyPart() != 128) continue;
            return item;
        }
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return null;
        }
        return (L2Weapon)weapon.getItem();
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public PetInventory getInventory() {
        return this._inventory;
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.destroyItem(process, objectId, count, this.getOwner(), (Object)reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            }
            return false;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        petIU.addItem(item);
        this.sendPacket(petIU);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item.getId());
                sm.addItemNumber(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item.getId());
                this.sendPacket(sm);
            }
        }
        return true;
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.destroyItemByItemId(process, itemId, count, this.getOwner(), reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            }
            return false;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        petIU.addItem(item);
        this.sendPacket(petIU);
        if (sendMessage) {
            if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item.getId());
                sm.addItemNumber(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item.getId());
                this.sendPacket(sm);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPickupItem(L2Object object) {
        if (this.isDead()) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this.broadcastPacket(new StopMove(this));
        if (!(object instanceof L2ItemInstance)) {
            _logPet.warning(this + " trying to pickup wrong target." + object);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        boolean follow = this.getFollowStatus();
        L2ItemInstance target = (L2ItemInstance)object;
        if (CursedWeaponsManager.getInstance().isCursed(target.getId())) {
            SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
            smsg.addItemName(target.getId());
            this.sendPacket(smsg);
            return;
        }
        if (FortSiegeManager.getInstance().isCombat(target.getId())) {
            return;
        }
        SystemMessage smsg = null;
        L2ItemInstance l2ItemInstance = target;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!target.getDropProtection().tryPickUp(this)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
                return;
            }
            if ((this.isInParty() && this.getParty().getLootDistribution() == 0 || !this.isInParty()) && !this._inventory.validateCapacity(target)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS);
                return;
            }
            if (target.getOwnerId() != 0 && target.getOwnerId() != this.getOwner().getObjectId() && !this.getOwner().isInLooterParty(target.getOwnerId())) {
                if (target.getId() == 57) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1_ADENA);
                    smsg.addItemNumber(target.getCount());
                } else if (target.getCount() > 1L) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S2_S1_S);
                    smsg.addItemName(target);
                    smsg.addItemNumber(target.getCount());
                } else {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                    smsg.addItemName(target);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(smsg);
                return;
            }
            if (target.getItemLootShedule() != null && (target.getOwnerId() == this.getOwner().getObjectId() || this.getOwner().isInLooterParty(target.getOwnerId()))) {
                target.resetOwnerTimer();
            }
            target.pickupMe(this);
            if (Config.SAVE_DROPPED_ITEM) {
                ItemsOnGroundManager.getInstance().removeObject(target);
            }
        }
        if (target.getItem().hasExImmediateEffect()) {
            IItemHandler handler = ItemHandler.getInstance().getHandler(target.getEtcItem());
            if (handler == null) {
                _log.warning("No item handler registered for item ID: " + target.getId() + ".");
            } else {
                handler.useItem(this, target, false);
            }
            ItemTable.getInstance().destroyItem("Consume", target, this.getOwner(), null);
            this.broadcastStatusUpdate();
        } else {
            if (target.getId() == 57) {
                smsg = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1_ADENA);
                smsg.addItemNumber(target.getCount());
                this.sendPacket(smsg);
            } else if (target.getEnchantLevel() > 0) {
                smsg = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1_S2);
                smsg.addNumber(target.getEnchantLevel());
                smsg.addItemName(target);
                this.sendPacket(smsg);
            } else if (target.getCount() > 1L) {
                smsg = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S2_S1_S);
                smsg.addItemNumber(target.getCount());
                smsg.addItemName(target);
                this.sendPacket(smsg);
            } else {
                smsg = SystemMessage.getSystemMessage(SystemMessageId.PET_PICKED_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
            }
            if (this.getOwner().isInParty() && this.getOwner().getParty().getLootDistribution() != 0) {
                this.getOwner().getParty().distributeItem(this.getOwner(), target);
            } else {
                L2ItemInstance item = this.getInventory().addItem("Pickup", target, this.getOwner(), this);
                this.sendPacket(new PetInventoryUpdate(item));
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (follow) {
            this.followOwner();
        }
    }

    @Override
    public void deleteMe(L2PcInstance owner) {
        this.getInventory().transferItemsToOwner();
        super.deleteMe(owner);
        this.destroyControlItem(owner, false);
        CharSummonTable.getInstance().getPets().remove(this.getOwner().getObjectId());
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer, true)) {
            return false;
        }
        this.stopFeed();
        this.sendPacket(SystemMessageId.MAKE_SURE_YOU_RESSURECT_YOUR_PET_WITHIN_24_HOURS);
        DecayTaskManager.getInstance().addDecayTask(this, 86400000);
        L2PcInstance owner = this.getOwner();
        if (!(owner == null || owner.isInDuel() || this.isInsideZone(ZoneId.PVP) && !this.isInsideZone(ZoneId.SIEGE))) {
            this.deathPenalty();
        }
        return true;
    }

    @Override
    public void doRevive() {
        this.getOwner().removeReviving();
        super.doRevive();
        DecayTaskManager.getInstance().cancelDecayTask(this);
        this.startFeed();
        if (!this.isHungry()) {
            this.setRunning();
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
    }

    @Override
    public void doRevive(double revivePower) {
        this.restoreExp(revivePower);
        this.doRevive();
    }

    public L2ItemInstance transferItem(String process, int objectId, long count, Inventory target, L2PcInstance actor, L2Object reference) {
        L2ItemInstance oldItem = this.getInventory().getItemByObjectId(objectId);
        L2ItemInstance playerOldItem = target.getItemByItemId(oldItem.getId());
        L2ItemInstance newItem = this.getInventory().transferItem(process, objectId, count, target, actor, reference);
        if (newItem == null) {
            return null;
        }
        PetInventoryUpdate petIU = new PetInventoryUpdate();
        if (oldItem.getCount() > 0L && oldItem != newItem) {
            petIU.addModifiedItem(oldItem);
        } else {
            petIU.addRemovedItem(oldItem);
        }
        this.sendPacket(petIU);
        if (!newItem.isStackable()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addNewItem(newItem);
            this.sendPacket(iu);
        } else if (playerOldItem != null && newItem.isStackable()) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(newItem);
            this.sendPacket(iu);
        }
        return newItem;
    }

    public void destroyControlItem(L2PcInstance owner, boolean evolve) {
        L2World.getInstance().removePet(owner.getObjectId());
        try {
            L2ItemInstance removedItem;
            if (evolve) {
                removedItem = owner.getInventory().destroyItem("Evolve", this.getControlObjectId(), 1L, this.getOwner(), (Object)this);
            } else {
                removedItem = owner.getInventory().destroyItem("PetDestroy", this.getControlObjectId(), 1L, this.getOwner(), (Object)this);
                if (removedItem != null) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(removedItem);
                    owner.sendPacket(sm);
                }
            }
            if (removedItem == null) {
                _log.warning("Couldn't destroy pet control item for " + owner + " pet: " + this + " evolve: " + evolve);
            } else {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addRemovedItem(removedItem);
                owner.sendPacket(iu);
                StatusUpdate su = new StatusUpdate(owner);
                su.addAttribute(14, owner.getCurrentLoad());
                owner.sendPacket(su);
                owner.broadcastUserInfo();
                L2World.getInstance().removeObject(removedItem);
            }
        }
        catch (Exception e) {
            _logPet.log(Level.WARNING, "Error while destroying control item: " + e.getMessage(), e);
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id = ?");){
            statement.setInt(1, this.getControlObjectId());
            statement.execute();
        }
        catch (Exception e) {
            _logPet.log(Level.SEVERE, "Failed to delete Pet [ObjectId: " + this.getObjectId() + "]", e);
        }
    }

    public void dropAllItems() {
        try {
            for (L2ItemInstance item : this.getInventory().getItems()) {
                this.dropItemHere(item);
            }
        }
        catch (Exception e) {
            _logPet.log(Level.WARNING, "Pet Drop Error: " + e.getMessage(), e);
        }
    }

    public void dropItemHere(L2ItemInstance dropit, boolean protect) {
        dropit = this.getInventory().dropItem("Drop", dropit.getObjectId(), dropit.getCount(), this.getOwner(), this);
        if (dropit != null) {
            if (protect) {
                dropit.getDropProtection().protect(this.getOwner());
            }
            _logPet.finer("Item id to drop: " + dropit.getId() + " amount: " + dropit.getCount());
            dropit.dropMe(this, this.getX(), this.getY(), this.getZ() + 100);
        }
    }

    public void dropItemHere(L2ItemInstance dropit) {
        this.dropItemHere(dropit, false);
    }

    @Override
    public boolean isMountable() {
        return this._mountable;
    }

    /*
     * Exception decompiling
     */
    private static L2PetInstance restore(L2ItemInstance control, L2NpcTemplate template, L2PcInstance owner) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setRestoreSummon(boolean val) {
        this._restoreSummon = val;
    }

    @Override
    public final void stopSkillEffects(boolean removed, int skillId) {
        super.stopSkillEffects(removed, skillId);
        List effects = (List)SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId());
        if (effects != null && !effects.isEmpty()) {
            for (SummonEffectsTable.SummonEffect effect : effects) {
                if (effect.getSkill().getId() != skillId) continue;
                ((List)SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId())).remove(effect);
            }
        }
    }

    @Override
    public void storeMe() {
        if (this.getControlObjectId() == 0) {
            return;
        }
        if (!Config.RESTORE_PET_ON_RECONNECT) {
            this._restoreSummon = false;
        }
        String req = !this.isRespawned() ? "INSERT INTO pets (name,level,curHp,curMp,exp,sp,fed,ownerId,restore,item_obj_id) VALUES (?,?,?,?,?,?,?,?,?,?)" : "UPDATE pets SET name=?,level=?,curHp=?,curMp=?,exp=?,sp=?,fed=?,ownerId=?,restore=? WHERE item_obj_id = ?";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(req);){
            statement.setString(1, this.getName());
            statement.setInt(2, this.getStat().getLevel());
            statement.setDouble(3, this.getStatus().getCurrentHp());
            statement.setDouble(4, this.getStatus().getCurrentMp());
            statement.setLong(5, this.getStat().getExp());
            statement.setInt(6, this.getStat().getSp());
            statement.setInt(7, this.getCurrentFed());
            statement.setInt(8, this.getOwner().getObjectId());
            statement.setString(9, String.valueOf(this._restoreSummon));
            statement.setInt(10, this.getControlObjectId());
            statement.executeUpdate();
            this._respawned = true;
            if (this._restoreSummon) {
                CharSummonTable.getInstance().getPets().put(this.getOwner().getObjectId(), (Object)this.getControlObjectId());
            } else {
                CharSummonTable.getInstance().getPets().remove(this.getOwner().getObjectId());
            }
        }
        catch (Exception e) {
            _logPet.log(Level.SEVERE, "Failed to store Pet [ObjectId: " + this.getObjectId() + "] data", e);
        }
        L2ItemInstance itemInst = this.getControlItem();
        if (itemInst != null && itemInst.getEnchantLevel() != this.getStat().getLevel()) {
            itemInst.setEnchantLevel(this.getStat().getLevel());
            itemInst.updateDatabase();
        }
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        if (!Config.SUMMON_STORE_SKILL_COOLTIME) {
            return;
        }
        if (SummonEffectsTable.getInstance().getPetEffects().contains(this.getControlObjectId())) {
            ((List)SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId())).clear();
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement(DELETE_SKILL_SAVE);
             PreparedStatement ps2 = con.prepareStatement(ADD_SKILL_SAVE);){
            ps1.setInt(1, this.getControlObjectId());
            ps1.execute();
            int buff_index = 0;
            FastList storedSkills = new FastList();
            if (storeEffects) {
                for (BuffInfo info : this.getEffectList().getEffects()) {
                    L2Skill skill;
                    if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Config.ALT_STORE_DANCES || storedSkills.contains(skill.getReuseHashCode())) continue;
                    storedSkills.add(skill.getReuseHashCode());
                    ps2.setInt(1, this.getControlObjectId());
                    ps2.setInt(2, skill.getId());
                    ps2.setInt(3, skill.getLevel());
                    ps2.setInt(4, info.getTime());
                    ps2.setInt(5, ++buff_index);
                    ps2.execute();
                    if (!SummonEffectsTable.getInstance().getPetEffects().contains(this.getControlObjectId())) {
                        SummonEffectsTable.getInstance().getPetEffects().put(this.getControlObjectId(), (Object)new FastList());
                    }
                    List list = (List)SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId());
                    SummonEffectsTable summonEffectsTable = SummonEffectsTable.getInstance();
                    summonEffectsTable.getClass();
                    list.add(summonEffectsTable.new SummonEffectsTable.SummonEffect(skill, info.getTime()));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store pet effect data: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreEffects() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement(RESTORE_SKILL_SAVE);
             PreparedStatement ps2 = con.prepareStatement(DELETE_SKILL_SAVE);){
            if (!SummonEffectsTable.getInstance().getPetEffects().contains(this.getControlObjectId())) {
                ps1.setInt(1, this.getControlObjectId());
                try (ResultSet rset = ps1.executeQuery();){
                    while (rset.next()) {
                        int effectCurTime = rset.getInt("remaining_time");
                        L2Skill skill = SkillTable.getInstance().getInfo(rset.getInt("skill_id"), rset.getInt("skill_level"));
                        if (skill == null || !skill.hasEffects(EffectScope.GENERAL)) continue;
                        if (!SummonEffectsTable.getInstance().getPetEffects().contains(this.getControlObjectId())) {
                            SummonEffectsTable.getInstance().getPetEffects().put(this.getControlObjectId(), (Object)new FastList());
                        }
                        List list = (List)SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId());
                        SummonEffectsTable summonEffectsTable = SummonEffectsTable.getInstance();
                        summonEffectsTable.getClass();
                        list.add(summonEffectsTable.new SummonEffectsTable.SummonEffect(skill, effectCurTime));
                    }
                }
            }
            ps2.setInt(1, this.getControlObjectId());
            ps2.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore " + this + " active effect data: " + e.getMessage(), e);
        }
        finally {
            if (SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId()) == null) {
                return;
            }
            for (SummonEffectsTable.SummonEffect se : (List)SummonEffectsTable.getInstance().getPetEffects().get(this.getControlObjectId())) {
                if (se == null) continue;
                se.getSkill().applyEffects(this, this, false, se.getEffectCurTime());
            }
        }
    }

    public synchronized void stopFeed() {
        if (this._feedTask != null) {
            this._feedTask.cancel(false);
            this._feedTask = null;
        }
    }

    public synchronized void startFeed() {
        this.stopFeed();
        if (!this.isDead() && this.getOwner().getSummon() == this) {
            this._feedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FeedTask(), 10000L, 10000L);
        }
    }

    @Override
    public synchronized void unSummon(L2PcInstance owner) {
        this.stopFeed();
        this.stopHpMpRegeneration();
        super.unSummon(owner);
        if (!this.isDead()) {
            if (this.getInventory() != null) {
                this.getInventory().deleteMe();
            }
            L2World.getInstance().removePet(owner.getObjectId());
        }
    }

    public void restoreExp(double restorePercent) {
        if (this._expBeforeDeath > 0L) {
            this.getStat().addExp(Math.round((double)(this._expBeforeDeath - this.getStat().getExp()) * restorePercent / 100.0));
            this._expBeforeDeath = 0L;
        }
    }

    private void deathPenalty() {
        byte lvl = this.getStat().getLevel();
        double percentLost = -0.07 * (double)lvl + 6.5;
        long lostExp = Math.round((double)(this.getStat().getExpForLevel(lvl + 1) - this.getStat().getExpForLevel(lvl)) * percentLost / 100.0);
        this._expBeforeDeath = this.getStat().getExp();
        this.getStat().addExp(-lostExp);
    }

    @Override
    public void addExpAndSp(long addToExp, int addToSp) {
        if (this.getId() == 12564) {
            this.getStat().addExpAndSp(Math.round((float)addToExp * Config.SINEATER_XP_RATE), addToSp);
        } else {
            this.getStat().addExpAndSp(Math.round((float)addToExp * Config.PET_XP_RATE), addToSp);
        }
    }

    @Override
    public long getExpForThisLevel() {
        return this.getStat().getExpForLevel(this.getLevel());
    }

    @Override
    public long getExpForNextLevel() {
        return this.getStat().getExpForLevel(this.getLevel() + 1);
    }

    @Override
    public final int getLevel() {
        return this.getStat().getLevel();
    }

    public int getMaxFed() {
        return this.getStat().getMaxFeed();
    }

    @Override
    public int getCriticalHit(L2Character target, L2Skill skill) {
        return this.getStat().getCriticalHit(target, skill);
    }

    @Override
    public int getMAtk(L2Character target, L2Skill skill) {
        return this.getStat().getMAtk(target, skill);
    }

    @Override
    public int getMDef(L2Character target, L2Skill skill) {
        return this.getStat().getMDef(target, skill);
    }

    @Override
    public final int getSkillLevel(int skillId) {
        if (this.getKnownSkill(skillId) == null) {
            return -1;
        }
        int lvl = this.getLevel();
        return lvl > 70 ? 7 + (lvl - 70) / 5 : lvl / 10;
    }

    public void updateRefOwner(L2PcInstance owner) {
        int oldOwnerId = this.getOwner().getObjectId();
        this.setOwner(owner);
        L2World.getInstance().removePet(oldOwnerId);
        L2World.getInstance().addPet(oldOwnerId, this);
    }

    public int getInventoryLimit() {
        return Config.INVENTORY_MAXIMUM_PET;
    }

    public void refreshOverloaded() {
        long weightproc;
        int newWeightPenalty;
        int maxLoad = this.getMaxLoad();
        if (maxLoad > 0 && this._curWeightPenalty != (newWeightPenalty = (weightproc = (long)((this.getCurrentLoad() - this.getBonusWeightPenalty()) * 1000 / maxLoad)) < 500L || this.getOwner().getDietMode() ? 0 : (weightproc < 666L ? 1 : (weightproc < 800L ? 2 : (weightproc < 1000L ? 3 : 4))))) {
            this._curWeightPenalty = newWeightPenalty;
            if (newWeightPenalty > 0) {
                this.addSkill(SkillTable.getInstance().getInfo(4270, newWeightPenalty));
                this.setIsOverloaded(this.getCurrentLoad() >= maxLoad);
            } else {
                this.removeSkill(this.getKnownSkill(4270), true);
                this.setIsOverloaded(false);
            }
        }
    }

    @Override
    public void updateAndBroadcastStatus(int val) {
        this.refreshOverloaded();
        super.updateAndBroadcastStatus(val);
    }

    @Override
    public final boolean isHungry() {
        return (float)this.getCurrentFed() < (float)this.getPetData().getHungryLimit() / 100.0f * (float)this.getPetLevelData().getPetMaxFeed();
    }

    @Override
    public final int getWeapon() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(5);
        if (weapon != null) {
            return weapon.getId();
        }
        return 0;
    }

    @Override
    public final int getArmor() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(6);
        if (weapon != null) {
            return weapon.getId();
        }
        return 0;
    }

    public final int getJewel() {
        L2ItemInstance weapon = this.getInventory().getPaperdollItem(4);
        if (weapon != null) {
            return weapon.getId();
        }
        return 0;
    }

    @Override
    public short getSoulShotsPerHit() {
        return this.getPetLevelData().getPetSoulShot();
    }

    @Override
    public short getSpiritShotsPerHit() {
        return this.getPetLevelData().getPetSpiritShot();
    }

    @Override
    public void setName(String name) {
        L2ItemInstance controlItem = this.getControlItem();
        if (controlItem != null) {
            if (controlItem.getCustomType2() == (name == null ? 1 : 0)) {
                controlItem.setCustomType2(name != null ? 1 : 0);
                controlItem.updateDatabase();
                InventoryUpdate iu = new InventoryUpdate();
                iu.addModifiedItem(controlItem);
                this.sendPacket(iu);
            }
        } else {
            _log.log(Level.WARNING, "Pet control item null, for pet: " + this.toString());
        }
        super.setName(name);
    }

    public boolean canEatFoodId(int itemId) {
        return this._data.getFood().contains(itemId);
    }

    @Override
    public boolean isPet() {
        return true;
    }

    class FeedTask
    implements Runnable {
        FeedTask() {
        }

        @Override
        public void run() {
            try {
                if (L2PetInstance.this.getOwner() == null || !L2PetInstance.this.getOwner().hasSummon() || L2PetInstance.this.getOwner().getSummon().getObjectId() != L2PetInstance.this.getObjectId()) {
                    L2PetInstance.this.stopFeed();
                    return;
                }
                if (L2PetInstance.this.getCurrentFed() > this.getFeedConsume()) {
                    L2PetInstance.this.setCurrentFed(L2PetInstance.this.getCurrentFed() - this.getFeedConsume());
                } else {
                    L2PetInstance.this.setCurrentFed(0);
                }
                L2PetInstance.this.broadcastStatusUpdate();
                List<Integer> foodIds = L2PetInstance.this.getPetData().getFood();
                if (foodIds.isEmpty()) {
                    if (L2PetInstance.this.getCurrentFed() == 0) {
                        if (L2PetInstance.this.getTemplate().getId() == 16050 && L2PetInstance.this.getOwner() != null) {
                            L2PetInstance.this.getOwner().setPkKills(Math.max(0, L2PetInstance.this.getOwner().getPkKills() - Rnd.get(1, 6)));
                        }
                        L2PetInstance.this.sendPacket(SystemMessageId.THE_HELPER_PET_LEAVING);
                        L2PetInstance.this.deleteMe(L2PetInstance.this.getOwner());
                    } else if (L2PetInstance.this.isHungry()) {
                        L2PetInstance.this.sendPacket(SystemMessageId.THERE_NOT_MUCH_TIME_REMAINING_UNTIL_HELPER_LEAVES);
                    }
                    return;
                }
                L2ItemInstance food = null;
                for (int id : foodIds) {
                    food = L2PetInstance.this.getInventory().getItemByItemId(id);
                    if (food == null) continue;
                    break;
                }
                if (L2PetInstance.this.isRunning() && L2PetInstance.this.isHungry()) {
                    L2PetInstance.this.setWalking();
                } else if (!L2PetInstance.this.isHungry() && !L2PetInstance.this.isRunning()) {
                    L2PetInstance.this.setRunning();
                }
                if (food != null && L2PetInstance.this.isHungry()) {
                    IItemHandler handler = ItemHandler.getInstance().getHandler(food.getEtcItem());
                    if (handler != null) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY);
                        sm.addItemName(food.getId());
                        L2PetInstance.this.sendPacket(sm);
                        handler.useItem(L2PetInstance.this, food, false);
                    }
                } else if (L2PetInstance.this.getCurrentFed() == 0) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOUR_PET_IS_VERY_HUNGRY);
                    L2PetInstance.this.sendPacket(sm);
                }
            }
            catch (Exception e) {
                _logPet.log(Level.SEVERE, "Pet [ObjectId: " + L2PetInstance.this.getObjectId() + "] a feed task error has occurred", e);
            }
        }

        private int getFeedConsume() {
            if (L2PetInstance.this.isAttackingNow()) {
                return L2PetInstance.this.getPetLevelData().getPetFeedBattle();
            }
            return L2PetInstance.this.getPetLevelData().getPetFeedNormal();
        }
    }
}

