/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.CharSummonTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SummonEffectsTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.network.serverpackets.SetSummonRemainTime;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2ServitorInstance
extends L2Summon {
    protected static final Logger log = Logger.getLogger(L2ServitorInstance.class.getName());
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_summon_skills_save (ownerId,ownerClassIndex,summonSkillId,skill_id,skill_level,remaining_time,buff_index) VALUES (?,?,?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT skill_id,skill_level,remaining_time,buff_index FROM character_summon_skills_save WHERE ownerId=? AND ownerClassIndex=? AND summonSkillId=? ORDER BY buff_index ASC";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_summon_skills_save WHERE ownerId=? AND ownerClassIndex=? AND summonSkillId=?";
    private float _expPenalty = 0.0f;
    private int _itemConsumeId;
    private int _itemConsumeCount;
    private int _itemConsumeSteps;
    private final int _totalLifeTime;
    private final int _timeLostIdle;
    private final int _timeLostActive;
    private int _timeRemaining;
    private int _nextItemConsumeTime;
    public int lastShowntimeRemaining;
    protected Future<?> _summonLifeTask;
    private int _referenceSkill;
    private boolean _shareElementals = false;
    private double _sharedElementalsPercent = 1.0;

    public L2ServitorInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2Skill skill) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2ServitorInstance);
        this.setShowSummonAnimation(true);
        if (skill != null) {
            L2SkillSummon summonSkill = (L2SkillSummon)skill;
            this._itemConsumeId = summonSkill.getItemConsumeIdOT();
            this._itemConsumeCount = summonSkill.getItemConsumeOT();
            this._itemConsumeSteps = summonSkill.getItemConsumeSteps();
            this._totalLifeTime = summonSkill.getTotalLifeTime();
            this._timeLostIdle = summonSkill.getTimeLostIdle();
            this._timeLostActive = summonSkill.getTimeLostActive();
            this._referenceSkill = summonSkill.getId();
        } else {
            this._itemConsumeId = 0;
            this._itemConsumeCount = 0;
            this._itemConsumeSteps = 0;
            this._totalLifeTime = 1200000;
            this._timeLostIdle = 1000;
            this._timeLostActive = 1000;
        }
        this._timeRemaining = this._totalLifeTime;
        this.lastShowntimeRemaining = this._totalLifeTime;
        this._nextItemConsumeTime = this._itemConsumeId == 0 ? -1 : (this._itemConsumeSteps == 0 ? -1 : this._totalLifeTime - this._totalLifeTime / (this._itemConsumeSteps + 1));
        int delay = 1000;
        if (Config.DEBUG && this._itemConsumeCount != 0) {
            _log.warning(this.getClass().getSimpleName() + ": Item Consume ID: " + this._itemConsumeId + ", Count: " + this._itemConsumeCount + ", Rate: " + this._itemConsumeSteps + " times.");
        }
        if (Config.DEBUG) {
            _log.warning(this.getClass().getSimpleName() + ": Task Delay " + delay / 1000 + " seconds.");
        }
        this._summonLifeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new SummonLifetime(this.getOwner(), this), delay, delay);
    }

    @Override
    public final int getLevel() {
        return this.getTemplate() != null ? (int)this.getTemplate().getLevel() : 0;
    }

    @Override
    public int getSummonType() {
        return 1;
    }

    public void setExpPenalty(float expPenalty) {
        this._expPenalty = expPenalty;
    }

    public float getExpPenalty() {
        return this._expPenalty;
    }

    public void setSharedElementals(boolean val) {
        this._shareElementals = val;
    }

    public boolean isSharingElementals() {
        return this._shareElementals;
    }

    public void setSharedElementalsValue(double val) {
        this._sharedElementalsPercent = val;
    }

    public double sharedElementalsPercent() {
        return this._sharedElementalsPercent;
    }

    public int getItemConsumeCount() {
        return this._itemConsumeCount;
    }

    public int getItemConsumeId() {
        return this._itemConsumeId;
    }

    public int getItemConsumeSteps() {
        return this._itemConsumeSteps;
    }

    public int getNextItemConsumeTime() {
        return this._nextItemConsumeTime;
    }

    public int getTotalLifeTime() {
        return this._totalLifeTime;
    }

    public int getTimeLostIdle() {
        return this._timeLostIdle;
    }

    public int getTimeLostActive() {
        return this._timeLostActive;
    }

    public int getTimeRemaining() {
        return this._timeRemaining;
    }

    public void setNextItemConsumeTime(int value) {
        this._nextItemConsumeTime = value;
    }

    public void decNextItemConsumeTime(int value) {
        this._nextItemConsumeTime -= value;
    }

    public void decTimeRemaining(int value) {
        this._timeRemaining -= value;
    }

    public void addExpAndSp(int addToExp, int addToSp) {
        this.getOwner().addExpAndSp(addToExp, addToSp);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (Config.DEBUG) {
            _log.warning(this.getClass().getSimpleName() + ": " + this.getTemplate().getName() + " (" + this.getOwner().getName() + ") has been killed.");
        }
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(false);
            this._summonLifeTask = null;
        }
        CharSummonTable.getInstance().removeServitor(this.getOwner());
        return true;
    }

    @Override
    public void doCast(L2Skill skill) {
        L2Skill skillToCast;
        int petLevel = this.getLevel();
        int skillLevel = petLevel / 10;
        if (petLevel >= 70) {
            skillLevel += (petLevel - 65) / 10;
        }
        if (skillLevel < 1) {
            skillLevel = 1;
        }
        if ((skillToCast = SkillTable.getInstance().getInfo(skill.getId(), skillLevel)) != null) {
            super.doCast(skillToCast);
        } else {
            super.doCast(skill);
        }
    }

    @Override
    public void setRestoreSummon(boolean val) {
        this._restoreSummon = val;
    }

    @Override
    public final void stopSkillEffects(boolean removed, int skillId) {
        List effects;
        super.stopSkillEffects(removed, skillId);
        TIntObjectHashMap<List<SummonEffectsTable.SummonEffect>> servitorEffects = SummonEffectsTable.getInstance().getServitorEffects(this.getOwner());
        if (servitorEffects != null && (effects = (List)servitorEffects.get(this.getReferenceSkill())) != null && !effects.isEmpty()) {
            for (SummonEffectsTable.SummonEffect effect : effects) {
                L2Skill skill = effect.getSkill();
                if (skill == null || skill.getId() != skillId) continue;
                effects.remove(effect);
            }
        }
    }

    @Override
    public void storeMe() {
        if (this._referenceSkill == 0 || this.isDead()) {
            return;
        }
        if (Config.RESTORE_SERVITOR_ON_RECONNECT) {
            CharSummonTable.getInstance().saveSummon(this);
        }
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        block45: {
            if (!Config.SUMMON_STORE_SKILL_COOLTIME) {
                return;
            }
            if (this.getOwner().isInOlympiadMode()) {
                return;
            }
            if (SummonEffectsTable.getInstance().getServitorEffectsOwner().contains(this.getOwner().getObjectId()) && ((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).contains(this.getOwner().getClassIndex()) && SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).contains(this.getReferenceSkill())) {
                ((List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill())).clear();
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(DELETE_SKILL_SAVE);){
                statement.setInt(1, this.getOwner().getObjectId());
                statement.setInt(2, this.getOwner().getClassIndex());
                statement.setInt(3, this.getReferenceSkill());
                statement.execute();
                int buff_index = 0;
                FastList storedSkills = new FastList();
                if (!storeEffects) break block45;
                try (PreparedStatement ps2 = con.prepareStatement(ADD_SKILL_SAVE);){
                    for (BuffInfo info : this.getEffectList().getEffects()) {
                        L2Skill skill;
                        if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Config.ALT_STORE_DANCES || storedSkills.contains(skill.getReuseHashCode())) continue;
                        storedSkills.add(skill.getReuseHashCode());
                        ps2.setInt(1, this.getOwner().getObjectId());
                        ps2.setInt(2, this.getOwner().getClassIndex());
                        ps2.setInt(3, this.getReferenceSkill());
                        ps2.setInt(4, skill.getId());
                        ps2.setInt(5, skill.getLevel());
                        ps2.setInt(6, info.getTime());
                        ps2.setInt(7, ++buff_index);
                        ps2.execute();
                        if (!SummonEffectsTable.getInstance().getServitorEffectsOwner().contains(this.getOwner().getObjectId())) {
                            SummonEffectsTable.getInstance().getServitorEffectsOwner().put(this.getOwner().getObjectId(), (Object)new TIntObjectHashMap());
                        }
                        if (!((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).contains(this.getOwner().getClassIndex())) {
                            ((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).put(this.getOwner().getClassIndex(), (Object)new TIntObjectHashMap());
                        }
                        if (!SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).contains(this.getReferenceSkill())) {
                            SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).put(this.getReferenceSkill(), (Object)new FastList());
                        }
                        List list = (List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill());
                        SummonEffectsTable summonEffectsTable = SummonEffectsTable.getInstance();
                        summonEffectsTable.getClass();
                        list.add(summonEffectsTable.new SummonEffectsTable.SummonEffect(skill, info.getTime()));
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not store summon effect data: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreEffects() {
        if (this.getOwner().isInOlympiadMode()) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            Throwable throwable;
            PreparedStatement statement;
            if (!(SummonEffectsTable.getInstance().getServitorEffectsOwner().contains(this.getOwner().getObjectId()) && ((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).contains(this.getOwner().getClassIndex()) && SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).contains(this.getReferenceSkill()))) {
                statement = con.prepareStatement(RESTORE_SKILL_SAVE);
                throwable = null;
                try {
                    statement.setInt(1, this.getOwner().getObjectId());
                    statement.setInt(2, this.getOwner().getClassIndex());
                    statement.setInt(3, this.getReferenceSkill());
                    try (ResultSet rset = statement.executeQuery();){
                        while (rset.next()) {
                            int effectCurTime = rset.getInt("remaining_time");
                            L2Skill skill = SkillTable.getInstance().getInfo(rset.getInt("skill_id"), rset.getInt("skill_level"));
                            if (skill == null || !skill.hasEffects(EffectScope.GENERAL)) continue;
                            if (!SummonEffectsTable.getInstance().getServitorEffectsOwner().contains(this.getOwner().getObjectId())) {
                                SummonEffectsTable.getInstance().getServitorEffectsOwner().put(this.getOwner().getObjectId(), (Object)new TIntObjectHashMap());
                            }
                            if (!((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).contains(this.getOwner().getClassIndex())) {
                                ((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).put(this.getOwner().getClassIndex(), (Object)new TIntObjectHashMap());
                            }
                            if (!SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).contains(this.getReferenceSkill())) {
                                SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).put(this.getReferenceSkill(), (Object)new FastList());
                            }
                            List list = (List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill());
                            SummonEffectsTable summonEffectsTable = SummonEffectsTable.getInstance();
                            summonEffectsTable.getClass();
                            list.add(summonEffectsTable.new SummonEffectsTable.SummonEffect(skill, effectCurTime));
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            statement = con.prepareStatement(DELETE_SKILL_SAVE);
            throwable = null;
            try {
                statement.setInt(1, this.getOwner().getObjectId());
                statement.setInt(2, this.getOwner().getClassIndex());
                statement.setInt(3, this.getReferenceSkill());
                statement.executeUpdate();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore " + this + " active effect data: " + e.getMessage(), e);
        }
        finally {
            if (!(SummonEffectsTable.getInstance().getServitorEffectsOwner().contains(this.getOwner().getObjectId()) && ((TIntObjectHashMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId())).contains(this.getOwner().getClassIndex()) && SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).contains(this.getReferenceSkill()))) {
                return;
            }
            for (SummonEffectsTable.SummonEffect se : (List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill())) {
                if (se == null) continue;
                se.getSkill().applyEffects(this, this, false, se.getEffectCurTime());
            }
        }
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        if (Config.DEBUG) {
            _log.info(this.getClass().getSimpleName() + ": " + this.getTemplate().getName() + " (" + owner.getName() + ") unsummoned.");
        }
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(false);
            this._summonLifeTask = null;
        }
        super.unSummon(owner);
        if (!this._restoreSummon) {
            CharSummonTable.getInstance().removeServitor(owner);
        }
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return this.getOwner().destroyItem(process, objectId, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (Config.DEBUG) {
            _log.warning(this.getClass().getSimpleName() + ": " + this.getTemplate().getName() + " (" + this.getOwner().getName() + ") consume.");
        }
        return this.getOwner().destroyItemByItemId(process, itemId, count, reference, sendMessage);
    }

    public void setTimeRemaining(int time) {
        this._timeRemaining = time;
    }

    public int getReferenceSkill() {
        return this._referenceSkill;
    }

    @Override
    public byte getAttackElement() {
        if (this.isSharingElementals() && this.getOwner() != null) {
            return this.getOwner().getAttackElement();
        }
        return super.getAttackElement();
    }

    @Override
    public int getAttackElementValue(byte attackAttribute) {
        if (this.isSharingElementals() && this.getOwner() != null) {
            return (int)((double)this.getOwner().getAttackElementValue(attackAttribute) * this.sharedElementalsPercent());
        }
        return super.getAttackElementValue(attackAttribute);
    }

    @Override
    public int getDefenseElementValue(byte defenseAttribute) {
        if (this.isSharingElementals() && this.getOwner() != null) {
            return (int)((double)this.getOwner().getDefenseElementValue(defenseAttribute) * this.sharedElementalsPercent());
        }
        return super.getDefenseElementValue(defenseAttribute);
    }

    @Override
    public boolean isServitor() {
        return true;
    }

    static class SummonLifetime
    implements Runnable {
        private final L2PcInstance _activeChar;
        private final L2ServitorInstance _summon;

        SummonLifetime(L2PcInstance activeChar, L2ServitorInstance newpet) {
            this._activeChar = activeChar;
            this._summon = newpet;
        }

        @Override
        public void run() {
            if (Config.DEBUG) {
                log.warning(this.getClass().getSimpleName() + ": " + this._summon.getTemplate().getName() + " (" + this._activeChar.getName() + ") run task.");
            }
            try {
                double oldTimeRemaining = this._summon.getTimeRemaining();
                int maxTime = this._summon.getTotalLifeTime();
                if (this._summon.isAttackingNow()) {
                    this._summon.decTimeRemaining(this._summon.getTimeLostActive());
                } else {
                    this._summon.decTimeRemaining(this._summon.getTimeLostIdle());
                }
                double newTimeRemaining = this._summon.getTimeRemaining();
                if (newTimeRemaining < 0.0) {
                    this._summon.unSummon(this._activeChar);
                } else if (newTimeRemaining <= (double)this._summon.getNextItemConsumeTime() && oldTimeRemaining > (double)this._summon.getNextItemConsumeTime()) {
                    this._summon.decNextItemConsumeTime(maxTime / (this._summon.getItemConsumeSteps() + 1));
                    if (this._summon.getItemConsumeCount() > 0 && this._summon.getItemConsumeId() != 0 && !this._summon.isDead() && !this._summon.destroyItemByItemId("Consume", this._summon.getItemConsumeId(), this._summon.getItemConsumeCount(), this._activeChar, true)) {
                        this._summon.unSummon(this._activeChar);
                    }
                }
                if ((double)this._summon.lastShowntimeRemaining - newTimeRemaining > (double)(maxTime / 352)) {
                    this._summon.sendPacket(new SetSummonRemainTime(maxTime, (int)newTimeRemaining));
                    this._summon.lastShowntimeRemaining = (int)newTimeRemaining;
                    this._summon.updateEffectIcons();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error on player [" + this._activeChar.getName() + "] summon item consume task.", e);
            }
        }
    }
}

