/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.ObjectKnownList;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;

public class CharKnownList
extends ObjectKnownList {
    private FastIntObjectMap<L2PcInstance> _knownPlayers;
    private FastIntObjectMap<L2Summon> _knownSummons;
    private FastIntObjectMap<Integer> _knownRelations;

    public CharKnownList(L2Character activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object.isPlayer()) {
            this.getKnownPlayers().put(object.getObjectId(), (Object)object.getActingPlayer());
            this.getKnownRelations().put(object.getObjectId(), (Object)-1);
        } else if (object.isSummon()) {
            this.getKnownSummons().put(object.getObjectId(), (Object)((L2Summon)object));
        }
        return true;
    }

    public final boolean knowsThePlayer(L2PcInstance player) {
        return this.getActiveChar() == player || this.getKnownPlayers().containsKey(player.getObjectId());
    }

    @Override
    public final void removeAllKnownObjects() {
        super.removeAllKnownObjects();
        this.getKnownPlayers().clear();
        this.getKnownRelations().clear();
        this.getKnownSummons().clear();
        L2Character activeChar = this.getActiveChar();
        activeChar.setTarget(null);
        if (activeChar.hasAI()) {
            if (!activeChar.isDead() && activeChar.isVisible() && activeChar.getAI().getNextAction() != null) {
                return;
            }
            activeChar.setAI(null);
        }
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (!forget) {
            if (object.isPlayer()) {
                this.getKnownPlayers().remove(object.getObjectId());
                this.getKnownRelations().remove(object.getObjectId());
            } else if (object.isSummon()) {
                this.getKnownSummons().remove(object.getObjectId());
            }
        }
        if (object == this.getActiveChar().getTarget()) {
            this.getActiveChar().setTarget(null);
        }
        return true;
    }

    @Override
    public void forgetObjects(boolean fullCheck) {
        if (!fullCheck) {
            Collection plrs = this.getKnownPlayers().values();
            Iterator pIter = plrs.iterator();
            while (pIter.hasNext()) {
                L2PcInstance player = (L2PcInstance)pIter.next();
                if (player == null) {
                    pIter.remove();
                    continue;
                }
                if (player.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(player), this.getActiveObject(), player, true)) continue;
                pIter.remove();
                this.removeKnownObject(player, true);
                this.getKnownRelations().remove(player.getObjectId());
                this.getKnownObjects().remove(player.getObjectId());
            }
            Collection sums = this.getKnownSummons().values();
            Iterator sIter = sums.iterator();
            while (sIter.hasNext()) {
                L2Summon summon = (L2Summon)sIter.next();
                if (summon == null) {
                    sIter.remove();
                    continue;
                }
                if (summon.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(summon), this.getActiveObject(), summon, true)) continue;
                sIter.remove();
                this.removeKnownObject(summon, true);
                this.getKnownObjects().remove(summon.getObjectId());
            }
            return;
        }
        Collection objs = this.getKnownObjects().values();
        Iterator oIter = objs.iterator();
        while (oIter.hasNext()) {
            L2Object object = (L2Object)oIter.next();
            if (object == null) {
                oIter.remove();
                continue;
            }
            if (object.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(object), this.getActiveObject(), object, true)) continue;
            oIter.remove();
            this.removeKnownObject(object, true);
            if (object.isPlayer()) {
                this.getKnownPlayers().remove(object.getObjectId());
                this.getKnownRelations().remove(object.getObjectId());
                continue;
            }
            if (!object.isSummon()) continue;
            this.getKnownSummons().remove(object.getObjectId());
        }
    }

    public L2Character getActiveChar() {
        return (L2Character)super.getActiveObject();
    }

    public Collection<L2Character> getKnownCharacters() {
        FastList result = null;
        Collection objs = this.getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2Character)) continue;
            if (result == null) {
                result = new FastList();
            }
            result.add((Object)((L2Character)obj));
        }
        return result != null ? result : Collections.emptyList();
    }

    public Collection<L2Character> getKnownCharactersInRadius(long radius) {
        List<L2Character> result = null;
        Collection objs = this.getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2Character) || !Util.checkIfInRange((int)radius, this.getActiveChar(), obj, true)) continue;
            if (result == null) {
                result = new ArrayList<L2Character>();
            }
            result.add((L2Character)obj);
        }
        return result != null ? result : Collections.emptyList();
    }

    public final FastIntObjectMap<L2PcInstance> getKnownPlayers() {
        if (this._knownPlayers == null) {
            this._knownPlayers = new FastIntObjectMap().shared();
        }
        return this._knownPlayers;
    }

    public final FastIntObjectMap<Integer> getKnownRelations() {
        if (this._knownRelations == null) {
            this._knownRelations = new FastIntObjectMap().shared();
        }
        return this._knownRelations;
    }

    public final FastIntObjectMap<L2Summon> getKnownSummons() {
        if (this._knownSummons == null) {
            this._knownSummons = new FastIntObjectMap().shared();
        }
        return this._knownSummons;
    }

    public final Collection<L2PcInstance> getKnownPlayersInRadius(long radius) {
        List<L2PcInstance> result = null;
        Collection plrs = this.getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (!Util.checkIfInRange((int)radius, this.getActiveChar(), player, true)) continue;
            if (result == null) {
                result = new ArrayList<L2PcInstance>();
            }
            result.add(player);
        }
        return result != null ? result : Collections.emptyList();
    }
}

