/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2ClassMasterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.stat.PlayableStat;
import com.l2jserver.gameserver.model.actor.transform.TransformTemplate;
import com.l2jserver.gameserver.model.entity.RecoBonus;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExVitalityPointInfo;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;

public class PcStat
extends PlayableStat {
    private int _oldMaxHp;
    private int _oldMaxMp;
    private int _oldMaxCp;
    private float _vitalityPoints = 1.0f;
    private byte _vitalityLevel = 0;
    private long _startingXp;
    public static final int[] VITALITY_LEVELS = new int[]{240, 2000, 13000, 17000, 20000};
    public static final int MAX_VITALITY_POINTS = VITALITY_LEVELS[4];
    public static final int MIN_VITALITY_POINTS = 1;

    public PcStat(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addExp(long value) {
        int karmaLost;
        L2PcInstance activeChar = this.getActiveChar();
        if (!this.getActiveChar().getAccessLevel().canGainExp()) {
            return false;
        }
        if (!super.addExp(value)) {
            return false;
        }
        if (!(activeChar.isCursedWeaponEquipped() || activeChar.getKarma() <= 0 || !activeChar.isGM() && activeChar.isInsideZone(ZoneId.PVP) || (karmaLost = Formulas.calculateKarmaLost(activeChar, value)) <= 0)) {
            activeChar.setKarma(activeChar.getKarma() - karmaLost);
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_KARMA_HAS_BEEN_CHANGED_TO_S1);
            msg.addNumber(activeChar.getKarma());
            activeChar.sendPacket(msg);
        }
        activeChar.sendPacket(new UserInfo(activeChar));
        activeChar.sendPacket(new ExBrExtraUserInfo(activeChar));
        return true;
    }

    @Override
    public boolean addExpAndSp(long addToExp, int addToSp) {
        return this.addExpAndSp(addToExp, addToSp, false);
    }

    public boolean addExpAndSp(long addToExp, int addToSp, boolean useBonuses) {
        L2PcInstance activeChar = this.getActiveChar();
        if (!activeChar.getAccessLevel().canGainExp()) {
            return false;
        }
        long baseExp = addToExp;
        int baseSp = addToSp;
        double bonusExp = 1.0;
        double bonusSp = 1.0;
        if (useBonuses) {
            bonusExp = this.getExpBonusMultiplier();
            bonusSp = this.getSpBonusMultiplier();
        }
        addToExp = (long)((double)addToExp * bonusExp);
        addToSp = (int)((double)addToSp * bonusSp);
        float ratioTakenByPlayer = 0.0f;
        if (activeChar.hasPet() && Util.checkIfInShortRadius(Config.ALT_PARTY_RANGE, activeChar, activeChar.getSummon(), false)) {
            L2PetInstance pet = (L2PetInstance)activeChar.getSummon();
            ratioTakenByPlayer = (float)pet.getPetLevelData().getOwnerExpTaken() / 100.0f;
            if (ratioTakenByPlayer > 1.0f) {
                ratioTakenByPlayer = 1.0f;
            }
            if (!pet.isDead()) {
                pet.addExpAndSp((long)((float)addToExp * (1.0f - ratioTakenByPlayer)), (int)((float)addToSp * (1.0f - ratioTakenByPlayer)));
            }
            addToExp = (long)((float)addToExp * ratioTakenByPlayer);
            addToSp = (int)((float)addToSp * ratioTakenByPlayer);
        }
        if (!super.addExpAndSp(addToExp, addToSp)) {
            return false;
        }
        SystemMessage sm = null;
        if (addToExp == 0L && addToSp != 0) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.ACQUIRED_S1_SP);
            sm.addNumber(addToSp);
        } else if (addToSp == 0 && addToExp != 0L) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_EXPERIENCE);
            sm.addNumber(addToExp);
        } else if (addToExp - baseExp > 0L) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_EARNED_S1_EXP_BONUS_S2_AND_S3_SP_BONUS_S4);
            sm.addNumber(addToExp);
            sm.addNumber(addToExp - baseExp);
            sm.addNumber(addToSp);
            sm.addNumber(addToSp - baseSp);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_EARNED_S1_EXP_AND_S2_SP);
            sm.addNumber(addToExp);
            sm.addNumber(addToSp);
        }
        activeChar.sendPacket(sm);
        return true;
    }

    @Override
    public boolean removeExpAndSp(long addToExp, int addToSp) {
        return this.removeExpAndSp(addToExp, addToSp, true);
    }

    public boolean removeExpAndSp(long addToExp, int addToSp, boolean sendMessage) {
        byte level = this.getLevel();
        if (!super.removeExpAndSp(addToExp, addToSp)) {
            return false;
        }
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EXP_DECREASED_BY_S1);
            sm.addNumber(addToExp);
            this.getActiveChar().sendPacket(sm);
            sm = SystemMessage.getSystemMessage(SystemMessageId.SP_DECREASED_S1);
            sm.addNumber(addToSp);
            this.getActiveChar().sendPacket(sm);
            if (this.getLevel() < level) {
                this.getActiveChar().broadcastStatusUpdate();
            }
        }
        return true;
    }

    @Override
    public final boolean addLevel(byte value) {
        L2PetInstance pet;
        if (this.getLevel() + value > ExperienceTable.getInstance().getMaxLevel() - 1) {
            return false;
        }
        if (!this.getActiveChar().getEvents().onLevelChange(value)) {
            return false;
        }
        boolean levelIncreased = super.addLevel(value);
        if (levelIncreased) {
            QuestState qs;
            if (!Config.DISABLE_TUTORIAL && (qs = this.getActiveChar().getQuestState("255_Tutorial")) != null) {
                qs.getQuest().notifyEvent("CE40", null, this.getActiveChar());
            }
            this.getActiveChar().setCurrentCp(this.getMaxCp());
            this.getActiveChar().broadcastPacket(new SocialAction(this.getActiveChar().getObjectId(), 2122));
            this.getActiveChar().sendPacket(SystemMessageId.YOU_INCREASED_YOUR_LEVEL);
            L2ClassMasterInstance.showQuestionMark(this.getActiveChar());
        }
        this.getActiveChar().rewardSkills();
        if (this.getActiveChar().getClan() != null) {
            this.getActiveChar().getClan().updateClanMember(this.getActiveChar());
            this.getActiveChar().getClan().broadcastToOnlineMembers(new PledgeShowMemberListUpdate(this.getActiveChar()));
        }
        if (this.getActiveChar().isInParty()) {
            this.getActiveChar().getParty().recalculatePartyLevel();
        }
        if (this.getActiveChar().isTransformed() || this.getActiveChar().isInStance()) {
            this.getActiveChar().getTransformation().onLevelUp(this.getActiveChar());
        }
        if (this.getActiveChar().hasPet() && (pet = (L2PetInstance)this.getActiveChar().getSummon()).getPetData().isSynchLevel() && pet.getLevel() != this.getLevel()) {
            pet.getStat().setLevel(this.getLevel());
            pet.getStat().getExpForLevel(this.getActiveChar().getLevel());
            pet.setCurrentHp(pet.getMaxHp());
            pet.setCurrentMp(pet.getMaxMp());
            pet.broadcastPacket(new SocialAction(this.getActiveChar().getObjectId(), 2122));
            pet.updateAndBroadcastStatus(1);
        }
        StatusUpdate su = new StatusUpdate(this.getActiveChar());
        su.addAttribute(1, this.getLevel());
        su.addAttribute(34, this.getMaxCp());
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(12, this.getMaxMp());
        this.getActiveChar().sendPacket(su);
        this.getActiveChar().refreshOverloaded();
        this.getActiveChar().refreshExpertisePenalty();
        this.getActiveChar().sendPacket(new UserInfo(this.getActiveChar()));
        this.getActiveChar().sendPacket(new ExBrExtraUserInfo(this.getActiveChar()));
        this.getActiveChar().sendPacket(new ExVoteSystemInfo(this.getActiveChar()));
        return levelIncreased;
    }

    @Override
    public boolean addSp(int value) {
        if (!super.addSp(value)) {
            return false;
        }
        StatusUpdate su = new StatusUpdate(this.getActiveChar());
        su.addAttribute(13, this.getSp());
        this.getActiveChar().sendPacket(su);
        return true;
    }

    @Override
    public final long getExpForLevel(int level) {
        return ExperienceTable.getInstance().getExpForLevel(level);
    }

    @Override
    public final L2PcInstance getActiveChar() {
        return (L2PcInstance)super.getActiveChar();
    }

    @Override
    public final long getExp() {
        if (this.getActiveChar().isSubClassActive()) {
            return this.getActiveChar().getSubClasses().get(this.getActiveChar().getClassIndex()).getExp();
        }
        return super.getExp();
    }

    public final long getBaseExp() {
        return super.getExp();
    }

    @Override
    public final void setExp(long value) {
        if (this.getActiveChar().isSubClassActive()) {
            this.getActiveChar().getSubClasses().get(this.getActiveChar().getClassIndex()).setExp(value);
        } else {
            super.setExp(value);
        }
    }

    public void setStartingExp(long value) {
        if (Config.BOTREPORT_ENABLE) {
            this._startingXp = value;
        }
    }

    public long getStartingExp() {
        return this._startingXp;
    }

    @Override
    public final byte getLevel() {
        if (this.getActiveChar().isSubClassActive()) {
            return this.getActiveChar().getSubClasses().get(this.getActiveChar().getClassIndex()).getLevel();
        }
        return super.getLevel();
    }

    public final byte getBaseLevel() {
        return super.getLevel();
    }

    @Override
    public final void setLevel(byte value) {
        if (value > ExperienceTable.getInstance().getMaxLevel() - 1) {
            value = (byte)(ExperienceTable.getInstance().getMaxLevel() - 1);
        }
        if (this.getActiveChar().isSubClassActive()) {
            this.getActiveChar().getSubClasses().get(this.getActiveChar().getClassIndex()).setLevel(value);
        } else {
            super.setLevel(value);
        }
    }

    @Override
    public final int getMaxCp() {
        int val;
        int n = val = this.getActiveChar() == null ? 1 : (int)this.calcStat(Stats.MAX_CP, this.getActiveChar().getTemplate().getBaseCpMax(this.getActiveChar().getLevel()));
        if (val != this._oldMaxCp) {
            this._oldMaxCp = val;
            if (this.getActiveChar().getStatus().getCurrentCp() != (double)val) {
                this.getActiveChar().getStatus().setCurrentCp(this.getActiveChar().getStatus().getCurrentCp());
            }
        }
        return val;
    }

    @Override
    public final int getMaxHp() {
        int val;
        int n = val = this.getActiveChar() == null ? 1 : (int)this.calcStat(Stats.MAX_HP, this.getActiveChar().getTemplate().getBaseHpMax(this.getActiveChar().getLevel()));
        if (val != this._oldMaxHp) {
            this._oldMaxHp = val;
            if (this.getActiveChar().getStatus().getCurrentHp() != (double)val) {
                this.getActiveChar().getStatus().setCurrentHp(this.getActiveChar().getStatus().getCurrentHp());
            }
        }
        return val;
    }

    @Override
    public final int getMaxMp() {
        int val;
        int n = val = this.getActiveChar() == null ? 1 : (int)this.calcStat(Stats.MAX_MP, this.getActiveChar().getTemplate().getBaseMpMax(this.getActiveChar().getLevel()));
        if (val != this._oldMaxMp) {
            this._oldMaxMp = val;
            if (this.getActiveChar().getStatus().getCurrentMp() != (double)val) {
                this.getActiveChar().getStatus().setCurrentMp(this.getActiveChar().getStatus().getCurrentMp());
            }
        }
        return val;
    }

    @Override
    public final int getSp() {
        if (this.getActiveChar().isSubClassActive()) {
            return this.getActiveChar().getSubClasses().get(this.getActiveChar().getClassIndex()).getSp();
        }
        return super.getSp();
    }

    public final int getBaseSp() {
        return super.getSp();
    }

    @Override
    public final void setSp(int value) {
        if (this.getActiveChar().isSubClassActive()) {
            this.getActiveChar().getSubClasses().get(this.getActiveChar().getClassIndex()).setSp(value);
        } else {
            super.setSp(value);
        }
    }

    @Override
    public float getBaseMoveSpeed(MoveType type) {
        L2PetLevelData data;
        L2PcInstance player = this.getActiveChar();
        if (player.isTransformed()) {
            TransformTemplate template = player.getTransformation().getTemplate(player);
            if (template != null) {
                return template.getBaseMoveSpeed(type);
            }
        } else if (player.isMounted() && (data = PetDataTable.getInstance().getPetLevelData(player.getMountNpcId(), player.getMountLevel())) != null) {
            return data.getSpeedOnRide(type);
        }
        return super.getBaseMoveSpeed(type);
    }

    @Override
    public int getRunSpeed() {
        int val = super.getRunSpeed() + Config.RUN_SPD_BOOST;
        if (val > Config.MAX_RUN_SPEED && !this.getActiveChar().canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            return Config.MAX_RUN_SPEED;
        }
        if (this.getActiveChar().isMounted()) {
            if (this.getActiveChar().getMountLevel() - this.getActiveChar().getLevel() >= 10) {
                val /= 2;
            }
            if (this.getActiveChar().isHungry()) {
                val /= 2;
            }
        }
        return val;
    }

    @Override
    public int getWalkSpeed() {
        int val = super.getWalkSpeed() + Config.RUN_SPD_BOOST;
        if (val > Config.MAX_RUN_SPEED && !this.getActiveChar().canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            return Config.MAX_RUN_SPEED;
        }
        if (this.getActiveChar().isMounted()) {
            if (this.getActiveChar().getMountLevel() - this.getActiveChar().getLevel() >= 10) {
                val /= 2;
            }
            if (this.getActiveChar().isHungry()) {
                val /= 2;
            }
        }
        return val;
    }

    @Override
    public int getPAtkSpd() {
        int val = super.getPAtkSpd();
        if (val > Config.MAX_PATK_SPEED && !this.getActiveChar().canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            return Config.MAX_PATK_SPEED;
        }
        return val;
    }

    private void updateVitalityLevel(boolean quiet) {
        byte level = this._vitalityPoints <= (float)VITALITY_LEVELS[0] ? (byte)0 : (this._vitalityPoints <= (float)VITALITY_LEVELS[1] ? (byte)1 : (this._vitalityPoints <= (float)VITALITY_LEVELS[2] ? (byte)2 : (this._vitalityPoints <= (float)VITALITY_LEVELS[3] ? (byte)3 : 4)));
        if (!quiet && level != this._vitalityLevel) {
            if (level < this._vitalityLevel) {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_HAS_DECREASED);
            } else {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_HAS_INCREASED);
            }
            if (level == 0) {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_IS_EXHAUSTED);
            } else if (level == 4) {
                this.getActiveChar().sendPacket(SystemMessageId.VITALITY_IS_AT_MAXIMUM);
            }
        }
        this._vitalityLevel = level;
    }

    public int getVitalityPoints() {
        return (int)this._vitalityPoints;
    }

    public void setVitalityPoints(int points, boolean quiet) {
        if ((float)(points = Math.min(Math.max(points, 1), MAX_VITALITY_POINTS)) == this._vitalityPoints) {
            return;
        }
        this._vitalityPoints = points;
        this.updateVitalityLevel(quiet);
        this.getActiveChar().sendPacket(new ExVitalityPointInfo(this.getVitalityPoints()));
    }

    public synchronized void updateVitalityPoints(float points, boolean useRates, boolean quiet) {
        if (points == 0.0f || !Config.ENABLE_VITALITY) {
            return;
        }
        if (useRates) {
            if (this.getActiveChar().isLucky()) {
                return;
            }
            if (points < 0.0f) {
                int stat = (int)this.calcStat(Stats.VITALITY_CONSUME_RATE, 1.0, this.getActiveChar(), null);
                if (stat == 0) {
                    return;
                }
                if (stat < 0) {
                    points = -points;
                }
            }
            points = points > 0.0f ? (points *= Config.RATE_VITALITY_GAIN) : (points *= Config.RATE_VITALITY_LOST);
        }
        if ((double)Math.abs((points = points > 0.0f ? Math.min(this._vitalityPoints + points, (float)MAX_VITALITY_POINTS) : Math.max(this._vitalityPoints + points, 1.0f)) - this._vitalityPoints) <= 1.0E-6) {
            return;
        }
        this._vitalityPoints = points;
        this.updateVitalityLevel(quiet);
    }

    public double getVitalityMultiplier() {
        double vitality = 1.0;
        if (Config.ENABLE_VITALITY) {
            switch (this.getVitalityLevel()) {
                case 1: {
                    vitality = Config.RATE_VITALITY_LEVEL_1;
                    break;
                }
                case 2: {
                    vitality = Config.RATE_VITALITY_LEVEL_2;
                    break;
                }
                case 3: {
                    vitality = Config.RATE_VITALITY_LEVEL_3;
                    break;
                }
                case 4: {
                    vitality = Config.RATE_VITALITY_LEVEL_4;
                }
            }
        }
        return vitality;
    }

    public byte getVitalityLevel() {
        return this._vitalityLevel;
    }

    public double getExpBonusMultiplier() {
        double bonus = 1.0;
        double vitality = 1.0;
        double nevits = 1.0;
        double hunting = 1.0;
        double bonusExp = 1.0;
        vitality = this.getVitalityMultiplier();
        nevits = RecoBonus.getRecoMultiplier(this.getActiveChar());
        bonusExp = 1.0 + this.calcStat(Stats.BONUS_EXP, 0.0, null, null) / 100.0;
        if (vitality > 1.0) {
            bonus += vitality - 1.0;
        }
        if (nevits > 1.0) {
            bonus += nevits - 1.0;
        }
        if (hunting > 1.0) {
            bonus += hunting - 1.0;
        }
        if (bonusExp > 1.0) {
            bonus += bonusExp - 1.0;
        }
        bonus = Math.max(bonus, 1.0);
        bonus = Math.min(bonus, Config.MAX_BONUS_EXP);
        return bonus;
    }

    public double getSpBonusMultiplier() {
        double bonus = 1.0;
        double vitality = 1.0;
        double nevits = 1.0;
        double hunting = 1.0;
        double bonusSp = 1.0;
        vitality = this.getVitalityMultiplier();
        nevits = RecoBonus.getRecoMultiplier(this.getActiveChar());
        bonusSp = 1.0 + this.calcStat(Stats.BONUS_SP, 0.0, null, null) / 100.0;
        if (vitality > 1.0) {
            bonus += vitality - 1.0;
        }
        if (nevits > 1.0) {
            bonus += nevits - 1.0;
        }
        if (hunting > 1.0) {
            bonus += hunting - 1.0;
        }
        if (bonusSp > 1.0) {
            bonus += bonusSp - 1.0;
        }
        bonus = Math.max(bonus, 1.0);
        bonus = Math.min(bonus, Config.MAX_BONUS_SP);
        return bonus;
    }
}

