/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.templates;

import com.l2jserver.gameserver.datatables.HerbDropTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.enums.AISkillType;
import com.l2jserver.gameserver.enums.NpcRace;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public final class L2NpcTemplate
extends L2CharTemplate
implements IIdentifiable {
    private static final Logger _log = Logger.getLogger(L2NpcTemplate.class.getName());
    private int _npcId;
    private int _idTemplate;
    private String _type;
    private String _name;
    private boolean _serverSideName;
    private String _title;
    private boolean _serverSideTitle;
    private String _sex;
    private byte _level;
    private int _rewardExp;
    private int _rewardSp;
    private int _rHand;
    private int _lHand;
    private int _enchantEffect;
    private NpcRace _race = NpcRace.NONE;
    private String _clientClass;
    private int _dropHerbGroup;
    private boolean _isCustom;
    private boolean _isQuestMonster;
    private float _baseVitalityDivider;
    private final ConcurrentHashMap<AISkillType, List<L2Skill>> _aiSkills = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, L2Skill> _skills = new ConcurrentHashMap();
    private final List<L2DropCategory> _dropCategories = new CopyOnWriteArrayList<L2DropCategory>();
    private List<L2MinionData> _minions = L2NpcTemplate.emptyArrayList();
    private List<ClassId> _teachInfo = L2NpcTemplate.emptyArrayList();
    private final ConcurrentHashMap<QuestEventType, List<Quest>> _questEvents = new ConcurrentHashMap();
    private L2NpcAIData _aiData;
    private StatsSet _parameters;

    public L2NpcTemplate(StatsSet set) {
        super(set);
    }

    @Override
    public void set(StatsSet set) {
        super.set(set);
        this._npcId = set.getInt("npcId");
        this._idTemplate = set.getInt("idTemplate");
        this._type = StringIntern.intern(set.getString("type"));
        this._name = StringIntern.intern(set.getString("name"));
        this._serverSideName = set.getBoolean("serverSideName");
        this._title = StringIntern.intern(set.getString("title"));
        this._isQuestMonster = this.getTitle().equalsIgnoreCase("Quest Monster") || this.getTitle().equals("\u30af\u30a8\u30b9\u30c8\u30e2\u30f3\u30b9\u30bf\u30fc");
        this._serverSideTitle = set.getBoolean("serverSideTitle");
        this._sex = StringIntern.intern(set.getString("sex"));
        this._level = set.getByte("level");
        this._rewardExp = set.getInt("rewardExp");
        this._rewardSp = set.getInt("rewardSp");
        this._rHand = set.getInt("rhand");
        this._lHand = set.getInt("lhand");
        this._enchantEffect = set.getInt("enchant");
        int herbGroup = set.getInt("dropHerbGroup");
        if (herbGroup > 0 && HerbDropTable.getInstance().getHerbDroplist(herbGroup) == null) {
            _log.warning("Missing Herb Drop Group for npcId: " + this.getId());
            this._dropHerbGroup = 0;
        } else {
            this._dropHerbGroup = herbGroup;
        }
        this._clientClass = StringIntern.intern(set.getString("client_class"));
        this._baseVitalityDivider = this.getLevel() > 0 && this.getRewardExp() > 0 ? this.getBaseHpMax() * 9.0f * (float)this.getLevel() * (float)this.getLevel() / (float)(100 * this.getRewardExp()) : 0.0f;
        this._isCustom = this._npcId != this._idTemplate;
    }

    public void resetSkills() {
        List EMPTY_LIST = Collections.emptyList();
        for (AISkillType type : AISkillType.values()) {
            this._aiSkills.put(type, EMPTY_LIST);
        }
        this._skills.clear();
    }

    public void resetDroplist() {
        this._dropCategories.clear();
    }

    public static boolean isAssignableTo(Class<?> sub, Class<?> clazz) {
        if (clazz.isInterface()) {
            Class<?>[] interfaces;
            for (Class<?> interface1 : interfaces = sub.getInterfaces()) {
                if (!clazz.getName().equals(interface1.getName())) continue;
                return true;
            }
        } else {
            do {
                if (!sub.getName().equals(clazz.getName())) continue;
                return true;
            } while ((sub = sub.getSuperclass()) != null);
        }
        return false;
    }

    public static boolean isAssignableTo(Object obj, Class<?> clazz) {
        return L2NpcTemplate.isAssignableTo(obj.getClass(), clazz);
    }

    private static final <T> List<T> emptyArrayList() {
        return Collections.emptyList();
    }

    private void addAISkill(AISkillType aiSkillType, L2Skill skill) {
        List<L2Skill> skills = this._aiSkills.get((Object)aiSkillType);
        if (skills == Collections.EMPTY_LIST) {
            skills = new ArrayList<L2Skill>();
            this._aiSkills.put(aiSkillType, skills);
        }
        skills.add(skill);
    }

    private void addAtkSkill(L2Skill skill) {
        this.addAISkill(AISkillType.ATTACK, skill);
    }

    private void addBuffSkill(L2Skill skill) {
        this.addAISkill(AISkillType.BUFF, skill);
    }

    private void addCOTSkill(L2Skill skill) {
        this.addAISkill(AISkillType.COT, skill);
    }

    private void addDebuffSkill(L2Skill skill) {
        this.addAISkill(AISkillType.DEBUFF, skill);
    }

    public void addDropData(L2DropData drop, int categoryType) {
        if (!drop.isQuestDrop()) {
            boolean catExists = false;
            for (L2DropCategory cat : this._dropCategories) {
                if (cat.getCategoryType() != categoryType) continue;
                cat.addDropData(drop, this.isType("L2RaidBoss") || this.isType("L2GrandBoss"));
                catExists = true;
                break;
            }
            if (!catExists) {
                L2DropCategory cat = new L2DropCategory(categoryType);
                cat.addDropData(drop, this.isType("L2RaidBoss") || this.isType("L2GrandBoss"));
                this._dropCategories.add(cat);
            }
        }
    }

    private void addGeneralSkill(L2Skill skill) {
        this.addAISkill(AISkillType.GENERAL, skill);
    }

    private void addHealSkill(L2Skill skill) {
        this.addAISkill(AISkillType.HEAL, skill);
    }

    private void addImmobiliseSkill(L2Skill skill) {
        this.addAISkill(AISkillType.IMMOBILIZE, skill);
    }

    private void addNegativeSkill(L2Skill skill) {
        this.addAISkill(AISkillType.NEGATIVE, skill);
    }

    public void addQuestEvent(QuestEventType eventType, Quest q) {
        List<Quest> quests = this._questEvents.get((Object)eventType);
        if (quests == null) {
            quests = new ArrayList<Quest>();
            this._questEvents.put(eventType, quests);
        }
        if (!eventType.isMultipleRegistrationAllowed() && !quests.isEmpty()) {
            _log.warning("Quest event not allowed in multiple quests.  Skipped addition of Event Type \"" + (Object)((Object)eventType) + "\" for NPC \"" + this._name + "\" and quest \"" + q.getName() + "\".");
        } else {
            quests.add(q);
        }
        int i = quests.size() - 1;
        while (--i >= 0) {
            if (!quests.get(i).getName().equals("L2AttackableAIScript")) continue;
            quests.add(quests.remove(i));
        }
        if (eventType == QuestEventType.ON_SPAWN && !q.getName().equals("L2AttackableAIScript")) {
            boolean hasOnSpawn;
            try {
                q.getClass().getDeclaredMethod("onSpawn", L2Npc.class);
                hasOnSpawn = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                hasOnSpawn = false;
            }
            if (hasOnSpawn) {
                for (Set t : SpawnTable.getInstance().getSpawnTable().values()) {
                    for (L2Spawn spawn : t) {
                        L2MonsterInstance leader;
                        L2Npc npc;
                        if (spawn == null || (npc = spawn.getLastSpawn()) == null) continue;
                        if (npc.getId() == this._npcId && npc.isVisible()) {
                            q.onSpawn(npc);
                        }
                        if (!npc.isMonster() || !(leader = (L2MonsterInstance)npc).hasMinions()) continue;
                        for (L2MonsterInstance minion : leader.getMinionList().getSpawnedMinions()) {
                            if (minion.getId() != this._npcId || !minion.isVisible()) continue;
                            q.onSpawn(minion);
                        }
                    }
                }
            }
        }
    }

    public void removeQuest(Quest q) {
        for (Map.Entry<QuestEventType, List<Quest>> entry : this._questEvents.entrySet()) {
            if (!entry.getValue().contains(q)) continue;
            Iterator<Quest> it = entry.getValue().iterator();
            while (it.hasNext()) {
                Quest q1 = it.next();
                if (q1 != q) continue;
                it.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            this._questEvents.remove((Object)entry.getKey());
        }
    }

    public void addMinionData(L2MinionData minion) {
        if (this._minions == Collections.EMPTY_LIST) {
            this._minions = new ArrayList<L2MinionData>();
        }
        this._minions.add(minion);
    }

    private void addRangeSkill(L2Skill skill) {
        if (skill.getCastRange() > 150) {
            this.addAISkill(AISkillType.LONG_RANGE, skill);
        } else if (skill.getCastRange() > 0) {
            this.addAISkill(AISkillType.SHORT_RANGE, skill);
        }
    }

    private void addResSkill(L2Skill skill) {
        this.addAISkill(AISkillType.RES, skill);
    }

    public void addSkill(L2Skill skill) {
        if (!skill.isPassive()) {
            if (skill.isSuicideAttack()) {
                this.addSuicideSkill(skill);
            } else {
                this.addGeneralSkill(skill);
                if (skill.isContinuous()) {
                    if (!skill.isDebuff()) {
                        this.addBuffSkill(skill);
                    } else {
                        this.addDebuffSkill(skill);
                        this.addCOTSkill(skill);
                        this.addRangeSkill(skill);
                    }
                } else if (skill.getSkillType() == L2SkillType.DUMMY) {
                    if (skill.hasEffectType(L2EffectType.DISPEL, L2EffectType.DISPEL_BY_SLOT)) {
                        this.addNegativeSkill(skill);
                        this.addRangeSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.HEAL, L2EffectType.HEAL_PERCENT)) {
                        this.addHealSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.PHYSICAL_ATTACK, L2EffectType.PHYSICAL_ATTACK_HP_LINK, L2EffectType.FATAL_BLOW, L2EffectType.ENERGY_ATTACK, L2EffectType.MAGICAL_ATTACK_MP, L2EffectType.MAGICAL_ATTACK, L2EffectType.DEATH_LINK, L2EffectType.HP_DRAIN)) {
                        this.addAtkSkill(skill);
                        this.addUniversalSkill(skill);
                        this.addRangeSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.SLEEP)) {
                        this.addImmobiliseSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT)) {
                        this.addImmobiliseSkill(skill);
                        this.addRangeSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.MUTE, L2EffectType.FEAR)) {
                        this.addCOTSkill(skill);
                        this.addRangeSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.PARALYZE)) {
                        this.addImmobiliseSkill(skill);
                        this.addRangeSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.DMG_OVER_TIME, L2EffectType.DMG_OVER_TIME_PERCENT)) {
                        this.addRangeSkill(skill);
                    } else if (skill.hasEffectType(L2EffectType.RESURRECTION)) {
                        this.addResSkill(skill);
                    } else {
                        this.addUniversalSkill(skill);
                    }
                }
            }
        }
        this._skills.put(skill.getId(), skill);
    }

    private void addSuicideSkill(L2Skill skill) {
        this.addAISkill(AISkillType.SUICIDE, skill);
    }

    public void setTeachInfo(List<ClassId> teachInfo) {
        this._teachInfo = teachInfo;
    }

    private void addUniversalSkill(L2Skill skill) {
        this.addAISkill(AISkillType.UNIVERSAL, skill);
    }

    public boolean canTeach(ClassId classId) {
        if (classId.level() == 3) {
            return this._teachInfo.contains(classId.getParent());
        }
        return this._teachInfo.contains(classId);
    }

    public void clearAllDropData() {
        for (L2DropCategory cat : this._dropCategories) {
            cat.clearAllDrops();
        }
        this._dropCategories.clear();
    }

    public L2NpcAIData getAIDataStatic() {
        if (this._aiData == null) {
            this._aiData = new L2NpcAIData();
        }
        return this._aiData;
    }

    public List<L2DropData> getAllDropData() {
        ArrayList<L2DropData> list = new ArrayList<L2DropData>();
        for (L2DropCategory tmp : this._dropCategories) {
            list.addAll((Collection<L2DropData>)tmp.getAllDrops());
        }
        return list;
    }

    public List<L2Skill> getAtkSkills() {
        return this._aiSkills.get((Object)AISkillType.ATTACK);
    }

    public float getBaseVitalityDivider() {
        return this._baseVitalityDivider;
    }

    public List<L2Skill> getBuffSkills() {
        return this._aiSkills.get((Object)AISkillType.BUFF);
    }

    public String getClientClass() {
        return this._clientClass;
    }

    public List<L2Skill> getCostOverTimeSkills() {
        return this._aiSkills.get((Object)AISkillType.COT);
    }

    public List<L2Skill> getDebuffSkills() {
        return this._aiSkills.get((Object)AISkillType.DEBUFF);
    }

    public List<L2DropCategory> getDropData() {
        return this._dropCategories;
    }

    public int getDropHerbGroup() {
        return this._dropHerbGroup;
    }

    public int getEnchantEffect() {
        return this._enchantEffect;
    }

    public Map<QuestEventType, List<Quest>> getEventQuests() {
        return this._questEvents;
    }

    public List<Quest> getEventQuests(QuestEventType EventType2) {
        return this._questEvents.get((Object)EventType2);
    }

    public List<L2Skill> getGeneralskills() {
        return this._aiSkills.get((Object)AISkillType.GENERAL);
    }

    public List<L2Skill> getHealSkills() {
        return this._aiSkills.get((Object)AISkillType.HEAL);
    }

    public int getIdTemplate() {
        return this._idTemplate;
    }

    public List<L2Skill> getImmobiliseSkills() {
        return this._aiSkills.get((Object)AISkillType.IMMOBILIZE);
    }

    public int getLeftHand() {
        return this._lHand;
    }

    public byte getLevel() {
        return this._level;
    }

    public List<L2Skill> getLongRangeSkills() {
        return this._aiSkills.get((Object)AISkillType.LONG_RANGE);
    }

    public List<L2MinionData> getMinionData() {
        return this._minions;
    }

    public String getName() {
        return this._name;
    }

    public List<L2Skill> getNegativeSkills() {
        return this._aiSkills.get((Object)AISkillType.NEGATIVE);
    }

    @Override
    public int getId() {
        return this._npcId;
    }

    public int getNpcId() {
        return this.getId();
    }

    public NpcRace getRace() {
        return this._race;
    }

    public List<L2Skill> getResSkills() {
        return this._aiSkills.get((Object)AISkillType.RES);
    }

    public int getRewardExp() {
        return this._rewardExp;
    }

    public int getRewardSp() {
        return this._rewardSp;
    }

    public int getRightHand() {
        return this._rHand;
    }

    public String getSex() {
        return this._sex;
    }

    public List<L2Skill> getShortRangeSkills() {
        return this._aiSkills.get((Object)AISkillType.SHORT_RANGE);
    }

    @Override
    public Map<Integer, L2Skill> getSkills() {
        return this._skills;
    }

    public List<L2Skill> getSuicideSkills() {
        return this._aiSkills.get((Object)AISkillType.SUICIDE);
    }

    public List<ClassId> getTeachInfo() {
        return this._teachInfo;
    }

    public String getTitle() {
        return this._title;
    }

    public String getType() {
        return this._type;
    }

    public List<L2Skill> getUniversalSkills() {
        return this._aiSkills.get((Object)AISkillType.UNIVERSAL);
    }

    public boolean isCustom() {
        return this._isCustom;
    }

    public boolean isQuestMonster() {
        return this._isQuestMonster;
    }

    public boolean isServerSideName() {
        return this._serverSideName;
    }

    public boolean isServerSideTitle() {
        return this._serverSideTitle;
    }

    public boolean isType(String t) {
        return this._type.equalsIgnoreCase(t);
    }

    public boolean isUndead() {
        return this._race == NpcRace.UNDEAD;
    }

    public void setAIData(L2NpcAIData aiData) {
        this._aiData = aiData;
    }

    public void setRace(int raceId) {
        switch (raceId) {
            case 1: {
                this._race = NpcRace.UNDEAD;
                break;
            }
            case 2: {
                this._race = NpcRace.MAGICCREATURE;
                break;
            }
            case 3: {
                this._race = NpcRace.BEAST;
                break;
            }
            case 4: {
                this._race = NpcRace.ANIMAL;
                break;
            }
            case 5: {
                this._race = NpcRace.PLANT;
                break;
            }
            case 6: {
                this._race = NpcRace.HUMANOID;
                break;
            }
            case 7: {
                this._race = NpcRace.SPIRIT;
                break;
            }
            case 8: {
                this._race = NpcRace.ANGEL;
                break;
            }
            case 9: {
                this._race = NpcRace.DEMON;
                break;
            }
            case 10: {
                this._race = NpcRace.DRAGON;
                break;
            }
            case 11: {
                this._race = NpcRace.GIANT;
                break;
            }
            case 12: {
                this._race = NpcRace.BUG;
                break;
            }
            case 13: {
                this._race = NpcRace.FAIRIE;
                break;
            }
            case 14: {
                this._race = NpcRace.HUMAN;
                break;
            }
            case 15: {
                this._race = NpcRace.ELVE;
                break;
            }
            case 16: {
                this._race = NpcRace.DARKELVE;
                break;
            }
            case 17: {
                this._race = NpcRace.ORC;
                break;
            }
            case 18: {
                this._race = NpcRace.DWARVE;
                break;
            }
            case 19: {
                this._race = NpcRace.OTHER;
                break;
            }
            case 20: {
                this._race = NpcRace.NONLIVING;
                break;
            }
            case 21: {
                this._race = NpcRace.SIEGEWEAPON;
                break;
            }
            case 22: {
                this._race = NpcRace.DEFENDINGARMY;
                break;
            }
            case 23: {
                this._race = NpcRace.MERCENARIE;
                break;
            }
            case 24: {
                this._race = NpcRace.UNKNOWN;
                break;
            }
            case 25: {
                this._race = NpcRace.KAMAEL;
                break;
            }
            default: {
                this._race = NpcRace.NONE;
            }
        }
    }

    public boolean hasParameters() {
        return this._parameters != null;
    }

    public StatsSet getParameters() {
        return this._parameters;
    }

    public void setParameters(StatsSet set) {
        this._parameters = set;
    }
}

