/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.ClassListData;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Hero {
    private static final Logger _log = Logger.getLogger(Hero.class.getName());
    private static final String GET_HEROES = "SELECT heroes.charId, characters.char_name, heroes.class_id, heroes.count, heroes.played FROM heroes, characters WHERE characters.charId = heroes.charId AND heroes.played = 1";
    private static final String GET_ALL_HEROES = "SELECT heroes.charId, characters.char_name, heroes.class_id, heroes.count, heroes.played FROM heroes, characters WHERE characters.charId = heroes.charId";
    private static final String UPDATE_ALL = "UPDATE heroes SET played = 0";
    private static final String INSERT_HERO = "INSERT INTO heroes (charId, class_id, count, played) VALUES (?,?,?,?)";
    private static final String UPDATE_HERO = "UPDATE heroes SET count = ?, played = ? WHERE charId = ?";
    private static final String GET_CLAN_ALLY = "SELECT characters.clanid AS clanid, coalesce(clan_data.ally_Id, 0) AS allyId FROM characters LEFT JOIN clan_data ON clan_data.clan_id = characters.clanid WHERE characters.charId = ?";
    private static final String GET_CLAN_NAME = "SELECT clan_name FROM clan_data WHERE clan_id = (SELECT clanid FROM characters WHERE charId = ?)";
    private static final String DELETE_ITEMS = "DELETE FROM items WHERE item_id IN (6842, 6611, 6612, 6613, 6614, 6615, 6616, 6617, 6618, 6619, 6620, 6621, 9388, 9389, 9390) AND owner_id NOT IN (SELECT charId FROM characters WHERE accesslevel > 0)";
    private static final Map<Integer, StatsSet> _heroes = new FastMap();
    private static final Map<Integer, StatsSet> _completeHeroes = new FastMap();
    private static final Map<Integer, StatsSet> _herocounts = new FastMap();
    private static final Map<Integer, List<StatsSet>> _herofights = new FastMap();
    private static final Map<Integer, List<StatsSet>> _herodiary = new FastMap();
    private static final Map<Integer, String> _heroMessage = new FastMap();
    public static final String COUNT = "count";
    public static final String PLAYED = "played";
    public static final String CLAN_NAME = "clan_name";
    public static final String CLAN_CREST = "clan_crest";
    public static final String ALLY_NAME = "ally_name";
    public static final String ALLY_CREST = "ally_crest";
    public static final int ACTION_RAID_KILLED = 1;
    public static final int ACTION_HERO_GAINED = 2;
    public static final int ACTION_CASTLE_TAKEN = 3;

    public static Hero getInstance() {
        return SingletonHolder._instance;
    }

    protected Hero() {
        this.init();
    }

    private void init() {
        _heroes.clear();
        _completeHeroes.clear();
        _herocounts.clear();
        _herofights.clear();
        _herodiary.clear();
        _heroMessage.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s1 = con.createStatement();
             ResultSet rset = s1.executeQuery(GET_HEROES);
             PreparedStatement ps = con.prepareStatement(GET_CLAN_ALLY);
             Statement s2 = con.createStatement();
             ResultSet rset2 = s2.executeQuery(GET_ALL_HEROES);){
            int charId;
            StatsSet hero;
            while (rset.next()) {
                hero = new StatsSet();
                charId = rset.getInt("charId");
                hero.set("char_name", rset.getString("char_name"));
                hero.set("class_id", rset.getInt("class_id"));
                hero.set(COUNT, rset.getInt(COUNT));
                hero.set(PLAYED, rset.getInt(PLAYED));
                this.loadFights(charId);
                this.loadDiary(charId);
                this.loadMessage(charId);
                this.processHeros(ps, charId, hero);
                _heroes.put(charId, hero);
            }
            while (rset2.next()) {
                hero = new StatsSet();
                charId = rset2.getInt("charId");
                hero.set("char_name", rset2.getString("char_name"));
                hero.set("class_id", rset2.getInt("class_id"));
                hero.set(COUNT, rset2.getInt(COUNT));
                hero.set(PLAYED, rset2.getInt(PLAYED));
                this.processHeros(ps, charId, hero);
                _completeHeroes.put(charId, hero);
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Hero System: Couldnt load Heroes", e);
        }
        _log.info("Hero System: Loaded " + _heroes.size() + " Heroes.");
        _log.info("Hero System: Loaded " + _completeHeroes.size() + " all time Heroes.");
    }

    private void processHeros(PreparedStatement ps, int charId, StatsSet hero) throws SQLException {
        ps.setInt(1, charId);
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                int clanId = rs.getInt("clanid");
                int allyId = rs.getInt("allyId");
                String clanName = "";
                String allyName = "";
                int clanCrest = 0;
                int allyCrest = 0;
                if (clanId > 0) {
                    clanName = ClanTable.getInstance().getClan(clanId).getName();
                    clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                    if (allyId > 0) {
                        allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                        allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                    }
                }
                hero.set(CLAN_CREST, clanCrest);
                hero.set(CLAN_NAME, clanName);
                hero.set(ALLY_CREST, allyCrest);
                hero.set(ALLY_NAME, allyName);
            }
            ps.clearParameters();
        }
    }

    private String calcFightTime(long FightTime) {
        String format = String.format("%%0%dd", 2);
        String seconds = String.format(format, (FightTime /= 1000L) % 60L);
        String minutes = String.format(format, FightTime % 3600L / 60L);
        String time = minutes + ":" + seconds;
        return time;
    }

    public void loadMessage(int charId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT message FROM heroes WHERE charId=?");){
            statement.setInt(1, charId);
            try (ResultSet rset = statement.executeQuery();){
                if (rset.next()) {
                    _heroMessage.put(charId, rset.getString("message"));
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Hero System: Couldnt load Hero Message for CharId: " + charId, e);
        }
    }

    public void loadDiary(int charId) {
        FastList _diary = new FastList();
        int diaryentries = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT * FROM  heroes_diary WHERE charId=? ORDER BY time ASC");){
            statement.setInt(1, charId);
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    Castle castle;
                    StatsSet _diaryentry = new StatsSet();
                    long time = rset.getLong("time");
                    int action = rset.getInt("action");
                    int param = rset.getInt("param");
                    String date = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u6642").format(new Date(time));
                    _diaryentry.set("date", date);
                    if (action == 1) {
                        L2NpcTemplate template = NpcTable.getInstance().getTemplate(param);
                        if (template != null) {
                            _diaryentry.set("action", template.getName() + " \u306b\u7acb\u3061\u5411\u304b\u3044\u52dd\u5229\u3092\u53ce\u3081\u308b\u3002");
                        }
                    } else if (action == 2) {
                        _diaryentry.set("action", "Gained Hero status");
                    } else if (action == 3 && (castle = CastleManager.getInstance().getCastleById(param)) != null) {
                        _diaryentry.set("action", castle.getName() + "\u306e\u653b\u57ce\u306b\u52dd\u5229\u3059\u308b\u3002");
                    }
                    _diary.add((Object)_diaryentry);
                    ++diaryentries;
                }
            }
            _herodiary.put(charId, (List<StatsSet>)_diary);
            _log.info("Hero System: Loaded " + diaryentries + " diary entries for Hero: " + CharNameTable.getInstance().getNameById(charId));
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Hero System: Couldnt load Hero Diary for CharId: " + charId, e);
        }
    }

    public void loadFights(int charId) {
        FastList _fights = new FastList();
        StatsSet _herocountdata = new StatsSet();
        Calendar _data = Calendar.getInstance();
        _data.set(5, 1);
        _data.set(11, 0);
        _data.set(12, 0);
        _data.set(14, 0);
        long from = _data.getTimeInMillis();
        int numberoffights = 0;
        int _victorys = 0;
        int _losses = 0;
        int _draws = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT * FROM olympiad_fights WHERE (charOneId=? OR charTwoId=?) AND start<? ORDER BY start ASC");){
            statement.setInt(1, charId);
            statement.setInt(2, charId);
            statement.setLong(3, from);
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    String date;
                    StatsSet fight;
                    String cls;
                    String name;
                    int charOneId = rset.getInt("charOneId");
                    int charOneClass = rset.getInt("charOneClass");
                    int charTwoId = rset.getInt("charTwoId");
                    int charTwoClass = rset.getInt("charTwoClass");
                    int winner = rset.getInt("winner");
                    long start = rset.getLong("start");
                    int time = rset.getInt("time");
                    int classed = rset.getInt("classed");
                    if (charId == charOneId) {
                        name = CharNameTable.getInstance().getNameById(charTwoId);
                        cls = ClassListData.getInstance().getClass(charTwoClass).getClientCode();
                        if (name == null || cls == null) continue;
                        fight = new StatsSet();
                        fight.set("oponent", name);
                        fight.set("oponentclass", cls);
                        fight.set("time", this.calcFightTime(time));
                        date = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u6642mm\u5206").format(new Date(start));
                        fight.set("start", date);
                        fight.set("classed", classed);
                        if (winner == 1) {
                            fight.set("result", "<font color=\"00ff00\">\u52dd\u5229</font>");
                            ++_victorys;
                        } else if (winner == 2) {
                            fight.set("result", "<font color=\"ff0000\">\u6557\u9000</font>");
                            ++_losses;
                        } else if (winner == 0) {
                            fight.set("result", "<font color=\"ffff00\">\u5f15\u5206</font>");
                            ++_draws;
                        }
                        _fights.add((Object)fight);
                        ++numberoffights;
                        continue;
                    }
                    if (charId != charTwoId) continue;
                    name = CharNameTable.getInstance().getNameById(charOneId);
                    cls = ClassListData.getInstance().getClass(charOneClass).getClientCode();
                    if (name == null || cls == null) continue;
                    fight = new StatsSet();
                    fight.set("oponent", name);
                    fight.set("oponentclass", cls);
                    fight.set("time", this.calcFightTime(time));
                    date = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u6642mm\u5206").format(new Date(start));
                    fight.set("start", date);
                    fight.set("classed", classed);
                    if (winner == 1) {
                        fight.set("result", "<font color=\"ff0000\">\u6557\u9000</font>");
                        ++_losses;
                    } else if (winner == 2) {
                        fight.set("result", "<font color=\"00ff00\">\u52dd\u5229</font>");
                        ++_victorys;
                    } else if (winner == 0) {
                        fight.set("result", "<font color=\"ffff00\">\u5f15\u5206</font>");
                        ++_draws;
                    }
                    _fights.add((Object)fight);
                    ++numberoffights;
                }
            }
            _herocountdata.set("victory", _victorys);
            _herocountdata.set("draw", _draws);
            _herocountdata.set("loss", _losses);
            _herocounts.put(charId, _herocountdata);
            _herofights.put(charId, (List<StatsSet>)_fights);
            _log.info("Hero System: Loaded " + numberoffights + " fights for Hero: " + CharNameTable.getInstance().getNameById(charId));
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Hero System: Couldnt load Hero fights history for CharId: " + charId, e);
        }
    }

    public Map<Integer, StatsSet> getHeroes() {
        return _heroes;
    }

    public int getHeroByClass(int classid) {
        for (Map.Entry<Integer, StatsSet> e : _heroes.entrySet()) {
            if (e.getValue().getInt("class_id") != classid) continue;
            return e.getKey();
        }
        return 0;
    }

    public void resetData() {
        _herodiary.clear();
        _herofights.clear();
        _herocounts.clear();
        _heroMessage.clear();
    }

    public void showHeroDiary(L2PcInstance activeChar, int heroclass, int charid, int page) {
        int perpage = 10;
        if (_herodiary.containsKey(charid)) {
            List<StatsSet> _mainlist = _herodiary.get(charid);
            NpcHtmlMessage DiaryReply = new NpcHtmlMessage();
            String htmContent = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/olympiad/herodiary.htm");
            if (htmContent != null && _heroMessage.containsKey(charid)) {
                DiaryReply.setHtml(htmContent);
                DiaryReply.replace((CharSequence)"%heroname%", CharNameTable.getInstance().getNameById(charid));
                DiaryReply.replace((CharSequence)"%message%", _heroMessage.get(charid));
                DiaryReply.disableValidation();
                if (!_mainlist.isEmpty()) {
                    FastList _list = FastList.newInstance();
                    _list.addAll(_mainlist);
                    Collections.reverse(_list);
                    boolean color = true;
                    StringBuilder fList = new StringBuilder(500);
                    int counter = 0;
                    int breakat = 0;
                    for (int i = (page - 1) * 10; i < _list.size(); ++i) {
                        breakat = i;
                        StatsSet _diaryentry = (StatsSet)_list.get(i);
                        StringUtil.append(fList, "<tr><td>");
                        if (color) {
                            StringUtil.append(fList, "<table width=270 bgcolor=\"131210\">");
                        } else {
                            StringUtil.append(fList, "<table width=270>");
                        }
                        StringUtil.append(fList, "<tr><td width=270><font color=\"LEVEL\">" + _diaryentry.getString("date") + ":xx</font></td></tr>");
                        StringUtil.append(fList, "<tr><td width=270>" + _diaryentry.getString("action") + "</td></tr>");
                        StringUtil.append(fList, "<tr><td>&nbsp;</td></tr></table>");
                        StringUtil.append(fList, "</td></tr>");
                        boolean bl = color = !color;
                        if (++counter >= 10) break;
                    }
                    if (breakat < _list.size() - 1) {
                        DiaryReply.replace((CharSequence)"%buttprev%", "<button value=\"\u623b\u308b\" action=\"bypass _diary?class=" + heroclass + "&page=" + (page + 1) + "\" width=60 height=25 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        DiaryReply.replace((CharSequence)"%buttprev%", "");
                    }
                    if (page > 1) {
                        DiaryReply.replace((CharSequence)"%buttnext%", "<button value=\"\u6b21\u3078\" action=\"bypass _diary?class=" + heroclass + "&page=" + (page - 1) + "\" width=60 height=25 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        DiaryReply.replace((CharSequence)"%buttnext%", "");
                    }
                    DiaryReply.replace((CharSequence)"%list%", fList.toString());
                    FastList.recycle((FastList)_list);
                } else {
                    DiaryReply.replace((CharSequence)"%list%", "");
                    DiaryReply.replace((CharSequence)"%buttprev%", "");
                    DiaryReply.replace((CharSequence)"%buttnext%", "");
                }
                activeChar.sendPacket(DiaryReply);
            }
        }
    }

    public void showHeroFights(L2PcInstance activeChar, int heroclass, int charid, int page) {
        int perpage = 20;
        int _win = 0;
        int _loss = 0;
        int _draw = 0;
        if (_herofights.containsKey(charid)) {
            List<StatsSet> _list = _herofights.get(charid);
            NpcHtmlMessage FightReply = new NpcHtmlMessage();
            String htmContent = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/olympiad/herohistory.htm");
            if (htmContent != null) {
                FightReply.setHtml(htmContent);
                FightReply.replace((CharSequence)"%heroname%", CharNameTable.getInstance().getNameById(charid));
                if (!_list.isEmpty()) {
                    if (_herocounts.containsKey(charid)) {
                        StatsSet _herocount = _herocounts.get(charid);
                        _win = _herocount.getInt("victory");
                        _loss = _herocount.getInt("loss");
                        _draw = _herocount.getInt("draw");
                    }
                    boolean color = true;
                    StringBuilder fList = new StringBuilder(500);
                    int counter = 0;
                    int breakat = 0;
                    for (int i = (page - 1) * 20; i < _list.size(); ++i) {
                        breakat = i;
                        StatsSet fight = _list.get(i);
                        fList.append("<tr><td>");
                        if (color) {
                            fList.append("<table width=270 bgcolor=\"131210\">");
                        } else {
                            fList.append("<table width=270>");
                        }
                        fList.append("<tr><td width=220><font color=\"LEVEL\">").append(fight.getString("start")).append("</font>&nbsp;&nbsp;").append(fight.getString("result")).append("</td><td width=50 align=right>").append(fight.getInt("classed") > 0 ? "<font color=\"FFFF99\">cls</font>" : "<font color=\"999999\">non-cls<font>").append("</td></tr><tr><td width=220>vs ").append(fight.getString("oponent")).append(" (").append(fight.getString("oponentclass")).append(")</td><td width=50 align=right>(").append(fight.getString("time")).append(")</td></tr><tr><td colspan=2>&nbsp;</td></tr></table></td></tr>");
                        boolean bl = color = !color;
                        if (++counter >= 20) break;
                    }
                    if (breakat < _list.size() - 1) {
                        FightReply.replace((CharSequence)"%buttprev%", "<button value=\"\u623b\u308b\" action=\"bypass _match?class=" + heroclass + "&page=" + (page + 1) + "\" width=60 height=25 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        FightReply.replace((CharSequence)"%buttprev%", "");
                    }
                    if (page > 1) {
                        FightReply.replace((CharSequence)"%buttnext%", "<button value=\"\u6b21\u3078\" action=\"bypass _match?class=" + heroclass + "&page=" + (page - 1) + "\" width=60 height=25 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_ct1.button_df\">");
                    } else {
                        FightReply.replace((CharSequence)"%buttnext%", "");
                    }
                    FightReply.replace((CharSequence)"%list%", fList.toString());
                } else {
                    FightReply.replace((CharSequence)"%list%", "");
                    FightReply.replace((CharSequence)"%buttprev%", "");
                    FightReply.replace((CharSequence)"%buttnext%", "");
                }
                FightReply.replace((CharSequence)"%win%", _win);
                FightReply.replace((CharSequence)"%draw%", _draw);
                FightReply.replace((CharSequence)"%loos%", _loss);
                activeChar.sendPacket(FightReply);
            }
        }
    }

    public synchronized void computeNewHeroes(List<StatsSet> newHeroes) {
        this.updateHeroes(true);
        if (!_heroes.isEmpty()) {
            for (StatsSet hero : _heroes.values()) {
                String name = hero.getString("char_name");
                L2PcInstance player = L2World.getInstance().getPlayer(name);
                if (player == null) continue;
                try {
                    player.setHero(false);
                    for (int i = 0; i < 25; ++i) {
                        L2ItemInstance equippedItem = player.getInventory().getPaperdollItem(i);
                        if (equippedItem == null || !equippedItem.isHeroItem()) continue;
                        player.getInventory().unEquipItemInSlot(i);
                    }
                    for (L2ItemInstance item : player.getInventory().getAvailableItems(false, false, false)) {
                        if (item == null || !item.isHeroItem()) continue;
                        player.destroyItem("Hero", item, null, true);
                        InventoryUpdate iu = new InventoryUpdate();
                        iu.addRemovedItem(item);
                        player.sendPacket(iu);
                    }
                    player.broadcastUserInfo();
                }
                catch (NullPointerException e) {}
            }
        }
        if (newHeroes.isEmpty()) {
            _heroes.clear();
            return;
        }
        FastMap heroes = new FastMap();
        for (StatsSet hero : newHeroes) {
            int charId = hero.getInt("charId");
            if (_completeHeroes != null && _completeHeroes.containsKey(charId)) {
                StatsSet oldHero = _completeHeroes.get(charId);
                int count = oldHero.getInt(COUNT);
                oldHero.set(COUNT, count + 1);
                oldHero.set(PLAYED, 1);
                heroes.put(charId, oldHero);
                continue;
            }
            StatsSet newHero = new StatsSet();
            newHero.set("char_name", hero.getString("char_name"));
            newHero.set("class_id", hero.getInt("class_id"));
            newHero.set(COUNT, 1);
            newHero.set(PLAYED, 1);
            heroes.put(charId, newHero);
        }
        this.deleteItemsInDb();
        _heroes.clear();
        _heroes.putAll((Map<Integer, StatsSet>)heroes);
        heroes.clear();
        this.updateHeroes(false);
        for (Integer charId : _heroes.keySet()) {
            L2PcInstance player = L2World.getInstance().getPlayer(charId);
            if (player != null) {
                player.setHero(true);
                L2Clan clan = player.getClan();
                if (clan != null) {
                    clan.addReputationScore(Config.HERO_POINTS, true);
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS);
                    sm.addString(CharNameTable.getInstance().getNameById(charId));
                    sm.addNumber(Config.HERO_POINTS);
                    clan.broadcastToOnlineMembers(sm);
                }
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
                player.broadcastUserInfo();
                this.setHeroGained(player.getObjectId());
                this.loadFights(player.getObjectId());
                this.loadDiary(player.getObjectId());
                _heroMessage.put(player.getObjectId(), "");
                continue;
            }
            this.setHeroGained(charId);
            this.loadFights(charId);
            this.loadDiary(charId);
            _heroMessage.put(charId, "");
            try {
                Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                Throwable throwable = null;
                try {
                    PreparedStatement statement = con.prepareStatement(GET_CLAN_NAME);
                    Throwable throwable2 = null;
                    try {
                        statement.setInt(1, charId);
                        ResultSet rset = statement.executeQuery();
                        Throwable throwable3 = null;
                        try {
                            L2Clan clan;
                            String clanName;
                            if (!rset.next() || (clanName = rset.getString(CLAN_NAME)) == null || (clan = ClanTable.getInstance().getClanByName(clanName)) == null) continue;
                            clan.addReputationScore(Config.HERO_POINTS, true);
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS);
                            sm.addString(CharNameTable.getInstance().getNameById(charId));
                            sm.addNumber(Config.HERO_POINTS);
                            clan.broadcastToOnlineMembers(sm);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (rset == null) continue;
                            if (throwable3 != null) {
                                try {
                                    rset.close();
                                }
                                catch (Throwable x2) {
                                    throwable3.addSuppressed(x2);
                                }
                                continue;
                            }
                            rset.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (con == null) continue;
                    if (throwable != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    con.close();
                }
            }
            catch (Exception e) {
                _log.warning("could not get clan name of player with objectId:" + charId + ": " + e);
            }
        }
    }

    public void updateHeroes(boolean setDefault) {
        block78: {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                if (setDefault) {
                    try (PreparedStatement update_all = con.prepareStatement(UPDATE_ALL);){
                        update_all.execute();
                        break block78;
                    }
                }
                for (Map.Entry<Integer, StatsSet> entry : _heroes.entrySet()) {
                    PreparedStatement statement;
                    Throwable throwable;
                    StatsSet hero = entry.getValue();
                    int heroId = entry.getKey();
                    if (_completeHeroes.isEmpty() || !_completeHeroes.containsKey(heroId)) {
                        throwable = null;
                        try (PreparedStatement insert = con.prepareStatement(INSERT_HERO);){
                            insert.setInt(1, heroId);
                            insert.setInt(2, hero.getInt("class_id"));
                            insert.setInt(3, hero.getInt(COUNT));
                            insert.setInt(4, hero.getInt(PLAYED));
                            insert.execute();
                            insert.close();
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        statement = con.prepareStatement(GET_CLAN_ALLY);
                        throwable = null;
                        try {
                            statement.setInt(1, heroId);
                            try (ResultSet rset = statement.executeQuery();){
                                if (rset.next()) {
                                    int clanId = rset.getInt("clanid");
                                    int allyId = rset.getInt("allyId");
                                    String clanName = "";
                                    String allyName = "";
                                    int clanCrest = 0;
                                    int allyCrest = 0;
                                    if (clanId > 0) {
                                        clanName = ClanTable.getInstance().getClan(clanId).getName();
                                        clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                                        if (allyId > 0) {
                                            allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                                            allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                                        }
                                    }
                                    hero.set(CLAN_CREST, clanCrest);
                                    hero.set(CLAN_NAME, clanName);
                                    hero.set(ALLY_CREST, allyCrest);
                                    hero.set(ALLY_NAME, allyName);
                                }
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (statement != null) {
                                if (throwable != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    statement.close();
                                }
                            }
                        }
                        _heroes.put(heroId, hero);
                        _completeHeroes.put(heroId, hero);
                        continue;
                    }
                    statement = con.prepareStatement(UPDATE_HERO);
                    throwable = null;
                    try {
                        statement.setInt(1, hero.getInt(COUNT));
                        statement.setInt(2, hero.getInt(PLAYED));
                        statement.setInt(3, heroId);
                        statement.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "Hero System: Couldnt update Heroes", e);
            }
        }
    }

    public void setHeroGained(int charId) {
        this.setDiaryData(charId, 2, 0);
    }

    public void setRBkilled(int charId, int npcId) {
        this.setDiaryData(charId, 1, npcId);
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(npcId);
        if (_herodiary.containsKey(charId) && template != null) {
            List<StatsSet> _list = _herodiary.get(charId);
            _herodiary.remove(charId);
            StatsSet _diaryentry = new StatsSet();
            String date = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u6642").format(new Date(System.currentTimeMillis()));
            _diaryentry.set("date", date);
            _diaryentry.set("action", template.getName() + " \u306b\u7acb\u3061\u5411\u304b\u3044\u52dd\u5229\u3092\u53ce\u3081\u308b\u3002");
            _list.add(_diaryentry);
            _herodiary.put(charId, _list);
        }
    }

    public void setCastleTaken(int charId, int castleId) {
        this.setDiaryData(charId, 3, castleId);
        Castle castle = CastleManager.getInstance().getCastleById(castleId);
        if (castle != null && _herodiary.containsKey(charId)) {
            List<StatsSet> _list = _herodiary.get(charId);
            _herodiary.remove(charId);
            StatsSet _diaryentry = new StatsSet();
            String date = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u6642").format(new Date(System.currentTimeMillis()));
            _diaryentry.set("date", date);
            _diaryentry.set("action", castle.getCastleName() + "\u306e\u653b\u57ce\u306b\u52dd\u5229\u3059\u308b\u3002");
            _list.add(_diaryentry);
            _herodiary.put(charId, _list);
        }
    }

    public void setDiaryData(int charId, int action, int param) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO heroes_diary (charId, time, action, param) values(?,?,?,?)");){
            statement.setInt(1, charId);
            statement.setLong(2, System.currentTimeMillis());
            statement.setInt(3, action);
            statement.setInt(4, param);
            statement.execute();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SQL exception while saving DiaryData.", e);
        }
    }

    public void setHeroMessage(L2PcInstance player, String message) {
        _heroMessage.put(player.getObjectId(), message);
    }

    public void saveHeroMessage(int charId) {
        if (_heroMessage.get(charId) == null) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE heroes SET message=? WHERE charId=?;");){
            statement.setString(1, _heroMessage.get(charId));
            statement.setInt(2, charId);
            statement.execute();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SQL exception while saving HeroMessage.", e);
        }
    }

    private void deleteItemsInDb() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(DELETE_ITEMS);){
            statement.execute();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public void shutdown() {
        for (int charId : _heroMessage.keySet()) {
            this.saveHeroMessage(charId);
        }
    }

    public boolean isHero(int objectId) {
        return _heroes.containsKey(objectId);
    }

    private static class SingletonHolder {
        protected static final Hero _instance = new Hero();

        private SingletonHolder() {
        }
    }
}

