/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2DoorTemplate;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.instancezone.InstanceWorld;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Instance {
    private static final Logger _log = Logger.getLogger(Instance.class.getName());
    private final int _id;
    private String _name;
    private int _ejectTime = Config.EJECT_DEAD_PLAYER_TIME;
    private boolean _allowRandomWalk = true;
    private final FastList<Integer> _players = new FastList().shared();
    private final FastList<L2Npc> _npcs = new FastList().shared();
    private final FastIntObjectMap<L2DoorInstance> _doors = new FastIntObjectMap().shared();
    private final Map<String, List<L2Spawn>> _manualSpawn = new HashMap<String, List<L2Spawn>>();
    private Location _spawnLoc = null;
    private boolean _allowSummon = true;
    private long _emptyDestroyTime = -1L;
    private long _lastLeft = -1L;
    private long _instanceStartTime = -1L;
    private long _instanceEndTime = -1L;
    private boolean _isPvPInstance = false;
    private boolean _showTimer = false;
    private boolean _isTimerIncrease = true;
    private String _timerText = "";
    protected ScheduledFuture<?> _checkTimeUpTask = null;
    protected final FastIntObjectMap<ScheduledFuture<?>> _ejectDeadTasks = new FastIntObjectMap();

    public Instance(int id) {
        this._id = id;
        this._instanceStartTime = System.currentTimeMillis();
    }

    public Instance(int id, String name) {
        this._id = id;
        this._name = name;
        this._instanceStartTime = System.currentTimeMillis();
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getEjectTime() {
        return this._ejectTime;
    }

    public void setEjectTime(int ejectTime) {
        this._ejectTime = ejectTime;
    }

    public boolean isSummonAllowed() {
        return this._allowSummon;
    }

    public void setAllowSummon(boolean b) {
        this._allowSummon = b;
    }

    public boolean isPvPInstance() {
        return this._isPvPInstance;
    }

    public void setPvPInstance(boolean b) {
        this._isPvPInstance = b;
    }

    public void setDuration(int duration) {
        if (this._checkTimeUpTask != null) {
            this._checkTimeUpTask.cancel(true);
        }
        this._checkTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(duration), 500L);
        this._instanceEndTime = System.currentTimeMillis() + (long)duration + 500L;
    }

    public void setEmptyDestroyTime(long time) {
        this._emptyDestroyTime = time;
    }

    public boolean containsPlayer(int objectId) {
        return this._players.contains((Object)objectId);
    }

    public void addPlayer(int objectId) {
        this._players.add((Object)objectId);
    }

    public void removePlayer(Integer objectId) {
        this._players.remove((Object)objectId);
        if (this._players.isEmpty() && this._emptyDestroyTime >= 0L) {
            this._lastLeft = System.currentTimeMillis();
            this.setDuration((int)(this._instanceEndTime - System.currentTimeMillis() - 500L));
        }
    }

    public void removePlayer(int objectId) {
        this.removePlayer((Integer)objectId);
    }

    public void addNpc(L2Npc npc) {
        this._npcs.add((Object)npc);
    }

    public void removeNpc(L2Npc npc) {
        if (npc.getSpawn() != null) {
            npc.getSpawn().stopRespawn();
        }
        this._npcs.remove((Object)npc);
    }

    public void addDoor(int doorId, StatsSet set) {
        if (this._doors.containsKey(doorId)) {
            _log.warning("Door ID " + doorId + " already exists in instance " + this.getId());
            return;
        }
        L2DoorInstance newdoor = new L2DoorInstance(IdFactory.getInstance().getNextId(), new L2DoorTemplate(set));
        newdoor.setInstanceId(this.getId());
        newdoor.setCurrentHp(newdoor.getMaxHp());
        newdoor.spawnMe(newdoor.getTemplate().getX(), newdoor.getTemplate().getY(), newdoor.getTemplate().getZ());
        this._doors.put(doorId, (Object)newdoor);
    }

    public List<Integer> getPlayers() {
        return this._players;
    }

    public List<L2Npc> getNpcs() {
        return this._npcs;
    }

    public Collection<L2DoorInstance> getDoors() {
        return this._doors.values();
    }

    public L2DoorInstance getDoor(int id) {
        return (L2DoorInstance)this._doors.get(id);
    }

    public long getInstanceEndTime() {
        return this._instanceEndTime;
    }

    public long getInstanceStartTime() {
        return this._instanceStartTime;
    }

    public boolean isShowTimer() {
        return this._showTimer;
    }

    public boolean isTimerIncrease() {
        return this._isTimerIncrease;
    }

    public String getTimerText() {
        return this._timerText;
    }

    public Location getSpawnLoc() {
        return this._spawnLoc;
    }

    public void setSpawnLoc(Location loc) {
        this._spawnLoc = loc;
    }

    public void removePlayers() {
        for (Integer objectId : this._players) {
            this.ejectProcedure(objectId);
        }
        this._players.clear();
    }

    public void removeNpcs() {
        for (L2Npc mob : this._npcs) {
            if (mob == null) continue;
            if (mob.getSpawn() != null) {
                mob.getSpawn().stopRespawn();
            }
            mob.deleteMe();
        }
        this._npcs.clear();
        this._manualSpawn.clear();
    }

    public void removeDoors() {
        for (L2DoorInstance door : this._doors.values()) {
            if (door == null) continue;
            L2WorldRegion region = door.getWorldRegion();
            door.decayMe();
            if (region != null) {
                region.removeVisibleObject(door);
            }
            door.getKnownList().removeAllKnownObjects();
            L2World.getInstance().removeObject(door);
        }
        this._doors.clear();
    }

    public void cancelQuestTimers() {
        int instanceId = this.getId();
        for (Quest quest : QuestManager.getInstance().getAllManagedScripts()) {
            if (quest == null) continue;
            block1: for (List<QuestTimer> timers : quest.getQuestTimers().values()) {
                if (timers == null || timers.isEmpty()) continue;
                for (QuestTimer timer : timers) {
                    if (timer == null || timer.getInstanceId() != instanceId) continue;
                    quest.cancelQuestTimers(timer.getName(), instanceId);
                    continue block1;
                }
            }
        }
    }

    public List<L2Npc> spawnGroup(String groupName) {
        ArrayList<L2Npc> ret = null;
        List<L2Spawn> manualSpawn = this._manualSpawn.get(groupName);
        if (manualSpawn != null) {
            ret = new ArrayList<L2Npc>(manualSpawn.size());
            for (L2Spawn spawnDat : manualSpawn) {
                ret.add(spawnDat.doSpawn());
            }
        } else {
            _log.warning(this.getName() + " instance: cannot spawn NPC's, wrong group name: " + groupName);
        }
        return ret;
    }

    public void loadInstanceTemplate(String filename) {
        Document doc = null;
        File xml = new File(Config.DATAPACK_ROOT, "data/instances/" + filename);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            doc = factory.newDocumentBuilder().parse(xml);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"instance".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseInstance(n);
            }
        }
        catch (IOException e) {
            _log.log(Level.WARNING, "Instance: can not find " + xml.getAbsolutePath() + " ! " + e.getMessage(), e);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Instance: error while loading " + xml.getAbsolutePath() + " ! " + e.getMessage(), e);
        }
    }

    private void parseInstance(Node n) throws Exception {
        Node first;
        this._name = n.getAttributes().getNamedItem("name").getNodeValue();
        Node a = n.getAttributes().getNamedItem("ejectTime");
        if (a != null) {
            this._ejectTime = 1000 * Integer.parseInt(a.getNodeValue());
        }
        if ((a = n.getAttributes().getNamedItem("allowRandomWalk")) != null) {
            this._allowRandomWalk = Boolean.parseBoolean(a.getNodeValue());
        }
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            int z;
            int y;
            if ("activityTime".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this._checkTimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(Integer.parseInt(a.getNodeValue()) * 60000), 15000L);
                this._instanceEndTime = System.currentTimeMillis() + Long.parseLong(a.getNodeValue()) * 60000L + 15000L;
                continue;
            }
            if ("allowSummon".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this.setAllowSummon(Boolean.parseBoolean(a.getNodeValue()));
                continue;
            }
            if ("emptyDestroyTime".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this._emptyDestroyTime = Long.parseLong(a.getNodeValue()) * 1000L;
                continue;
            }
            if ("showTimer".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a != null) {
                    this._showTimer = Boolean.parseBoolean(a.getNodeValue());
                }
                if ((a = n.getAttributes().getNamedItem("increase")) != null) {
                    this._isTimerIncrease = Boolean.parseBoolean(a.getNodeValue());
                }
                if ((a = n.getAttributes().getNamedItem("text")) == null) continue;
                this._timerText = a.getNodeValue();
                continue;
            }
            if ("PvPInstance".equalsIgnoreCase(n.getNodeName())) {
                a = n.getAttributes().getNamedItem("val");
                if (a == null) continue;
                this.setPvPInstance(Boolean.parseBoolean(a.getNodeValue()));
                continue;
            }
            if ("doorlist".equalsIgnoreCase(n.getNodeName())) {
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    int doorId = 0;
                    if (!"door".equalsIgnoreCase(d.getNodeName())) continue;
                    doorId = Integer.parseInt(d.getAttributes().getNamedItem("doorId").getNodeValue());
                    StatsSet set = new StatsSet();
                    set.add(DoorTable.getInstance().getDoorTemplate(doorId));
                    for (Node bean = d.getFirstChild(); bean != null; bean = bean.getNextSibling()) {
                        if (!"set".equalsIgnoreCase(bean.getNodeName())) continue;
                        NamedNodeMap attrs = bean.getAttributes();
                        String setname = attrs.getNamedItem("name").getNodeValue();
                        String value = attrs.getNamedItem("val").getNodeValue();
                        set.set(setname, value);
                    }
                    this.addDoor(doorId, set);
                }
                continue;
            }
            if ("spawnlist".equalsIgnoreCase(n.getNodeName())) {
                for (Node group = n.getFirstChild(); group != null; group = group.getNextSibling()) {
                    if (!"group".equalsIgnoreCase(group.getNodeName())) continue;
                    String spawnGroup = group.getAttributes().getNamedItem("name").getNodeValue();
                    ArrayList<L2Spawn> manualSpawn = new ArrayList<L2Spawn>();
                    for (Node d = group.getFirstChild(); d != null; d = d.getNextSibling()) {
                        L2NpcTemplate npcTemplate;
                        int npcId = 0;
                        int x = 0;
                        int y2 = 0;
                        int z2 = 0;
                        int heading = 0;
                        int respawn = 0;
                        int respawnRandom = 0;
                        int delay = -1;
                        Boolean allowRandomWalk = null;
                        if (!"spawn".equalsIgnoreCase(d.getNodeName())) continue;
                        npcId = Integer.parseInt(d.getAttributes().getNamedItem("npcId").getNodeValue());
                        x = Integer.parseInt(d.getAttributes().getNamedItem("x").getNodeValue());
                        y2 = Integer.parseInt(d.getAttributes().getNamedItem("y").getNodeValue());
                        z2 = Integer.parseInt(d.getAttributes().getNamedItem("z").getNodeValue());
                        heading = Integer.parseInt(d.getAttributes().getNamedItem("heading").getNodeValue());
                        respawn = Integer.parseInt(d.getAttributes().getNamedItem("respawn").getNodeValue());
                        if (d.getAttributes().getNamedItem("onKillDelay") != null) {
                            delay = Integer.parseInt(d.getAttributes().getNamedItem("onKillDelay").getNodeValue());
                        }
                        if (d.getAttributes().getNamedItem("respawnRandom") != null) {
                            respawnRandom = Integer.parseInt(d.getAttributes().getNamedItem("respawnRandom").getNodeValue());
                        }
                        if (d.getAttributes().getNamedItem("allowRandomWalk") != null) {
                            allowRandomWalk = Boolean.valueOf(d.getAttributes().getNamedItem("allowRandomWalk").getNodeValue());
                        }
                        if ((npcTemplate = NpcTable.getInstance().getTemplate(npcId)) != null) {
                            L2Spawn spawnDat = new L2Spawn(npcTemplate);
                            spawnDat.setX(x);
                            spawnDat.setY(y2);
                            spawnDat.setZ(z2);
                            spawnDat.setAmount(1);
                            spawnDat.setHeading(heading);
                            spawnDat.setRespawnDelay(respawn, respawnRandom);
                            if (respawn == 0) {
                                spawnDat.stopRespawn();
                            } else {
                                spawnDat.startRespawn();
                            }
                            spawnDat.setInstanceId(this.getId());
                            if (allowRandomWalk == null) {
                                spawnDat.setIsNoRndWalk(!this._allowRandomWalk);
                            } else {
                                spawnDat.setIsNoRndWalk(allowRandomWalk == false);
                            }
                            if (spawnGroup.equals("general")) {
                                L2Npc spawned = spawnDat.doSpawn();
                                if (delay < 0 || !(spawned instanceof L2Attackable)) continue;
                                ((L2Attackable)spawned).setOnKillDelay(delay);
                                continue;
                            }
                            manualSpawn.add(spawnDat);
                            continue;
                        }
                        _log.warning("Instance: Data missing in NPC table for ID: " + npcId + " in Instance " + this.getId());
                    }
                    if (manualSpawn.isEmpty()) continue;
                    this._manualSpawn.put(spawnGroup, manualSpawn);
                }
                continue;
            }
            if ("spawnpoint".equalsIgnoreCase(n.getNodeName())) {
                try {
                    int x = Integer.parseInt(n.getAttributes().getNamedItem("spawnX").getNodeValue());
                    y = Integer.parseInt(n.getAttributes().getNamedItem("spawnY").getNodeValue());
                    z = Integer.parseInt(n.getAttributes().getNamedItem("spawnZ").getNodeValue());
                    this._spawnLoc = new Location(x, y, z);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Error parsing instance xml: " + e.getMessage(), e);
                    this._spawnLoc = null;
                }
                continue;
            }
            if (!"returnteleport".equalsIgnoreCase(n.getNodeName())) continue;
            try {
                int x = Integer.parseInt(n.getAttributes().getNamedItem("x").getNodeValue());
                y = Integer.parseInt(n.getAttributes().getNamedItem("y").getNodeValue());
                z = Integer.parseInt(n.getAttributes().getNamedItem("z").getNodeValue());
                this._spawnLoc = new Location(x, y, z);
                continue;
            }
            catch (Exception e) {
                _log.warning("Error parsing instance xml: " + e);
                this._spawnLoc = null;
            }
        }
    }

    protected void doCheckTimeUp(int remaining) {
        int timeLeft;
        int interval;
        CreatureSay cs = null;
        if (this._players.isEmpty() && this._emptyDestroyTime == 0L) {
            remaining = 0;
            interval = 500;
        } else if (this._players.isEmpty() && this._emptyDestroyTime > 0L) {
            long emptyTimeLeft = this._lastLeft + this._emptyDestroyTime - System.currentTimeMillis();
            if (emptyTimeLeft <= 0L) {
                interval = 0;
                remaining = 0;
            } else if (remaining > 300000 && emptyTimeLeft > 300000L) {
                interval = 300000;
                remaining -= 300000;
            } else if (remaining > 60000 && emptyTimeLeft > 60000L) {
                interval = 60000;
                remaining -= 60000;
            } else if (remaining > 30000 && emptyTimeLeft > 30000L) {
                interval = 30000;
                remaining -= 30000;
            } else {
                interval = 10000;
                remaining -= 10000;
            }
        } else if (remaining > 300000) {
            timeLeft = remaining / 60000;
            interval = 300000;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DUNGEON_EXPIRES_IN_S1_MINUTES);
            sm.addString(Integer.toString(timeLeft));
            Announcements.getInstance().announceToInstance(sm, this.getId());
            remaining -= 300000;
        } else if (remaining > 60000) {
            timeLeft = remaining / 60000;
            interval = 60000;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DUNGEON_EXPIRES_IN_S1_MINUTES);
            sm.addString(Integer.toString(timeLeft));
            Announcements.getInstance().announceToInstance(sm, this.getId());
            remaining -= 60000;
        } else if (remaining > 30000) {
            timeLeft = remaining / 1000;
            interval = 30000;
            cs = new CreatureSay(0, 9, "\u30c0\u30f3\u30b8\u30e7\u30f3 \u7d42\u4e86", timeLeft + "\u79d2");
            remaining -= 30000;
        } else {
            timeLeft = remaining / 1000;
            interval = 10000;
            cs = new CreatureSay(0, 9, "\u30c0\u30f3\u30b8\u30e7\u30f3 \u7d42\u4e86", timeLeft + "\u79d2");
            remaining -= 10000;
        }
        if (cs != null) {
            for (Integer objectId : this._players) {
                this.broadcastPacket(objectId, cs);
            }
        }
        this.cancelTimer();
        this._checkTimeUpTask = remaining >= 10000 ? ThreadPoolManager.getInstance().scheduleGeneral(new CheckTimeUp(remaining), interval) : ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), interval);
    }

    public void cancelTimer() {
        if (this._checkTimeUpTask != null) {
            this._checkTimeUpTask.cancel(true);
        }
    }

    public void cancelEjectDeadPlayer(L2PcInstance player) {
        ScheduledFuture task = (ScheduledFuture)this._ejectDeadTasks.remove(player.getObjectId());
        if (task != null) {
            task.cancel(true);
        }
    }

    public void addEjectDeadTask(L2PcInstance player) {
        if (player != null) {
            this._ejectDeadTasks.put(player.getObjectId(), ThreadPoolManager.getInstance().scheduleGeneral(new EjectPlayer(player), this._ejectTime));
        }
    }

    public final void notifyDeath(L2Character killer, L2Character victim) {
        InstanceWorld instance = InstanceManager.getInstance().getPlayerWorld(victim.getActingPlayer());
        if (instance != null) {
            instance.onDeath(killer, victim);
        }
    }

    private void ejectProcedure(int objectId) {
        L2PcInstance player = L2World.getInstance().getPlayer(objectId);
        if (player != null && player.getInstanceId() == this.getId()) {
            player.setInstanceId(0);
            if (this.getSpawnLoc() != null) {
                player.teleToLocation((ILocational)this.getSpawnLoc(), true);
            } else {
                player.teleToLocation(TeleportWhereType.TOWN);
            }
        }
    }

    private void broadcastPacket(int objectId, L2GameServerPacket _packet) {
        L2PcInstance player = L2World.getInstance().getPlayer(objectId);
        if (player != null && player.getInstanceId() == this.getId()) {
            player.sendPacket(_packet);
        }
    }

    protected class EjectPlayer
    implements Runnable {
        private final L2PcInstance _player;

        public EjectPlayer(L2PcInstance player) {
            this._player = player;
        }

        @Override
        public void run() {
            if (this._player != null && this._player.isDead() && this._player.getInstanceId() == Instance.this.getId()) {
                this._player.setInstanceId(0);
                if (Instance.this.getSpawnLoc() != null) {
                    this._player.teleToLocation((ILocational)Instance.this.getSpawnLoc(), true);
                } else {
                    this._player.teleToLocation(TeleportWhereType.TOWN);
                }
            }
        }
    }

    public class TimeUp
    implements Runnable {
        @Override
        public void run() {
            InstanceManager.getInstance().destroyInstance(Instance.this.getId());
        }
    }

    public class CheckTimeUp
    implements Runnable {
        private final int _remaining;

        public CheckTimeUp(int remaining) {
            this._remaining = remaining;
        }

        @Override
        public void run() {
            Instance.this.doCheckTimeUp(this._remaining);
        }
    }
}

