/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.holders;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import java.util.HashMap;
import java.util.Map;

public final class NpcRoutesHolder {
    private final Map<String, String> _correspondences = new HashMap<String, String>();

    public void addRoute(String routeName, Location loc) {
        this._correspondences.put(this.getUniqueKey(loc), routeName);
    }

    public String getRouteName(L2Npc npc) {
        if (npc.getSpawn() != null) {
            String key = this.getUniqueKey(npc.getSpawn().getLocation());
            String result = this._correspondences.get(key);
            return result != null ? result : "";
        }
        return "";
    }

    private String getUniqueKey(ILocational loc) {
        return loc.getX() + "," + loc.getY() + "," + loc.getZ();
    }

    public Map<String, String> getCorrespondences() {
        return this._correspondences;
    }
}

