/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.holders;

import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.skills.L2Skill;
import java.util.HashMap;
import java.util.Map;

public class PlayerSkillHolder
implements ISkillsHolder {
    private final Map<Integer, L2Skill> _skills = new HashMap<Integer, L2Skill>();

    public PlayerSkillHolder(L2PcInstance player) {
        for (L2Skill skill : player.getSkills().values()) {
            if (!SkillTreesData.getInstance().isSkillAllowed(player, skill)) continue;
            this.addSkill(skill);
        }
    }

    @Override
    public Map<Integer, L2Skill> getSkills() {
        return this._skills;
    }

    @Override
    public L2Skill addSkill(L2Skill skill) {
        return this._skills.put(skill.getId(), skill);
    }

    @Override
    public int getSkillLevel(int skillId) {
        L2Skill skill = this.getKnownSkill(skillId);
        return skill == null ? -1 : skill.getLevel();
    }

    @Override
    public L2Skill getKnownSkill(int skillId) {
        return this._skills.get(skillId);
    }
}

