/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.instancezone;

import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import javolution.util.FastList;

public class InstanceWorld {
    public int instanceId;
    public int templateId = -1;
    public final List<Integer> allowed = new FastList();
    public volatile int status;

    public List<Integer> getAllowed() {
        return this.allowed;
    }

    public Integer removeAllowed(int id) {
        return this.allowed.remove(this.allowed.indexOf(id));
    }

    public Integer removeAllowed(L2PcInstance player) {
        return this.removeAllowed(player.getObjectId());
    }

    public boolean addAllowed(int id) {
        return this.allowed.add(id);
    }

    public boolean addAllowed(L2PcInstance player) {
        return this.addAllowed(player.getObjectId());
    }

    public boolean isAllowed(int id) {
        return this.allowed.contains(id);
    }

    public boolean isAllowed(L2PcInstance player) {
        return this.isAllowed(player.getObjectId());
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int incStatus() {
        return ++this.status;
    }

    public void onDeath(L2Character killer, L2Character victim) {
        Instance instance;
        if (victim != null && victim.isPlayer() && (instance = InstanceManager.getInstance().getInstance(this.getInstanceId())) != null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_WILL_BE_EXPELLED_IN_S1);
            sm.addNumber((instance.getEjectTime() + 59999) / 60000);
            victim.getActingPlayer().sendPacket(sm);
            instance.addEjectDeadTask(victim.getActingPlayer());
        }
    }
}

