/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.TrapAction;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.L2ZoneType;

public class VerifyQuestEvent {
    public static boolean hasMethod(QuestEventType EventType2, Quest q) {
        switch (EventType2) {
            case ON_FIRST_TALK: {
                return VerifyQuestEvent.hasOnFirstTalk(q);
            }
            case ON_TALK: {
                return VerifyQuestEvent.hasOnTalk(q);
            }
            case ON_ATTACK: {
                return VerifyQuestEvent.hasOnAttack(q);
            }
            case ON_KILL: {
                return VerifyQuestEvent.hasOnKill(q);
            }
            case ON_SPAWN: {
                return VerifyQuestEvent.hasOnSpawn(q);
            }
            case ON_SKILL_SEE: {
                return VerifyQuestEvent.hasOnSkillSee(q);
            }
            case ON_FACTION_CALL: {
                return VerifyQuestEvent.hasOnFactionCall(q);
            }
            case ON_AGGRO_RANGE_ENTER: {
                return VerifyQuestEvent.hasOnAggroRangeEnter(q);
            }
            case ON_SPELL_FINISHED: {
                return VerifyQuestEvent.hasOnSpellFinished(q);
            }
            case ON_ENTER_ZONE: {
                return VerifyQuestEvent.hasOnEnterZone(q);
            }
            case ON_EXIT_ZONE: {
                return VerifyQuestEvent.hasOnExitZone(q);
            }
            case ON_TRAP_ACTION: {
                return VerifyQuestEvent.hasOnTrapAction(q);
            }
            case ON_ITEM_USE: {
                return VerifyQuestEvent.hasOnItemUse(q);
            }
            case ON_EVENT_RECEIVED: {
                return VerifyQuestEvent.hasOnEventReceived(q);
            }
            case ON_MOVE_FINISHED: {
                return VerifyQuestEvent.hasOnMoveFinished(q);
            }
            case ON_NODE_ARRIVED: {
                return VerifyQuestEvent.hasOnNodeArrived(q);
            }
            case ON_SEE_CREATURE: {
                return VerifyQuestEvent.hasOnSeeCreature(q);
            }
            case ON_ROUTE_FINISHED: {
                return VerifyQuestEvent.hasOnRouteFinished(q);
            }
        }
        return true;
    }

    public static String checkMethod(QuestEventType EventType2, Quest q) {
        String result = null;
        switch (EventType2) {
            case ON_FIRST_TALK: {
                if (VerifyQuestEvent.hasOnFirstTalk(q)) break;
                result = "onFirstTalk()";
                break;
            }
            case ON_TALK: {
                if (VerifyQuestEvent.hasOnTalk(q)) break;
                result = "onTalk()";
                break;
            }
            case ON_ATTACK: {
                if (VerifyQuestEvent.hasOnAttack(q)) break;
                result = "onAttack()";
                break;
            }
            case ON_KILL: {
                if (VerifyQuestEvent.hasOnKill(q)) break;
                result = "onKill()";
                break;
            }
            case ON_SPAWN: {
                if (VerifyQuestEvent.hasOnSpawn(q)) break;
                result = "onSpawn()";
                break;
            }
            case ON_SKILL_SEE: {
                if (VerifyQuestEvent.hasOnSkillSee(q)) break;
                result = "onSkillSee()";
                break;
            }
            case ON_FACTION_CALL: {
                if (VerifyQuestEvent.hasOnFactionCall(q)) break;
                result = "onFactionCall()";
                break;
            }
            case ON_AGGRO_RANGE_ENTER: {
                if (VerifyQuestEvent.hasOnAggroRangeEnter(q)) break;
                result = "onAggroRangeEnter()";
                break;
            }
            case ON_SPELL_FINISHED: {
                if (VerifyQuestEvent.hasOnSpellFinished(q)) break;
                result = "onSpellFinished()";
                break;
            }
            case ON_ENTER_ZONE: {
                if (VerifyQuestEvent.hasOnEnterZone(q)) break;
                result = "onEnterZone()";
                break;
            }
            case ON_EXIT_ZONE: {
                if (VerifyQuestEvent.hasOnExitZone(q)) break;
                result = "onExitZone()";
                break;
            }
            case ON_TRAP_ACTION: {
                if (VerifyQuestEvent.hasOnTrapAction(q)) break;
                result = "onTrapAction()";
                break;
            }
            case ON_ITEM_USE: {
                if (VerifyQuestEvent.hasOnItemUse(q)) break;
                result = "onItemUse()";
                break;
            }
            case ON_EVENT_RECEIVED: {
                if (VerifyQuestEvent.hasOnEventReceived(q)) break;
                result = "onEventReceived()";
                break;
            }
            case ON_MOVE_FINISHED: {
                if (VerifyQuestEvent.hasOnMoveFinished(q)) break;
                result = "onMoveFinished()";
                break;
            }
            case ON_NODE_ARRIVED: {
                if (VerifyQuestEvent.hasOnNodeArrived(q)) break;
                result = "onNodeArrived()";
                break;
            }
            case ON_SEE_CREATURE: {
                if (VerifyQuestEvent.hasOnSeeCreature(q)) break;
                result = "onSeeCreature()";
                break;
            }
            case ON_ROUTE_FINISHED: {
                if (VerifyQuestEvent.hasOnRouteFinished(q)) break;
                result = "onRouteFinished()";
                break;
            }
        }
        return result;
    }

    public static boolean hasOnFirstTalk(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onFirstTalk", L2Npc.class, L2PcInstance.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnTalk(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onTalk", L2Npc.class, L2PcInstance.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnAttack(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onAttack", L2Npc.class, L2PcInstance.class, Integer.TYPE, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnKill(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onKill", L2Npc.class, L2PcInstance.class, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnSpawn(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onSpawn", L2Npc.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnSkillSee(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onSkillSee", L2Npc.class, L2PcInstance.class, L2Skill.class, L2Object[].class, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnFactionCall(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onFactionCall", L2Npc.class, L2Npc.class, L2PcInstance.class, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnAggroRangeEnter(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onAggroRangeEnter", L2Npc.class, L2PcInstance.class, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnSpellFinished(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onSpellFinished", L2Npc.class, L2PcInstance.class, L2Skill.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnEnterZone(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onEnterZone", L2Character.class, L2ZoneType.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnExitZone(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onExitZone", L2Character.class, L2ZoneType.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnTrapAction(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onTrapAction", L2TrapInstance.class, L2Character.class, TrapAction.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnItemUse(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onItemUse", L2Item.class, L2PcInstance.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnEventReceived(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onEventReceived", String.class, L2Npc.class, L2Npc.class, L2Object.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnMoveFinished(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onMoveFinished", L2Npc.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnNodeArrived(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onNodeArrived", L2Npc.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnSeeCreature(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onSeeCreature", L2Npc.class, L2Character.class, Boolean.TYPE);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public static boolean hasOnRouteFinished(Quest q) {
        try {
            q.getClass().getDeclaredMethod("onRouteFinished", L2Npc.class);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }
}

