/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.EnchantSkillGroupsData;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.util.Rnd;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestExEnchantSkillRouteChange
extends L2GameClientPacket {
    private static final String _C__D0_34_REQUESTEXENCHANTSKILLROUTECHANGE = "[C] D0:34 RequestExEnchantSkillRouteChange";
    private static final Logger _logEnchant = Logger.getLogger("enchant");
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._skillId <= 0 || this._skillLvl <= 0) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClassId().level() < 3) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS);
            return;
        }
        if (player.getLevel() < 76) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL);
            return;
        }
        if (!player.isAllowedToEnchantSkills()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT);
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLvl);
        if (skill == null) {
            return;
        }
        int reqItemId = 9626;
        L2EnchantSkillLearn s = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(this._skillId);
        if (s == null) {
            return;
        }
        int beforeEnchantSkillLevel = player.getSkillLevel(this._skillId);
        if (beforeEnchantSkillLevel <= 100) {
            return;
        }
        int currentEnchantLevel = beforeEnchantSkillLevel % 100;
        if (currentEnchantLevel != this._skillLvl % 100) {
            return;
        }
        L2EnchantSkillGroup.EnchantSkillHolder esd = s.getEnchantSkillHolder(this._skillLvl);
        int requiredSp = esd.getSpCost();
        int requireditems = esd.getAdenaCost();
        if (player.getSp() >= requiredSp) {
            SystemMessage sm;
            L2ItemInstance spb = player.getInventory().getItemByItemId(reqItemId);
            if (Config.ES_SP_BOOK_NEEDED && spb == null) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_CHANGE_SKILL_ENCHANT_ROUTE);
                return;
            }
            if (player.getInventory().getAdena() < (long)requireditems) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            boolean check = player.getStat().removeExpAndSp(0L, requiredSp, false);
            if (Config.ES_SP_BOOK_NEEDED) {
                check &= player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)player, true);
            }
            if (!(check &= player.destroyItemByItemId("Consume", 57, requireditems, player, true))) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            int levelPenalty = Rnd.get(Math.min(4, currentEnchantLevel));
            this._skillLvl -= levelPenalty;
            if (this._skillLvl % 100 == 0) {
                this._skillLvl = s.getBaseLevel();
            }
            if ((skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLvl)) != null) {
                if (Config.LOG_SKILL_ENCHANTS) {
                    LogRecord record = new LogRecord(Level.INFO, "Route Change");
                    record.setParameters(new Object[]{player, skill, spb});
                    record.setLoggerName("skill");
                    _logEnchant.log(record);
                }
                player.addSkill(skill, true);
                player.sendPacket(ExEnchantSkillResult.valueOf(true));
            }
            if (Config.DEBUG) {
                _log.fine("Learned skill ID: " + this._skillId + " Level: " + this._skillLvl + " for " + requiredSp + " SP, " + requireditems + " Adena.");
            }
            player.sendPacket(new UserInfo(player));
            player.sendPacket(new ExBrExtraUserInfo(player));
            if (levelPenalty == 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WILL_REMAIN);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WAS_DECREASED_BY_S2);
                sm.addSkillName(this._skillId);
                sm.addNumber(levelPenalty);
                player.sendPacket(sm);
            }
            player.sendSkillList();
            int afterEnchantSkillLevel = player.getSkillLevel(this._skillId);
            player.sendPacket(new ExEnchantSkillInfo(this._skillId, afterEnchantSkillLevel));
            player.sendPacket(new ExEnchantSkillInfoDetail(3, this._skillId, afterEnchantSkillLevel, player));
            player.updateShortCuts(this._skillId, afterEnchantSkillLevel);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL);
            player.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_34_REQUESTEXENCHANTSKILLROUTECHANGE;
    }
}

