/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroCmd;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.ArrayList;

public final class RequestMakeMacro
extends L2GameClientPacket {
    private static final String _C__CD_REQUESTMAKEMACRO = "[C] CD RequestMakeMacro";
    private Macro _macro;
    private int _commandsLenght = 0;
    private static final int MAX_MACRO_LENGTH = 12;

    @Override
    protected void readImpl() {
        int _id = this.readD();
        String _name = this.readS();
        String _desc = this.readS();
        String _acronym = this.readS();
        int _icon = this.readC();
        int _count = this.readC();
        if (_count > 12) {
            _count = 12;
        }
        if (Config.DEBUG) {
            _log.info("Make macro id:" + _id + "\tname:" + _name + "\tdesc:" + _desc + "\tacronym:" + _acronym + "\ticon:" + _icon + "\tcount:" + _count);
        }
        ArrayList<MacroCmd> commands = new ArrayList<MacroCmd>(_count);
        for (int i = 0; i < _count; ++i) {
            int entry = this.readC();
            int type = this.readC();
            int d1 = this.readD();
            int d2 = this.readC();
            String command = this.readS();
            this._commandsLenght += command.length();
            commands.add(new MacroCmd(entry, type, d1, d2, command));
            if (!Config.DEBUG) continue;
            _log.info("entry:" + entry + "\ttype:" + type + "\td1:" + d1 + "\td2:" + d2 + "\tcommand:" + command);
        }
        this._macro = new Macro(_id, _icon, _name, _desc, _acronym, commands);
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._commandsLenght > 255) {
            player.sendPacket(SystemMessageId.INVALID_MACRO);
            return;
        }
        if (player.getMacros().size() > 48) {
            player.sendPacket(SystemMessageId.YOU_MAY_CREATE_UP_TO_48_MACROS);
            return;
        }
        if (this._macro.getName().isEmpty()) {
            player.sendPacket(SystemMessageId.ENTER_THE_MACRO_NAME);
            return;
        }
        if (this._macro.getDescr().length() > 32) {
            player.sendPacket(SystemMessageId.MACRO_DESCRIPTION_MAX_32_CHARS);
            return;
        }
        player.registerMacro(this._macro);
    }

    @Override
    public String getType() {
        return _C__CD_REQUESTMAKEMACRO;
    }
}

