/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestPetition
extends L2GameClientPacket {
    private static final String _C__89_RequestPetition = "[C] 89 RequestPetition";
    private String _content;
    private int _type;

    @Override
    protected void readImpl() {
        this._content = this.readS();
        this._type = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!AdminTable.getInstance().isGmOnline(false)) {
            activeChar.sendPacket(SystemMessageId.NO_GM_PROVIDING_SERVICE_NOW);
            return;
        }
        if (!PetitionManager.getInstance().isPetitioningAllowed()) {
            activeChar.sendPacket(SystemMessageId.GAME_CLIENT_UNABLE_TO_CONNECT_TO_PETITION_SERVER);
            return;
        }
        if (PetitionManager.getInstance().isPlayerPetitionPending(activeChar)) {
            activeChar.sendPacket(SystemMessageId.ONLY_ONE_ACTIVE_PETITION_AT_TIME);
            return;
        }
        if (PetitionManager.getInstance().getPendingPetitionCount() == Config.MAX_PETITIONS_PENDING) {
            activeChar.sendPacket(SystemMessageId.PETITION_SYSTEM_CURRENT_UNAVAILABLE);
            return;
        }
        int totalPetitions = PetitionManager.getInstance().getPlayerTotalPetitionCount(activeChar) + 1;
        if (totalPetitions > Config.MAX_PETITIONS_PER_PLAYER) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.WE_HAVE_RECEIVED_S1_PETITIONS_TODAY);
            sm.addNumber(totalPetitions);
            activeChar.sendPacket(sm);
            sm = null;
            return;
        }
        if (this._content.length() > 255) {
            activeChar.sendPacket(SystemMessageId.PETITION_MAX_CHARS_255);
            return;
        }
        int petitionId = PetitionManager.getInstance().submitPetition(activeChar, this._content, this._type);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PETITION_ACCEPTED_RECENT_NO_S1);
        sm.addNumber(petitionId);
        activeChar.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.SUBMITTED_YOU_S1_TH_PETITION_S2_LEFT);
        sm.addNumber(totalPetitions);
        sm.addNumber(Config.MAX_PETITIONS_PER_PLAYER - totalPetitions);
        activeChar.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.S1_PETITION_ON_WAITING_LIST);
        sm.addNumber(PetitionManager.getInstance().getPendingPetitionCount());
        activeChar.sendPacket(sm);
        sm = null;
    }

    @Override
    public String getType() {
        return _C__89_RequestPetition;
    }
}

