/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.geoeditorcon.GeoEditorListener;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.GetOnVehicle;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;

public class ValidatePosition
extends L2GameClientPacket {
    private static final String _C__59_VALIDATEPOSITION = "[C] 59 ValidatePosition";
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _data;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._x = this.readD();
        this._y = this.readD();
        this._z = this.readD();
        this._heading = this.readD();
        this._data = this.readD();
    }

    @Override
    protected void runImpl() {
        L2Clan clan;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || activeChar.isTeleporting() || activeChar.inObserverMode()) {
            return;
        }
        int realX = activeChar.getX();
        int realY = activeChar.getY();
        int realZ = activeChar.getZ();
        if (Config.DEVELOPER) {
            _log.fine("client pos: " + this._x + " " + this._y + " " + this._z + " head " + this._heading);
            _log.fine("server pos: " + realX + " " + realY + " " + realZ + " head " + activeChar.getHeading());
        }
        if (this._x == 0 && this._y == 0 && realX != 0) {
            return;
        }
        if (activeChar.isInBoat()) {
            int dy;
            int dx;
            double diffSq;
            if (Config.COORD_SYNCHRONIZE == 2 && (diffSq = (double)((dx = this._x - activeChar.getInVehiclePosition().getX()) * dx + (dy = this._y - activeChar.getInVehiclePosition().getY()) * dy)) > 250000.0) {
                this.sendPacket(new GetOnVehicle(activeChar.getObjectId(), this._data, activeChar.getInVehiclePosition()));
            }
            return;
        }
        if (activeChar.isInAirShip()) {
            return;
        }
        if (activeChar.isFalling(this._z)) {
            return;
        }
        int dx = this._x - realX;
        int dy = this._y - realY;
        int dz = this._z - realZ;
        double diffSq = dx * dx + dy * dy;
        if (Config.ACCEPT_GEOEDITOR_CONN && GeoEditorListener.getInstance().getThread() != null && GeoEditorListener.getInstance().getThread().isWorking() && GeoEditorListener.getInstance().getThread().isSend(activeChar)) {
            GeoEditorListener.getInstance().getThread().sendGmPosition(this._x, this._y, (short)this._z);
        }
        if (activeChar.isFlying() || activeChar.isInsideZone(ZoneId.WATER)) {
            activeChar.setXYZ(realX, realY, this._z);
            if (diffSq > 90000.0) {
                activeChar.sendPacket(new ValidateLocation(activeChar));
            }
        } else if (diffSq < 360000.0) {
            if (Config.COORD_SYNCHRONIZE == -1) {
                activeChar.setXYZ(realX, realY, this._z);
                return;
            }
            if (Config.COORD_SYNCHRONIZE == 1) {
                if (!activeChar.isMoving() || !activeChar.validateMovementHeading(this._heading)) {
                    if (diffSq < 2500.0) {
                        activeChar.setXYZ(realX, realY, this._z);
                    } else {
                        activeChar.setXYZ(this._x, this._y, this._z);
                    }
                } else {
                    activeChar.setXYZ(realX, realY, this._z);
                }
                activeChar.setHeading(this._heading);
                return;
            }
            if (Config.GEODATA > 0 && (diffSq > 250000.0 || Math.abs(dz) > 200)) {
                if (Math.abs(dz) > 200 && Math.abs(dz) < 1500 && Math.abs(this._z - activeChar.getClientZ()) < 800) {
                    activeChar.setXYZ(realX, realY, this._z);
                    realZ = this._z;
                } else {
                    if (Config.DEVELOPER) {
                        _log.info(activeChar.getName() + ": Synchronizing position Server --> Client");
                    }
                    activeChar.sendPacket(new ValidateLocation(activeChar));
                }
            }
        }
        activeChar.setClientX(this._x);
        activeChar.setClientY(this._y);
        activeChar.setClientZ(this._z);
        activeChar.setClientHeading(this._heading);
        activeChar.setLastServerPosition(realX, realY, realZ);
        if (!Config.ALT_FLYING_WYVERN_IN_SIEGE && activeChar.getMountType() == MountType.WYVERN && activeChar.isInsideZone(ZoneId.SIEGE) && ((clan = activeChar.getClan()) == null || activeChar != clan.getLeader().getPlayerInstance() || CastleManager.getInstance().getCastle(activeChar) != CastleManager.getInstance().getCastleByOwner(clan))) {
            activeChar.sendMessage("You entered into a no-fly zone.");
            activeChar.teleToLocation(TeleportWhereType.TOWN);
        }
    }

    @Override
    public String getType() {
        return _C__59_VALIDATEPOSITION;
    }
}

