/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver.writepackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.entity.Castle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import org.netcon.BaseWritePacket;

public final class InitWorldInfo
extends BaseWritePacket {
    public static final byte TYPE_INFO = 0;
    public static final byte TYPE_PLAYER = 1;
    public static final byte TYPE_CLAN = 2;
    public static final byte TYPE_CASTLE = 3;
    private static Logger _log = Logger.getLogger(InitWorldInfo.class.getName());

    public InitWorldInfo(StatsSet[] players, L2Clan[] clans, byte type, int info) {
        super.writeC(1);
        super.writeC(0);
        super.writeD((int)type);
        block13 : switch (type) {
            case 0: {
                super.writeD(info);
                break;
            }
            case 2: {
                super.writeD(info != -1 ? info : clans.length);
                int i = 0;
                for (L2Clan c : clans) {
                    if (c == null) continue;
                    if (i++ == info) break block13;
                    super.writeD(c.getId());
                    super.writeS(c.getName());
                    super.writeD(c.getLevel());
                    if (c.getLeader() == null) {
                        this.writeD(0);
                        this.writeS("");
                        _log.info("Clan Id: " + c.getId() + " has null clan leader!");
                    } else {
                        super.writeD(c.getLeader().getObjectId());
                        super.writeS(c.getLeader().getName());
                    }
                    super.writeD(c.getMembersCount());
                    super.writeC(c.isNoticeEnabled() ? 1 : 0);
                    super.writeS(c.getAllyName());
                    List<L2Clan> clanAllies = ClanTable.getInstance().getClanAllies(c.getAllyId());
                    super.writeD(clanAllies.size());
                    for (L2Clan allies : clanAllies) {
                        super.writeD(allies.getId());
                    }
                }
                break;
            }
            case 1: {
                super.writeD(info != -1 ? info : players.length);
                int i = 0;
                for (StatsSet p : players) {
                    if (i++ == info) break block13;
                    super.writeD(p.getInt("charId"));
                    super.writeS(p.getString("char_name"));
                    super.writeS(p.getString("account_name"));
                    super.writeD(p.getInt("level"));
                    super.writeD(p.getInt("clanid"));
                    super.writeD(p.getInt("accesslevel"));
                    super.writeC(p.getInt("online"));
                    FastList list = FastList.newInstance();
                    try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                         PreparedStatement statement = con.prepareStatement("SELECT friendId FROM character_friends WHERE charId=?");){
                        statement.setInt(1, p.getInt("charId"));
                        try (ResultSet rset = statement.executeQuery();){
                            while (rset.next()) {
                                list.add((Object)rset.getInt("friendId"));
                            }
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.SEVERE, "Error restoring friend data for Community Board transfer.", e);
                    }
                    super.writeD(list.size());
                    Iterator i$ = list.iterator();
                    while (i$.hasNext()) {
                        int j = (Integer)i$.next();
                        super.writeD(j);
                    }
                    FastList.recycle((FastList)list);
                }
                break;
            }
            case 3: {
                List<Castle> castles = CastleManager.getInstance().getCastles();
                this.writeD(castles.size());
                _log.info("Transfering " + castles.size() + " castles data to CB server.");
                for (Castle castle : castles) {
                    this.writeD(castle.getResidenceId());
                    this.writeS(castle.getName());
                    this.writeD(castle.getOwnerId());
                    this.writeD(castle.getTaxPercent());
                    this.writeD((int)(castle.getSiege().getSiegeDate().getTimeInMillis() / 1000L));
                }
                break;
            }
        }
    }
}

