/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.ClanInfo;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class AllianceInfo
extends L2GameServerPacket {
    private final String _name;
    private final int _total;
    private final int _online;
    private final String _leaderC;
    private final String _leaderP;
    private final ClanInfo[] _allies;

    public AllianceInfo(int allianceId) {
        L2Clan leader = ClanTable.getInstance().getClan(allianceId);
        this._name = leader.getAllyName();
        this._leaderC = leader.getName();
        this._leaderP = leader.getLeaderName();
        List<L2Clan> allies = ClanTable.getInstance().getClanAllies(allianceId);
        this._allies = new ClanInfo[allies.size()];
        int idx = 0;
        int total = 0;
        int online = 0;
        for (L2Clan clan : allies) {
            ClanInfo ci = new ClanInfo(clan);
            this._allies[idx++] = ci;
            total += ci.getTotal();
            online += ci.getOnline();
        }
        this._total = total;
        this._online = online;
    }

    @Override
    protected void writeImpl() {
        this.writeC(181);
        this.writeS(this._name);
        this.writeD(this._total);
        this.writeD(this._online);
        this.writeS(this._leaderC);
        this.writeS(this._leaderP);
        this.writeD(this._allies.length);
        for (ClanInfo aci : this._allies) {
            this.writeS(aci.getClan().getName());
            this.writeD(0);
            this.writeD(aci.getClan().getLevel());
            this.writeS(aci.getClan().getLeaderName());
            this.writeD(aci.getTotal());
            this.writeD(aci.getOnline());
        }
    }

    public String getName() {
        return this._name;
    }

    public int getTotal() {
        return this._total;
    }

    public int getOnline() {
        return this._online;
    }

    public String getLeaderC() {
        return this._leaderC;
    }

    public String getLeaderP() {
        return this._leaderP;
    }

    public ClanInfo[] getAllies() {
        return this._allies;
    }
}

