/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ManorData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class ExShowSeedSetting
extends L2GameServerPacket {
    private final int _manorId;
    private final int _count;
    private final long[] _seedData;

    public ExShowSeedSetting(int manorId) {
        this._manorId = manorId;
        Castle c = CastleManager.getInstance().getCastleById(this._manorId);
        List<Integer> seeds = ManorData.getInstance().getSeedsForCastle(this._manorId);
        this._count = seeds.size();
        this._seedData = new long[this._count * 12];
        int i = 0;
        for (int s : seeds) {
            this._seedData[i * 12 + 0] = s;
            this._seedData[i * 12 + 1] = ManorData.getInstance().getSeedLevel(s);
            this._seedData[i * 12 + 2] = ManorData.getInstance().getRewardItemBySeed(s, 1);
            this._seedData[i * 12 + 3] = ManorData.getInstance().getRewardItemBySeed(s, 2);
            this._seedData[i * 12 + 4] = ManorData.getInstance().getSeedSaleLimit(s);
            this._seedData[i * 12 + 5] = ManorData.getInstance().getSeedBuyPrice(s);
            this._seedData[i * 12 + 6] = ManorData.getInstance().getSeedBasicPrice(s) * 60 / 100;
            this._seedData[i * 12 + 7] = ManorData.getInstance().getSeedBasicPrice(s) * 10;
            SeedProduction seedPr = c.getSeed(s, 0);
            if (seedPr != null) {
                this._seedData[i * 12 + 8] = seedPr.getStartProduce();
                this._seedData[i * 12 + 9] = seedPr.getPrice();
            } else {
                this._seedData[i * 12 + 8] = 0L;
                this._seedData[i * 12 + 9] = 0L;
            }
            seedPr = c.getSeed(s, 1);
            if (seedPr != null) {
                this._seedData[i * 12 + 10] = seedPr.getStartProduce();
                this._seedData[i * 12 + 11] = seedPr.getPrice();
            } else {
                this._seedData[i * 12 + 10] = 0L;
                this._seedData[i * 12 + 11] = 0L;
            }
            ++i;
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(38);
        this.writeD(this._manorId);
        this.writeD(this._count);
        for (int i = 0; i < this._count; ++i) {
            this.writeD((int)this._seedData[i * 12 + 0]);
            this.writeD((int)this._seedData[i * 12 + 1]);
            this.writeC(1);
            this.writeD((int)this._seedData[i * 12 + 2]);
            this.writeC(1);
            this.writeD((int)this._seedData[i * 12 + 3]);
            this.writeD((int)this._seedData[i * 12 + 4]);
            this.writeD((int)this._seedData[i * 12 + 5]);
            this.writeD((int)this._seedData[i * 12 + 6]);
            this.writeD((int)this._seedData[i * 12 + 7]);
            this.writeQ(this._seedData[i * 12 + 8]);
            this.writeQ(this._seedData[i * 12 + 9]);
            this.writeQ(this._seedData[i * 12 + 10]);
            this.writeQ(this._seedData[i * 12 + 11]);
        }
    }
}

