/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ManorData;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Iterator;
import java.util.List;
import javolution.util.FastMap;

public class ExShowSellCropList
extends L2GameServerPacket {
    private int _manorId = 1;
    private final FastMap<Integer, L2ItemInstance> _cropsItems;
    private final FastMap<Integer, CropProcure> _castleCrops;

    public ExShowSellCropList(L2PcInstance player, int manorId, List<CropProcure> crops) {
        this._manorId = manorId;
        this._castleCrops = new FastMap();
        this._cropsItems = new FastMap();
        List<Integer> allCrops = ManorData.getInstance().getAllCrops();
        Iterator<Object> i$ = allCrops.iterator();
        while (i$.hasNext()) {
            int cropId = i$.next();
            L2ItemInstance item = player.getInventory().getItemByItemId(cropId);
            if (item == null) continue;
            this._cropsItems.put((Object)cropId, (Object)item);
        }
        for (CropProcure crop : crops) {
            if (!this._cropsItems.containsKey((Object)crop.getId()) || crop.getAmount() <= 0L) continue;
            this._castleCrops.put((Object)crop.getId(), (Object)crop);
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(44);
        this.writeD(this._manorId);
        this.writeD(this._cropsItems.size());
        for (L2ItemInstance item : this._cropsItems.values()) {
            this.writeD(item.getObjectId());
            this.writeD(item.getDisplayId());
            this.writeD(ManorData.getInstance().getSeedLevelByCrop(item.getId()));
            this.writeC(1);
            this.writeD(ManorData.getInstance().getRewardItem(item.getId(), 1));
            this.writeC(1);
            this.writeD(ManorData.getInstance().getRewardItem(item.getId(), 2));
            if (this._castleCrops.containsKey((Object)item.getId())) {
                CropProcure crop = (CropProcure)this._castleCrops.get((Object)item.getId());
                this.writeD(this._manorId);
                this.writeQ(crop.getAmount());
                this.writeQ(crop.getPrice());
                this.writeC(crop.getReward());
            } else {
                this.writeD(-1);
                this.writeQ(0L);
                this.writeQ(0L);
                this.writeC(0);
            }
            this.writeQ(item.getCount());
        }
    }
}

